/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.lws;

import com.aelitis.azureus.core.lws.LightWeightSeed;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.disk.DiskManager;
import org.gudy.azureus2.plugins.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadActivationEvent;
import org.gudy.azureus2.plugins.download.DownloadActivationListener;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAttributeListener;
import org.gudy.azureus2.plugins.download.DownloadCompletionListener;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.download.DownloadListener;
import org.gudy.azureus2.plugins.download.DownloadPeerListener;
import org.gudy.azureus2.plugins.download.DownloadPropertyListener;
import org.gudy.azureus2.plugins.download.DownloadRemovalVetoException;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;
import org.gudy.azureus2.plugins.download.DownloadStats;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.download.DownloadTrackerListener;
import org.gudy.azureus2.plugins.download.DownloadWillBeRemovedListener;
import org.gudy.azureus2.plugins.download.savelocation.SaveLocationChange;
import org.gudy.azureus2.plugins.network.RateLimiter;
import org.gudy.azureus2.plugins.peers.PeerManager;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.plugins.torrent.TorrentManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadAnnounceResultImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LWSDownload
implements Download {
    private LightWeightSeed lws;
    private TRTrackerAnnouncer announcer;
    private DownloadAnnounceResultImpl announce_result;
    private Map user_data = new HashMap();
    private Map torrent_attributes = new HashMap();
    private DownloadScrapeResult scrape_result = new DownloadScrapeResult(){

        public Download getDownload() {
            return LWSDownload.this;
        }

        public int getResponseType() {
            return LWSDownload.this.announce_result.getResponseType() == 1 ? 1 : 2;
        }

        public int getSeedCount() {
            return LWSDownload.this.announce_result.getSeedCount();
        }

        public int getNonSeedCount() {
            int seeds = this.getSeedCount();
            int reported = LWSDownload.this.announce_result.getReportedPeerCount();
            int min_peers = reported - seeds;
            int peers = LWSDownload.this.announce_result.getNonSeedCount();
            if (peers < min_peers) {
                peers = min_peers;
            }
            return peers;
        }

        public long getScrapeStartTime() {
            return 0L;
        }

        public void setNextScrapeStartTime(long nextScrapeStartTime) {
        }

        public long getNextScrapeStartTime() {
            return 0L;
        }

        public String getStatus() {
            if (this.getResponseType() == 1) {
                return "OK";
            }
            return LWSDownload.this.announce_result.getError();
        }

        public URL getURL() {
            return LWSDownload.this.announce_result.getURL();
        }
    };

    protected LWSDownload(LightWeightSeed _lws, TRTrackerAnnouncer _announcer) {
        this.lws = _lws;
        this.announcer = _announcer;
        this.announce_result = new DownloadAnnounceResultImpl(this, this.announcer.getLastResponse());
    }

    @Override
    public int getState() {
        return 5;
    }

    @Override
    public int getSubState() {
        return 5;
    }

    @Override
    public String getErrorStateDetails() {
        return "";
    }

    @Override
    public void setFlag(long flag, boolean value) {
        this.notSupported();
    }

    @Override
    public boolean getFlag(long flag) {
        return flag == 1024L;
    }

    @Override
    public long getFlags() {
        return 1024L;
    }

    @Override
    public int getIndex() {
        return 0;
    }

    @Override
    public File[] calculateDefaultPaths(boolean for_moving) {
        return new File[2];
    }

    @Override
    public SaveLocationChange calculateDefaultDownloadLocation() {
        return null;
    }

    @Override
    public boolean isInDefaultSaveDir() {
        return false;
    }

    @Override
    public Torrent getTorrent() {
        return this.lws.getTorrent();
    }

    @Override
    public void initialize() throws DownloadException {
    }

    @Override
    public void start() throws DownloadException {
    }

    @Override
    public void startDownload(boolean force) {
    }

    @Override
    public void stopDownload() {
    }

    @Override
    public void stop() throws DownloadException {
    }

    @Override
    public void stopAndQueue() throws DownloadException {
    }

    @Override
    public void restart() throws DownloadException {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void recheckData() throws DownloadException {
    }

    @Override
    public boolean isStartStopLocked() {
        return false;
    }

    @Override
    public boolean isForceStart() {
        return true;
    }

    @Override
    public void setForceStart(boolean forceStart) {
    }

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public void setPriority(int priority) {
    }

    @Override
    public boolean isPriorityLocked() {
        return false;
    }

    @Override
    public boolean isPaused() {
        return false;
    }

    @Override
    public String getName() {
        return this.lws.getName();
    }

    @Override
    public String getTorrentFileName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getAttribute(TorrentAttribute attribute) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            return (String)this.torrent_attributes.get(attribute);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAttribute(TorrentAttribute attribute, String value) {
        Map map = this.torrent_attributes;
        synchronized (map) {
            this.torrent_attributes.put(attribute, value);
        }
    }

    @Override
    public String[] getListAttribute(TorrentAttribute attribute) {
        TorrentManager tm = PluginInitializer.getDefaultInterface().getTorrentManager();
        if (attribute == tm.getAttribute("Networks")) {
            return new String[]{"Public"};
        }
        if (attribute == tm.getAttribute("PeerSources")) {
            return new String[]{"DHT"};
        }
        return null;
    }

    @Override
    public void setListAttribute(TorrentAttribute attribute, String[] value) {
        this.notSupported();
    }

    @Override
    public void setMapAttribute(TorrentAttribute attribute, Map value) {
        this.notSupported();
    }

    @Override
    public Map getMapAttribute(TorrentAttribute attribute) {
        return null;
    }

    @Override
    public void setIntAttribute(TorrentAttribute name, int value) {
        this.notSupported();
    }

    @Override
    public int getIntAttribute(TorrentAttribute name) {
        return 0;
    }

    @Override
    public void setLongAttribute(TorrentAttribute name, long value) {
        this.notSupported();
    }

    @Override
    public long getLongAttribute(TorrentAttribute name) {
        return 0L;
    }

    @Override
    public void setBooleanAttribute(TorrentAttribute name, boolean value) {
        this.notSupported();
    }

    @Override
    public boolean getBooleanAttribute(TorrentAttribute name) {
        return false;
    }

    @Override
    public boolean hasAttribute(TorrentAttribute name) {
        return false;
    }

    @Override
    public void addAttributeListener(DownloadAttributeListener l, TorrentAttribute attr, int event_type) {
    }

    @Override
    public void removeAttributeListener(DownloadAttributeListener l, TorrentAttribute attr, int event_type) {
    }

    @Override
    public String getCategoryName() {
        return null;
    }

    @Override
    public void setCategory(String sName) {
        this.notSupported();
    }

    @Override
    public void remove() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void remove(boolean delete_torrent, boolean delete_data) throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public boolean isRemoved() {
        return false;
    }

    @Override
    public int getPosition() {
        return 0;
    }

    @Override
    public long getCreationTime() {
        return 0L;
    }

    @Override
    public void setPosition(int newPosition) {
        this.notSupported();
    }

    @Override
    public void moveUp() {
        this.notSupported();
    }

    @Override
    public void moveDown() {
        this.notSupported();
    }

    @Override
    public void moveTo(int position) {
        this.notSupported();
    }

    @Override
    public boolean canBeRemoved() throws DownloadRemovalVetoException {
        throw new DownloadRemovalVetoException("no way");
    }

    @Override
    public void setAnnounceResult(DownloadAnnounceResult result) {
        this.announcer.setAnnounceResult(result);
    }

    @Override
    public void setScrapeResult(DownloadScrapeResult result) {
    }

    @Override
    public DownloadAnnounceResult getLastAnnounceResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.announce_result;
    }

    @Override
    public DownloadScrapeResult getLastScrapeResult() {
        this.announce_result.setContent(this.announcer.getLastResponse());
        return this.scrape_result;
    }

    @Override
    public DownloadScrapeResult getAggregatedScrapeResult() {
        return this.getLastScrapeResult();
    }

    @Override
    public DownloadActivationEvent getActivationState() {
        return null;
    }

    @Override
    public DownloadStats getStats() {
        return null;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public void setMaximumDownloadKBPerSecond(int kb) {
        this.notSupported();
    }

    @Override
    public int getMaximumDownloadKBPerSecond() {
        return 0;
    }

    @Override
    public void addRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.notSupported();
    }

    @Override
    public void removeRateLimiter(RateLimiter limiter, boolean is_upload) {
        this.notSupported();
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        return 0;
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int max_rate_bps) {
        this.notSupported();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public boolean isComplete(boolean bIncludeDND) {
        return true;
    }

    @Override
    public boolean isChecking() {
        return false;
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public String getSavePath() {
        return "";
    }

    @Override
    public void moveDataFiles(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    @Override
    public boolean canMoveDataFiles() {
        return false;
    }

    @Override
    public void moveTorrentFile(File new_parent_dir) throws DownloadException {
        this.notSupported();
    }

    @Override
    public void renameDownload(String name) throws DownloadException {
        this.notSupported();
    }

    @Override
    public PeerManager getPeerManager() {
        return null;
    }

    @Override
    public DiskManager getDiskManager() {
        return null;
    }

    @Override
    public DiskManagerFileInfo[] getDiskManagerFileInfo() {
        return null;
    }

    @Override
    public DiskManagerFileInfo getDiskManagerFileInfo(int i) {
        return null;
    }

    @Override
    public int getDiskManagerFileCount() {
        return 0;
    }

    @Override
    public void requestTrackerAnnounce() {
    }

    @Override
    public void requestTrackerAnnounce(boolean immediate) {
    }

    @Override
    public void requestTrackerScrape(boolean immediate) {
    }

    @Override
    public void addListener(DownloadListener l) {
    }

    @Override
    public void removeListener(DownloadListener l) {
    }

    @Override
    public void addCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    @Override
    public void removeCompletionListener(DownloadCompletionListener l) {
        this.notSupported();
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l) {
    }

    @Override
    public void addTrackerListener(DownloadTrackerListener l, boolean immediateTrigger) {
    }

    @Override
    public void removeTrackerListener(DownloadTrackerListener l) {
    }

    @Override
    public void addDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    @Override
    public void removeDownloadWillBeRemovedListener(DownloadWillBeRemovedListener l) {
        this.notSupported();
    }

    @Override
    public void addActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    @Override
    public void removeActivationListener(DownloadActivationListener l) {
        this.notSupported();
    }

    @Override
    public void addPeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    @Override
    public void removePeerListener(DownloadPeerListener l) {
        this.notSupported();
    }

    @Override
    public int getSeedingRank() {
        return 0;
    }

    @Override
    public void setSeedingRank(int rank) {
        this.notSupported();
    }

    @Override
    public void addPropertyListener(DownloadPropertyListener l) {
        this.notSupported();
    }

    @Override
    public void removePropertyListener(DownloadPropertyListener l) {
        this.notSupported();
    }

    @Override
    public byte[] getDownloadPeerId() {
        return null;
    }

    @Override
    public boolean isMessagingEnabled() {
        return true;
    }

    @Override
    public void setMessagingEnabled(boolean enabled) {
    }

    @Override
    public void moveDataFiles(File new_parent_dir, String new_name) throws DownloadException {
        this.notSupported();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        Map map = this.user_data;
        synchronized (map) {
            return this.user_data.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object data) {
        Map map = this.user_data;
        synchronized (map) {
            this.user_data.put(key, data);
        }
    }

    @Override
    public void changeLocation(SaveLocationChange slc) throws DownloadException {
        this.notSupported();
    }

    @Override
    public boolean isStub() {
        return false;
    }

    @Override
    public boolean canStubbify() {
        return false;
    }

    @Override
    public DownloadStub stubbify() throws DownloadException, DownloadRemovalVetoException {
        throw new DownloadException("Not Supported");
    }

    @Override
    public Download destubbify() throws DownloadException {
        throw new DownloadException("Not Supported");
    }

    @Override
    public List<DistributedDatabase> getDistributedDatabases() {
        return DDBaseImpl.getDDBs(this);
    }

    @Override
    public byte[] getTorrentHash() {
        return this.lws.getTorrent().getHash();
    }

    @Override
    public long getTorrentSize() {
        return this.lws.getTorrent().getSize();
    }

    @Override
    public DownloadStub.DownloadStubFile[] getStubFiles() {
        this.notSupported();
        return null;
    }

    protected void notSupported() {
        Debug.out("Not Supported");
    }
}

