/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.TimeFormatter;

public class OutgoingMessageQueueImpl
implements OutgoingMessageQueue {
    private final LinkedList queue = new LinkedList();
    private final AEMonitor queue_mon = new AEMonitor("OutgoingMessageQueue:queue");
    private final ArrayList delayed_notifications = new ArrayList();
    private final AEMonitor delayed_notifications_mon = new AEMonitor("OutgoingMessageQueue:DN");
    private volatile ArrayList listeners = new ArrayList();
    private final AEMonitor listeners_mon = new AEMonitor("OutgoingMessageQueue:L");
    private int total_size = 0;
    private int total_data_size = 0;
    private boolean priority_boost = false;
    private RawMessage urgent_message = null;
    private boolean destroyed = false;
    private MessageStreamEncoder stream_encoder;
    private Transport transport;
    private int percent_complete = -1;
    private static final boolean TRACE_HISTORY = false;
    private static final int MAX_HISTORY_TRACES = 30;
    private final LinkedList prev_sent = new LinkedList();
    private boolean trace;
    private WeakReference rawBufferCache = new WeakReference<Object>(null);
    private WeakReference origPositionsCache = new WeakReference<Object>(null);

    public OutgoingMessageQueueImpl(MessageStreamEncoder stream_encoder) {
        this.stream_encoder = stream_encoder;
    }

    public void setTransport(Transport _transport) {
        this.transport = _transport;
    }

    public int getMssSize() {
        return this.transport == null ? NetworkManager.getMinMssSize() : this.transport.getMssSize();
    }

    public void setEncoder(MessageStreamEncoder stream_encoder) {
        this.stream_encoder = stream_encoder;
    }

    public MessageStreamEncoder getEncoder() {
        return this.stream_encoder;
    }

    public int getPercentDoneOfCurrentMessage() {
        return this.percent_complete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.destroyed = true;
        try {
            this.queue_mon.enter();
            while (!this.queue.isEmpty()) {
                ((RawMessage)this.queue.remove(0)).destroy();
            }
            Object var2_1 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        this.total_size = 0;
        this.total_data_size = 0;
        this.prev_sent.clear();
        this.listeners = new ArrayList();
        this.percent_complete = -1;
        this.urgent_message = null;
    }

    public int getTotalSize() {
        return this.total_size;
    }

    public int getDataQueuedBytes() {
        return this.total_data_size;
    }

    public int getProtocolQueuedBytes() {
        return this.total_size - this.total_data_size;
    }

    public boolean getPriorityBoost() {
        return this.priority_boost;
    }

    public void setPriorityBoost(boolean boost) {
        this.priority_boost = boost;
    }

    public boolean isBlocked() {
        if (this.transport == null) {
            return false;
        }
        return !this.transport.isReadyForWrite(null);
    }

    public boolean hasUrgentMessage() {
        return this.urgent_message != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessage(Message message, boolean manual_listener_notify) {
        boolean allowed = true;
        ArrayList list_ref = this.listeners;
        for (int i = 0; i < list_ref.size(); ++i) {
            OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)list_ref.get(i);
            allowed = allowed && listener.messageAdded(message);
        }
        if (!allowed) {
            return;
        }
        RawMessage[] rmesgs = this.stream_encoder.encodeMessage(message);
        if (this.destroyed) {
            for (int i = 0; i < rmesgs.length; ++i) {
                rmesgs[i].destroy();
            }
            return;
        }
        for (int i = 0; i < rmesgs.length; ++i) {
            Object var13_19;
            RawMessage rmesg = rmesgs[i];
            this.removeMessagesOfType(rmesg.messagesToRemove(), manual_listener_notify);
            try {
                this.queue_mon.enter();
                int pos = 0;
                for (RawMessage msg : this.queue) {
                    if (rmesg.getPriority() > msg.getPriority() && msg.getRawData()[0].position((byte)5) == 0) break;
                    ++pos;
                }
                if (rmesg.isNoDelay()) {
                    this.urgent_message = rmesg;
                }
                this.queue.add(pos, rmesg);
                DirectByteBuffer[] payload = rmesg.getRawData();
                int remaining = 0;
                for (int j = 0; j < payload.length; ++j) {
                    remaining += payload[j].remaining((byte)5);
                }
                this.total_size += remaining;
                if (rmesg.getType() == 1) {
                    this.total_data_size += remaining;
                }
                var13_19 = null;
                this.queue_mon.exit();
            }
            catch (Throwable throwable) {
                var13_19 = null;
                this.queue_mon.exit();
                throw throwable;
            }
            if (manual_listener_notify) {
                Object var15_20;
                NotificationItem item = new NotificationItem(0);
                item.message = rmesg;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                    var15_20 = null;
                    this.delayed_notifications_mon.exit();
                    continue;
                }
                catch (Throwable throwable) {
                    var15_20 = null;
                    this.delayed_notifications_mon.exit();
                    throw throwable;
                }
            }
            ArrayList listeners_ref = this.listeners;
            for (int j = 0; j < listeners_ref.size(); ++j) {
                OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(j);
                listener.messageQueued(rmesg.getBaseMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessagesOfType(Message[] message_types, boolean manual_listener_notify) {
        if (message_types == null) {
            return;
        }
        ArrayList<RawMessage> messages_removed = null;
        try {
            this.queue_mon.enter();
            Iterator i = this.queue.iterator();
            block4: while (i.hasNext()) {
                RawMessage msg = (RawMessage)i.next();
                for (int t = 0; t < message_types.length; ++t) {
                    boolean same_type = message_types[t].getID().equals(msg.getID());
                    if (!same_type || msg.getRawData()[0].position((byte)5) != 0) continue;
                    if (msg == this.urgent_message) {
                        this.urgent_message = null;
                    }
                    DirectByteBuffer[] payload = msg.getRawData();
                    int remaining = 0;
                    for (int x = 0; x < payload.length; ++x) {
                        remaining += payload[x].remaining((byte)5);
                    }
                    this.total_size -= remaining;
                    if (msg.getType() == 1) {
                        this.total_data_size -= remaining;
                    }
                    if (manual_listener_notify) {
                        Object var12_15;
                        NotificationItem item = new NotificationItem(1);
                        item.message = msg;
                        try {
                            this.delayed_notifications_mon.enter();
                            this.delayed_notifications.add(item);
                            var12_15 = null;
                            this.delayed_notifications_mon.exit();
                        }
                        catch (Throwable throwable) {
                            var12_15 = null;
                            this.delayed_notifications_mon.exit();
                            throw throwable;
                        }
                    } else {
                        if (messages_removed == null) {
                            messages_removed = new ArrayList<RawMessage>();
                        }
                        messages_removed.add(msg);
                    }
                    i.remove();
                    continue block4;
                }
            }
            if (this.queue.isEmpty()) {
                this.percent_complete = -1;
            }
            Object var14_17 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        if (!manual_listener_notify && messages_removed != null) {
            ArrayList listeners_ref = this.listeners;
            for (int x = 0; x < messages_removed.size(); ++x) {
                RawMessage msg = (RawMessage)messages_removed.get(x);
                for (int i = 0; i < listeners_ref.size(); ++i) {
                    OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg.getBaseMessage());
                }
                msg.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMessage(Message message, boolean manual_listener_notify) {
        Message msg_removed = null;
        try {
            this.queue_mon.enter();
            for (RawMessage raw : this.queue) {
                if (!message.equals(raw.getBaseMessage())) continue;
                if (raw.getRawData()[0].position((byte)5) != 0) break;
                if (raw == this.urgent_message) {
                    this.urgent_message = null;
                }
                DirectByteBuffer[] payload = raw.getRawData();
                int remaining = 0;
                for (int x = 0; x < payload.length; ++x) {
                    remaining += payload[x].remaining((byte)5);
                }
                this.total_size -= remaining;
                if (raw.getType() == 1) {
                    this.total_data_size -= remaining;
                }
                this.queue.remove(raw);
                msg_removed = raw;
                break;
            }
            if (this.queue.isEmpty()) {
                this.percent_complete = -1;
            }
            Object var10_10 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        if (msg_removed != null) {
            if (manual_listener_notify) {
                NotificationItem item = new NotificationItem(1);
                item.message = msg_removed;
                try {
                    this.delayed_notifications_mon.enter();
                    this.delayed_notifications.add(item);
                    Object var12_13 = null;
                    this.delayed_notifications_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    this.delayed_notifications_mon.exit();
                    throw throwable;
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                for (int i = 0; i < listeners_ref.size(); ++i) {
                    OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                    listener.messageRemoved(msg_removed.getBaseMessage());
                }
                msg_removed.destroy();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deliverToTransport(int max_bytes, boolean manual_listener_notify) throws IOException {
        if (max_bytes < 1) {
            Debug.out("max_bytes < 1: " + max_bytes);
            return 0;
        }
        if (this.transport == null) {
            throw new IOException("not ready to deliver data");
        }
        int data_written = 0;
        int protocol_written = 0;
        ArrayList<RawMessage> messages_sent = null;
        try {
            this.queue_mon.enter();
            if (!this.queue.isEmpty()) {
                int buffer_limit = 64;
                Object[] raw_buffers = (ByteBuffer[])this.rawBufferCache.get();
                if (raw_buffers == null) {
                    raw_buffers = new ByteBuffer[buffer_limit];
                    this.rawBufferCache = new WeakReference<Object[]>(raw_buffers);
                } else {
                    Arrays.fill(raw_buffers, null);
                }
                int[] orig_positions = (int[])this.origPositionsCache.get();
                if (orig_positions == null) {
                    orig_positions = new int[buffer_limit];
                    this.origPositionsCache = new WeakReference<int[]>(orig_positions);
                } else {
                    Arrays.fill(orig_positions, 0);
                }
                int buffer_count = 0;
                int total_sofar = 0;
                Iterator i = this.queue.iterator();
                block8: while (i.hasNext()) {
                    DirectByteBuffer[] payloads = ((RawMessage)i.next()).getRawData();
                    for (int x = 0; x < payloads.length; ++x) {
                        ByteBuffer buff = payloads[x].getBuffer((byte)5);
                        raw_buffers[buffer_count] = buff;
                        orig_positions[buffer_count] = buff.position();
                        ++buffer_count;
                        if ((total_sofar += buff.remaining()) >= max_bytes) break block8;
                        if (buffer_count != buffer_limit) continue;
                        int new_buffer_limit = buffer_limit * 2;
                        ByteBuffer[] new_raw_buffers = new ByteBuffer[new_buffer_limit];
                        int[] new_orig_positions = new int[new_buffer_limit];
                        System.arraycopy(raw_buffers, 0, new_raw_buffers, 0, buffer_limit);
                        System.arraycopy(orig_positions, 0, new_orig_positions, 0, buffer_limit);
                        raw_buffers = new_raw_buffers;
                        orig_positions = new_orig_positions;
                        buffer_limit = new_buffer_limit;
                    }
                }
                Object last_buff = raw_buffers[buffer_count - 1];
                int orig_last_limit = ((Buffer)last_buff).limit();
                if (total_sofar > max_bytes) {
                    ((ByteBuffer)last_buff).limit(orig_last_limit - (total_sofar - max_bytes));
                }
                this.transport.write((ByteBuffer[])raw_buffers, 0, buffer_count);
                ((ByteBuffer)last_buff).limit(orig_last_limit);
                int pos = 0;
                boolean stop = false;
                block10: while (!this.queue.isEmpty() && !stop) {
                    RawMessage msg = (RawMessage)this.queue.get(0);
                    DirectByteBuffer[] payloads = msg.getRawData();
                    for (int x = 0; x < payloads.length; ++x) {
                        ByteBuffer bb = payloads[x].getBuffer((byte)5);
                        int bytes_written = bb.limit() - bb.remaining() - orig_positions[pos];
                        this.total_size -= bytes_written;
                        if (msg.getType() == 1) {
                            this.total_data_size -= bytes_written;
                        }
                        if (x > 0 && msg.getType() == 1) {
                            data_written += bytes_written;
                        } else {
                            protocol_written += bytes_written;
                        }
                        if (bb.hasRemaining()) {
                            stop = true;
                            int message_size = 0;
                            int written = 0;
                            for (int i2 = 0; i2 < payloads.length; ++i2) {
                                ByteBuffer buff = payloads[i2].getBuffer((byte)5);
                                message_size += buff.limit();
                                if (i2 < x) {
                                    written += buff.limit();
                                    continue;
                                }
                                if (i2 != x) continue;
                                written += buff.position();
                            }
                            this.percent_complete = written * 100 / message_size;
                            continue block10;
                        }
                        if (x == payloads.length - 1) {
                            if (msg == this.urgent_message) {
                                this.urgent_message = null;
                            }
                            this.queue.remove(0);
                            this.percent_complete = -1;
                            if (manual_listener_notify) {
                                Object var25_35;
                                NotificationItem item = new NotificationItem(2);
                                item.message = msg;
                                try {
                                    this.delayed_notifications_mon.enter();
                                    this.delayed_notifications.add(item);
                                    var25_35 = null;
                                    this.delayed_notifications_mon.exit();
                                }
                                catch (Throwable throwable) {
                                    var25_35 = null;
                                    this.delayed_notifications_mon.exit();
                                    throw throwable;
                                }
                            } else {
                                if (messages_sent == null) {
                                    messages_sent = new ArrayList<RawMessage>();
                                }
                                messages_sent.add(msg);
                            }
                        }
                        if (++pos < buffer_count) continue;
                        stop = true;
                        continue block10;
                    }
                }
            }
            Object var27_37 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var27_38 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        if (data_written + protocol_written > 0 || messages_sent != null) {
            if (this.trace) {
                TimeFormatter.milliTrace("omq:deliver: " + (data_written + protocol_written) + ", q=" + this.queue.size() + "/" + this.total_size);
            }
            if (manual_listener_notify) {
                if (data_written > 0) {
                    NotificationItem item = new NotificationItem(3);
                    item.byte_count = data_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                        Object var29_40 = null;
                        this.delayed_notifications_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var29_41 = null;
                        this.delayed_notifications_mon.exit();
                        throw throwable;
                    }
                }
                if (protocol_written > 0) {
                    NotificationItem item = new NotificationItem(4);
                    item.byte_count = protocol_written;
                    try {
                        this.delayed_notifications_mon.enter();
                        this.delayed_notifications.add(item);
                        Object var31_43 = null;
                        this.delayed_notifications_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var31_44 = null;
                        this.delayed_notifications_mon.exit();
                        throw throwable;
                    }
                }
            } else {
                ArrayList listeners_ref = this.listeners;
                int num_listeners = listeners_ref.size();
                for (int i = 0; i < num_listeners; ++i) {
                    OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                    if (data_written > 0) {
                        listener.dataBytesSent(data_written);
                    }
                    if (protocol_written > 0) {
                        listener.protocolBytesSent(protocol_written);
                    }
                    if (messages_sent == null) continue;
                    for (int x = 0; x < messages_sent.size(); ++x) {
                        RawMessage msg = (RawMessage)messages_sent.get(x);
                        listener.messageSent(msg.getBaseMessage());
                        if (i != num_listeners - 1) continue;
                        msg.destroy();
                    }
                }
            }
        } else if (this.trace) {
            TimeFormatter.milliTrace("omq:deliver: 0, q=" + this.queue.size() + "/" + this.total_size);
        }
        return data_written + protocol_written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        try {
            this.queue_mon.enter();
            if (this.queue.isEmpty()) {
                Object var4_1 = null;
                this.queue_mon.exit();
                return;
            }
            for (int i = 0; i < this.queue.size(); ++i) {
                RawMessage msg = (RawMessage)this.queue.get(i);
                msg.setNoDelay();
                if (i != 0) continue;
                this.urgent_message = msg;
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        Object var4_2 = null;
        this.queue_mon.exit();
        ArrayList list_ref = this.listeners;
        for (int i = 0; i < list_ref.size(); ++i) {
            OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)list_ref.get(i);
            listener.flush();
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doListenerNotifications() {
        ArrayList notifications_copy;
        try {
            this.delayed_notifications_mon.enter();
            if (this.delayed_notifications.size() == 0) {
                Object var3_1 = null;
                this.delayed_notifications_mon.exit();
                return;
            }
            notifications_copy = new ArrayList(this.delayed_notifications);
            this.delayed_notifications.clear();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.delayed_notifications_mon.exit();
            throw throwable;
        }
        Object var3_2 = null;
        this.delayed_notifications_mon.exit();
        ArrayList listeners_ref = this.listeners;
        block9: for (int j = 0; j < notifications_copy.size(); ++j) {
            NotificationItem item = (NotificationItem)notifications_copy.get(j);
            switch (item.type) {
                case 0: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.messageQueued(item.message.getBaseMessage());
                    }
                    continue block9;
                }
                case 1: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.messageRemoved(item.message.getBaseMessage());
                    }
                    item.message.destroy();
                    continue block9;
                }
                case 2: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.messageSent(item.message.getBaseMessage());
                    }
                    item.message.destroy();
                    continue block9;
                }
                case 4: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.protocolBytesSent(item.byte_count);
                    }
                    continue block9;
                }
                case 3: {
                    OutgoingMessageQueue.MessageQueueListener listener;
                    int i;
                    for (i = 0; i < listeners_ref.size(); ++i) {
                        listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
                        listener.dataBytesSent(item.byte_count);
                    }
                    continue block9;
                }
                default: {
                    Debug.out("NotificationItem.type unknown :" + item.type);
                }
            }
        }
    }

    public void setTrace(boolean on) {
        this.trace = on;
        this.transport.setTrace(on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getQueueTrace() {
        StringBuffer trace = new StringBuffer();
        trace.append("**** OUTGOING QUEUE TRACE ****\n");
        try {
            this.queue_mon.enter();
            int i = 0;
            for (RawMessage raw : this.prev_sent) {
                trace.append("[#h" + i + "]: ").append(raw.getID()).append(" [").append(raw.getDescription()).append("]").append("\n");
                ++i;
            }
            int position = this.queue.size() - 1;
            for (RawMessage raw : this.queue) {
                int pos = raw.getRawData()[0].position((byte)5);
                int length = raw.getRawData()[0].limit((byte)5);
                trace.append("[#").append(position).append(" ").append(pos).append(":").append(length).append("]: ").append(raw.getID()).append(" [").append(raw.getDescription()).append("]").append("\n");
                --position;
            }
            Object var9_9 = null;
            this.queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.queue_mon.exit();
            throw throwable;
        }
        return trace.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList<OutgoingMessageQueue.MessageQueueListener> new_list = new ArrayList<OutgoingMessageQueue.MessageQueueListener>(this.listeners.size() + 1);
            new_list.addAll(this.listeners);
            new_list.add(listener);
            this.listeners = new_list;
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQueueListener(OutgoingMessageQueue.MessageQueueListener listener) {
        try {
            this.listeners_mon.enter();
            ArrayList new_list = new ArrayList(this.listeners);
            new_list.remove(listener);
            this.listeners = new_list;
            Object var4_3 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public void notifyOfExternallySentMessage(Message message) {
        int i;
        ArrayList listeners_ref = this.listeners;
        DirectByteBuffer[] buffs = message.getData();
        int size = 0;
        for (i = 0; i < buffs.length; ++i) {
            size += buffs[i].remaining((byte)5);
        }
        for (i = 0; i < listeners_ref.size(); ++i) {
            OutgoingMessageQueue.MessageQueueListener listener = (OutgoingMessageQueue.MessageQueueListener)listeners_ref.get(i);
            listener.messageSent(message);
            if (message.getType() == 1) {
                listener.dataBytesSent(size);
                continue;
            }
            listener.protocolBytesSent(size);
        }
    }

    private static class NotificationItem {
        private static final int MESSAGE_ADDED = 0;
        private static final int MESSAGE_REMOVED = 1;
        private static final int MESSAGE_SENT = 2;
        private static final int DATA_BYTES_SENT = 3;
        private static final int PROTOCOL_BYTES_SENT = 4;
        private final int type;
        private RawMessage message;
        private int byte_count = 0;

        private NotificationItem(int notification_type) {
            this.type = notification_type;
        }
    }
}

