/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.util;

import com.aelitis.azureus.core.util.IdentityHashSet;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyOnWriteSet<T> {
    private boolean is_identify;
    private volatile Set<T> set;
    private boolean visible = false;

    public CopyOnWriteSet(boolean identity_hash_set) {
        this.is_identify = identity_hash_set;
        this.set = this.is_identify ? new IdentityHashSet<T>() : new HashSet<T>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(T o) {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            if (this.visible) {
                AbstractSet new_set = this.is_identify ? new IdentityHashSet<T>(this.set) : new HashSet<T>(this.set);
                new_set.add(o);
                this.set = new_set;
                this.visible = false;
            } else {
                this.set.add(o);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T o) {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            if (this.visible) {
                AbstractSet new_set = this.is_identify ? new IdentityHashSet<T>(this.set) : new HashSet<T>(this.set);
                boolean res = new_set.remove(o);
                this.set = new_set;
                this.visible = false;
                return res;
            }
            return this.set.remove(o);
        }
    }

    public boolean contains(T o) {
        return this.set.contains(o);
    }

    public int size() {
        return this.set.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getSet() {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            this.visible = true;
            return this.set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator<T> iterator() {
        CopyOnWriteSet copyOnWriteSet = this;
        synchronized (copyOnWriteSet) {
            this.visible = true;
            return new CopyOnWriteSetIterator(this.set.iterator());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyOnWriteSetIterator
    implements Iterator<T> {
        private Iterator<T> it;
        private T last;

        protected CopyOnWriteSetIterator(Iterator<T> _it) {
            this.it = _it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            this.last = this.it.next();
            return this.last;
        }

        @Override
        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException("next has not been called!");
            }
            CopyOnWriteSet.this.remove(this.last);
        }
    }
}

