/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerStats;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;

public class CacheView
implements UISWTViewCoreEventListener {
    public static final String MSGID_PREFIX = "CacheView";
    CacheFileManagerStats stats;
    Composite panel;
    Label lblInUse;
    Label lblSize;
    Label lblPercentUsed;
    ProgressBar pbInUse;
    Label lblReadsFromCache;
    Label lblNumberReadsFromCache;
    Label lblAvgSizeFromCache;
    Label lblReadsFromFile;
    Label lblNumberReadsFromFile;
    Label lblAvgSizeFromFile;
    Label lblPercentReads;
    ProgressBar pbReads;
    Label lblWritesToCache;
    Label lblNumberWritesToCache;
    Label lblAvgSizeToCache;
    Label lblWritesToFile;
    Label lblNumberWritesToFile;
    Label lblAvgSizeToFile;
    Label lblPercentWrites;
    ProgressBar pbWrites;
    Canvas readsFromFile;
    Canvas readsFromCache;
    Canvas writesToCache;
    Canvas writesToFile;
    SpeedGraphic rffGraph;
    SpeedGraphic rfcGraph;
    SpeedGraphic wtcGraph;
    SpeedGraphic wtfGraph;
    private UISWTView swtView;

    public CacheView() {
        try {
            this.stats = CacheFileManagerFactory.getSingleton().getStats();
            this.rfcGraph = SpeedGraphic.getInstance();
            this.wtcGraph = SpeedGraphic.getInstance();
            this.rffGraph = SpeedGraphic.getInstance();
            this.wtfGraph = SpeedGraphic.getInstance();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    private void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new GridLayout());
        this.generateGeneralGroup();
        this.generateReadsGroup();
        this.generateWritesGroup();
        this.generateSpeedGroup();
    }

    private void generateGeneralGroup() {
        Group gCacheGeneral = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheGeneral, "CacheView.general.title");
        gCacheGeneral.setLayoutData((Object)new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 4;
        gCacheGeneral.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheGeneral, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.general.inUse");
        this.lblInUse = new Label((Composite)gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblInUse.setLayoutData((Object)gridData);
        this.pbInUse = new ProgressBar((Composite)gCacheGeneral, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbInUse.setLayoutData((Object)gridData);
        this.pbInUse.setMinimum(0);
        this.pbInUse.setMaximum(1000);
        this.lblPercentUsed = new Label((Composite)gCacheGeneral, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        this.lblPercentUsed.setLayoutData((Object)gridData);
        lbl = new Label((Composite)gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.general.size");
        this.lblSize = new Label((Composite)gCacheGeneral, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblSize.setLayoutData((Object)gridData);
    }

    private void generateReadsGroup() {
        Group gCacheReads = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheReads, "CacheView.reads.title");
        gCacheReads.setLayoutData((Object)new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheReads.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheReads, 0);
        lbl = new Label((Composite)gCacheReads, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.#");
        lbl = new Label((Composite)gCacheReads, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.amount");
        lbl = new Label((Composite)gCacheReads, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.avgsize");
        lbl = new Label((Composite)gCacheReads, 0);
        lbl = new Label((Composite)gCacheReads, 0);
        lbl = new Label((Composite)gCacheReads, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.fromCache");
        this.lblNumberReadsFromCache = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberReadsFromCache.setLayoutData((Object)gridData);
        this.lblReadsFromCache = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblReadsFromCache.setLayoutData((Object)gridData);
        this.lblAvgSizeFromCache = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeFromCache.setLayoutData((Object)gridData);
        this.pbReads = new ProgressBar((Composite)gCacheReads, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbReads.setLayoutData((Object)gridData);
        this.pbReads.setMinimum(0);
        this.pbReads.setMaximum(1000);
        this.lblPercentReads = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        this.lblPercentReads.setLayoutData((Object)gridData);
        lbl = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.fromFile");
        this.lblNumberReadsFromFile = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberReadsFromFile.setLayoutData((Object)gridData);
        this.lblReadsFromFile = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblReadsFromFile.setLayoutData((Object)gridData);
        this.lblAvgSizeFromFile = new Label((Composite)gCacheReads, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeFromFile.setLayoutData((Object)gridData);
    }

    private void generateSpeedGroup() {
        Group gCacheSpeeds = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheSpeeds, "CacheView.speeds.title");
        gCacheSpeeds.setLayoutData((Object)new GridData(1808));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 3;
        gCacheSpeeds.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheSpeeds, 0);
        lbl = new Label((Composite)gCacheSpeeds, 0);
        GridData gridData = new GridData(64);
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.reads");
        lbl = new Label((Composite)gCacheSpeeds, 0);
        gridData = new GridData(64);
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.writes");
        lbl = new Label((Composite)gCacheSpeeds, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.fromCache");
        this.readsFromCache = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.readsFromCache.setLayoutData((Object)gridData);
        this.rfcGraph.initialize(this.readsFromCache);
        this.writesToCache = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.writesToCache.setLayoutData((Object)gridData);
        this.wtcGraph.initialize(this.writesToCache);
        lbl = new Label((Composite)gCacheSpeeds, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.speeds.fromFile");
        this.readsFromFile = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.readsFromFile.setLayoutData((Object)gridData);
        this.rffGraph.initialize(this.readsFromFile);
        this.writesToFile = new Canvas((Composite)gCacheSpeeds, 262144);
        gridData = new GridData(1808);
        this.writesToFile.setLayoutData((Object)gridData);
        this.wtfGraph.initialize(this.writesToFile);
    }

    public void periodicUpdate() {
        this.rfcGraph.addIntValue((int)this.stats.getAverageBytesReadFromCache());
        this.rffGraph.addIntValue((int)this.stats.getAverageBytesReadFromFile());
        this.wtcGraph.addIntValue((int)this.stats.getAverageBytesWrittenToCache());
        this.wtfGraph.addIntValue((int)this.stats.getAverageBytesWrittenToFile());
    }

    private void generateWritesGroup() {
        Group gCacheWrites = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gCacheWrites, "CacheView.writes.title");
        gCacheWrites.setLayoutData((Object)new GridData(768));
        GridLayout layoutGeneral = new GridLayout();
        layoutGeneral.numColumns = 6;
        gCacheWrites.setLayout((Layout)layoutGeneral);
        Label lbl = new Label((Composite)gCacheWrites, 0);
        lbl = new Label((Composite)gCacheWrites, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.#");
        lbl = new Label((Composite)gCacheWrites, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.amount");
        lbl = new Label((Composite)gCacheWrites, 0);
        Messages.setLanguageText((Widget)lbl, "CacheView.reads.avgsize");
        lbl = new Label((Composite)gCacheWrites, 0);
        lbl = new Label((Composite)gCacheWrites, 0);
        lbl = new Label((Composite)gCacheWrites, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.writes.toCache");
        this.lblNumberWritesToCache = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberWritesToCache.setLayoutData((Object)gridData);
        this.lblWritesToCache = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblWritesToCache.setLayoutData((Object)gridData);
        this.lblAvgSizeToCache = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeToCache.setLayoutData((Object)gridData);
        this.pbWrites = new ProgressBar((Composite)gCacheWrites, 256);
        gridData = new GridData(768);
        gridData.verticalSpan = 2;
        this.pbWrites.setLayoutData((Object)gridData);
        this.pbWrites.setMinimum(0);
        this.pbWrites.setMaximum(1000);
        this.lblPercentWrites = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.widthHint = 100;
        this.lblPercentWrites.setLayoutData((Object)gridData);
        lbl = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        lbl.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lbl, "CacheView.writes.toFile");
        this.lblNumberWritesToFile = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblNumberWritesToFile.setLayoutData((Object)gridData);
        this.lblWritesToFile = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblWritesToFile.setLayoutData((Object)gridData);
        this.lblAvgSizeToFile = new Label((Composite)gCacheWrites, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.lblAvgSizeToFile.setLayoutData((Object)gridData);
    }

    private void delete() {
        Utils.disposeComposite(this.panel);
        this.rfcGraph.dispose();
        this.rffGraph.dispose();
        this.wtcGraph.dispose();
        this.wtfGraph.dispose();
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getSize()));
        this.lblInUse.setText(DisplayFormatters.formatByteCountToKiBEtc(this.stats.getUsedSize()));
        int perThousands = (int)(1000L * this.stats.getUsedSize() / this.stats.getSize());
        this.lblPercentUsed.setText(DisplayFormatters.formatPercentFromThousands(perThousands));
        this.pbInUse.setSelection(perThousands);
        this.refrehReads();
        this.refreshWrites();
        this.rfcGraph.refresh(false);
        this.rffGraph.refresh(false);
        this.wtcGraph.refresh(false);
        this.wtfGraph.refresh(false);
    }

    private void refrehReads() {
        long readsFromCache = this.stats.getBytesReadFromCache();
        long readsFromFile = this.stats.getBytesReadFromFile();
        long nbReadsFromCache = this.stats.getCacheReadCount();
        long nbReadsFromFile = this.stats.getFileReadCount();
        this.lblNumberReadsFromCache.setText("" + nbReadsFromCache);
        this.lblNumberReadsFromFile.setText("" + nbReadsFromFile);
        if (nbReadsFromCache != 0L) {
            long avgReadFromCache = readsFromCache / nbReadsFromCache;
            this.lblAvgSizeFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromCache));
        } else {
            this.lblAvgSizeFromCache.setText("--");
        }
        if (nbReadsFromFile != 0L) {
            long avgReadFromFile = readsFromFile / nbReadsFromFile;
            this.lblAvgSizeFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadFromFile));
        } else {
            this.lblAvgSizeFromFile.setText("--");
        }
        this.lblReadsFromCache.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromCache));
        this.lblReadsFromFile.setText(DisplayFormatters.formatByteCountToKiBEtc(readsFromFile));
        long totalRead = readsFromCache + readsFromFile;
        if (totalRead > 0L) {
            int perThousands = (int)(1000L * this.stats.getBytesReadFromCache() / totalRead);
            this.lblPercentReads.setText(DisplayFormatters.formatPercentFromThousands(perThousands) + " " + MessageText.getString("CacheView.reads.hits"));
            this.pbReads.setSelection(perThousands);
        }
    }

    private void refreshWrites() {
        long writesToCache = this.stats.getBytesWrittenToCache();
        long writesToFile = this.stats.getBytesWrittenToFile();
        long nbWritesToCache = this.stats.getCacheWriteCount();
        long nbWritesToFile = this.stats.getFileWriteCount();
        this.lblNumberWritesToCache.setText("" + nbWritesToCache);
        this.lblNumberWritesToFile.setText("" + nbWritesToFile);
        if (nbWritesToCache != 0L) {
            long avgReadToCache = writesToCache / nbWritesToCache;
            this.lblAvgSizeToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToCache));
        } else {
            this.lblAvgSizeToCache.setText("--");
        }
        if (nbWritesToFile != 0L) {
            long avgReadToFile = writesToFile / nbWritesToFile;
            this.lblAvgSizeToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(avgReadToFile));
        } else {
            this.lblAvgSizeToFile.setText("--");
        }
        this.lblWritesToCache.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToCache));
        this.lblWritesToFile.setText(DisplayFormatters.formatByteCountToKiBEtc(writesToFile));
        long totalNbWrites = nbWritesToCache + nbWritesToFile;
        if (totalNbWrites > 0L) {
            int perThousands = (int)(1000L * nbWritesToCache / totalNbWrites);
            this.lblPercentWrites.setText(DisplayFormatters.formatPercentFromThousands(perThousands) + " " + MessageText.getString("CacheView.writes.hits"));
            this.pbWrites.setSelection(perThousands);
        }
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString("CacheView.title.full"));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

