/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import java.util.Locale;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;

public class PeersItem
extends CoreTableColumnSWT
implements TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "peers";
    private static String textStarted;
    private static String textStartedOver;
    private static String textNotStarted;
    private static String textStartedNoScrape;
    private static String textNotStartedNoScrape;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    public PeersItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            public void localeChanged(Locale old_locale, Locale new_locale) {
                textStarted = MessageText.getString("Column.seedspeers.started");
                textStartedOver = MessageText.getString("Column.seedspeers.started.over");
                textNotStarted = MessageText.getString("Column.seedspeers.notstarted");
                textStartedNoScrape = MessageText.getString("Column.seedspeers.started.noscrape");
                textNotStartedNoScrape = MessageText.getString("Column.seedspeers.notstarted.noscrape");
            }
        });
    }

    private static class Cell
    extends AbstractTrackerCell {
        long lTotalPeers = -1L;

        public Cell(TableCell cell) {
            super(cell);
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            if (this.checkScrapeResult(response)) {
                this.lTotalPeers = response.getPeers();
            }
        }

        public void refresh(TableCell cell) {
            long totalPeers;
            super.refresh(cell);
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            long lConnectedPeers = 0L;
            if (dm != null) {
                TRTrackerScraperResponse response;
                lConnectedPeers = dm.getNbPeers();
                if (this.lTotalPeers == -1L && (response = dm.getTrackerScrapeResponse()) != null && response.isValid()) {
                    this.lTotalPeers = response.getPeers();
                }
            }
            if ((totalPeers = this.lTotalPeers) <= 0L && dm != null) {
                totalPeers = dm.getActivationCount();
            }
            long value = lConnectedPeers * 10000000L;
            if (totalPeers > 0L) {
                value += totalPeers;
            }
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            if (dm != null) {
                boolean hasScrape;
                int state = dm.getState();
                boolean started = state == 60 || state == 50;
                boolean bl = hasScrape = this.lTotalPeers >= 0L;
                String tmp = started ? (hasScrape ? (lConnectedPeers > this.lTotalPeers ? textStartedOver : textStarted) : textStartedNoScrape) : (hasScrape ? textNotStarted : textNotStartedNoScrape);
                tmp = tmp.replaceAll("%1", String.valueOf(lConnectedPeers));
                tmp = tmp.replaceAll("%2", String.valueOf(totalPeers));
                cell.setText(tmp);
            } else {
                cell.setText("");
            }
        }

        public void cellHover(TableCell cell) {
            super.cellHover(cell);
            long lConnectedPeers = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                lConnectedPeers = dm.getNbPeers();
                String sToolTip = lConnectedPeers + " " + MessageText.getString("GeneralView.label.connected") + "\n";
                if (this.lTotalPeers != -1L) {
                    sToolTip = sToolTip + this.lTotalPeers + " " + MessageText.getString("GeneralView.label.in_swarm");
                } else {
                    TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                    sToolTip = sToolTip + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                    if (response != null) {
                        sToolTip = sToolTip + "(" + response.getStatusString() + ")";
                    }
                }
                int activationCount = dm.getActivationCount();
                if (activationCount > 0) {
                    sToolTip = sToolTip + "\n" + MessageText.getString("PeerColumn.activationCount", new String[]{"" + activationCount});
                }
                cell.setToolTip(sToolTip);
            } else {
                cell.setToolTip("");
            }
        }
    }
}

