/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public abstract class TransportHelperFilterStream
implements TransportHelperFilter {
    private TransportHelper transport;
    private DirectByteBuffer write_buffer_pending_db;
    private ByteBuffer write_buffer_pending_byte;

    protected TransportHelperFilterStream(TransportHelper _transport) {
        this.transport = _transport;
    }

    public boolean hasBufferedWrite() {
        return this.write_buffer_pending_db != null || this.write_buffer_pending_byte != null || this.transport.hasDelayedWrite();
    }

    public boolean hasBufferedRead() {
        return false;
    }

    public TransportHelper getHelper() {
        return this.transport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long write(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        if (this.write_buffer_pending_byte != null) {
            if (this.transport.write(this.write_buffer_pending_byte, false) == 0) {
                return 0L;
            }
            this.write_buffer_pending_byte = null;
        }
        long total_written = 0L;
        if (this.write_buffer_pending_db != null) {
            ByteBuffer write_buffer_pending = this.write_buffer_pending_db.getBuffer((byte)5);
            int max_writable = 0;
            for (int i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer source_buffer = buffers[i];
                int position = source_buffer.position();
                int limit = source_buffer.limit();
                int size = limit - position;
                max_writable += size;
            }
            int pending_position = write_buffer_pending.position();
            int pending_limit = write_buffer_pending.limit();
            int pending_writable = pending_limit - pending_position;
            if (pending_writable > max_writable) {
                pending_writable = max_writable;
                write_buffer_pending.limit(pending_position + pending_writable);
            }
            int written = this.transport.write(write_buffer_pending, false);
            write_buffer_pending.limit(pending_limit);
            if (written > 0) {
                total_written = written;
                if (write_buffer_pending.remaining() == 0) {
                    this.write_buffer_pending_db.returnToPool();
                    this.write_buffer_pending_db = null;
                }
                int skip = written;
                for (int i = array_offset; i < array_offset + length; ++i) {
                    ByteBuffer source_buffer = buffers[i];
                    int position = source_buffer.position();
                    int limit = source_buffer.limit();
                    int size = limit - position;
                    if (size <= skip) {
                        source_buffer.position(limit);
                        skip -= size;
                        continue;
                    }
                    source_buffer.position(position + skip);
                    skip = 0;
                    break;
                }
                if (skip != 0) {
                    throw new IOException("skip inconsistent - " + skip);
                }
            }
            if (total_written < (long)pending_writable || total_written == (long)max_writable) {
                return total_written;
            }
        }
        for (int i = array_offset; i < array_offset + length; ++i) {
            Object var19_23;
            ByteBuffer source_buffer = buffers[i];
            int position = source_buffer.position();
            int limit = source_buffer.limit();
            int size = limit - position;
            if (size == 0) continue;
            DirectByteBuffer target_buffer_db = DirectByteBufferPool.getBuffer((byte)26, size);
            try {
                ByteBuffer target_buffer = target_buffer_db.getBuffer((byte)5);
                this.cryptoOut(source_buffer, target_buffer);
                target_buffer.position(0);
                boolean partial_write = false;
                for (int j = i + 1; j < array_offset + length; ++j) {
                    if (!buffers[j].hasRemaining()) continue;
                    partial_write = true;
                }
                int written = this.transport.write(target_buffer, partial_write);
                total_written += (long)written;
                source_buffer.position(position + written);
                if (written < size) {
                    this.write_buffer_pending_db = target_buffer_db;
                    target_buffer_db = null;
                    if (written == 0) {
                        this.write_buffer_pending_byte = ByteBuffer.wrap(new byte[]{target_buffer.get()});
                        source_buffer.get();
                        ++total_written;
                    }
                    var19_23 = null;
                    if (target_buffer_db == null) break;
                    target_buffer_db.returnToPool();
                    break;
                }
                var19_23 = null;
                if (target_buffer_db == null) continue;
                target_buffer_db.returnToPool();
                continue;
            }
            catch (Throwable throwable) {
                var19_23 = null;
                if (target_buffer_db != null) {
                    target_buffer_db.returnToPool();
                }
                throw throwable;
            }
        }
        return total_written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long read(ByteBuffer[] buffers, int array_offset, int length) throws IOException {
        long l;
        int total_read = 0;
        DirectByteBuffer[] copy_db = new DirectByteBuffer[buffers.length];
        ByteBuffer[] copy = new ByteBuffer[buffers.length];
        try {
            int i;
            for (i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer buffer = buffers[i];
                int size = buffer.remaining();
                if (size > 0) {
                    copy_db[i] = DirectByteBufferPool.getBuffer((byte)26, size);
                    copy[i] = copy_db[i].getBuffer((byte)5);
                    continue;
                }
                copy[i] = ByteBuffer.allocate(0);
            }
            total_read = (int)((long)total_read + this.transport.read(copy, array_offset, length));
            for (i = array_offset; i < array_offset + length; ++i) {
                ByteBuffer source_buffer = copy[i];
                if (source_buffer == null) continue;
                ByteBuffer target_buffer = buffers[i];
                int source_position = source_buffer.position();
                if (source_position <= 0) continue;
                source_buffer.flip();
                this.cryptoIn(source_buffer, target_buffer);
            }
            l = total_read;
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            for (int i = 0; i < copy_db.length; ++i) {
                if (copy_db[i] == null) continue;
                copy_db[i].returnToPool();
            }
            throw throwable;
        }
        for (int i = 0; i < copy_db.length; ++i) {
            if (copy_db[i] == null) continue;
            copy_db[i].returnToPool();
        }
        return l;
    }

    public void setTrace(boolean on) {
        this.transport.setTrace(on);
    }

    protected abstract void cryptoOut(ByteBuffer var1, ByteBuffer var2) throws IOException;

    protected abstract void cryptoIn(ByteBuffer var1, ByteBuffer var2) throws IOException;
}

