/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.http;

import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.RawMessage;
import com.aelitis.azureus.core.networkmanager.impl.RawMessageImpl;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessage;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageDecoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPMessageEncoder;
import com.aelitis.azureus.core.networkmanager.impl.http.HTTPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HTTPNetworkConnection {
    protected static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int MAX_OUTSTANDING_BT_REQUESTS = 16;
    protected static final String NL = "\r\n";
    private static final String HDR_SERVER = "Server: Azureus 5.5.0.1_B10\r\n";
    private static final String HDR_KEEP_ALIVE_TIMEOUT = "Keep-Alive: timeout=30\r\n";
    private static final String HDR_CACHE_CONTROL = "Cache-Control: public, max-age=86400\r\n";
    private static final String DEFAULT_CONTENT_TYPE = HTTPUtils.guessContentTypeFromFileType(null);
    private static int max_read_block_size;
    private static final int TIMEOUT_CHECK_PERIOD = 15000;
    private static final int DEAD_CONNECTION_TIMEOUT_PERIOD = 30000;
    private static final int MAX_CON_PER_ENDPOINT = 5000;
    private static Map<networkConnectionKey, List<HTTPNetworkConnection>> http_connection_map;
    private HTTPNetworkManager manager;
    private NetworkConnection connection;
    private PEPeerTransport peer;
    private HTTPMessageDecoder decoder;
    private HTTPMessageEncoder encoder;
    private boolean sent_handshake = false;
    private byte[] peer_id = PeerUtils.createWebSeedPeerID();
    private boolean choked = true;
    private List<httpRequest> http_requests = new ArrayList<httpRequest>();
    private List<BTRequest> choked_requests = new ArrayList<BTRequest>();
    private List<pendingRequest> outstanding_requests = new ArrayList<pendingRequest>();
    private BitSet piece_map = new BitSet();
    private long last_http_activity_time;
    private networkConnectionKey network_connection_key;
    private boolean closing;
    private boolean destroyed;
    private String last_modified_date;
    private String content_type = DEFAULT_CONTENT_TYPE;
    private CopyOnWriteList<requestListener> request_listeners = null;

    protected static boolean checkConnections(List<HTTPNetworkConnection> connections) {
        boolean some_closed = false;
        HTTPNetworkConnection oldest = null;
        long oldest_time = -1L;
        Iterator<HTTPNetworkConnection> it = connections.iterator();
        ArrayList<HTTPNetworkConnection> timed_out = new ArrayList<HTTPNetworkConnection>();
        while (it.hasNext()) {
            HTTPNetworkConnection connection = it.next();
            long time = connection.getTimeSinceLastActivity();
            if (time > 30000L && connection.getRequestCount() == 0) {
                timed_out.add(connection);
                continue;
            }
            if (time <= oldest_time || connection.isClosing()) continue;
            oldest_time = time;
            oldest = connection;
        }
        for (int i = 0; i < timed_out.size(); ++i) {
            ((HTTPNetworkConnection)timed_out.get(i)).close("Timeout");
            some_closed = true;
        }
        if (connections.size() - timed_out.size() > 5000) {
            oldest.close("Too many connections from initiator");
            some_closed = true;
        }
        return some_closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HTTPNetworkConnection(HTTPNetworkManager _manager, NetworkConnection _connection, PEPeerTransport _peer) {
        this.manager = _manager;
        this.connection = _connection;
        this.peer = _peer;
        DiskManager dm = this.peer.getManager().getDiskManager();
        long last_modified = 0L;
        try {
            last_modified = dm.getFiles()[0].getFile(true).lastModified();
        }
        catch (Throwable e) {
            // empty catch block
        }
        this.last_modified_date = TimeFormatter.getHTTPDate(last_modified);
        this.network_connection_key = new networkConnectionKey();
        this.last_http_activity_time = SystemTime.getCurrentTime();
        this.decoder = (HTTPMessageDecoder)this.connection.getIncomingMessageQueue().getDecoder();
        this.encoder = (HTTPMessageEncoder)this.connection.getOutgoingMessageQueue().getEncoder();
        Map<networkConnectionKey, List<HTTPNetworkConnection>> map = http_connection_map;
        synchronized (map) {
            List<HTTPNetworkConnection> connections = http_connection_map.get(this.network_connection_key);
            if (connections == null) {
                connections = new ArrayList<HTTPNetworkConnection>();
                http_connection_map.put(this.network_connection_key, connections);
            }
            connections.add(this);
            if (connections.size() > 5000) {
                HTTPNetworkConnection.checkConnections(connections);
            }
        }
        this.encoder.setConnection(this);
        this.decoder.setConnection(this);
    }

    protected boolean isSeed() {
        if (!this.peer.getControl().isSeeding() || this.peer.getControl().getHiddenBytes() > 0L) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.peer, LOGID, "Download is not seeding"));
            }
            this.sendAndClose(this.manager.getNotFound());
            return false;
        }
        return true;
    }

    protected void setContentType(String ct) {
        this.content_type = ct;
    }

    protected HTTPNetworkManager getManager() {
        return this.manager;
    }

    protected NetworkConnection getConnection() {
        return this.connection;
    }

    protected PEPeerTransport getPeer() {
        return this.peer;
    }

    protected PEPeerControl getPeerControl() {
        return this.peer.getControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodeChoke() {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            this.choked = true;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage encodeUnchoke() {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            this.choked = false;
            for (int i = 0; i < this.choked_requests.size(); ++i) {
                this.decoder.addMessage(this.choked_requests.get(i));
            }
            this.choked_requests.clear();
        }
        return null;
    }

    protected RawMessage encodeBitField() {
        this.decoder.addMessage(new BTInterested(1));
        return null;
    }

    protected void readWakeup() {
        this.connection.getTransport().setReadyForRead();
    }

    protected RawMessage encodeHandShake(Message message) {
        return null;
    }

    protected abstract void decodeHeader(HTTPMessageDecoder var1, String var2) throws IOException;

    protected String encodeHeader(httpRequest request2) {
        String current_date = TimeFormatter.getHTTPDate(SystemTime.getCurrentTime());
        StringBuffer res = new StringBuffer(256);
        boolean partial = request2.isPartialContent();
        res.append("HTTP/1.1 ");
        res.append(partial ? "206 Partial Content" : "200 OK");
        res.append(NL);
        res.append("Content-Type: ");
        res.append(this.content_type);
        res.append(NL);
        res.append("Date: ");
        res.append(current_date);
        res.append(NL);
        res.append("Last-Modified: ");
        res.append(this.last_modified_date);
        res.append(NL);
        res.append(HDR_CACHE_CONTROL);
        res.append(HDR_SERVER);
        if (partial) {
            long[] offsets = request2.getOriginalOffsets();
            long[] lengths = request2.getOriginalLengths();
            long content_length = request2.getContentLength();
            if (offsets.length == 1 && content_length > 0L) {
                res.append("Content-Range: bytes " + offsets[0] + "-" + (offsets[0] + lengths[0] - 1L) + "/" + content_length);
                res.append(NL);
            }
        }
        res.append("Connection: ");
        res.append(request2.keepAlive() ? "Keep-Alive" : "Close");
        res.append(NL);
        if (request2.keepAlive()) {
            res.append(HDR_KEEP_ALIVE_TIMEOUT);
        }
        res.append("Content-Length: ");
        res.append(request2.getTotalLength());
        res.append(NL);
        res.append(NL);
        return res.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addRequest(httpRequest request2) throws IOException {
        this.last_http_activity_time = SystemTime.getCurrentTime();
        PEPeerControl control = this.getPeerControl();
        if (!this.sent_handshake) {
            this.sent_handshake = true;
            this.decoder.addMessage(new BTHandshake(control.getHash(), this.peer_id, false, 1));
            byte[] bits = new byte[(control.getPieces().length + 7) / 8];
            DirectByteBuffer buffer = new DirectByteBuffer(ByteBuffer.wrap(bits));
            this.decoder.addMessage(new BTBitfield(buffer, 1));
        }
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            this.http_requests.add(request2);
        }
        this.submitBTRequests();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submitBTRequests() throws IOException {
        PEPeerControl control = this.getPeerControl();
        long piece_size = control.getPieceLength(0);
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            while (this.outstanding_requests.size() < 16 && this.http_requests.size() > 0) {
                httpRequest http_request = this.http_requests.get(0);
                long[] offsets = http_request.getModifiableOffsets();
                long[] lengths = http_request.getModifiableLengths();
                int index = http_request.getIndex();
                long offset = offsets[index];
                long length = lengths[index];
                int this_piece_number = (int)(offset / piece_size);
                int this_piece_size = control.getPieceLength(this_piece_number);
                int offset_in_piece = (int)(offset - (long)this_piece_number * piece_size);
                int space_this_piece = this_piece_size - offset_in_piece;
                int request_size = (int)Math.min(length, (long)space_this_piece);
                request_size = Math.min(request_size, max_read_block_size);
                this.addBTRequest(new BTRequest(this_piece_number, offset_in_piece, request_size, 1), http_request);
                if ((long)request_size == length) {
                    if (index == offsets.length - 1) {
                        this.http_requests.remove(0);
                        continue;
                    }
                    http_request.setIndex(index + 1);
                    continue;
                }
                int n = index;
                offsets[n] = offsets[n] + (long)request_size;
                int n2 = index;
                lengths[n2] = lengths[n2] - (long)request_size;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addBTRequest(BTRequest request2, httpRequest http_request) throws IOException {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            if (this.destroyed) {
                throw new IOException("HTTP connection destroyed");
            }
            this.outstanding_requests.add(new pendingRequest(request2, http_request));
            if (this.choked) {
                if (this.choked_requests.size() > 1024) {
                    Debug.out("pending request limit exceeded");
                } else {
                    this.choked_requests.add(request2);
                }
            } else {
                this.decoder.addMessage(request2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RawMessage[] encodePiece(Message message) {
        this.last_http_activity_time = SystemTime.getCurrentTime();
        BTPiece piece = (BTPiece)message;
        ArrayList<pendingRequest> ready_requests = new ArrayList<pendingRequest>();
        boolean found = false;
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            if (this.destroyed) {
                return new RawMessage[]{this.getEmptyRawMessage(message)};
            }
            for (int i = 0; i < this.outstanding_requests.size(); ++i) {
                pendingRequest r;
                BTPiece btp;
                pendingRequest req = this.outstanding_requests.get(i);
                if (req.getPieceNumber() != piece.getPieceNumber() || req.getStart() != piece.getPieceOffset() || req.getLength() != piece.getPieceData().remaining((byte)5) || req.getBTPiece() != null) continue;
                req.setBTPiece(piece);
                found = true;
                if (i != 0) break;
                Iterator<pendingRequest> it = this.outstanding_requests.iterator();
                while (it.hasNext() && (btp = (r = it.next()).getBTPiece()) != null) {
                    it.remove();
                    ready_requests.add(r);
                }
                break;
            }
        }
        if (!found) {
            Debug.out("request not matched");
            return new RawMessage[]{this.getEmptyRawMessage(message)};
        }
        if (ready_requests.size() == 0) {
            return new RawMessage[]{this.getEmptyRawMessage(message)};
        }
        try {
            this.submitBTRequests();
        }
        catch (IOException e) {
            // empty catch block
        }
        pendingRequest req = (pendingRequest)ready_requests.get(0);
        httpRequest http_request = req.getHTTPRequest();
        RawMessage[] raw_messages = new RawMessage[ready_requests.size()];
        for (int i = 0; i < raw_messages.length; ++i) {
            DirectByteBuffer[] buffers = new DirectByteBuffer[2];
            if (!http_request.hasSentFirstReply()) {
                http_request.setSentFirstReply();
                String header = this.encodeHeader(http_request);
                buffers[0] = new DirectByteBuffer(ByteBuffer.wrap(header.getBytes()));
            } else {
                buffers[0] = new DirectByteBuffer(ByteBuffer.allocate(0));
            }
            req = (pendingRequest)ready_requests.get(i);
            BTPiece this_piece = req.getBTPiece();
            int piece_number = this_piece.getPieceNumber();
            if (!this.piece_map.get(piece_number)) {
                this.piece_map.set(piece_number);
                this.decoder.addMessage(new BTHave(piece_number, 1));
            }
            buffers[1] = this_piece.getPieceData();
            req.logQueued();
            if (this.request_listeners != null) {
                Iterator<requestListener> it = this.request_listeners.iterator();
                while (it.hasNext()) {
                    it.next().requestComplete(req);
                }
            }
            raw_messages[i] = new RawMessageImpl(this_piece, buffers, 2, true, new Message[0]);
        }
        return raw_messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getRequestCount() {
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            return this.http_requests.size();
        }
    }

    protected boolean isClosing() {
        return this.closing;
    }

    protected void close(String reason) {
        this.closing = true;
        this.peer.getControl().removePeer(this.peer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = http_connection_map;
        synchronized (object) {
            List<HTTPNetworkConnection> connections = http_connection_map.get(this.network_connection_key);
            if (connections != null) {
                connections.remove(this);
                if (connections.size() == 0) {
                    http_connection_map.remove(this.network_connection_key);
                }
            }
        }
        object = this.outstanding_requests;
        synchronized (object) {
            Object req;
            int i;
            this.destroyed = true;
            for (i = 0; i < this.outstanding_requests.size(); ++i) {
                req = this.outstanding_requests.get(i);
                BTPiece piece = ((pendingRequest)req).getBTPiece();
                if (piece == null) continue;
                piece.destroy();
            }
            this.outstanding_requests.clear();
            for (i = 0; i < this.choked_requests.size(); ++i) {
                req = this.choked_requests.get(i);
                ((BTRequest)req).destroy();
            }
            this.choked_requests.clear();
        }
    }

    protected long getTimeSinceLastActivity() {
        long now = SystemTime.getCurrentTime();
        if (now < this.last_http_activity_time) {
            this.last_http_activity_time = now;
        }
        return now - this.last_http_activity_time;
    }

    protected void log(String str) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getPeer(), LOGID, str));
        }
    }

    protected RawMessage getEmptyRawMessage(Message message) {
        return new RawMessageImpl(message, new DirectByteBuffer[]{new DirectByteBuffer(ByteBuffer.allocate(0))}, 2, true, new Message[0]);
    }

    protected void sendAndClose(String data) {
        final HTTPMessage http_message = new HTTPMessage(data);
        this.getConnection().getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void messageSent(Message message) {
                if (message == http_message) {
                    HTTPNetworkConnection.this.close("Close after message send complete");
                }
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }

            public void flush() {
            }
        });
        this.getConnection().getOutgoingMessageQueue().addMessage(http_message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushRequests(final flushListener l) {
        boolean sync_fire = false;
        List<pendingRequest> list = this.outstanding_requests;
        synchronized (list) {
            final int request_count = this.outstanding_requests.size();
            if (request_count == 0) {
                sync_fire = true;
            } else {
                if (this.request_listeners == null) {
                    this.request_listeners = new CopyOnWriteList();
                }
                this.request_listeners.add(new requestListener(){
                    int num_to_go;
                    {
                        this.num_to_go = request_count;
                    }

                    public void requestComplete(pendingRequest r) {
                        --this.num_to_go;
                        if (this.num_to_go == 0) {
                            HTTPNetworkConnection.this.request_listeners.remove(this);
                            HTTPNetworkConnection.this.flushRequestsSupport(l);
                        }
                    }
                });
            }
        }
        if (sync_fire) {
            this.flushRequestsSupport(l);
        }
    }

    protected void flushRequestsSupport(final flushListener l) {
        OutgoingMessageQueue omq2 = this.getConnection().getOutgoingMessageQueue();
        final HTTPMessage http_message = new HTTPMessage(new byte[0]);
        omq2.registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public boolean messageAdded(Message message) {
                return true;
            }

            public void messageQueued(Message message) {
            }

            public void messageRemoved(Message message) {
            }

            public void messageSent(Message message) {
                if (message == http_message) {
                    l.flushed();
                }
            }

            public void protocolBytesSent(int byte_count) {
            }

            public void dataBytesSent(int byte_count) {
            }

            public void flush() {
            }
        });
        omq2.addMessage(http_message, false);
        if (omq2.getTotalSize() == 0) {
            l.flushed();
        }
    }

    static {
        ParameterListener param_listener = new ParameterListener(){

            public void parameterChanged(String str) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", param_listener);
        http_connection_map = new HashMap<networkConnectionKey, List<HTTPNetworkConnection>>();
        SimpleTimer.addPeriodicEvent("HTTPNetworkConnection:timer", 15000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                Map map = http_connection_map;
                synchronized (map) {
                    boolean check = true;
                    block3: while (check) {
                        check = false;
                        for (Map.Entry entry : http_connection_map.entrySet()) {
                            networkConnectionKey key = (networkConnectionKey)entry.getKey();
                            List connections = (List)entry.getValue();
                            if (!HTTPNetworkConnection.checkConnections(connections) || http_connection_map.containsKey(key)) continue;
                            check = true;
                            continue block3;
                        }
                    }
                }
            }
        });
    }

    protected static interface flushListener {
        public void flushed();
    }

    protected static class httpRequest {
        private final long[] orig_offsets;
        private final long[] orig_lengths;
        private final long content_length;
        private final boolean partial_content;
        private final boolean keep_alive;
        private final long[] mod_offsets;
        private final long[] mod_lengths;
        private int index;
        private long total_length;
        private boolean sent_first_reply;

        protected httpRequest(long[] _offsets, long[] _lengths, long _content_length, boolean _partial_content, boolean _keep_alive) {
            this.orig_offsets = _offsets;
            this.orig_lengths = _lengths;
            this.content_length = _content_length;
            this.partial_content = _partial_content;
            this.keep_alive = _keep_alive;
            this.mod_offsets = (long[])this.orig_offsets.clone();
            this.mod_lengths = (long[])this.orig_lengths.clone();
            for (int i = 0; i < this.orig_lengths.length; ++i) {
                this.total_length += this.orig_lengths[i];
            }
        }

        protected boolean isPartialContent() {
            return this.partial_content;
        }

        protected long getContentLength() {
            return this.content_length;
        }

        protected boolean hasSentFirstReply() {
            return this.sent_first_reply;
        }

        protected void setSentFirstReply() {
            this.sent_first_reply = true;
        }

        protected long[] getOriginalOffsets() {
            return this.orig_offsets;
        }

        protected long[] getOriginalLengths() {
            return this.orig_lengths;
        }

        protected long[] getModifiableOffsets() {
            return this.mod_offsets;
        }

        protected long[] getModifiableLengths() {
            return this.mod_lengths;
        }

        protected int getIndex() {
            return this.index;
        }

        protected void setIndex(int _index) {
            this.index = _index;
        }

        protected long getTotalLength() {
            return this.total_length;
        }

        protected boolean keepAlive() {
            return this.keep_alive;
        }
    }

    protected class networkConnectionKey {
        protected networkConnectionKey() {
        }

        public boolean equals(Object obj) {
            if (obj instanceof networkConnectionKey) {
                networkConnectionKey other = (networkConnectionKey)obj;
                return Arrays.equals(this.getAddress(), other.getAddress()) && Arrays.equals(this.getHash(), other.getHash());
            }
            return false;
        }

        protected String getName() {
            return HTTPNetworkConnection.this.peer.getControl().getDisplayName() + ": " + HTTPNetworkConnection.this.connection.getEndpoint().getNotionalAddress().getAddress().getHostAddress();
        }

        protected byte[] getAddress() {
            return AddressUtils.getAddressBytes(HTTPNetworkConnection.this.connection.getEndpoint().getNotionalAddress());
        }

        protected byte[] getHash() {
            return HTTPNetworkConnection.this.peer.getControl().getHash();
        }

        public int hashCode() {
            return HTTPNetworkConnection.this.peer.getControl().hashCode();
        }
    }

    private static class pendingRequest {
        private int piece;
        private int start;
        private int length;
        private httpRequest http_request;
        private BTPiece bt_piece;

        protected pendingRequest(BTRequest _request, httpRequest _http_request) {
            this.piece = _request.getPieceNumber();
            this.start = _request.getPieceOffset();
            this.length = _request.getLength();
            this.http_request = _http_request;
        }

        protected int getPieceNumber() {
            return this.piece;
        }

        protected int getStart() {
            return this.start;
        }

        protected int getLength() {
            return this.length;
        }

        protected httpRequest getHTTPRequest() {
            return this.http_request;
        }

        protected BTPiece getBTPiece() {
            return this.bt_piece;
        }

        protected void setBTPiece(BTPiece _bt_piece) {
            this.bt_piece = _bt_piece;
        }

        protected void logQueued() {
        }
    }

    protected static interface requestListener {
        public void requestComplete(pendingRequest var1);
    }
}

