/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.devices.DeviceManagerFactory;
import com.aelitis.azureus.core.devices.DeviceMediaRenderer;
import com.aelitis.azureus.core.devices.TranscodeException;
import com.aelitis.azureus.core.devices.TranscodeProfile;
import com.aelitis.azureus.core.devices.TranscodeProvider;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import java.util.HashMap;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallationListener;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class DeviceInfoArea
extends SkinView {
    private DeviceMediaRenderer device;
    private Composite main;
    private Composite parent;

    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        MdiEntrySWT entry;
        MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
        if (mdi != null && (entry = mdi.getEntryFromSkinObject(skinObject)) != null) {
            this.device = (DeviceMediaRenderer)entry.getDatasource();
        }
        this.parent = (Composite)skinObject.getControl();
        return null;
    }

    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        if (this.device == null) {
            this.initDeviceOverview();
        } else {
            this.initDeviceView();
        }
        return null;
    }

    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        Utils.disposeComposite(this.main);
        return super.skinObjectHidden(skinObject, params);
    }

    private void initDeviceView() {
        this.main = new Composite(this.parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        this.main.setLayout((Layout)layout);
        this.main.setLayoutData((Object)Utils.getFilledFormData());
        Composite control = new Composite(this.main, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 0;
        control.setLayout((Layout)layout);
        GridData grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        control.setLayoutData((Object)grid_data);
        Label dir_lab = new Label(control, 0);
        dir_lab.setText("Local directory: " + this.device.getWorkingDirectory().getAbsolutePath());
        Button show_folder_button = new Button(control, 8);
        Messages.setLanguageText((Widget)show_folder_button, "MyTorrentsView.menu.explore");
        show_folder_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerUtils.open(DeviceInfoArea.this.device.getWorkingDirectory());
            }
        });
        new Label(control, 0);
        if (this.device.canFilterFilesView()) {
            final Button show_xcode_button = new Button(control, 32);
            Messages.setLanguageText((Widget)show_xcode_button, "devices.xcode.only.show");
            show_xcode_button.setSelection(this.device.getFilterFilesView());
            show_xcode_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeviceInfoArea.this.device.setFilterFilesView(show_xcode_button.getSelection());
                }
            });
        }
        final Button btnReset = new Button(this.main, 8);
        btnReset.setText("Forget Default Profile Choice");
        btnReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeviceInfoArea.this.device.setDefaultTranscodeProfile(null);
                btnReset.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        try {
            btnReset.setEnabled(this.device.getDefaultTranscodeProfile() != null);
        }
        catch (TranscodeException e1) {
            btnReset.setEnabled(false);
        }
        btnReset.setLayoutData((Object)new GridData());
        this.parent.getParent().layout();
    }

    protected void initDeviceOverview() {
        final PluginInstaller installer = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInstaller();
        boolean hasItunes = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azitunes") != null;
        this.main = new Composite(this.parent, 0);
        this.main.setLayoutData((Object)Utils.getFilledFormData());
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.main.setLayout((Layout)layout);
        if (hasItunes) {
            Button itunes_button;
            Button top = itunes_button = new Button(this.main, 0);
            itunes_button.setText("Install iTunes Integration");
            itunes_button.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    try {
                        StandardPlugin itunes_plugin = installer.getStandardPlugin("azitunes");
                        if (itunes_plugin == null) {
                            Debug.out("iTunes standard plugin not found");
                        } else {
                            itunes_plugin.install(false);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment(0, 4);
            itunes_button.setLayoutData((Object)fd);
        } else {
            Label lblItunesInstalled;
            Label top = lblItunesInstalled = new Label(this.main, 64);
            lblItunesInstalled.setText("iTunes support is available");
        }
        if (Constants.isCVSVersion()) {
            // empty if block
        }
        this.parent.getParent().layout();
    }

    private void buildBetaArea(Composite parent, Control above) {
        TranscodeProvider[] providers;
        Group betaArea = new Group(parent, 0);
        betaArea.setText("Beta Debug");
        betaArea.setLayout((Layout)new FormLayout());
        FormData fd = Utils.getFilledFormData();
        fd.top = new FormAttachment(above, 5);
        betaArea.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        Label label = new Label((Composite)betaArea, 0);
        label.setText("Transcode Providers:");
        label.setLayoutData((Object)fd);
        Button vuze_button = new Button((Composite)betaArea, 0);
        vuze_button.setText("Install Vuze Transcoder");
        if (AzureusCoreFactory.isCoreRunning()) {
            PluginInstaller installer = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInstaller();
            StandardPlugin vuze_plugin = null;
            try {
                vuze_plugin = installer.getStandardPlugin("vuzexcode");
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (vuze_plugin == null || vuze_plugin.isAlreadyInstalled()) {
                vuze_button.setEnabled(false);
            }
            final StandardPlugin f_vuze_plugin = vuze_plugin;
            vuze_button.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    try {
                        f_vuze_plugin.install(false);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)label, 4);
            vuze_button.setLayoutData((Object)fd);
        }
        Button top = vuze_button;
        for (TranscodeProvider provider2 : providers = DeviceManagerFactory.getSingleton().getTranscodeManager().getProviders()) {
            fd = new FormData();
            fd.left = new FormAttachment(0, 10);
            fd.right = new FormAttachment(100, 0);
            fd.top = new FormAttachment((Control)top, 4);
            Label prov_lab = new Label((Composite)betaArea, 0);
            prov_lab.setText(provider2.getName());
            prov_lab.setLayoutData((Object)fd);
            top = prov_lab;
            TranscodeProfile[] profiles = provider2.getProfiles();
            String line = null;
            for (TranscodeProfile profile : profiles) {
                line = line == null ? profile.getName() : line + ", " + profile.getName();
            }
            if (line == null) continue;
            fd = new FormData();
            fd.left = new FormAttachment(0, 25);
            fd.right = new FormAttachment(100, 0);
            fd.top = new FormAttachment((Control)top, 4);
            Label prof_lab = new Label((Composite)betaArea, 64);
            prof_lab.setText("Profiles: " + line);
            prof_lab.setLayoutData((Object)fd);
            top = prof_lab;
        }
        final Button both_button = new Button((Composite)betaArea, 0);
        both_button.setText("Test! Install RSSGen and AZBlog!");
        if (AzureusCoreFactory.isCoreRunning()) {
            final PluginInstaller installer = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInstaller();
            StandardPlugin plugin1 = null;
            StandardPlugin plugin2 = null;
            try {
                plugin1 = installer.getStandardPlugin("azrssgen");
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                plugin2 = installer.getStandardPlugin("azblog");
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (plugin1 != null && plugin2 != null) {
                final Composite install_area = new Composite((Composite)betaArea, 2048);
                fd = new FormData();
                fd.left = new FormAttachment((Control)both_button, 0);
                fd.right = new FormAttachment(100, 0);
                fd.top = new FormAttachment((Control)top, 4);
                fd.bottom = new FormAttachment(100, 0);
                install_area.setLayoutData((Object)fd);
                final StandardPlugin f_plugin1 = plugin1;
                final StandardPlugin f_plugin2 = plugin2;
                both_button.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        both_button.setEnabled(false);
                        try {
                            HashMap<Integer, Object> properties = new HashMap<Integer, Object>();
                            properties.put(1, 2);
                            properties.put(2, install_area);
                            properties.put(3, true);
                            installer.install(new InstallablePlugin[]{f_plugin1, f_plugin2}, false, properties, new PluginInstallationListener(){

                                public void completed() {
                                    System.out.println("Install completed!");
                                    this.tidy();
                                }

                                public void cancelled() {
                                    System.out.println("Install cancelled");
                                    this.tidy();
                                }

                                public void failed(PluginException e) {
                                    System.out.println("Install failed: " + e);
                                    this.tidy();
                                }

                                protected void tidy() {
                                    Utils.execSWTThread(new Runnable(){

                                        public void run() {
                                            Control[] kids;
                                            for (Control c : kids = install_area.getChildren()) {
                                                c.dispose();
                                            }
                                            both_button.setEnabled(true);
                                        }
                                    });
                                }
                            });
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            } else {
                both_button.setEnabled(false);
            }
            fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment((Control)top, 4);
            fd.bottom = new FormAttachment(100, 0);
            both_button.setLayoutData((Object)fd);
        }
    }
}

