/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.main;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiChildCloseListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MdiEntryDatasourceListener;
import com.aelitis.azureus.ui.mdi.MdiListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MdiSWTMenuHackListener;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.SBC_TorrentDetailsView;
import com.aelitis.azureus.ui.swt.views.skin.SB_Discovery;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SB_Vuze;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.DataSourceUtils;
import com.aelitis.azureus.util.FeatureUtils;
import java.util.Map;
import org.eclipse.swt.widgets.Menu;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener2;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MenuFactory;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.PeersSuperView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;

public class MainMDISetup {
    public static void setupSideBar(final MultipleDocumentInterfaceSWT mdi, final MdiListener l) {
        UIManager uim;
        if (Utils.isAZ2UI()) {
            MainMDISetup.setupSidebarClassic(mdi);
        } else {
            MainMDISetup.setupSidebarVuzeUI(mdi);
        }
        mdi.registerEntry("DMDetails_.*", new MdiEntryCreationListener2(){

            @Override
            public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                return MainMDISetup.createTorrentDetailEntry(mdi, id, datasource);
            }
        });
        PluginInitializer.getDefaultInterface().getUIManager().addUIListener(new UIManagerListener2(){

            public void UIDetached(UIInstance instance) {
            }

            public void UIAttached(UIInstance instance) {
            }

            public void UIAttachedComplete(UIInstance instance) {
                String startTab;
                ContentNetwork startupCN;
                PluginInitializer.getDefaultInterface().getUIManager().removeUIListener(this);
                MdiEntry currentEntry = mdi.getCurrentEntry();
                if (currentEntry != null) {
                    return;
                }
                String CFG_STARTTAB = "v3.StartTab";
                String CFG_STARTTAB_DS = "v3.StartTab.ds";
                String datasource = null;
                boolean showWelcome = COConfigurationManager.getBooleanParameter("v3.Show Welcome");
                if (ConfigurationChecker.isNewVersion()) {
                    showWelcome = true;
                }
                if ((startupCN = ContentNetworkManagerFactory.getSingleton().getStartupContentNetwork()) == null || !startupCN.isServiceSupported(8)) {
                    showWelcome = false;
                }
                if (showWelcome) {
                    startTab = "Welcome";
                } else {
                    if (!COConfigurationManager.hasParameter("v3.StartTab", true)) {
                        COConfigurationManager.setParameter("v3.StartTab", "Library");
                    }
                    startTab = COConfigurationManager.getStringParameter("v3.StartTab");
                    datasource = COConfigurationManager.getStringParameter("v3.StartTab.ds", null);
                }
                if (startTab.equals("Plus")) {
                    SBC_PlusFTUX.setSourceRef("lastview");
                }
                if (!mdi.loadEntryByID(startTab, true, false, datasource)) {
                    mdi.showEntryByID("Library");
                }
                if (l != null) {
                    mdi.addListener(l);
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("Beta Programme Enabled", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                boolean enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
                if (enabled) {
                    mdi.loadEntryByID("BetaProgramme", false);
                }
            }
        });
        mdi.registerEntry(StatsView.VIEW_ID, new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", new StatsView(), id, true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("AllPeersView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.transfers", new PeersSuperView(), id, true, null, null);
                entry.setImageLeftID("image.sidebar.allpeers");
                return entry;
            }
        });
        mdi.registerEntry("LoggerView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", new LoggerView(), id, true, null, null);
                return entry;
            }
        });
        mdi.registerEntry("TagsOverview", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "TagsOverview", "tagsview", "{mdi.entry.tagsoverview}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.tag-overview");
                return entry;
            }
        });
        mdi.registerEntry("TagDiscovery", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "TagDiscovery", "tagdiscoveryview", "{mdi.entry.tagdiscovery}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.tag-overview");
                return entry;
            }
        });
        mdi.registerEntry("ChatOverview", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.transfers", "ChatOverview", "chatsview", "{mdi.entry.chatsoverview}", null, null, true, null);
                entry.setImageLeftID("image.sidebar.chats-overview");
                return entry;
            }
        });
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        if (pi != null && (uim = pi.getUIManager()) != null) {
            MenuItem menuItem = uim.getMenuManager().addMenuItem("mainmenu", "tags.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagsOverview");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "tag.discovery.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("TagDiscovery");
                }
            });
            menuItem = uim.getMenuManager().addMenuItem("mainmenu", "chats.view.heading");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    UIFunctionsManager.getUIFunctions().getMDI().showEntryByID("ChatOverview");
                }
            });
        }
    }

    private static void setupSidebarClassic(final MultipleDocumentInterfaceSWT mdi) {
        mdi.registerEntry("Library", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
                String title = uiClassic ? "{MyTorrentsView.mytorrents}" : "{sidebar.Library}";
                MdiEntry entry = mdi.createEntryFromSkinRef(null, "Library", "library", title, null, null, false, "");
                entry.setImageLeftID("image.sidebar.library");
                return entry;
            }
        });
        mdi.showEntryByID("Library");
        mdi.registerEntry("ConfigView", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", new ConfigView(), id, true, null, null);
                return entry;
            }
        });
    }

    private static void setupSidebarVuzeUI(final MultipleDocumentInterfaceSWT mdi) {
        String[] preferredOrder = new String[]{"header.transfers", "header.vuze", "header.discovery", "header.devices", "header.subscriptions", "header.dvd", "header.plugins"};
        mdi.setPreferredOrder(preferredOrder);
        for (int i = 0; i < preferredOrder.length; ++i) {
            String id = preferredOrder[i];
            mdi.registerEntry(id, new MdiEntryCreationListener(){

                public MdiEntry createMDiEntry(String id) {
                    MdiEntry entry = mdi.createHeader(id, "sidebar." + id, null);
                    if (entry == null) {
                        return null;
                    }
                    entry.setDefaultExpanded(true);
                    if (id.equals("header.plugins")) {
                        entry.addListener(new MdiChildCloseListener(){

                            public void mdiChildEntryClosed(MdiEntry parent, MdiEntry child, boolean user) {
                                if (mdi.getChildrenOf(parent.getId()).size() == 0) {
                                    parent.close(true);
                                }
                            }
                        });
                        PluginInterface pi = PluginInitializer.getDefaultInterface();
                        UIManager uim = pi.getUIManager();
                        MenuManager menuManager = uim.getMenuManager();
                        MenuItem menuItem = menuManager.addMenuItem("sidebar.header.plugins", "label.plugin.options");
                        menuItem.addListener(new MenuItemListener(){

                            public void selected(MenuItem menu, Object target) {
                                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                if (uif != null) {
                                    uif.openView(4, "plugins");
                                }
                            }
                        });
                    }
                    return entry;
                }
            });
        }
        if (COConfigurationManager.getBooleanParameter("Show Options In Side Bar")) {
            mdi.registerEntry("ConfigView", new MdiEntryCreationListener(){

                public MdiEntry createMDiEntry(String id) {
                    MdiEntry entry = mdi.createEntryFromEventListener("header.plugins", new ConfigView(), id, true, null, null);
                    return entry;
                }
            });
        }
        mdi.registerEntry("About.Plugins", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entry = mdi.createEntryFromSkinRef("header.plugins", "About.Plugins", "main.generic.browse", "{mdi.entry.about.plugins}", null, null, true, "");
                String url = ConstantsVuze.getDefaultContentNetwork().getSiteRelativeURL("plugins", true);
                entry.setDatasource(url);
                entry.setImageLeftID("image.sidebar.plugin");
                return entry;
            }
        });
        final int burnInfoShown = COConfigurationManager.getIntParameter("burninfo.shown", 0);
        if (burnInfoShown == 0) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (FeatureManagerUI.enabled) {
                                mdi.loadEntryByID("Plus", false);
                                if (!FeatureUtils.hasFullBurn()) {
                                    mdi.loadEntryByID("BurnInfo", false);
                                }
                                COConfigurationManager.setParameter("burninfo.shown", burnInfoShown + 1);
                            }
                        }
                    });
                }
            });
        }
        SB_Transfers.setup(mdi);
        new SB_Vuze(mdi);
        new SB_Discovery(mdi);
        mdi.loadEntryByID("Library", false);
        mdi.loadEntryByID("LibraryUnopened", false);
        mdi.loadEntryByID("Subscriptions", false);
        mdi.loadEntryByID("Devices", false);
        mdi.loadEntryByID("Activity", false);
    }

    protected static MdiEntry createTorrentDetailEntry(MultipleDocumentInterface mdi, String id, Object ds) {
        if (ds == null) {
            return null;
        }
        final MdiEntry torrentDetailEntry = mdi.createEntryFromSkinRef("header.transfers", id, "torrentdetails", "", null, ds, true, null);
        final ViewTitleInfo viewTitleInfo = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                Object ds = ((BaseMdiEntry)torrentDetailEntry).getDatasourceCore();
                if (propertyID == 10) {
                    return DataSourceUtils.getHash(ds);
                }
                if (propertyID == 7) {
                    return "DMDetails";
                }
                if (propertyID == 2) {
                    return "image.sidebar.details";
                }
                DownloadManager manager = SBC_TorrentDetailsView.dataSourceToDownloadManager(ds);
                if (manager == null) {
                    return null;
                }
                if (propertyID == 5) {
                    if (Utils.isAZ2UI()) {
                        int completed = manager.getStats().getCompleted();
                        return DisplayFormatters.formatPercentFromThousands(completed) + " : " + manager.getDisplayName();
                    }
                    return manager.getDisplayName();
                }
                if (propertyID == 0 && !Utils.isAZ2UI()) {
                    int completed = manager.getStats().getCompleted();
                    if (completed != 1000) {
                        return completed / 10 + "%";
                    }
                } else if (propertyID == 1) {
                    String eta;
                    String s = "";
                    int completed = manager.getStats().getCompleted();
                    if (completed != 1000) {
                        s = completed / 10 + "% Complete\n";
                    }
                    if ((eta = DisplayFormatters.formatETA(manager.getStats().getSmoothedETA())).length() > 0) {
                        s = s + MessageText.getString("TableColumn.header.eta") + ": " + eta + "\n";
                    }
                    return manager.getDisplayName() + (s.length() == 0 ? "" : ": " + s);
                }
                return null;
            }
        };
        if (torrentDetailEntry instanceof MdiEntrySWT) {
            ((MdiEntrySWT)torrentDetailEntry).addListener(new MdiSWTMenuHackListener(){

                public void menuWillBeShown(MdiEntry entry, Menu menuTree) {
                    TableView tv = SelectedContentManager.getCurrentlySelectedTableView();
                    menuTree.setData("TableView", (Object)tv);
                    DownloadManager manager = SBC_TorrentDetailsView.dataSourceToDownloadManager(torrentDetailEntry.getDatasource());
                    if (manager != null) {
                        menuTree.setData("downloads", (Object)new DownloadManager[]{manager});
                    }
                    menuTree.setData("is_detailed_view", (Object)new Boolean(true));
                    MenuFactory.buildTorrentMenu(menuTree);
                }
            });
        }
        torrentDetailEntry.addListener(new MdiEntryDatasourceListener(){

            public void mdiEntryDatasourceChanged(MdiEntry entry) {
                Object newDataSource = entry.getDatasource();
                if (newDataSource instanceof String) {
                    final String s = (String)newDataSource;
                    if (!AzureusCoreFactory.isCoreRunning()) {
                        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                            public void azureusCoreRunning(AzureusCore core) {
                                torrentDetailEntry.setDatasource(DataSourceUtils.getDM(s));
                            }
                        });
                        return;
                    }
                }
                ViewTitleInfoManager.refreshTitleInfo(viewTitleInfo);
            }
        });
        torrentDetailEntry.setViewTitleInfo(viewTitleInfo);
        return torrentDetailEntry;
    }
}

