/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectExpandItem;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;

public class SWTSkinObjectExpandBar
extends SWTSkinObjectContainer {
    private ExpandBar expandBar;
    private List<SWTSkinObjectExpandItem> expandItems = new ArrayList<SWTSkinObjectExpandItem>();
    private List<SWTSkinObjectExpandItem> fillHeightItems = new ArrayList<SWTSkinObjectExpandItem>();

    public SWTSkinObjectExpandBar(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, null, sID, sConfigID, "expandbar", parent);
        this.createExpandBar();
    }

    private void createExpandBar() {
        Composite createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        int style = 0;
        if (this.properties.getIntValue(this.sConfigID + ".border", 0) == 1) {
            style = 2048;
        }
        this.expandBar = new ExpandBar(createOn, style);
        this.expandBar.setLayout(null);
        this.expandBar.setSpacing(1);
        this.expandBar.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                SWTSkinObjectExpandBar.this.handleResize(null);
            }
        });
        this.triggerListeners(4);
        this.setControl((Control)this.expandBar);
    }

    protected void handleResize(ExpandItem itemResizing) {
        SWTSkinObjectExpandItem foundItem = null;
        if (itemResizing != null) {
            SWTSkinObjectExpandItem[] children;
            for (SWTSkinObjectExpandItem item : children = this.getChildren()) {
                if (item.getExpandItem() != itemResizing) continue;
                foundItem = item;
                item.resizeComposite();
                break;
            }
        }
        for (SWTSkinObjectExpandItem autoItem : this.fillHeightItems) {
            if (autoItem == foundItem) continue;
            autoItem.resizeComposite();
        }
    }

    public void relayout() {
        super.relayout();
        this.handleResize(null);
    }

    protected void addExpandItem(SWTSkinObjectExpandItem item) {
        this.expandItems.add(item);
        if (item.fillsHeight()) {
            this.fillHeightItems.add(item);
        }
    }

    protected void removeExpandItem(SWTSkinObjectExpandItem item) {
        this.expandItems.remove(item);
        this.fillHeightItems.remove(item);
    }

    public SWTSkinObjectExpandItem[] getChildren() {
        return this.expandItems.toArray(new SWTSkinObjectExpandItem[0]);
    }

    public ExpandBar getExpandbar() {
        return this.expandBar;
    }
}

