/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionAssociationLookup;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionLookupListener;
import com.aelitis.azureus.core.subs.SubscriptionManager;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionPopularityListener;
import com.aelitis.azureus.ui.swt.widgets.AnimatedImage;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class SubscriptionListWindow
implements SubscriptionLookupListener {
    private DownloadManager download;
    private boolean useCachedSubs;
    private Display display;
    private Shell shell;
    AnimatedImage animatedImage;
    Button action;
    Label loadingText;
    ProgressBar loadingProgress;
    boolean loadingDone = false;
    SubscriptionAssociationLookup lookup = null;
    Composite mainComposite;
    Composite loadingPanel;
    Composite listPanel;
    Table subscriptionsList;
    StackLayout mainLayout;
    SubscriptionItemModel[] subscriptionItems;

    public SubscriptionListWindow(DownloadManager download, boolean useCachedSubs) {
        this.download = download;
        this.useCachedSubs = useCachedSubs;
        this.shell = ShellFactory.createMainShell(32);
        this.shell.setSize(400, 300);
        Utils.centreWindow(this.shell);
        this.display = this.shell.getDisplay();
        this.shell.setText(MessageText.getString("subscriptions.listwindow.title"));
        this.shell.setLayout((Layout)new FormLayout());
        this.mainComposite = new Composite((Composite)this.shell, 0);
        Label separator = new Label((Composite)this.shell, 258);
        Button cancel = new Button((Composite)this.shell, 8);
        this.action = new Button((Composite)this.shell, 8);
        cancel.setText(MessageText.getString("Button.cancel"));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment((Control)separator, 0);
        this.mainComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)cancel, -2);
        separator.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.action);
        data.width = 100;
        data.bottom = new FormAttachment(100, -5);
        cancel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.width = 100;
        data.bottom = new FormAttachment(100, -5);
        this.action.setLayoutData((Object)data);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SubscriptionListWindow.this.lookup != null) {
                    SubscriptionListWindow.this.lookup.cancel();
                }
                if (!SubscriptionListWindow.this.shell.isDisposed()) {
                    SubscriptionListWindow.this.shell.dispose();
                }
            }
        });
        this.mainLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.mainLayout);
        this.loadingPanel = new Composite(this.mainComposite, 0);
        this.loadingPanel.setLayout((Layout)new FormLayout());
        this.listPanel = new Composite(this.mainComposite, 0);
        this.listPanel.setLayout((Layout)new FillLayout());
        this.subscriptionsList = new Table(this.listPanel, 268501508);
        this.subscriptionsList.setHeaderVisible(true);
        TableColumn name = new TableColumn(this.subscriptionsList, 0);
        name.setText(MessageText.getString("subscriptions.listwindow.name"));
        name.setWidth(310);
        name.setResizable(false);
        TableColumn popularity = new TableColumn(this.subscriptionsList, 0);
        popularity.setText(MessageText.getString("subscriptions.listwindow.popularity"));
        popularity.setWidth(70);
        popularity.setResizable(false);
        this.subscriptionsList.addListener(36, new Listener(){

            public void handleEvent(Event e) {
                TableItem item = (TableItem)e.item;
                int index = SubscriptionListWindow.this.subscriptionsList.indexOf(item);
                if (index >= 0 && index < SubscriptionListWindow.this.subscriptionItems.length) {
                    SubscriptionItemModel subscriptionItem = SubscriptionListWindow.this.subscriptionItems[index];
                    item.setText(0, subscriptionItem.name);
                    item.setText(1, subscriptionItem.popularityDisplay);
                }
            }
        });
        this.subscriptionsList.setSortColumn(popularity);
        this.subscriptionsList.setSortDirection(1024);
        this.subscriptionsList.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionListWindow.this.action.setEnabled(SubscriptionListWindow.this.subscriptionsList.getSelectionIndex() != -1);
            }
        });
        Listener sortListener = new Listener(){

            public void handleEvent(Event e) {
                TableColumn sortColumn = SubscriptionListWindow.this.subscriptionsList.getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = SubscriptionListWindow.this.subscriptionsList.getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    SubscriptionListWindow.this.subscriptionsList.setSortColumn(currentColumn);
                    dir = 1024;
                }
                SubscriptionListWindow.this.subscriptionsList.setSortDirection(dir);
                SubscriptionListWindow.this.sortAndRefresh();
            }
        };
        name.addListener(13, sortListener);
        popularity.addListener(13, sortListener);
        this.animatedImage = new AnimatedImage(this.loadingPanel);
        this.loadingText = new Label(this.loadingPanel, 0x1000040);
        this.loadingProgress = new ProgressBar(this.loadingPanel, 256);
        this.animatedImage.setImageFromName("spinner_big");
        String contentName = "Dummy";
        if (download != null) {
            contentName = download.getDisplayName();
        }
        this.loadingText.setText(MessageText.getString("subscriptions.listwindow.loadingtext", new String[]{contentName}));
        this.loadingProgress.setMinimum(0);
        this.loadingProgress.setMaximum(300);
        this.loadingProgress.setSelection(0);
        data = new FormData();
        data.left = new FormAttachment(1, 2, -16);
        data.top = new FormAttachment(1, 2, -32);
        data.width = 32;
        data.height = 32;
        this.animatedImage.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment(this.animatedImage.getControl(), 10);
        data.height = 50;
        this.loadingText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        data.top = new FormAttachment((Control)this.loadingText, 5);
        this.loadingProgress.setLayoutData((Object)data);
        boolean autoCheck = COConfigurationManager.getBooleanParameter("subscriptions.autocheck");
        if (autoCheck) {
            this.startChecking();
        } else {
            this.action.setText(MessageText.getString("Button.yes"));
            Composite acceptPanel = new Composite(this.mainComposite, 0);
            acceptPanel.setLayout((Layout)new FormLayout());
            Label acceptLabel = new Label(acceptPanel, 0x1000040);
            acceptLabel.setText(MessageText.getString("subscriptions.listwindow.autochecktext"));
            data = new FormData();
            data.left = new FormAttachment(0, 5);
            data.right = new FormAttachment(100, -5);
            data.top = new FormAttachment(1, 3, 0);
            acceptLabel.setLayoutData((Object)data);
            this.action.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    SubscriptionListWindow.this.action.removeListener(13, (Listener)this);
                    COConfigurationManager.setParameter("subscriptions.autocheck", true);
                    SubscriptionListWindow.this.startChecking();
                    SubscriptionListWindow.this.mainComposite.layout();
                }
            });
            this.mainLayout.topControl = acceptPanel;
        }
        this.shell.open();
    }

    private void startChecking() {
        this.action.setText(MessageText.getString("subscriptions.listwindow.subscribe"));
        this.action.setEnabled(false);
        try {
            if (this.download != null) {
                byte[] hash = this.download.getTorrent().getHash();
                SubscriptionManager subs_man = SubscriptionManagerFactory.getSingleton();
                if (this.useCachedSubs) {
                    Subscription[] subs = subs_man.getKnownSubscriptions(hash);
                    this.complete(hash, subs);
                } else {
                    this.lookup = subs_man.lookupAssociations(hash, this);
                }
            }
            this.loadingDone = false;
            AEThread2 progressMover = new AEThread2("progressMover", true){

                public void run() {
                    final int[] waitTime = new int[]{100};
                    while (!SubscriptionListWindow.this.loadingDone) {
                        if (SubscriptionListWindow.this.display != null && !SubscriptionListWindow.this.display.isDisposed()) {
                            SubscriptionListWindow.this.display.asyncExec(new Runnable(){

                                public void run() {
                                    if (SubscriptionListWindow.this.loadingProgress != null && !SubscriptionListWindow.this.loadingProgress.isDisposed()) {
                                        int currentSelection = SubscriptionListWindow.this.loadingProgress.getSelection() + 1;
                                        SubscriptionListWindow.this.loadingProgress.setSelection(currentSelection);
                                        if (currentSelection > SubscriptionListWindow.this.loadingProgress.getMaximum() * 80 / 100) {
                                            waitTime[0] = 300;
                                        }
                                        if (currentSelection > SubscriptionListWindow.this.loadingProgress.getMaximum() * 90 / 100) {
                                            waitTime[0] = 1000;
                                        }
                                    } else {
                                        SubscriptionListWindow.this.loadingDone = true;
                                    }
                                }
                            });
                        }
                        try {
                            Thread.sleep(waitTime[0]);
                        }
                        catch (Exception e) {
                            SubscriptionListWindow.this.loadingDone = true;
                        }
                    }
                }
            };
            progressMover.start();
        }
        catch (Exception e) {
            this.failed(null, null);
        }
        this.animatedImage.start();
        this.mainLayout.topControl = this.loadingPanel;
    }

    public void found(byte[] hash, Subscription subscription) {
    }

    public void complete(byte[] hash, Subscription[] subscriptions) {
        if (subscriptions.length <= 0) {
            this.failed(hash, null);
        } else {
            this.subscriptionItems = new SubscriptionItemModel[subscriptions.length];
            for (int i = 0; i < subscriptions.length; ++i) {
                SubscriptionItemModel subscriptionItem;
                this.subscriptionItems[i] = subscriptionItem = new SubscriptionItemModel();
                subscriptionItem.name = subscriptions[i].getName();
                subscriptionItem.popularity = -1L;
                subscriptionItem.popularityDisplay = MessageText.getString("subscriptions.listwindow.popularity.reading");
                subscriptionItem.subscription = subscriptions[i];
                try {
                    subscriptions[i].getPopularity(new SubscriptionPopularityListener(){

                        public void gotPopularity(long popularity) {
                            SubscriptionListWindow.this.update(subscriptionItem, popularity, popularity + "");
                        }

                        public void failed(SubscriptionException error) {
                            SubscriptionListWindow.this.update(subscriptionItem, -2L, MessageText.getString("subscriptions.listwindow.popularity.unknown"));
                        }
                    });
                    continue;
                }
                catch (SubscriptionException e) {
                    this.update(subscriptionItem, -2L, MessageText.getString("subscriptions.listwindow.popularity.unknown"));
                }
            }
            if (this.display != null && !this.display.isDisposed()) {
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        SubscriptionListWindow.this.animatedImage.stop();
                        SubscriptionListWindow.this.mainLayout.topControl = SubscriptionListWindow.this.listPanel;
                        SubscriptionListWindow.this.mainComposite.layout();
                        SubscriptionListWindow.this.sortAndRefresh();
                        SubscriptionListWindow.this.subscriptionsList.setSelection(0);
                        SubscriptionListWindow.this.action.addListener(13, new Listener(){

                            public void handleEvent(Event arg0) {
                                Subscription subscription;
                                int selectedIndex;
                                if (SubscriptionListWindow.this.subscriptionsList != null && !SubscriptionListWindow.this.subscriptionsList.isDisposed() && (selectedIndex = SubscriptionListWindow.this.subscriptionsList.getSelectionIndex()) >= 0 && selectedIndex < SubscriptionListWindow.this.subscriptionItems.length && (subscription = SubscriptionListWindow.this.subscriptionItems[selectedIndex].subscription) != null) {
                                    subscription.setSubscribed(true);
                                }
                            }
                        });
                    }
                });
            }
        }
    }

    protected void update(SubscriptionItemModel subscriptionItem, long popularity, String text) {
        subscriptionItem.popularity = popularity;
        subscriptionItem.popularityDisplay = text;
        this.display.asyncExec(new Runnable(){

            public void run() {
                SubscriptionListWindow.this.sortAndRefresh();
            }
        });
    }

    private void sortAndRefresh() {
        if (this.subscriptionsList.isDisposed()) {
            return;
        }
        for (int i = 0; i < this.subscriptionItems.length; ++i) {
            this.subscriptionItems[i].selected = false;
        }
        int currentSelection = this.subscriptionsList.getSelectionIndex();
        if (currentSelection >= 0 && currentSelection < this.subscriptionItems.length) {
            this.subscriptionItems[currentSelection].selected = true;
        }
        final int dir = this.subscriptionsList.getSortDirection() == 1024 ? 1 : -1;
        final boolean nameSort = this.subscriptionsList.getColumn(0) == this.subscriptionsList.getSortColumn();
        Arrays.sort(this.subscriptionItems, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                SubscriptionItemModel item0 = (SubscriptionItemModel)arg0;
                SubscriptionItemModel item1 = (SubscriptionItemModel)arg1;
                if (nameSort) {
                    return dir * item0.name.compareTo(item1.name);
                }
                return dir * (int)(item1.popularity - item0.popularity);
            }
        });
        this.subscriptionsList.setItemCount(this.subscriptionItems.length);
        this.subscriptionsList.clearAll();
        if (currentSelection >= 0 && currentSelection < this.subscriptionItems.length) {
            for (int i = 0; i < this.subscriptionItems.length; ++i) {
                if (!this.subscriptionItems[i].selected) continue;
                this.subscriptionsList.setSelection(i);
            }
        }
    }

    public void failed(byte[] hash, SubscriptionException error) {
        if (this.display != null && !this.display.isDisposed()) {
            this.display.asyncExec(new Runnable(){

                public void run() {
                    SubscriptionListWindow.this.animatedImage.stop();
                    SubscriptionListWindow.this.animatedImage.dispose();
                    SubscriptionListWindow.this.loadingProgress.dispose();
                    SubscriptionListWindow.this.loadingText.setText(MessageText.getString("subscriptions.listwindow.failed"));
                }
            });
        }
    }

    public static void main(String[] args) {
        Display display = new Display();
        SubscriptionListWindow slw = new SubscriptionListWindow(null, false);
        while (!slw.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private class SubscriptionItemModel {
        String name;
        long popularity;
        String popularityDisplay;
        Subscription subscription;
        boolean selected;

        private SubscriptionItemModel() {
        }
    }
}

