/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcherWithException;
import org.gudy.azureus2.core3.util.SystemTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerManager<T> {
    private static final boolean TIME_LISTENERS = false;
    private final String name;
    private ListenerManagerDispatcher<T> target;
    private ListenerManagerDispatcherWithException target_with_exception;
    private boolean async;
    private AEThread2 async_thread;
    private List<T> listeners = new ArrayList<T>(0);
    private List<Object[]> dispatch_queue;
    private AESemaphore dispatch_sem;
    private boolean logged_too_many_listeners;

    public static <T> ListenerManager<T> createManager(String name, ListenerManagerDispatcher<T> target) {
        return new ListenerManager<T>(name, target, false);
    }

    public static <T> ListenerManager<T> createAsyncManager(String name, ListenerManagerDispatcher<T> target) {
        return new ListenerManager<T>(name, target, true);
    }

    protected ListenerManager(String _name, ListenerManagerDispatcher<T> _target, boolean _async) {
        this.name = _name;
        this.target = _target;
        this.async = _async;
        if (this.target instanceof ListenerManagerDispatcherWithException) {
            this.target_with_exception = (ListenerManagerDispatcherWithException)this.target;
        }
        if (this.async) {
            this.dispatch_sem = new AESemaphore("ListenerManager::" + this.name);
            this.dispatch_queue = new LinkedList<Object[]>();
            if (this.target_with_exception != null) {
                throw new RuntimeException("Can't have an async manager with exceptions!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(T listener) {
        if (listener == null) {
            Debug.out("Trying to add null listener to " + this.name);
            return;
        }
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList<T> new_listeners = new ArrayList<T>(this.listeners);
            if (new_listeners.contains(listener)) {
                if (Constants.IS_CVS_VERSION) {
                    Debug.out("check this out: listener added twice");
                }
                Logger.log(new LogEvent(LogIDs.CORE, 1, "addListener called but listener already added for " + this.name + "\n\t" + Debug.getStackTrace(true, false)));
            }
            new_listeners.add(listener);
            if (new_listeners.size() > 50) {
                if (Constants.IS_CVS_VERSION) {
                    Debug.out("check this out: lots of listeners!");
                    if (!this.logged_too_many_listeners) {
                        this.logged_too_many_listeners = true;
                        Debug.out(String.valueOf(new_listeners));
                    }
                }
                Logger.log(new LogEvent(LogIDs.CORE, 1, "addListener: over 50 listeners added for " + this.name + "\n\t" + Debug.getStackTrace(true, false)));
            }
            this.listeners = new_listeners;
            if (this.async && this.async_thread == null) {
                this.async_thread = new AEThread2(this.name, true){

                    public void run() {
                        ListenerManager.this.dispatchLoop();
                    }
                };
                this.async_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object listener) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            ArrayList<T> new_listeners = new ArrayList<T>(this.listeners);
            new_listeners.remove(listener);
            this.listeners = new_listeners;
            if (this.async && this.listeners.size() == 0) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasListener(T listener) {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            return this.listeners.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            this.listeners = new ArrayList<T>();
            if (this.async) {
                this.async_thread = null;
                this.dispatch_sem.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> getListenersCopy() {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            return this.listeners;
        }
    }

    public void dispatch(int type, Object value) {
        this.dispatch(type, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(int type, Object value, boolean blocking) {
        if (this.async) {
            AESemaphore sem = null;
            if (blocking) {
                sem = new AESemaphore("ListenerManager:blocker");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.listeners.size() == 0) {
                    return;
                }
                this.dispatch_queue.add(new Object[]{this.listeners, new Integer(type), value, sem});
                if (this.async_thread == null) {
                    this.async_thread = new AEThread2(this.name, true){

                        public void run() {
                            ListenerManager.this.dispatchLoop();
                        }
                    };
                    this.async_thread.start();
                }
            }
            this.dispatch_sem.release();
            if (sem != null) {
                sem.reserve();
            }
        } else {
            List<T> listeners_ref;
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                listeners_ref = this.listeners;
            }
            try {
                this.dispatchInternal((T)listeners_ref, type, value);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchWithException(int type, Object value) throws Throwable {
        List<T> listeners_ref;
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            listeners_ref = this.listeners;
        }
        this.dispatchInternal((T)listeners_ref, type, value);
    }

    public void dispatch(T listener, int type, Object value) {
        this.dispatch(listener, type, value, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(T listener, int type, Object value, boolean blocking) {
        if (this.async) {
            AESemaphore sem = null;
            if (blocking) {
                sem = new AESemaphore("ListenerManager:blocker");
            }
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                this.dispatch_queue.add(new Object[]{listener, new Integer(type), value, sem, null});
                if (this.async_thread == null) {
                    this.async_thread = new AEThread2(this.name, true){

                        public void run() {
                            ListenerManager.this.dispatchLoop();
                        }
                    };
                    this.async_thread.start();
                }
            }
            this.dispatch_sem.release();
            if (sem != null) {
                sem.reserve();
            }
        } else {
            if (this.target_with_exception != null) {
                throw new RuntimeException("call dispatchWithException, not dispatch");
            }
            this.doDispatch(listener, type, value);
        }
    }

    protected String getListenerName(T listener) {
        Class<?> listener_class = listener.getClass();
        String res = listener_class.getName();
        try {
            Method getString = listener_class.getMethod("getString", new Class[0]);
            if (getString != null) {
                String s = (String)getString.invoke(listener, new Object[0]);
                res = res + " (" + s + ")";
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        return res;
    }

    protected void doDispatch(T listener, int type, Object value) {
        try {
            this.target.dispatch(listener, type, value);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    protected void doDispatchWithException(T listener, int type, Object value) throws Throwable {
        this.target_with_exception.dispatchWithException(listener, type, value);
    }

    protected void dispatchInternal(List<T> listeners_ref, int type, Object value) throws Throwable {
        for (int i = 0; i < listeners_ref.size(); ++i) {
            if (this.target_with_exception != null) {
                this.doDispatchWithException(listeners_ref.get(i), type, value);
                continue;
            }
            this.doDispatch(listeners_ref.get(i), type, value);
        }
    }

    protected void dispatchInternal(T listener, int type, Object value) throws Throwable {
        if (this.target_with_exception != null) {
            this.doDispatchWithException(listener, type, value);
        } else {
            this.doDispatch(listener, type, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatchLoop() {
        while (true) {
            this.dispatch_sem.reserve();
            Object[] data = null;
            ListenerManager listenerManager = this;
            synchronized (listenerManager) {
                if (this.async_thread == null || !this.async_thread.isCurrentThread()) {
                    this.dispatch_sem.release();
                    return;
                }
                if (this.dispatch_queue.size() > 0) {
                    data = this.dispatch_queue.remove(0);
                }
                if (data == null) continue;
            }
            try {
                if (data.length == 4) {
                    this.dispatchInternal((T)((List)data[0]), (int)((Integer)data[1]), data[2]);
                    continue;
                }
                this.dispatchInternal(data[0], (int)((Integer)data[1]), data[2]);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                continue;
            }
            finally {
                if (data[3] == null) continue;
                ((AESemaphore)data[3]).release();
                continue;
            }
            break;
        }
    }

    public static <T> void dispatchWithTimeout(List<T> _listeners, final ListenerManagerDispatcher<T> _dispatcher, long _timeout) {
        final ArrayList<T> listeners = new ArrayList<T>(_listeners);
        final boolean[] completed = new boolean[listeners.size()];
        final AESemaphore timeout_sem = new AESemaphore("ListenerManager:dwt:timeout");
        int i = 0;
        while (i < listeners.size()) {
            final int f_i = i++;
            new AEThread2("ListenerManager:dwt:dispatcher", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        _dispatcher.dispatch(listeners.get(f_i), -1, null);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    finally {
                        completed[f_i] = true;
                        timeout_sem.release();
                    }
                }
            }.start();
        }
        boolean timeout_occurred = false;
        for (int i2 = 0; i2 < listeners.size(); ++i2) {
            if (_timeout <= 0L) {
                timeout_occurred = true;
                break;
            }
            long start = SystemTime.getCurrentTime();
            if (!timeout_sem.reserve(_timeout)) {
                timeout_occurred = true;
                break;
            }
            long end = SystemTime.getCurrentTime();
            if (end <= start) continue;
            _timeout -= end - start;
        }
        if (timeout_occurred) {
            String str = "";
            for (int i3 = 0; i3 < completed.length; ++i3) {
                if (completed[i3]) continue;
                str = str + (str.length() == 0 ? "" : ",") + listeners.get(i3);
            }
            if (str.length() > 0) {
                Debug.out("Listener dispatch timeout: failed = " + str);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long size() {
        ListenerManager listenerManager = this;
        synchronized (listenerManager) {
            return this.listeners.size();
        }
    }
}

