/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLList;
import org.gudy.azureus2.plugins.torrent.TorrentAnnounceURLListSet;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourceuploader.ResourceUploader;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class UrlUtils {
    private static final ThreadPool connect_pool = new ThreadPool("URLConnectWithTimeout", 8, true);
    private static final String[] prefixes;
    private static int MAGNETURL_STARTS_AT;
    private static final Object[] XMLescapes;
    private static String last_headers;
    private static final String default_headers = "QWNjZXB0OiB0ZXh0L2h0bWwsYXBwbGljYXRpb24veGh0bWwreG1sLGFwcGxpY2F0aW9uL3htbDtxPTAuOSwqLyo7cT0wLjgKQWNjZXB0LUNoYXJzZXQ6IElTTy04ODU5LTEsdXRmLTg7cT0wLjcsKjtxPTAuMwpBY2NlcHQtRW5jb2Rpbmc6IGd6aXAsZGVmbGF0ZQpBY2NlcHQtTGFuZ3VhZ2U6IGVuLVVTLGVuO3E9MC44CkNhY2hlLUNvbnRyb2w6IG1heC1hZ2U9MApDb25uZWN0aW9uOiBrZWVwLWFsaXZlClVzZXItQWdlbnQ6IE1vemlsbGEvNS4wIChXaW5kb3dzIE5UIDYuMTsgV09XNjQpIEFwcGxlV2ViS2l0LzUzNi4xMSAoS0hUTUwsIGxpa2UgR2Vja28pIENocm9tZS8yMC4wLjExMzIuNDcgU2FmYXJpLzUzNi4xMQ==";

    public static String getMagnetURI(byte[] hash) {
        return "magnet:?xt=urn:btih:" + Base32.encode(hash);
    }

    public static String getMagnetURI(byte[] hash, String name, String[] networks) {
        String magnet_uri = UrlUtils.getMagnetURI(hash);
        magnet_uri = magnet_uri + UrlUtils.encodeName(name);
        magnet_uri = magnet_uri + UrlUtils.encodeNetworks(networks);
        return magnet_uri;
    }

    private static String encodeName(String name) {
        if (name == null) {
            return "";
        }
        return "&dn=" + UrlUtils.encode(name);
    }

    private static String encodeNetworks(String[] networks) {
        String net_str = "";
        if (networks != null && networks.length > 0) {
            for (String net : networks) {
                if (net == "Public" && networks.length == 1) break;
                net_str = net_str + "&net=" + net;
            }
        }
        return net_str;
    }

    public static String getMagnetURI(Download download) {
        return UrlUtils.getMagnetURI(PluginCoreUtils.unwrap(download));
    }

    public static String getMagnetURI(DownloadManager dm) {
        if (dm == null) {
            return null;
        }
        TOTorrent to_torrent = dm.getTorrent();
        if (to_torrent == null) {
            return null;
        }
        String name = dm.getDisplayName();
        String magnet_uri = UrlUtils.getMagnetURI(name, PluginCoreUtils.wrap(to_torrent));
        String[] networks = dm.getDownloadState().getNetworks();
        magnet_uri = magnet_uri + UrlUtils.encodeNetworks(networks);
        return magnet_uri;
    }

    public static String getMagnetURI(String name, Torrent torrent) {
        TorrentAnnounceURLListSet[] sets;
        String magnet_str = UrlUtils.getMagnetURI(torrent.getHash());
        magnet_str = magnet_str + UrlUtils.encodeName(name);
        ArrayList<String> tracker_urls = new ArrayList<String>();
        URL announce_url = torrent.getAnnounceURL();
        if (announce_url != null && !TorrentUtils.isDecentralised(announce_url)) {
            tracker_urls.add(announce_url.toExternalForm());
        }
        TorrentAnnounceURLList list = torrent.getAnnounceURLList();
        for (TorrentAnnounceURLListSet set : sets = list.getSets()) {
            String str;
            URL set_url;
            URL[] set_urls = set.getURLs();
            if (set_urls.length <= 0 || TorrentUtils.isDecentralised(set_url = set_urls[0]) || tracker_urls.contains(str = set_url.toExternalForm())) continue;
            tracker_urls.add(str);
        }
        for (String str : tracker_urls) {
            magnet_str = magnet_str + "&tr=" + UrlUtils.encode(str);
        }
        ArrayList<String> ws_urls = new ArrayList<String>();
        Object obj = torrent.getAdditionalProperty("url-list");
        if (obj instanceof byte[]) {
            try {
                ws_urls.add(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
            }
            catch (Throwable e) {}
        } else if (obj instanceof List) {
            for (Object o : (List)obj) {
                try {
                    if (o instanceof byte[]) {
                        ws_urls.add(new URL(new String((byte[])o, "UTF-8")).toExternalForm());
                        continue;
                    }
                    if (!(o instanceof String)) continue;
                    ws_urls.add(new URL((String)o).toExternalForm());
                }
                catch (Throwable e) {}
            }
        } else if (obj instanceof String) {
            try {
                ws_urls.add(new URL((String)obj).toExternalForm());
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        for (String str : ws_urls) {
            magnet_str = magnet_str + "&ws=" + UrlUtils.encode(str);
        }
        return magnet_str;
    }

    public static String normaliseMagnetURI(String base_hash) {
        byte[] hash = UrlUtils.decodeSHA1Hash(base_hash);
        if (hash != null) {
            return UrlUtils.getMagnetURI(hash);
        }
        return null;
    }

    public static byte[] decodeSHA1Hash(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        byte[] hash = null;
        try {
            if (str.length() == 40) {
                hash = ByteFormatter.decodeString(str);
            } else if (str.length() == 32) {
                hash = Base32.decode(str);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (hash != null && hash.length != 20) {
            hash = null;
        }
        return hash;
    }

    public static boolean isURL(String sURL) {
        return UrlUtils.parseTextForURL(sURL, true) != null;
    }

    public static boolean isURL(String sURL, boolean bGuess) {
        return UrlUtils.parseTextForURL(sURL, true, bGuess) != null;
    }

    public static String parseTextForURL(String text, boolean accept_magnets) {
        return UrlUtils.parseTextForURL(text, accept_magnets, true);
    }

    public static String getURL(String text) {
        return UrlUtils.parseTextForURL(text, false, false);
    }

    public static String parseTextForURL(String text, boolean accept_magnets, boolean guess) {
        String textLower;
        if (text == null || text.length() < 5) {
            return null;
        }
        if ((text = text.trim()).startsWith("azplug:")) {
            return text;
        }
        if (text.startsWith("chat:")) {
            return "azplug:?id=azbuddy&arg=" + UrlUtils.encode(text);
        }
        String href = UrlUtils.parseHTMLforURL(text);
        if (href != null) {
            return href;
        }
        try {
            text = text.trim();
            text = URLDecoder.decode(text);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            textLower = text.toLowerCase();
        }
        catch (Throwable e) {
            textLower = text;
        }
        int max = accept_magnets ? prefixes.length : MAGNETURL_STARTS_AT;
        int end = -1;
        int start = textLower.length();
        String strURL = null;
        for (int i = 0; i < max; ++i) {
            int testBegin = textLower.indexOf(prefixes[i]);
            if (testBegin < 0 || testBegin >= start) continue;
            end = text.indexOf("\n", testBegin + prefixes[i].length());
            String strURLTest = end >= 0 ? text.substring(testBegin, end - 1) : text.substring(testBegin);
            try {
                URL parsedURL = new URL(strURLTest);
                strURL = parsedURL.toExternalForm();
                continue;
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
                if (i < MAGNETURL_STARTS_AT) continue;
                strURL = strURLTest;
            }
        }
        if (strURL != null) {
            return strURL;
        }
        if (new File(text).exists()) {
            return null;
        }
        if (accept_magnets && (text.startsWith("bc://") || text.startsWith("bctp://"))) {
            return UrlUtils.parseTextForMagnets(text);
        }
        if (accept_magnets && text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        if (accept_magnets && text.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + text;
        }
        if (accept_magnets && guess) {
            String hash;
            Pattern pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
            Matcher matcher = pattern.matcher(text);
            if (matcher.find()) {
                hash = text.substring(matcher.start() + 1, matcher.start() + 33);
                return "magnet:?xt=urn:btih:" + hash;
            }
            pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
            matcher = pattern.matcher(text);
            if (matcher.find()) {
                hash = text.substring(matcher.start() + 1, matcher.start() + 41);
                byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
                return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
            }
        }
        return null;
    }

    public static String parseTextForMagnets(String text) {
        String hash;
        String decodeString;
        String magnet;
        String base64;
        byte[] decode;
        if (text.startsWith("magnet:") || text.startsWith("maggot:")) {
            return text;
        }
        if (text.matches("^[a-fA-F0-9]{40}$")) {
            byte[] infohash = ByteFormatter.decodeString(text.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        if (text.matches("^[a-zA-Z2-7]{32}$")) {
            return "magnet:?xt=urn:btih:" + text;
        }
        Pattern pattern = Pattern.compile("magnet:\\?[a-z%0-9=_:&.]+", 2);
        Matcher matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        pattern = Pattern.compile("maggot://[a-z0-9]+:[a-z0-9]", 2);
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            return matcher.group();
        }
        pattern = Pattern.compile("bc://bt/([a-z0-9=\\+/]+)", 2);
        matcher = pattern.matcher(text.replaceAll(" ", "+"));
        if (matcher.find() && (decode = Base64.decode(base64 = matcher.group(1))) != null && decode.length > 0) {
            try {
                String hash2;
                String magnet2;
                String decodeString2 = new String(decode, "utf8");
                pattern = Pattern.compile("AA.*/(.*)/ZZ", 2);
                matcher = pattern.matcher(decodeString2);
                if (matcher.find() && (magnet2 = UrlUtils.parseTextForMagnets(hash2 = matcher.group(1))) != null) {
                    pattern = Pattern.compile("AA/(.*)/[0-9]+", 2);
                    matcher = pattern.matcher(decodeString2);
                    if (matcher.find()) {
                        String name = matcher.group(1);
                        return magnet2 + "&dn=" + UrlUtils.encode(name);
                    }
                    return magnet2;
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if ((matcher = (pattern = Pattern.compile("bctp://task/(.*)", 2)).matcher(text)).find() && (magnet = UrlUtils.parseTextForMagnets(decodeString = matcher.group(1))) != null) {
            pattern = Pattern.compile("(.*)/[0-9]+", 2);
            matcher = pattern.matcher(decodeString);
            if (matcher.find()) {
                String name = matcher.group(1);
                return magnet + "&dn=" + UrlUtils.encode(name);
            }
            return magnet;
        }
        text = "!" + text + "!";
        pattern = Pattern.compile("[^a-zA-Z2-7][a-zA-Z2-7]{32}[^a-zA-Z2-7]");
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            hash = text.substring(matcher.start() + 1, matcher.start() + 33);
            return "magnet:?xt=urn:btih:" + hash;
        }
        pattern = Pattern.compile("[^a-fA-F0-9][a-fA-F0-9]{40}[^a-fA-F0-9]");
        matcher = pattern.matcher(text);
        if (matcher.find()) {
            hash = text.substring(matcher.start() + 1, matcher.start() + 41);
            byte[] infohash = ByteFormatter.decodeString(hash.toUpperCase());
            return "magnet:?xt=urn:btih:" + Base32.encode(infohash);
        }
        return null;
    }

    private static String parseHTMLforURL(String text) {
        if (text == null) {
            return null;
        }
        Pattern pat = Pattern.compile("<.*a\\s++.*href=\"?([^\\'\"\\s>]++).*", 2);
        Matcher m = pat.matcher(text);
        if (m.find()) {
            String sURL = m.group(1);
            try {
                sURL = URLDecoder.decode(sURL);
            }
            catch (Exception e) {
                // empty catch block
            }
            return sURL;
        }
        return null;
    }

    public static void main(String[] args) {
        MagnetURIHandler.getSingleton();
        byte[] infohash = ByteFormatter.decodeString("1234567890123456789012345678901234567890");
        String[] test = new String[]{"http://moo.com", "http%3A%2F/moo%2Ecom", "magnet:?moo", "magnet%3A%3Fxt=urn:btih:26", "magnet%3A//%3Fmooo", "magnet:?xt=urn:btih:" + Base32.encode(infohash), "aaaaaaaaaabbbbbbbbbbccccccccccdddddddddd", "magnet:?dn=OpenOffice.org_2.0.3_Win32Intel_install.exe&xt=urn:sha1:PEMIGLKMNFI4HZ4CCHZNPKZJNMAAORKN&xt=urn:tree:tiger:JMIJVWHCQUX47YYH7O4XIBCORNU2KYKHBBC6DHA&xt=urn:ed2k:1c0804541f34b6583a383bb8f2cec682&xl=96793015&xs=http://mirror.switch.ch/ftp/mirror/OpenOffice/stable/2.0.3/OOo_2.0.3_Win32Intel_install.exe"};
        for (int i = 0; i < test.length; ++i) {
            System.out.println("URLDecoder.decode: " + test[i] + " -> " + URLDecoder.decode(test[i]));
            System.out.println("decode: " + test[i] + " -> " + UrlUtils.decode(test[i]));
            System.out.println("isURL: " + test[i] + " -> " + UrlUtils.isURL(test[i]));
            System.out.println("parse: " + test[i] + " -> " + UrlUtils.parseTextForURL(test[i], true));
        }
        String[] testEncode = new String[]{"a b"};
        for (int i = 0; i < testEncode.length; ++i) {
            String txt = testEncode[i];
            try {
                System.out.println("URLEncoder.encode: " + txt + " -> " + URLEncoder.encode(txt, "UTF8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            System.out.println("URLEncoder.encode: " + txt + " -> " + URLEncoder.encode(txt));
            System.out.println("encode: " + txt + " -> " + UrlUtils.encode(txt));
        }
    }

    public static String encode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLEncoder.encode(s, "UTF-8").replaceAll("\\+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return URLEncoder.encode(s).replaceAll("\\+", "%20");
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return "";
        }
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return URLDecoder.decode(s);
        }
    }

    public static String escapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[0], escapeEntry[1]);
        }
        return ret;
    }

    public static String unescapeXML(String s) {
        if (s == null) {
            return "";
        }
        String ret = s;
        for (int i = 0; i < XMLescapes.length; ++i) {
            String[] escapeEntry = (String[])XMLescapes[i];
            ret = ret.replaceAll(escapeEntry[1], escapeEntry[0]);
        }
        return ret;
    }

    public static String convertIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            return "[" + host + "]";
        }
        return host;
    }

    public static String expandIPV6Host(String host) {
        if (host.indexOf(58) != -1) {
            try {
                return InetAddress.getByAddress(InetAddress.getByName(host).getAddress()).getHostAddress();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return host;
    }

    public static void connectWithTimeout(URLConnection connection, long connect_timeout) throws IOException {
        UrlUtils.connectWithTimeouts(connection, connect_timeout, -1L);
    }

    public static void connectWithTimeouts(URLConnection connection, long connect_timeout, long read_timeout) throws IOException {
        if (connect_timeout != -1L) {
            connection.setConnectTimeout((int)connect_timeout);
        }
        if (read_timeout != -1L) {
            connection.setReadTimeout((int)read_timeout);
        }
        connection.connect();
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String referer) {
        UrlUtils.setBrowserHeaders(rd, null, referer);
    }

    public static void setBrowserHeaders(ResourceDownloader rd, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                rd.setProperty("URL_" + lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                rd.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(ResourceUploader ru, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                ru.setProperty("URL_" + lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                ru.setProperty("URL_Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static void setBrowserHeaders(URLConnection connection, String referer) {
        UrlUtils.setBrowserHeaders(connection, null, referer);
    }

    public static void setBrowserHeaders(URLConnection connection, String encoded_headers, String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(encoded_headers);
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                connection.setRequestProperty(lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                connection.setRequestProperty("Referer", referer);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    public static Map getBrowserHeaders(String referer) {
        String headers_to_use = UrlUtils.getBrowserHeadersToUse(null);
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            String header_string = new String(Base64.decode(headers_to_use), "UTF-8");
            String[] headers = header_string.split("\n");
            for (int i = 0; i < headers.length; ++i) {
                String header = headers[i];
                int pos = header.indexOf(58);
                if (pos == -1) continue;
                String lhs = header.substring(0, pos).trim();
                String rhs = header.substring(pos + 1).trim();
                if (lhs.equalsIgnoreCase("Host") || lhs.equalsIgnoreCase("Referer")) continue;
                result.put(lhs, rhs);
            }
            if (referer != null && referer.length() > 0) {
                result.put("Referer", referer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBrowserHeadersToUse(String encoded_headers) {
        String headers_to_use = encoded_headers;
        Class<UrlUtils> clazz = UrlUtils.class;
        synchronized (UrlUtils.class) {
            if (headers_to_use == null) {
                headers_to_use = last_headers != null ? last_headers : default_headers;
            } else {
                if (last_headers == null || !headers_to_use.equals(last_headers)) {
                    COConfigurationManager.setParameter("metasearch.web.last.headers", headers_to_use);
                }
                last_headers = headers_to_use;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return headers_to_use;
        }
    }

    public static boolean queryHasParameter(String query_string, String param_name, boolean case_sensitive) {
        if (!case_sensitive) {
            query_string = query_string.toLowerCase();
            param_name = param_name.toLowerCase();
        }
        if (query_string.charAt(0) == '?') {
            query_string = '&' + query_string.substring(1);
        } else if (query_string.charAt(0) != '&') {
            query_string = '&' + query_string;
        }
        return query_string.indexOf("&" + param_name + "=") != -1;
    }

    public static boolean containsPasskey(URL url) {
        String url_str = url.toExternalForm();
        return url_str.matches(".*[0-9a-z]{20,40}.*");
    }

    public static URL setPort(URL u, int port) {
        if (port == -1) {
            port = u.getDefaultPort();
        }
        StringBuffer result = new StringBuffer();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            if ((pos = authority.lastIndexOf(58)) == -1) {
                if (port > 0) {
                    result.append(authority + ":" + port);
                } else {
                    result.append(authority);
                }
            } else if (port > 0) {
                result.append(authority.substring(0, pos + 1) + port);
            } else {
                result.append(authority.substring(0, pos));
            }
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL setHost(URL u, String host) {
        StringBuffer result = new StringBuffer();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            if ((pos = authority.lastIndexOf(58)) == -1) {
                result.append(host);
            } else {
                result.append(host + authority.substring(pos));
            }
        }
        if (u.getPath() != null) {
            result.append(u.getPath());
        }
        if (u.getQuery() != null) {
            result.append('?');
            result.append(u.getQuery());
        }
        if (u.getRef() != null) {
            result.append("#");
            result.append(u.getRef());
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL setProtocol(URL u, String protocol) {
        String str = u.toExternalForm();
        int pos = str.indexOf(":");
        try {
            return new URL(protocol + str.substring(pos));
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static URL getBaseURL(URL u) {
        StringBuffer result = new StringBuffer();
        result.append(u.getProtocol());
        result.append(":");
        String authority = u.getAuthority();
        if (authority != null && authority.length() > 0) {
            result.append("//");
            int pos = authority.indexOf(64);
            if (pos != -1) {
                result.append(authority.substring(0, pos + 1));
                authority = authority.substring(pos + 1);
            }
            pos = authority.lastIndexOf(58);
            int port = u.getPort();
            if (port == -1) {
                port = u.getDefaultPort();
            }
            if (pos == -1) {
                result.append(authority + ":" + port);
            } else {
                result.append(authority.substring(0, pos + 1) + port);
            }
        }
        try {
            return new URL(result.toString());
        }
        catch (Throwable e) {
            Debug.out(e);
            return u;
        }
    }

    public static String getCanonicalString(URL url) {
        String protocol = url.getProtocol();
        if (!protocol.equals(protocol.toLowerCase(Locale.US))) {
            protocol = protocol.toLowerCase(Locale.US);
            url = UrlUtils.setProtocol(url, protocol);
        }
        int port = url.getPort();
        if (protocol.equals("http") || protocol.equals("https")) {
            if (port == url.getDefaultPort()) {
                url = UrlUtils.setPort(url, 0);
            }
        } else if (port == -1) {
            url = UrlUtils.setPort(url, url.getDefaultPort());
        }
        return url.toString();
    }

    public static URL getIPV4Fallback(URL url) {
        try {
            InetAddress[] addresses = AddressUtils.getAllByName(url.getHost());
            if (addresses.length > 0) {
                InetAddress ipv4 = null;
                InetAddress ipv6 = null;
                for (InetAddress a : addresses) {
                    if (a instanceof Inet4Address) {
                        ipv4 = a;
                        continue;
                    }
                    ipv6 = a;
                }
                if (ipv4 != null && ipv6 != null) {
                    url = UrlUtils.setHost(url, ipv4.getHostAddress());
                    return url;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static long getContentLength(URLConnection con) {
        long res = con.getContentLength();
        if (res == -1L) {
            try {
                String str = con.getHeaderField("content-length");
                if (str != null) {
                    res = Long.parseLong(str);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return res;
    }

    static {
        connect_pool.setWarnWhenFull();
        prefixes = new String[]{"http://", "https://", "ftp://", "dht://", "magnet:?", "magnet://?", "maggot://"};
        MAGNETURL_STARTS_AT = 3;
        XMLescapes = new Object[]{new String[]{"&", "&amp;"}, new String[]{">", "&gt;"}, new String[]{"<", "&lt;"}, new String[]{"\"", "&quot;"}, new String[]{"'", "&apos;"}};
        last_headers = COConfigurationManager.getStringParameter("metasearch.web.last.headers", null);
    }
}

