/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.osx;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.help.AboutWindow;
import org.gudy.azureus2.ui.swt.mainwindow.PluginsMenuHelper;
import org.gudy.azureus2.ui.swt.nat.NatTestWindow;
import org.gudy.azureus2.ui.swt.osx.OSXFileOpen;
import org.gudy.azureus2.ui.swt.speedtest.SpeedTestWizard;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CocoaUIEnhancer {
    private static final boolean DEBUG = false;
    private static Object callBack3;
    private static long callBack3Addr;
    private static Object callBack4;
    private static long callBack4Addr;
    private static CocoaUIEnhancer instance;
    private static final int kServicesMenuItem = 4;
    private static int NSWindowToolbarButton;
    private static long sel_application_openFile_;
    private static long sel_application_openFiles_;
    private static long sel_applicationShouldHandleReopen_;
    private static long sel_toolbarButtonClicked_;
    private static boolean alreadyHaveOpenDoc;
    static final byte[] SWT_OBJECT;
    private long delegateIdSWTApplication;
    private long delegateJniRef;
    private Object delegate;
    private static boolean initialized;
    private static Class<?> osCls;
    private static Class<?> nsmenuCls;
    private static Class<?> nsmenuitemCls;
    private static Class<?> nsapplicationCls;
    private static Class<?> nsarrayCls;
    private static Class<?> nsstringCls;
    private static Class<?> nsidCls;
    private static Class<?> nsautoreleasepoolCls;
    private static Class<?> nsworkspaceCls;
    private static Class<?> nsimageCls;
    private static Class<?> nssizeCls;

    static int actionProc(int id, int sel, int arg0) {
        return (int)CocoaUIEnhancer.actionProc((long)id, (long)sel, (long)arg0);
    }

    static long actionProc(long id, long sel, long arg0) {
        if (sel == sel_toolbarButtonClicked_) {
            try {
                Field fldsel_window = osCls.getField("sel_window");
                Object windowId = CocoaUIEnhancer.invoke(osCls, "objc_msgSend", new Object[]{CocoaUIEnhancer.wrapPointer(arg0), fldsel_window.get(null)});
                final Shell shellAffected = (Shell)CocoaUIEnhancer.invoke(Display.class, Display.getCurrent(), "findWidget", new Object[]{windowId});
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        Long l = (Long)shellAffected.getData("OSX.ToolBarToggle");
                        int type = l == null || l == 0L ? 18 : 17;
                        Event event2 = new Event();
                        event2.type = type;
                        event2.display = shellAffected.getDisplay();
                        event2.widget = shellAffected;
                        shellAffected.notifyListeners(type, event2);
                        shellAffected.setData("OSX.ToolBarToggle", (Object)new Long(type == 18 ? 1L : 0L));
                    }
                });
            }
            catch (Throwable t) {
                Debug.out(t);
            }
        }
        return 0L;
    }

    static int actionProc(int id, int sel, int arg0, int arg1) throws Throwable {
        return (int)CocoaUIEnhancer.actionProc((long)id, (long)sel, (long)arg0, (long)arg1);
    }

    static long actionProc(long id, long sel, long arg0, long arg1) throws Throwable {
        Display display = Display.getCurrent();
        if (display == null) {
            return 0L;
        }
        if (!alreadyHaveOpenDoc && sel == sel_application_openFile_) {
            Constructor<?> conNSString = nsstringCls.getConstructor(Integer.TYPE);
            Object file = conNSString.newInstance(arg1);
            String fileString = (String)CocoaUIEnhancer.invoke(file, "getString");
            OSXFileOpen.fileOpen(fileString);
        } else if (!alreadyHaveOpenDoc && sel == sel_application_openFiles_) {
            Constructor<?> conNSArray = nsarrayCls.getConstructor(Integer.TYPE);
            Constructor<?> conNSString = nsstringCls.getConstructor(nsidCls);
            Object arrayOfFiles = conNSArray.newInstance(arg1);
            int count = ((Number)CocoaUIEnhancer.invoke(arrayOfFiles, "count")).intValue();
            String[] files = new String[count];
            for (int i = 0; i < count; ++i) {
                Object fieldId = CocoaUIEnhancer.invoke(nsarrayCls, arrayOfFiles, "objectAtIndex", new Object[]{i});
                Object nsstring = conNSString.newInstance(fieldId);
                files[i] = (String)CocoaUIEnhancer.invoke(nsstring, "getString");
            }
            OSXFileOpen.fileOpen(files);
        } else if (sel == sel_applicationShouldHandleReopen_) {
            Event event2 = new Event();
            event2.detail = 1;
            if (display != null) {
                CocoaUIEnhancer.invoke(Display.class, display, "sendEvent", new Class[]{Integer.TYPE, Event.class}, new Object[]{26, event2});
            }
        }
        return 0L;
    }

    private static Class<?> classForName(String classname) {
        try {
            Class<?> cls = Class.forName(classname);
            return cls;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private static long convertToLong(Object object) {
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return i.longValue();
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        return 0L;
    }

    public static CocoaUIEnhancer getInstance() {
        if (instance == null) {
            try {
                instance = new CocoaUIEnhancer();
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        return instance;
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Object[] args) {
        try {
            Class[] signature = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                Class<?> thisClass = args[i].getClass();
                signature[i] = thisClass == Integer.class ? Integer.TYPE : (thisClass == Long.class ? Long.TYPE : (thisClass == Byte.class ? Byte.TYPE : (thisClass == Boolean.class ? Boolean.TYPE : thisClass)));
            }
            Method method = clazz.getMethod(methodName, signature);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object invoke(Class<?> clazz, Object target, String methodName, Class[] signature, Object[] args) {
        try {
            Method method = clazz.getDeclaredMethod(methodName, signature);
            method.setAccessible(true);
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Object invoke(Class<?> clazz, String methodName, Object[] args) {
        return CocoaUIEnhancer.invoke(clazz, null, methodName, args);
    }

    private static Object invoke(Object obj, String methodName) {
        return CocoaUIEnhancer.invoke(obj, methodName, (Class[])null, (Object[])null);
    }

    private static Object invoke(Object obj, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = obj.getClass().getMethod(methodName, paramTypes);
            return m.invoke(obj, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static long registerName(Class<?> osCls, String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object object = CocoaUIEnhancer.invoke(osCls, "sel_registerName", new Object[]{name});
        return CocoaUIEnhancer.convertToLong(object);
    }

    private static Object wrapPointer(long value) {
        Class<Number> PTR_CLASS;
        Class<Number> clazz = PTR_CLASS = C.PTR_SIZEOF == 8 ? Long.TYPE : Integer.TYPE;
        if (PTR_CLASS == Long.TYPE) {
            return new Long(value);
        }
        return new Integer((int)value);
    }

    private CocoaUIEnhancer() throws Throwable {
        Object delegateObjSWTApplication = CocoaUIEnhancer.invoke(osCls, "objc_lookUpClass", new Object[]{"SWTApplicationDelegate"});
        this.delegateIdSWTApplication = CocoaUIEnhancer.convertToLong(delegateObjSWTApplication);
        Class<?> swtapplicationdelegateCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.SWTApplicationDelegate");
        this.delegate = swtapplicationdelegateCls.newInstance();
        Object delegateAlloc = CocoaUIEnhancer.invoke(this.delegate, "alloc");
        CocoaUIEnhancer.invoke(delegateAlloc, "init");
        Object delegateIdObj = nsidCls.getField("id").get(this.delegate);
        this.delegateJniRef = ((Number)this.invoke(osCls, "NewGlobalRef", new Class[]{Object.class}, this)).longValue();
        if (this.delegateJniRef == 0L) {
            SWT.error((int)2);
        }
        CocoaUIEnhancer.invoke(osCls, "object_setInstanceVariable", new Object[]{delegateIdObj, SWT_OBJECT, CocoaUIEnhancer.wrapPointer(this.delegateJniRef)});
    }

    public void hookApplicationMenu() {
        Display display = Display.getCurrent();
        try {
            this.initialize();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        display.disposeExec(new Runnable(){

            public void run() {
                CocoaUIEnhancer.invoke(callBack3, "dispose");
                callBack3 = null;
                CocoaUIEnhancer.invoke(callBack4, "dispose");
                callBack4 = null;
                if (CocoaUIEnhancer.this.delegateJniRef != 0L) {
                    CocoaUIEnhancer.invoke(osCls, "DeleteGlobalRef", new Object[]{CocoaUIEnhancer.wrapPointer(CocoaUIEnhancer.this.delegateJniRef)});
                    CocoaUIEnhancer.this.delegateJniRef = 0L;
                }
                if (CocoaUIEnhancer.this.delegate != null) {
                    CocoaUIEnhancer.invoke(CocoaUIEnhancer.this.delegate, "release");
                    CocoaUIEnhancer.this.delegate = null;
                }
            }
        });
    }

    public void hookDocumentOpen() throws Throwable {
        if (alreadyHaveOpenDoc) {
            return;
        }
        if (sel_application_openFile_ == 0L) {
            sel_application_openFile_ = CocoaUIEnhancer.registerName(osCls, "application:openFile:");
        }
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(this.delegateIdSWTApplication), CocoaUIEnhancer.wrapPointer(sel_application_openFile_), CocoaUIEnhancer.wrapPointer(callBack4Addr), "@:@:@"});
        if (sel_application_openFiles_ == 0L) {
            sel_application_openFiles_ = CocoaUIEnhancer.registerName(osCls, "application:openFiles:");
        }
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(this.delegateIdSWTApplication), CocoaUIEnhancer.wrapPointer(sel_application_openFiles_), CocoaUIEnhancer.wrapPointer(callBack4Addr), "@:@:@"});
    }

    static MenuItem getItem(Menu menu, int id) {
        MenuItem[] items = menu.getItems();
        for (int i = 0; i < items.length; ++i) {
            if (items[i].getID() != id) continue;
            return items[i];
        }
        return null;
    }

    private void initialize() throws Exception {
        Object sharedApplication = this.invoke(nsapplicationCls, "sharedApplication");
        Object mainMenu = CocoaUIEnhancer.invoke(sharedApplication, "mainMenu");
        Object mainMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, mainMenu, "itemAtIndex", new Object[]{CocoaUIEnhancer.wrapPointer(0L)});
        Object appMenu = CocoaUIEnhancer.invoke(mainMenuItem, "submenu");
        Object servicesMenuItem = CocoaUIEnhancer.invoke(nsmenuCls, appMenu, "itemAtIndex", new Object[]{CocoaUIEnhancer.wrapPointer(4L)});
        CocoaUIEnhancer.invoke(nsmenuitemCls, servicesMenuItem, "setEnabled", new Object[]{false});
        Menu systemMenu = Display.getCurrent().getSystemMenu();
        if (systemMenu != null) {
            MenuItem sysItem = CocoaUIEnhancer.getItem(systemMenu, -1);
            if (sysItem != null) {
                sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AboutWindow.show();
                    }
                });
            }
            if ((sysItem = CocoaUIEnhancer.getItem(systemMenu, -2)) != null) {
                sysItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.openView(4, null);
                        }
                    }
                });
            }
            int quitIndex = systemMenu.indexOf(CocoaUIEnhancer.getItem(systemMenu, -6));
            MenuItem restartItem = new MenuItem(systemMenu, 64, quitIndex);
            Messages.setLanguageText((Widget)restartItem, "MainWindow.menu.file.restart");
            restartItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                    if (uiFunctions != null) {
                        uiFunctions.dispose(true, false);
                    }
                }
            });
            boolean isAZ3 = "az3".equalsIgnoreCase(COConfigurationManager.getStringParameter("ui"));
            if (!isAZ3) {
                int prefIndex = systemMenu.indexOf(CocoaUIEnhancer.getItem(systemMenu, -2)) + 1;
                MenuItem wizItem = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)wizItem, "MainWindow.menu.file.configure");
                wizItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new ConfigureWizard(false, 0);
                    }
                });
                MenuItem natMenu = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)natMenu, "MainWindow.menu.tools.nattest");
                natMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new NatTestWindow();
                    }
                });
                MenuItem netstatMenu = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)netstatMenu, "MainWindow.menu.tools.netstat");
                netstatMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions != null) {
                            PluginsMenuHelper.IViewInfo[] views;
                            for (PluginsMenuHelper.IViewInfo view : views = PluginsMenuHelper.getInstance().getPluginViewsInfo()) {
                                String viewID = view.viewID;
                                if (viewID == null || !viewID.equals("aznetstatus")) continue;
                                view.openView(uiFunctions);
                            }
                        }
                    }
                });
                MenuItem speedMenu = new MenuItem(systemMenu, 64, prefIndex);
                Messages.setLanguageText((Widget)speedMenu, "MainWindow.menu.tools.speedtest");
                speedMenu.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        new SpeedTestWizard();
                    }
                });
            }
        }
        if (sel_applicationShouldHandleReopen_ == 0L) {
            sel_applicationShouldHandleReopen_ = CocoaUIEnhancer.registerName(osCls, "applicationShouldHandleReopen:hasVisibleWindows:");
        }
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(this.delegateIdSWTApplication), CocoaUIEnhancer.wrapPointer(sel_applicationShouldHandleReopen_), CocoaUIEnhancer.wrapPointer(callBack4Addr), "@:@c"});
        initialized = true;
    }

    private Object invoke(Class<?> cls, String methodName) {
        return this.invoke(cls, methodName, null, null);
    }

    private Object invoke(Class<?> cls, String methodName, Class<?>[] paramTypes, Object ... arguments) {
        try {
            Method m = cls.getMethod(methodName, paramTypes);
            return m.invoke(null, arguments);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void registerToolbarToggle(Shell shell) throws Throwable {
        if (sel_toolbarButtonClicked_ == 0L) {
            sel_toolbarButtonClicked_ = CocoaUIEnhancer.registerName(osCls, "toolbarButtonClicked:");
        }
        CocoaUIEnhancer.invoke(osCls, "class_addMethod", new Object[]{CocoaUIEnhancer.wrapPointer(this.delegateIdSWTApplication), CocoaUIEnhancer.wrapPointer(sel_toolbarButtonClicked_), CocoaUIEnhancer.wrapPointer(callBack3Addr), "@:@"});
        Class<?> nstoolbarCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSToolbar");
        Class<?> nsbuttonCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSButton");
        Object dummyBar = nstoolbarCls.newInstance();
        CocoaUIEnhancer.invoke(dummyBar, "alloc");
        Object nsStrDummyToolbar = CocoaUIEnhancer.invoke(nsstringCls, "stringWith", new Object[]{"SWTToolbar"});
        CocoaUIEnhancer.invoke(dummyBar, "initWithIdentifier", new Class[]{nsstringCls}, nsStrDummyToolbar);
        CocoaUIEnhancer.invoke(dummyBar, "setVisible", new Class[]{Boolean.TYPE}, Boolean.FALSE);
        Object view = shell.getClass().getField("view").get(shell);
        Object nsWindow = CocoaUIEnhancer.invoke(view, "window");
        CocoaUIEnhancer.invoke(nsWindow, "setToolbar", new Class[]{nstoolbarCls}, dummyBar);
        CocoaUIEnhancer.invoke(nsWindow, "setShowsToolbarButton", new Class[]{Boolean.TYPE}, Boolean.TRUE);
        Object toolbarButton = CocoaUIEnhancer.invoke(nsWindow, "standardWindowButton", new Class[]{Integer.TYPE}, new Integer(NSWindowToolbarButton));
        CocoaUIEnhancer.invoke(toolbarButton, "setTarget", new Class[]{nsidCls}, this.delegate);
        CocoaUIEnhancer.invoke(nsbuttonCls, toolbarButton, "setAction", new Object[]{CocoaUIEnhancer.wrapPointer(sel_toolbarButtonClicked_)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getFileIcon(String path, int imageWidthHeight) {
        Object pool;
        block6: {
            Image image;
            pool = null;
            try {
                try {
                    Image image2;
                    Object nsImage;
                    pool = nsautoreleasepoolCls.newInstance();
                    Object delegateAlloc = CocoaUIEnhancer.invoke(pool, "alloc");
                    CocoaUIEnhancer.invoke(delegateAlloc, "init");
                    Object workspace = CocoaUIEnhancer.invoke(nsworkspaceCls, "sharedWorkspace", new Object[0]);
                    Object fullPath = CocoaUIEnhancer.invoke(nsstringCls, "stringWith", new Object[]{path});
                    if (fullPath == null || (nsImage = CocoaUIEnhancer.invoke(workspace, "iconForFile", new Class[]{nsstringCls}, fullPath)) == null) break block6;
                    Object size = nssizeCls.newInstance();
                    nssizeCls.getField("width").set(size, imageWidthHeight);
                    nssizeCls.getField("height").set(size, imageWidthHeight);
                    CocoaUIEnhancer.invoke(nsImage, "setSize", new Class[]{nssizeCls}, size);
                    CocoaUIEnhancer.invoke(nsImage, "retain");
                    image = image2 = (Image)CocoaUIEnhancer.invoke(Image.class, null, "cocoa_new", new Class[]{Device.class, Integer.TYPE, nsimageCls}, new Object[]{Display.getCurrent(), 0, nsImage});
                    Object var11_11 = null;
                    if (pool == null) return image;
                }
                catch (Throwable t) {
                    Debug.printStackTrace(t);
                    Object var11_13 = null;
                    if (pool == null) return null;
                    CocoaUIEnhancer.invoke(pool, "release");
                    return null;
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                if (pool == null) throw throwable;
                CocoaUIEnhancer.invoke(pool, "release");
                throw throwable;
            }
            CocoaUIEnhancer.invoke(pool, "release");
            return image;
        }
        Object var11_12 = null;
        if (pool == null) return null;
        CocoaUIEnhancer.invoke(pool, "release");
        return null;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    static {
        NSWindowToolbarButton = 3;
        SWT_OBJECT = new byte[]{83, 87, 84, 95, 79, 66, 74, 69, 67, 84, 0};
        initialized = false;
        osCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.OS");
        nsmenuCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSMenu");
        nsmenuitemCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSMenuItem");
        nsapplicationCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSApplication");
        nsarrayCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSArray");
        nsstringCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSString");
        nsidCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.id");
        nsautoreleasepoolCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSAutoreleasePool");
        nsworkspaceCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSWorkspace");
        nsimageCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSImage");
        nssizeCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.cocoa.NSSize");
        Class<CocoaUIEnhancer> clazz = CocoaUIEnhancer.class;
        Class<?> callbackCls = CocoaUIEnhancer.classForName("org.eclipse.swt.internal.Callback");
        try {
            SWT.class.getDeclaredField("OpenDocument");
            alreadyHaveOpenDoc = true;
        }
        catch (Throwable t) {
            alreadyHaveOpenDoc = false;
        }
        try {
            Method mGetAddress = callbackCls.getMethod("getAddress", new Class[0]);
            Constructor<?> consCallback = callbackCls.getConstructor(Object.class, String.class, Integer.TYPE);
            callBack3 = consCallback.newInstance(clazz, "actionProc", 3);
            Object object = mGetAddress.invoke(callBack3, (Object[])null);
            callBack3Addr = CocoaUIEnhancer.convertToLong(object);
            if (callBack3Addr == 0L) {
                SWT.error((int)3);
            }
            if ((callBack4Addr = CocoaUIEnhancer.convertToLong(object = mGetAddress.invoke(callBack4 = consCallback.newInstance(clazz, "actionProc", 4), (Object[])null))) == 0L) {
                SWT.error((int)3);
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }
}

