/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.cnetwork.impl;

import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkImpl;
import com.aelitis.azureus.core.cnetwork.impl.ContentNetworkManagerImpl;
import com.aelitis.azureus.core.crypto.VuzeCryptoManager;
import com.aelitis.azureus.core.metasearch.MetaSearchManagerFactory;
import com.aelitis.azureus.util.ImportExportUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContentNetworkVuzeGeneric
extends ContentNetworkImpl {
    private static String URL_SUFFIX;
    private static final String RPC_ADDRESS;
    private Map<Integer, String> service_map = new HashMap<Integer, String>();
    private Set<Integer> service_exclusions;
    private String SITE_HOST;
    private String URL_PREFIX;
    private String URL_EXT_PREFIX;
    private String URL_ICON;
    private String URL_RELAY_RPC;
    private String URL_AUTHORIZED_RPC;
    private String URL_FAQ;
    private String URL_BLOG;
    private String URL_FORUMS;
    private String URL_WIKI;

    public ContentNetworkVuzeGeneric(ContentNetworkManagerImpl _manager, long _content_network, long _version, String _name, Map<String, Object> _pprop_defaults, Set<Integer> _service_exclusions, String _site_host, String _url_prefix, String _url_icon, String _url_relay_rpc, String _url_authorised_rpc, String _url_faq, String _url_blog, String _url_forums, String _url_wiki, String _url_ext_prefix) {
        super(_manager, 1L, _content_network, _version, _name, _pprop_defaults);
        this.SITE_HOST = _site_host;
        this.URL_PREFIX = _url_prefix;
        this.URL_ICON = _url_icon;
        this.URL_RELAY_RPC = _url_relay_rpc;
        this.URL_AUTHORIZED_RPC = _url_authorised_rpc;
        this.URL_FAQ = _url_faq;
        this.URL_BLOG = _url_blog;
        this.URL_FORUMS = _url_forums;
        this.URL_WIKI = _url_wiki;
        this.URL_EXT_PREFIX = _url_ext_prefix;
        this.service_exclusions = _service_exclusions;
        this.init();
    }

    protected ContentNetworkVuzeGeneric(ContentNetworkManagerImpl _manager, Map<String, Object> _map) throws IOException {
        super(_manager);
        this.importFromBEncodedMap(_map);
    }

    @Override
    protected void importFromBEncodedMap(Map<String, Object> map) throws IOException {
        super.importFromBEncodedMap(map);
        this.SITE_HOST = ImportExportUtils.importString(map, "vg_site");
        this.URL_PREFIX = ImportExportUtils.importString(map, "vg_prefix");
        this.URL_EXT_PREFIX = ImportExportUtils.importString(map, "vg_ext_prefix");
        if (this.URL_EXT_PREFIX == null) {
            this.URL_EXT_PREFIX = this.URL_PREFIX;
        }
        this.URL_ICON = ImportExportUtils.importString(map, "vg_icon");
        this.URL_RELAY_RPC = ImportExportUtils.importString(map, "vg_relay_rpc");
        this.URL_AUTHORIZED_RPC = ImportExportUtils.importString(map, "vg_auth_rpc");
        this.URL_FAQ = ImportExportUtils.importString(map, "vg_faq");
        this.URL_BLOG = ImportExportUtils.importString(map, "vg_blog");
        this.URL_FORUMS = ImportExportUtils.importString(map, "vg_forums");
        this.URL_WIKI = ImportExportUtils.importString(map, "vg_wiki");
        List sex = (List)map.get("vg_sex");
        if (sex != null) {
            this.service_exclusions = new HashSet<Integer>();
            for (Long l : sex) {
                this.service_exclusions.add(l.intValue());
            }
        }
        this.init();
    }

    protected void exportToBEncodedMap(Map map) throws IOException {
        super.exportToBEncodedMap(map);
        ImportExportUtils.exportString(map, "vg_site", this.SITE_HOST);
        ImportExportUtils.exportString(map, "vg_prefix", this.URL_PREFIX);
        ImportExportUtils.exportString(map, "vg_ext_prefix", this.URL_EXT_PREFIX);
        ImportExportUtils.exportString(map, "vg_icon", this.URL_ICON);
        ImportExportUtils.exportString(map, "vg_relay_rpc", this.URL_RELAY_RPC);
        ImportExportUtils.exportString(map, "vg_auth_rpc", this.URL_AUTHORIZED_RPC);
        ImportExportUtils.exportString(map, "vg_faq", this.URL_FAQ);
        ImportExportUtils.exportString(map, "vg_blog", this.URL_BLOG);
        ImportExportUtils.exportString(map, "vg_forums", this.URL_FORUMS);
        ImportExportUtils.exportString(map, "vg_wiki", this.URL_WIKI);
        if (this.service_exclusions != null) {
            ArrayList<Long> sex = new ArrayList<Long>();
            for (Integer i : this.service_exclusions) {
                sex.add(i.longValue());
            }
            map.put("vg_sex", sex);
        }
    }

    protected void init() {
        this.service_map.clear();
        this.addService(1, this.URL_PREFIX + "search?q=");
        this.addService(2, this.URL_PREFIX + "xsearch/index.php?q=");
        this.addService(3, "http://" + RPC_ADDRESS + "/vzrpc/rpc.php");
        this.addService(6, this.URL_PREFIX + "browse.start?");
        this.addService(7, this.URL_PREFIX + "publish.start?");
        this.addService(8, this.URL_PREFIX + "welcome.start?");
        this.addService(35, this.URL_PREFIX + "about.start?");
        this.addService(9, this.URL_PREFIX + "publishnew.start?");
        this.addService(10, this.URL_PREFIX + "publishinfo.start");
        this.addService(11, this.URL_PREFIX + "details/");
        this.addService(12, this.URL_PREFIX + "comment/");
        this.addService(13, this.URL_PREFIX + "profile/");
        this.addService(14, this.URL_PREFIX + "download/");
        this.addService(15, this.URL_PREFIX);
        this.addService(16, this.URL_EXT_PREFIX + "support/");
        this.addService(22, this.URL_PREFIX + "login.start?");
        this.addService(23, this.URL_PREFIX + "logout.start?");
        this.addService(24, this.URL_PREFIX + "register.start?");
        this.addService(25, this.URL_PREFIX + "profile.start?");
        this.addService(26, this.URL_PREFIX + "account.start?");
        this.addService(27, this.URL_PREFIX);
        this.addService(37, this.URL_EXT_PREFIX);
        this.addService(28, this.URL_PREFIX + "user/AddFriend.html?");
        this.addService(29, this.URL_PREFIX + "xsearch/index.php?");
        this.addService(31, this.URL_PREFIX + "ip.start?");
        this.addService(30, this.URL_ICON);
        this.addService(32, this.URL_PREFIX + "emp/load/");
        this.addService(33, this.URL_PREFIX + "emp/recommend/");
        this.addService(34, this.URL_PREFIX + "sidebar.close");
        this.addService(36, "http://pixel.quantserve.com/pixel/p-64Ix1G_SXwOa-.gif");
        if (this.URL_RELAY_RPC != null) {
            this.addService(4, this.URL_RELAY_RPC);
        }
        if (this.URL_AUTHORIZED_RPC != null) {
            this.addService(5, this.URL_AUTHORIZED_RPC);
        }
        if (this.URL_FAQ != null) {
            this.addService(17, this.URL_FAQ);
            this.addService(18, this.URL_FAQ);
        }
        if (this.URL_BLOG != null) {
            this.addService(19, this.URL_BLOG);
        }
        if (this.URL_FORUMS != null) {
            this.addService(20, this.URL_FORUMS);
        }
        if (this.URL_WIKI != null) {
            this.addService(21, this.URL_WIKI);
        }
    }

    protected void addService(int type, String url_str) {
        this.service_map.put(type, url_str);
    }

    protected Set<Integer> getServiceExclusions() {
        return this.service_exclusions;
    }

    @Override
    public Object getProperty(int property) {
        if (property == 1) {
            return this.SITE_HOST;
        }
        if (property == 2) {
            return this.getID() != 1L;
        }
        if (property == 3) {
            return String.valueOf(this.getID());
        }
        this.debug("Unknown property");
        return null;
    }

    @Override
    public boolean isServiceSupported(int service_type) {
        if (this.service_exclusions != null && this.service_exclusions.contains(service_type)) {
            return false;
        }
        return this.service_map.get(service_type) != null;
    }

    @Override
    public String getServiceURL(int service_type) {
        return this.getServiceURL(service_type, new Object[0]);
    }

    @Override
    public String getServiceURL(int service_type, Object[] params) {
        if (this.service_exclusions != null && this.service_exclusions.contains(service_type)) {
            this.debug("Service type '" + service_type + "' is excluded");
            return null;
        }
        String base = this.service_map.get(service_type);
        if (base == null) {
            this.debug("Unknown service type '" + service_type + "'");
            return null;
        }
        switch (service_type) {
            case 1: {
                String query = (String)params[0];
                return base + UrlUtils.encode(query) + "&" + URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
            }
            case 2: {
                String extension_key;
                String query = (String)params[0];
                boolean to_subscribe = (Boolean)params[1];
                String url_str = base + UrlUtils.encode(query) + "&" + URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                if (to_subscribe) {
                    url_str = url_str + "&createSubscription=1";
                }
                if ((extension_key = this.getExtensionKey()) != null) {
                    url_str = url_str + "&extension_key=" + UrlUtils.encode(extension_key);
                }
                url_str = url_str + "&fud=" + UrlUtils.encode(MetaSearchManagerFactory.getSingleton().getMetaSearch().getFUD());
                return url_str;
            }
            case 11: {
                String hash = (String)params[0];
                String client_ref = (String)params[1];
                String url_str = base + hash + ".html?" + URL_SUFFIX;
                if (client_ref != null) {
                    url_str = url_str + "&client_ref=" + UrlUtils.encode(client_ref);
                }
                return url_str;
            }
            case 32: 
            case 33: {
                String hash = (String)params[0];
                String url_str = base + hash + "?" + URL_SUFFIX;
                return url_str;
            }
            case 12: {
                String hash = (String)params[0];
                return base + hash + ".html?" + URL_SUFFIX + "&rnd=" + Math.random();
            }
            case 13: {
                String login_id = (String)params[0];
                String client_ref = (String)params[1];
                return base + UrlUtils.encode(login_id) + "?" + URL_SUFFIX + "&client_ref=" + UrlUtils.encode(client_ref);
            }
            case 14: {
                String hash = (String)params[0];
                String client_ref = (String)params[1];
                String url_str = base + hash + ".torrent";
                if (client_ref != null) {
                    url_str = url_str + "?referal=" + UrlUtils.encode(client_ref);
                }
                url_str = this.appendURLSuffix(url_str, false, true);
                return url_str;
            }
            case 18: {
                String topic = (String)params[0];
                return base + topic;
            }
            case 22: {
                String message = (String)params[0];
                if (message == null || message.length() == 0) {
                    base = base + URL_SUFFIX;
                } else {
                    base = base + "msg=" + UrlUtils.encode(message);
                    base = base + "&" + URL_SUFFIX;
                }
                return base;
            }
            case 25: 
            case 26: {
                base = base + URL_SUFFIX + "&rand=" + SystemTime.getCurrentTime();
                return base;
            }
            case 27: {
                String relative_url = (String)params[0];
                boolean append_suffix = (Boolean)params[1];
                base = base + (relative_url.startsWith("/") ? relative_url.substring(1) : relative_url);
                if (append_suffix) {
                    base = this.appendURLSuffix(base, false, true);
                }
                return base;
            }
            case 37: {
                String relative_url = (String)params[0];
                boolean append_suffix = (Boolean)params[1];
                base = base + (relative_url.startsWith("/") ? relative_url.substring(1) : relative_url);
                if (append_suffix) {
                    base = this.appendURLSuffix(base, false, true);
                }
                base = base.replaceAll("&vzemb=1", "");
                return base;
            }
            case 28: {
                String colour = (String)params[0];
                base = base + "ts=" + Math.random() + "&bg_color=" + colour + "&" + URL_SUFFIX;
                return base;
            }
            case 29: {
                String subs_id = (String)params[0];
                base = base + "subscription=" + subs_id + "&" + URL_SUFFIX;
                return base;
            }
            case 31: {
                String sourceRef;
                String string = sourceRef = params.length > 0 ? (String)params[0] : null;
                if (sourceRef != null) {
                    base = base + "sourceref=" + UrlUtils.encode(sourceRef) + "&" + URL_SUFFIX;
                }
                return base;
            }
            case 8: {
                String installID = COConfigurationManager.getStringParameter("install.id", "null");
                if (installID.length() == 0) {
                    installID = "blank";
                }
                base = base + "iid=" + UrlUtils.encode(installID) + "&" + URL_SUFFIX;
                return base;
            }
            case 6: 
            case 7: 
            case 23: 
            case 24: {
                return base + URL_SUFFIX;
            }
            case 35: {
                return base + "azv=" + "5.5.0.1_B13" + "&locale=" + MessageText.getCurrentLocale().toString();
            }
        }
        return this.appendURLSuffix(base, false, true);
    }

    @Override
    public String appendURLSuffix(String url_in, boolean for_post, boolean include_azid) {
        if (url_in.indexOf("vzemb=") != -1) {
            return url_in;
        }
        String suffix = URL_SUFFIX;
        if (!include_azid) {
            suffix = suffix.replaceAll("azid=.*?&", "");
        }
        if (for_post) {
            if (url_in.length() == 0) {
                return suffix;
            }
            return url_in + "&" + suffix;
        }
        if (url_in.indexOf("?") >= 0) {
            return url_in + "&" + suffix;
        }
        return url_in + "?" + suffix;
    }

    private String getExtensionKey() {
        FeatureManager.FeatureDetails[] fds;
        FeatureManager fm = PluginInitializer.getDefaultInterface().getUtilities().getFeatureManager();
        for (FeatureManager.FeatureDetails fd : fds = fm.getFeatureDetails("core")) {
            String finger_print;
            if (fd.hasExpired() || (finger_print = (String)fd.getProperty("Fingerprint")) == null) continue;
            return fd.getLicence().getShortID() + "-" + finger_print;
        }
        return null;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Send Version Info", "locale"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                boolean send_info = COConfigurationManager.getBooleanParameter("Send Version Info");
                URL_SUFFIX = "azid=" + (send_info ? Base32.encode(VuzeCryptoManager.getSingleton().getPlatformAZID()) : "anonymous") + "&azv=" + "5.5.0.1_B13" + "&locale=" + MessageText.getCurrentLocale().toString() + "&os.name=" + UrlUtils.encode(System.getProperty("os.name")) + "&vzemb=1";
                String suffix = System.getProperty("url.suffix", null);
                if (suffix != null) {
                    URL_SUFFIX = URL_SUFFIX + ("&" + suffix);
                }
            }
        });
        RPC_ADDRESS = System.getProperty("platform_rpc", "vrpc.vuze.com");
    }
}

