/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger;

import com.aelitis.azureus.core.cnetwork.ContentNetwork;
import com.aelitis.azureus.core.cnetwork.ContentNetworkManagerFactory;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.ContentNetworkUtils;
import com.aelitis.azureus.util.FeatureUtils;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.MapUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;

public class PlatformMessenger {
    private static final boolean DEBUG_URL = System.getProperty("platform.messenger.debug.url", "0").equals("1");
    private static final String URL_PLATFORM_MESSAGE = "?service=rpc";
    private static final String URL_POST_PLATFORM_DATA = "service=rpc";
    private static final int MAX_POST_LENGTH = 0x180000;
    private static boolean USE_HTTP_POST = true;
    public static String REPLY_EXCEPTION = "exception";
    public static String REPLY_ACTION = "action";
    public static String REPLY_RESULT = "response";
    private static Map<String, Map<PlatformMessage, PlatformMessengerListener>> mapQueues = new HashMap<String, Map<PlatformMessage, PlatformMessengerListener>>();
    private static final String QUEUE_NOAZID = "noazid.";
    private static final String QUEUE_NORMAL = "msg.";
    private static AEMonitor queue_mon = new AEMonitor("v3.PlatformMessenger.queue");
    private static Timer timerProcess = new Timer("v3.PlatformMessenger.queue");
    private static Map<String, TimerEvent> mapTimerEvents = new HashMap<String, TimerEvent>();
    private static AEMonitor mon_mapTimerEvents = new AEMonitor("mapTimerEvents");
    private static boolean initialized;
    private static fakeContext context;
    private static boolean allowMulti;
    private static AsyncDispatcher dispatcher;
    private static Map<String, Object> mapExtra;

    public static synchronized void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        context = new fakeContext();
    }

    public static ClientMessageContext getClientMessageContext() {
        if (!initialized) {
            PlatformMessenger.init();
        }
        return context;
    }

    public static void queueMessage(PlatformMessage message, PlatformMessengerListener listener) {
        PlatformMessenger.queueMessage(message, listener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void queueMessage(PlatformMessage message, PlatformMessengerListener listener, boolean addToBottom) {
        if (!initialized) {
            PlatformMessenger.init();
        }
        if (message == null) {
            PlatformMessenger.debug("fire timerevent");
        }
        queue_mon.enter();
        try {
            long fireBefore;
            String queueID;
            if (message != null) {
                queueID = !message.sendAZID() ? QUEUE_NOAZID : QUEUE_NORMAL;
                Map<PlatformMessage, PlatformMessengerListener> mapQueue = mapQueues.get(queueID);
                if (mapQueue == null) {
                    mapQueue = new LinkedHashMap<PlatformMessage, PlatformMessengerListener>();
                    mapQueues.put(queueID, mapQueue);
                }
                mapQueue.put(message, listener);
                PlatformMessenger.debug("q " + queueID + "(" + mapQueue.size() + ") " + message.toShortString() + ": " + message + " @ " + new Date(message.getFireBefore()) + "; in " + (message.getFireBefore() - SystemTime.getCurrentTime()) + "ms");
                fireBefore = message.getFireBefore();
            } else {
                queueID = null;
                fireBefore = SystemTime.getCurrentTime();
            }
            if (queueID != null) {
                try {
                    mon_mapTimerEvents.enter();
                    TimerEvent timerEvent2 = mapTimerEvents.get(queueID);
                    if (timerEvent2 == null || timerEvent2.hasRun() || fireBefore < timerEvent2.getWhen()) {
                        if (timerEvent2 != null) {
                            mapTimerEvents.remove(queueID);
                            timerEvent2.cancel();
                        }
                        timerEvent2 = timerProcess.addEvent(fireBefore, new TimerEventPerformer(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void perform(TimerEvent event2) {
                                try {
                                    mon_mapTimerEvents.enter();
                                    if (mapTimerEvents.get(queueID) == event2) {
                                        mapTimerEvents.remove(queueID);
                                    }
                                    Object var3_2 = null;
                                    mon_mapTimerEvents.exit();
                                }
                                catch (Throwable throwable) {
                                    Object var3_3 = null;
                                    mon_mapTimerEvents.exit();
                                    throw throwable;
                                }
                                Map mapQueue = (Map)mapQueues.get(queueID);
                                while (mapQueue != null && mapQueue.size() > 0) {
                                    PlatformMessenger.processQueue(queueID, mapQueue);
                                }
                            }
                        });
                        mapTimerEvents.put(queueID, timerEvent2);
                    }
                    if (timerEvent2 != null) {
                        PlatformMessenger.debug(" next q process for  " + queueID + " in " + (timerEvent2.getWhen() - SystemTime.getCurrentTime()));
                    }
                    Object var8_6 = null;
                    mon_mapTimerEvents.exit();
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    mon_mapTimerEvents.exit();
                    throw throwable;
                }
            }
            Object var10_9 = null;
            queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            queue_mon.exit();
            throw throwable;
        }
    }

    public static void debug(String string) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("v3.PMsgr");
        diag_logger.log(string);
        if (ConstantsVuze.DIAG_TO_STDOUT) {
            System.out.println(Thread.currentThread().getName() + "|" + System.currentTimeMillis() + "] " + string);
        }
    }

    protected static void debug(String string, Throwable e) {
        PlatformMessenger.debug(string + "\n\t" + e.getClass().getName() + ": " + e.getMessage() + ", " + Debug.getCompressedStackTrace(e, 1, 80));
    }

    public static void pushMessageNow(PlatformMessage message, PlatformMessengerListener listener) {
        PlatformMessenger.debug("push " + message.toShortString() + ": " + message);
        HashMap<PlatformMessage, PlatformMessengerListener> map = new HashMap<PlatformMessage, PlatformMessengerListener>(1);
        map.put(message, listener);
        PlatformMessenger.processQueue(null, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processQueue(String queueID, Map mapQueue) {
        String sURL;
        if (!initialized) {
            PlatformMessenger.init();
        }
        final HashMap mapProcessing = new HashMap();
        boolean sendAZID = true;
        long contentNetworkID = 1L;
        boolean isMulti = false;
        StringBuffer urlStem = new StringBuffer();
        long sequenceNo = 0L;
        HashMap<String, Object> mapPayload = new HashMap<String, Object>();
        mapPayload.put("azid", ConstantsVuze.AZID);
        mapPayload.put("azv", "5.5.0.1_B13");
        mapPayload.put("mode", FeatureUtils.getMode());
        mapPayload.putAll(mapExtra);
        ArrayList listCommands = new ArrayList();
        mapPayload.put("commands", listCommands);
        queue_mon.enter();
        try {
            String lastServer = null;
            boolean first = true;
            Iterator iter = mapQueue.keySet().iterator();
            while (iter.hasNext()) {
                PlatformMessage message = (PlatformMessage)iter.next();
                Object value = mapQueue.get(message);
                HashMap<String, Object> mapCmd = new HashMap<String, Object>();
                if (first) {
                    sendAZID = message.sendAZID();
                    first = false;
                }
                message.setSequenceNo(sequenceNo);
                if (urlStem.length() > 0) {
                    urlStem.append('&');
                }
                String listenerID = message.getListenerID();
                String messageID = message.getMessageID();
                Map<?, ?> params = message.getParameters();
                try {
                    urlStem.append("msg=");
                    urlStem.append(URLEncoder.encode(listenerID, "UTF-8"));
                    urlStem.append(":");
                    urlStem.append(URLEncoder.encode(message.getOperationID(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
                mapCmd.put("seq-id", sequenceNo);
                mapCmd.put("listener-id", listenerID);
                mapCmd.put("op-id", message.getOperationID());
                if (params != null) {
                    mapCmd.put("values", params);
                }
                listCommands.add(mapCmd);
                if (sequenceNo > 10L) {
                    PlatformMessenger.debug("breaking up batch at " + sequenceNo + " because max limit would be exceeded");
                    break;
                }
                String curServer = messageID + "-" + listenerID;
                if (lastServer != null && !lastServer.equals(curServer)) {
                    isMulti = true;
                }
                lastServer = curServer;
                PlatformMessengerListener listener = (PlatformMessengerListener)mapProcessing.get(message);
                if (listener != null) {
                    listener.messageSent(message);
                }
                ++sequenceNo;
                mapProcessing.put(message, value);
                iter.remove();
                if (PlatformMessenger.getAllowMulti()) continue;
                break;
            }
            Object var24_23 = null;
            queue_mon.exit();
        }
        catch (Throwable throwable) {
            Object var24_24 = null;
            queue_mon.exit();
            throw throwable;
        }
        if (mapProcessing.size() == 0) {
            return;
        }
        ContentNetwork cn = ContentNetworkManagerFactory.getSingleton().getContentNetwork(contentNetworkID);
        if (cn == null) {
            cn = ConstantsVuze.getDefaultContentNetwork();
        }
        String sURL_RPC = ContentNetworkUtils.getUrl(cn, 3) + "&" + urlStem.toString();
        String sPostData = null;
        String sJSONPayload = UrlUtils.encode(JSONUtils.encodeToJSON(mapPayload));
        if (USE_HTTP_POST) {
            sURL = sURL_RPC;
            sPostData = "service=rpc&payload=" + sJSONPayload;
            sPostData = cn.appendURLSuffix(sPostData, true, sendAZID);
            if (DEBUG_URL) {
                PlatformMessenger.debug("POST for " + mapProcessing.size() + ": " + sURL + "\n   DATA: " + sPostData);
            } else {
                PlatformMessenger.debug("POST for " + mapProcessing.size() + ": " + sURL);
            }
        } else {
            sURL = sURL_RPC + URL_PLATFORM_MESSAGE + "&payload=" + sJSONPayload;
            sURL = cn.appendURLSuffix(sURL, false, sendAZID);
            if (DEBUG_URL) {
                PlatformMessenger.debug("GET: " + sURL);
            } else {
                PlatformMessenger.debug("GET: " + sURL_RPC + URL_PLATFORM_MESSAGE);
            }
        }
        final String fURL = sURL;
        final String fPostData = sPostData;
        dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                try {
                    PlatformMessenger.processQueueAsync(fURL, fPostData, mapProcessing);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    if (e instanceof ResourceDownloaderException) {
                        PlatformMessenger.debug("Error while sending message(s) to Platform: " + e.toString());
                    } else {
                        PlatformMessenger.debug("Error while sending message(s) to Platform", e);
                    }
                    for (PlatformMessage message : mapProcessing.keySet()) {
                        PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
                        if (l == null) continue;
                        try {
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("text", e.toString());
                            map.put("Throwable", e);
                            l.replyReceived(message, REPLY_EXCEPTION, map);
                        }
                        catch (Throwable e2) {
                            PlatformMessenger.debug("Error while sending replyReceived", e2);
                        }
                    }
                }
            }
        });
    }

    protected static void processQueueAsync(String sURL, String sData, Map mapProcessing) throws Throwable {
        URL url = new URL(sURL);
        Object[] result = PlatformMessenger.downloadURL(url, sData);
        String s = (String)result[0];
        List listReplies = (List)result[1];
        if (listReplies == null || listReplies.isEmpty()) {
            PlatformMessenger.debug("Error while sending message(s) to Platform: reply: " + s + "\nurl: " + sURL + "\nPostData: " + sData);
            for (PlatformMessage message : mapProcessing.keySet()) {
                PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
                if (l == null) continue;
                try {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("text", "result was " + s);
                    l.replyReceived(message, REPLY_EXCEPTION, map);
                }
                catch (Throwable e2) {
                    PlatformMessenger.debug("Error while sending replyReceived\nurl: " + sURL + "\nPostData: " + sData, e2);
                }
            }
            return;
        }
        HashMap<Long, Map> mapOrder = new HashMap<Long, Map>();
        for (Object reply : listReplies) {
            if (!(reply instanceof Map)) continue;
            mapOrder.put(MapUtils.getMapLong((Map)reply, "seq-id", -1L), (Map)reply);
        }
        for (PlatformMessage message : mapProcessing.keySet()) {
            Map<String, String> payload;
            String replyType;
            PlatformMessengerListener l = (PlatformMessengerListener)mapProcessing.get(message);
            if (l == null) continue;
            Map mapReply = (Map)mapOrder.get(new Long(message.getSequenceNo()));
            if (mapReply == null) {
                PlatformMessenger.debug("No reply for " + message.toShortString());
            }
            if ((replyType = MapUtils.getMapString(mapReply, "type", "payload")).equalsIgnoreCase("payload")) {
                payload = MapUtils.getMapMap(mapReply, "payload", Collections.EMPTY_MAP);
            } else {
                payload = new HashMap();
                payload.put("message", MapUtils.getMapString(mapReply, "message", "?"));
            }
            if (mapReply != null) {
                String reply = JSONUtils.encodeToJSON(payload);
                PlatformMessenger.debug("Got a reply for " + message.toShortString() + "\n\t" + reply.substring(0, Math.min(8192, reply.length())));
            }
            try {
                l.replyReceived(message, replyType, payload);
            }
            catch (Exception e2) {
                PlatformMessenger.debug("Error while sending replyReceived", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] downloadURL(URL rpc_url, String postData) throws Throwable {
        try {
            Object[] result = PlatformMessenger.downloadURLSupport(null, null, rpc_url, postData);
            if (result[1] == null) {
                throw new Exception("Request failed");
            }
            return result;
        }
        catch (Throwable e) {
            AEProxyFactory.PluginProxy plugin_proxy = AEProxyFactory.getPluginProxy("vuze settings", rpc_url, true);
            if (plugin_proxy == null) {
                throw e;
            }
            URL url = plugin_proxy.getURL();
            Proxy proxy = plugin_proxy.getProxy();
            boolean ok = false;
            try {
                String proxy_host = rpc_url.getHost() + (rpc_url.getPort() == -1 ? "" : ":" + rpc_url.getPort());
                Object[] result = PlatformMessenger.downloadURLSupport(proxy, proxy_host, url, postData);
                ok = true;
                Object[] objectArray = result;
                {
                    Object var11_12 = null;
                    plugin_proxy.setOK(ok);
                }
                return objectArray;
            }
            catch (Throwable throwable) {
                try {
                    Object var11_13 = null;
                    plugin_proxy.setOK(ok);
                    throw throwable;
                }
                catch (Throwable f) {
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object[] downloadURLSupport(Proxy proxy, String proxy_host, URL url, String postData) throws Throwable {
        byte[] data;
        ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
        ResourceDownloader rd = proxy == null ? rdf.create(url, postData) : rdf.create(url, postData, proxy);
        if (proxy_host != null) {
            rd.setProperty("URL_HOST", proxy_host);
        }
        rd.setProperty("URL_Connection", "Keep-Alive");
        rd = rdf.getRetryDownloader(rd, 3);
        InputStream is = rd.download();
        try {
            int length = is.available();
            data = new byte[length];
            is.read(data);
            Object var10_10 = null;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            is.close();
            throw throwable;
        }
        is.close();
        String s = new String(data, "UTF8");
        Map mapAllReplies = JSONUtils.decodeJSON(s);
        List listReplies = MapUtils.getMapList(mapAllReplies, "replies", null);
        return new Object[]{s, listReplies};
    }

    public static void setAllowMulti(boolean allowMulti) {
        PlatformMessenger.allowMulti = allowMulti;
    }

    public static boolean getAllowMulti() {
        return allowMulti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtraParam(String key, Object value) {
        Map<String, Object> map = mapExtra;
        synchronized (map) {
            mapExtra.put(key, value);
        }
    }

    static {
        allowMulti = false;
        dispatcher = new AsyncDispatcher(5000);
        mapExtra = new HashMap<String, Object>();
    }

    private static class fakeContext
    extends ClientMessageContextImpl {
        private long contentNetworkID = 1L;

        private void log(String str) {
            if (System.getProperty("browser.route.all.external.stimuli.for.testing", "false").equalsIgnoreCase("true")) {
                System.err.println(str);
            }
            this.debug(str);
        }

        public fakeContext() {
            super("fakeContext", null);
        }

        public void deregisterBrowser() {
            this.log("deregisterBrowser");
        }

        public void displayBrowserMessage(String message) {
            this.log("displayBrowserMessage - " + message);
        }

        public boolean executeInBrowser(String javascript) {
            this.log("executeInBrowser - " + javascript);
            return false;
        }

        public Object getBrowserData(String key) {
            this.log("getBrowserData - " + key);
            return null;
        }

        public boolean sendBrowserMessage(String key, String op) {
            this.log("sendBrowserMessage - " + key + "/" + op);
            return false;
        }

        public boolean sendBrowserMessage(String key, String op, Map params) {
            this.log("sendBrowserMessage - " + key + "/" + op + "/" + params);
            return false;
        }

        public void setBrowserData(String key, Object value) {
            this.log("setBrowserData - " + key + "/" + value);
        }

        public boolean sendBrowserMessage(String key, String op, Collection params) {
            this.log("sendBrowserMessage - " + key + "/" + op + "/" + params);
            return false;
        }

        public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler handler) {
            this.log("setTorrentURLHandler - " + handler);
        }

        public long getContentNetworkID() {
            return this.contentNetworkID;
        }

        public void setContentNetworkID(long contentNetwork) {
            this.contentNetworkID = contentNetwork;
        }
    }
}

