/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.pluginsimpl.local.FailedPlugin;
import org.gudy.azureus2.pluginsimpl.local.PluginInterfaceImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.launch.PluginLauncherImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.update.UpdateManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.update.UpdaterUpdateChecker;
import org.gudy.azureus2.update.UpdaterUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginInitializer
implements GlobalManagerListener,
AEDiagnosticsEvidenceGenerator {
    public static final boolean DISABLE_PLUGIN_VERIFICATION = false;
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String INTERNAL_PLUGIN_ID = "<internal>";
    private String[][] builtin_plugins = new String[][]{{"Start/Stop Rules", "com.aelitis.azureus.plugins.startstoprules.defaultplugin.StartStopRulesDefaultPlugin", "azbpstartstoprules", "", "true", "true"}, {"Torrent Removal Rules", "com.aelitis.azureus.plugins.removerules.DownloadRemoveRulesPlugin", "azbpremovalrules", "", "true", "false"}, {"Share Hoster", "com.aelitis.azureus.plugins.sharing.hoster.ShareHosterPlugin", "azbpsharehoster", "ShareHoster", "true", "false"}, {"Plugin Update Checker", "org.gudy.azureus2.pluginsimpl.update.PluginUpdatePlugin", "azbppluginupdate", "PluginUpdate", "true", "true"}, {"UPnP", "com.aelitis.azureus.plugins.upnp.UPnPPlugin", "azbpupnp", "UPnP", "true", "false"}, {"DHT", "com.aelitis.azureus.plugins.dht.DHTPlugin", "azbpdht", "DHT", "true", "false"}, {"DHT Tracker", "com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin", "azbpdhdtracker", "DHT Tracker", "true", "false"}, {"Magnet URI Handler", "com.aelitis.azureus.plugins.magnet.MagnetPlugin", "azbpmagnet", "Magnet URI Handler", "true", "false"}, {"Core Update Checker", "org.gudy.azureus2.update.CoreUpdateChecker", "azbpcoreupdater", "CoreUpdater", "true", "true"}, {"Core Patch Checker", "org.gudy.azureus2.update.CorePatchChecker", "azbpcorepatcher", "CorePatcher", "true", "true"}, {"Platform Checker", "org.gudy.azureus2.platform.PlatformManagerPluginDelegate", "azplatform2", "azplatform2", "true", "false"}, {"External Seed", "com.aelitis.azureus.plugins.extseed.ExternalSeedPlugin", "azextseed", "azextseed", "true", "false"}, {"Local Tracker", "com.aelitis.azureus.plugins.tracker.local.LocalTrackerPlugin", "azlocaltracker", "azlocaltracker", "true", "false"}, {"Network Status", "com.aelitis.azureus.plugins.net.netstatus.NetStatusPlugin", "aznetstat", "aznetstat", "true", "false"}, {"Buddy", "com.aelitis.azureus.plugins.net.buddy.BuddyPlugin", "azbuddy", "azbuddy", "true", "false"}, {"RSS", "com.aelitis.azureus.core.rssgen.RSSGeneratorPlugin", "azintrss", "azintrss", "true", "false"}};
    static VerifiedPluginHolder verified_plugin_holder;
    private static String[][] default_version_details;
    private static PluginInitializer singleton;
    private static AEMonitor class_mon;
    private static List registration_queue;
    private static List initThreads;
    private static AsyncDispatcher async_dispatcher;
    private static List<PluginEvent> plugin_event_history;
    private AzureusCoreOperation core_operation;
    private AzureusCore azureus_core;
    private PluginInterfaceImpl default_plugin;
    private PluginManager plugin_manager;
    private ClassLoader root_class_loader = this.getClass().getClassLoader();
    private List loaded_pi_list = new ArrayList();
    private static boolean loading_builtin;
    private List<Plugin> s_plugins = new ArrayList<Plugin>();
    private List<PluginInterfaceImpl> s_plugin_interfaces = new ArrayList<PluginInterfaceImpl>();
    private boolean initialisation_complete;
    private volatile boolean plugins_initialised;
    private Set<String> vc_disabled_plugins = VersionCheckClient.getSingleton().getDisabledPluginIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInitializer getSingleton(AzureusCore azureus_core, AzureusCoreOperation core_operation) {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new PluginInitializer(azureus_core, core_operation);
            }
            PluginInitializer pluginInitializer = singleton;
            Object var4_3 = null;
            class_mon.exit();
            return pluginInitializer;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PluginInitializer peekSingleton() {
        try {
            class_mon.enter();
            PluginInitializer pluginInitializer = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return pluginInitializer;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void queueRegistration(Class _class) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(_class);
            } else {
                try {
                    singleton.initializePluginFromClass(_class, INTERNAL_PLUGIN_ID, _class.getName(), false, false, true);
                }
                catch (PluginException pluginException) {
                }
            }
            Object var3_2 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void queueRegistration(Plugin plugin, String id) {
        try {
            class_mon.enter();
            if (singleton == null) {
                registration_queue.add(new Object[]{plugin, id});
            } else {
                try {
                    singleton.initializePluginFromInstance(plugin, id, plugin.getClass().getName());
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected static boolean isLoadingBuiltin() {
        return loading_builtin;
    }

    public static void checkAzureusVersion(String name, Properties props, boolean alert_on_fail) throws PluginException {
        String required_version = (String)props.get("plugin.azureus.min_version");
        if (required_version == null) {
            return;
        }
        if (Constants.compareVersions("5.5.0.1_B13", required_version) < 0) {
            String plugin_name_bit = name.length() > 0 ? name + " " : "";
            String msg = "Plugin " + plugin_name_bit + "requires " + Constants.APP_NAME + " version " + required_version + " or higher";
            if (alert_on_fail) {
                Logger.log(new LogAlert(true, 3, msg));
            }
            throw new PluginException(msg);
        }
    }

    public static void checkJDKVersion(String name, Properties props, boolean alert_on_fail) throws PluginException {
        String required_jdk = (String)props.get("plugin.jdk.min_version");
        if (required_jdk != null) {
            String actual_jdk = Constants.JAVA_VERSION;
            required_jdk = PluginInitializer.normaliseJDK(required_jdk);
            actual_jdk = PluginInitializer.normaliseJDK(actual_jdk);
            if (required_jdk.length() == 0 || actual_jdk.length() == 0) {
                return;
            }
            if (Constants.compareVersions(actual_jdk, required_jdk) < 0) {
                String msg = "Plugin " + (name.length() > 0 ? name + " " : "") + "requires Java version " + required_jdk + " or higher";
                if (alert_on_fail) {
                    Logger.log(new LogAlert(true, 3, msg));
                }
                throw new PluginException(msg);
            }
        }
    }

    protected static String normaliseJDK(String jdk) {
        try {
            char c;
            String str = "";
            for (int i = 0; i < jdk.length() && ((c = jdk.charAt(i)) == '.' || Character.isDigit(c)); ++i) {
                str = str + c;
            }
            if (Integer.parseInt("" + str.charAt(0)) > 1) {
                str = "1." + str;
            }
            return str;
        }
        catch (Throwable e) {
            return "";
        }
    }

    protected PluginInitializer(AzureusCore _azureus_core, AzureusCoreOperation _core_operation) {
        this.azureus_core = _azureus_core;
        AEDiagnostics.addEvidenceGenerator(this);
        this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void componentCreated(AzureusCore core, AzureusCoreComponent comp2) {
                if (comp2 instanceof GlobalManager) {
                    GlobalManager gm = (GlobalManager)comp2;
                    gm.addListener(PluginInitializer.this);
                }
            }
        });
        this.core_operation = _core_operation;
        UpdateManagerImpl.getSingleton(this.azureus_core);
        this.plugin_manager = PluginManagerImpl.getSingleton(this);
        String dynamic_plugins = System.getProperty("azureus.dynamic.plugins", null);
        if (dynamic_plugins != null) {
            String[] classes;
            for (String c : classes = dynamic_plugins.split(";")) {
                try {
                    PluginInitializer.queueRegistration(Class.forName(c));
                }
                catch (Throwable e) {
                    Debug.out("Registration of dynamic plugin '" + c + "' failed", e);
                }
            }
        }
        UpdaterUtils.checkBootstrapPlugins();
    }

    protected void fireCreated(PluginInterfaceImpl pi) {
        this.azureus_core.triggerLifeCycleComponentCreated(pi);
    }

    protected void fireOperational(PluginInterfaceImpl pi, boolean op) {
        this.fireEventSupport(op ? 8 : 9, pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addInitThread() {
        List list = initThreads;
        synchronized (list) {
            if (initThreads.contains(Thread.currentThread())) {
                Debug.out("Already added");
            }
            initThreads.add(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeInitThread() {
        List list = initThreads;
        synchronized (list) {
            initThreads.remove(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isInitialisationThread() {
        List list = initThreads;
        synchronized (list) {
            return initThreads.contains(Thread.currentThread());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List loadPlugins(AzureusCore core, boolean bSkipAlreadyLoaded, boolean load_external_plugins, boolean loading_for_startup, boolean initialise_plugins) {
        int i;
        if (bSkipAlreadyLoaded) {
            ArrayList<PluginInterfaceImpl> pis;
            List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
            synchronized (list) {
                pis = new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
            }
            for (int i2 = 0; i2 < pis.size(); ++i2) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)pis.get(i2);
                Plugin p = pi.getPlugin();
                if (!(p instanceof FailedPlugin)) continue;
                this.unloadPlugin(pi);
            }
        }
        ArrayList pluginLoaded = new ArrayList();
        PluginManagerImpl.setStartDetails(core);
        this.getRootClassLoader();
        File user_dir = FileUtil.getUserFile("plugins");
        File app_dir = FileUtil.getApplicationFile("plugins");
        int user_plugins = 0;
        int app_plugins = 0;
        if (user_dir.exists() && user_dir.isDirectory()) {
            user_plugins = user_dir.listFiles().length;
        }
        if (app_dir.exists() && app_dir.isDirectory()) {
            app_plugins = app_dir.listFiles().length;
        }
        if (load_external_plugins) {
            pluginLoaded.addAll(this.loadPluginsFromDir(user_dir, 0, user_plugins + app_plugins, bSkipAlreadyLoaded, loading_for_startup, initialise_plugins));
            if (!user_dir.equals(app_dir)) {
                pluginLoaded.addAll(this.loadPluginsFromDir(app_dir, user_plugins, user_plugins + app_plugins, bSkipAlreadyLoaded, loading_for_startup, initialise_plugins));
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading of external plugins skipped"));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading built-in plugins"));
        }
        PluginManagerDefaults def = PluginManager.getDefaults();
        for (i = 0; i < this.builtin_plugins.length; ++i) {
            if (def.isDefaultPluginEnabled(this.builtin_plugins[i][0])) {
                Object var16_21;
                if (this.core_operation != null) {
                    this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin") + this.builtin_plugins[i][0]);
                }
                try {
                    try {
                        loading_builtin = true;
                        Class<?> cla = this.root_class_loader.loadClass(this.builtin_plugins[i][1]);
                        Method load_method = cla.getMethod("load", PluginInterface.class);
                        load_method.invoke(null, this.getDefaultInterfaceSupport());
                        Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[i][0] + "' ok"));
                    }
                    catch (NoSuchMethodException e) {
                        var16_21 = null;
                        loading_builtin = false;
                        continue;
                    }
                    catch (Throwable e) {
                        if (this.builtin_plugins[i][4].equalsIgnoreCase("true")) {
                            Debug.printStackTrace(e);
                            Logger.log(new LogAlert(false, "Load of built in plugin '" + this.builtin_plugins[i][2] + "' fails", e));
                        }
                        var16_21 = null;
                        loading_builtin = false;
                        continue;
                    }
                    var16_21 = null;
                    loading_builtin = false;
                    continue;
                }
                catch (Throwable throwable) {
                    var16_21 = null;
                    loading_builtin = false;
                    throw throwable;
                }
            }
            if (!Logger.isEnabled()) continue;
            Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + this.builtin_plugins[i][2] + "' is disabled"));
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Loading dynamically registered plugins"));
        }
        for (i = 0; i < registration_queue.size(); ++i) {
            String id;
            Class<?> cla;
            Object entry = registration_queue.get(i);
            if (entry instanceof Class) {
                cla = (Class<?>)entry;
                id = cla.getName();
            } else {
                Object[] x = (Object[])entry;
                Plugin plugin = (Plugin)x[0];
                cla = plugin.getClass();
                id = (String)x[1];
            }
            try {
                Method load_method = cla.getMethod("load", PluginInterface.class);
                load_method.invoke(null, this.getDefaultInterfaceSupport());
                continue;
            }
            catch (NoSuchMethodException e) {
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
                Logger.log(new LogAlert(false, "Load of dynamic plugin '" + id + "' fails", e));
            }
        }
        return pluginLoaded;
    }

    private void getRootClassLoader() {
        File user_dir = FileUtil.getUserFile("shared");
        this.getRootClassLoader(user_dir);
        File app_dir = FileUtil.getApplicationFile("shared");
        if (!user_dir.equals(app_dir)) {
            this.getRootClassLoader(app_dir);
        }
    }

    private void getRootClassLoader(File dir) {
        File[] files;
        if ((dir = new File(dir, "lib")).exists() && dir.isDirectory() && (files = dir.listFiles()) != null) {
            files = PluginLauncherImpl.getHighestJarVersions(files, new String[]{null}, new String[]{null}, false);
            for (int i = 0; i < files.length; ++i) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Share class loader extended by " + files[i].toString()));
                }
                this.root_class_loader = PluginLauncherImpl.addFileToClassPath(PluginInitializer.class.getClassLoader(), this.root_class_loader, files[i]);
            }
        }
    }

    private List loadPluginsFromDir(File pluginDirectory, int plugin_offset, int plugin_total, boolean bSkipAlreadyLoaded, boolean loading_for_startup, boolean initialise) {
        ArrayList dirLoadedPIs = new ArrayList();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "Plugin Directory is " + pluginDirectory));
        }
        if (!pluginDirectory.exists()) {
            FileUtil.mkdirs(pluginDirectory);
        }
        if (pluginDirectory.isDirectory()) {
            File[] pluginsDirectory = pluginDirectory.listFiles();
            for (int i = 0; i < pluginsDirectory.length; ++i) {
                if (pluginsDirectory[i].getName().equals("CVS")) {
                    if (!Logger.isEnabled()) continue;
                    Logger.log(new LogEvent(LOGID, "Skipping plugin " + pluginsDirectory[i].getName()));
                    continue;
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "Loading plugin " + pluginsDirectory[i].getName()));
                }
                if (this.core_operation != null) {
                    this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin") + pluginsDirectory[i].getName());
                }
                try {
                    List loaded_pis = this.loadPluginFromDir(pluginsDirectory[i], bSkipAlreadyLoaded, loading_for_startup, initialise);
                    this.loaded_pi_list.add(loaded_pis);
                    dirLoadedPIs.addAll(loaded_pis);
                }
                catch (PluginException e) {
                    // empty catch block
                }
                if (this.core_operation == null) continue;
                this.core_operation.reportPercent(100 * (i + plugin_offset) / plugin_total);
            }
        }
        return dirLoadedPIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List loadPluginFromDir(File directory, boolean bSkipAlreadyLoaded, boolean loading_for_startup, boolean initialise) throws PluginException {
        ArrayList<PluginInterfaceImpl> loaded_pis = new ArrayList<PluginInterfaceImpl>();
        ClassLoader plugin_class_loader = this.root_class_loader;
        if (!directory.isDirectory()) {
            return loaded_pis;
        }
        String pluginName = directory.getName();
        File[] pluginContents = directory.listFiles();
        if (pluginContents == null) return loaded_pis;
        if (pluginContents.length == 0) {
            return loaded_pis;
        }
        boolean looks_like_plugin = false;
        for (int i = 0; i < pluginContents.length; ++i) {
            String name = pluginContents[i].getName().toLowerCase();
            if (!name.endsWith(".jar") && !name.equals("plugin.properties")) continue;
            looks_like_plugin = true;
            break;
        }
        if (!looks_like_plugin) {
            if (!Logger.isEnabled()) return loaded_pis;
            Logger.log(new LogEvent(LOGID, 1, "Plugin directory '" + directory + "' has no plugin.properties " + "or .jar files, skipping"));
            return loaded_pis;
        }
        String[] plugin_version = new String[]{null};
        String[] plugin_id = new String[]{null};
        pluginContents = PluginLauncherImpl.getHighestJarVersions(pluginContents, plugin_version, plugin_id, true);
        for (int i = 0; i < pluginContents.length; ++i) {
            String name;
            File jar_file = pluginContents[i];
            if (pluginContents.length > 1 && (name = jar_file.getName()).startsWith("i18nPlugin_")) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "renaming '" + name + "' to conform with versioning system"));
                }
                jar_file.renameTo(new File(jar_file.getParent(), "i18nAZ_0.1.jar  "));
                continue;
            }
            plugin_class_loader = PluginLauncherImpl.addFileToClassPath(this.root_class_loader, plugin_class_loader, jar_file);
        }
        String plugin_class_string = null;
        try {
            int p1;
            String plugin_name_string;
            Properties props;
            block58: {
                props = new Properties();
                File properties_file = new File(directory.toString() + File.separator + "plugin.properties");
                try {
                    if (properties_file.exists()) {
                        FileInputStream fis = null;
                        try {
                            fis = new FileInputStream(properties_file);
                            props.load(fis);
                            Object var17_20 = null;
                            if (fis == null) break block58;
                        }
                        catch (Throwable throwable) {
                            Object var17_21 = null;
                            if (fis == null) throw throwable;
                            fis.close();
                            throw throwable;
                        }
                        fis.close();
                        break block58;
                    }
                    if (!(plugin_class_loader instanceof URLClassLoader)) throw new Exception("failed to load plugin.properties from dir or jars");
                    URLClassLoader current = (URLClassLoader)plugin_class_loader;
                    URL url = current.findResource("plugin.properties");
                    if (url == null) throw new Exception("failed to load plugin.properties from jars");
                    URLConnection connection = url.openConnection();
                    InputStream is = connection.getInputStream();
                    props.load(is);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    String msg = "Can't read 'plugin.properties' for plugin '" + pluginName + "': file may be missing";
                    Logger.log(new LogAlert(false, 3, msg));
                    System.out.println(msg);
                    throw new PluginException(msg, e);
                }
            }
            PluginInitializer.checkJDKVersion(pluginName, props, true);
            PluginInitializer.checkAzureusVersion(pluginName, props, true);
            plugin_class_string = (String)props.get("plugin.class");
            if (plugin_class_string == null && (plugin_class_string = (String)props.get("plugin.classes")) == null) {
                plugin_class_string = "";
            }
            if ((plugin_name_string = (String)props.get("plugin.name")) == null) {
                plugin_name_string = (String)props.get("plugin.names");
            }
            int pos1 = 0;
            int pos2 = 0;
            do {
                String plugin_class;
                if ((p1 = plugin_class_string.indexOf(";", pos1)) == -1) {
                    plugin_class = plugin_class_string.substring(pos1).trim();
                } else {
                    plugin_class = plugin_class_string.substring(pos1, p1).trim();
                    pos1 = p1 + 1;
                }
                PluginInterfaceImpl existing_pi = this.getPluginFromClass(plugin_class);
                if (existing_pi != null) {
                    if (bSkipAlreadyLoaded) {
                        return loaded_pis;
                    }
                    File this_parent = directory.getParentFile();
                    File existing_parent = null;
                    if (existing_pi.getInitializerKey() instanceof File) {
                        existing_parent = ((File)existing_pi.getInitializerKey()).getParentFile();
                    }
                    if (this_parent.equals(FileUtil.getApplicationFile("plugins")) && existing_parent != null && existing_parent.equals(FileUtil.getUserFile("plugins"))) {
                        if (!Logger.isEnabled()) return new ArrayList();
                        Logger.log(new LogEvent(LOGID, "Plugin '" + plugin_name_string + "/" + plugin_class + ": shared version overridden by user-specific one"));
                        return new ArrayList();
                    }
                    Logger.log(new LogAlert(false, 1, "Error loading '" + plugin_name_string + "', plugin class '" + plugin_class + "' is already loaded"));
                    continue;
                }
                String plugin_name = null;
                if (plugin_name_string != null) {
                    int p2 = plugin_name_string.indexOf(";", pos2);
                    if (p2 == -1) {
                        plugin_name = plugin_name_string.substring(pos2).trim();
                    } else {
                        plugin_name = plugin_name_string.substring(pos2, p2).trim();
                        pos2 = p2 + 1;
                    }
                }
                Properties new_props = (Properties)props.clone();
                for (int j = 0; j < default_version_details.length; ++j) {
                    if (!plugin_class.equals(default_version_details[j][0])) continue;
                    if (new_props.get("plugin.id") == null) {
                        new_props.put("plugin.id", default_version_details[j][1]);
                    }
                    if (plugin_name == null) {
                        plugin_name = default_version_details[j][2];
                    }
                    if (new_props.get("plugin.version") != null) continue;
                    if (plugin_version[0] != null) {
                        new_props.put("plugin.version", plugin_version[0]);
                        continue;
                    }
                    new_props.put("plugin.version", default_version_details[j][3]);
                }
                new_props.put("plugin.class", plugin_class);
                if (plugin_name != null) {
                    new_props.put("plugin.name", plugin_name);
                }
                Throwable load_failure = null;
                String pid = plugin_id[0] == null ? directory.getName() : plugin_id[0];
                ArrayList<File> verified_files = null;
                Plugin plugin = null;
                if (this.vc_disabled_plugins.contains(pid)) {
                    this.log("Plugin '" + pid + "' has been administratively disabled");
                    continue;
                }
                try {
                    String cl_key = "plugin.cl.ext." + pid;
                    String str = COConfigurationManager.getStringParameter(cl_key, null);
                    if (str != null && str.length() > 0) {
                        COConfigurationManager.removeParameter(cl_key);
                        plugin_class_loader = PluginLauncherImpl.extendClassLoader(this.root_class_loader, plugin_class_loader, new URL(str));
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
                if (pid.endsWith("_v")) {
                    verified_files = new ArrayList<File>();
                    this.log("Re-verifying " + pid);
                    for (int i = 0; i < pluginContents.length; ++i) {
                        File jar_file = pluginContents[i];
                        if (!jar_file.getName().endsWith(".jar")) continue;
                        try {
                            this.log("    verifying " + jar_file);
                            AEVerifier.verifyData(jar_file);
                            verified_files.add(jar_file);
                            this.log("    OK");
                            continue;
                        }
                        catch (Throwable e) {
                            String msg = "Error loading plugin '" + pluginName + "' / '" + plugin_class_string + "'";
                            Logger.log(new LogAlert(false, msg, e));
                            plugin = new FailedPlugin(plugin_name, directory.getAbsolutePath());
                        }
                    }
                }
                if (plugin == null) {
                    plugin = PluginLauncherImpl.getPreloadedPlugin(plugin_class);
                    if (plugin == null) {
                        try {
                            try {
                                Class<?> c = PlatformManagerFactory.getPlatformManager().loadClass(plugin_class_loader, plugin_class);
                                plugin = (Plugin)c.newInstance();
                                try {
                                    if (plugin_class_loader instanceof URLClassLoader) {
                                        URL[] urls;
                                        for (URL u : urls = ((URLClassLoader)plugin_class_loader).getURLs()) {
                                            String path = u.getPath();
                                            if (!path.endsWith(".jar")) continue;
                                            int s1 = path.lastIndexOf(47);
                                            int s2 = path.lastIndexOf(92);
                                            if ((s2 = (path = path.substring(Math.max(s1, s2) + 1)).indexOf(95)) <= 0) continue;
                                            path = path.substring(0, s2);
                                            path = path.replaceAll("-", "");
                                            String cl = "plugin.preinit." + pid + ".PI" + path;
                                            try {
                                                Class<?> pic = plugin_class_loader.loadClass(cl);
                                                if (pic == null) continue;
                                                pic.newInstance();
                                            }
                                            catch (Throwable e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                }
                                catch (Throwable e) {
                                }
                            }
                            catch (PlatformManagerException e) {
                                throw e.getCause();
                            }
                        }
                        catch (UnsupportedClassVersionError e) {
                            plugin = new FailedPlugin(plugin_name, directory.getAbsolutePath());
                            load_failure = new UnsupportedClassVersionError(e.getMessage());
                        }
                        catch (Throwable e) {
                            if (!(e instanceof ClassNotFoundException) || !props.getProperty("plugin.install_if_missing", "no").equalsIgnoreCase("yes")) {
                                load_failure = e;
                            }
                            plugin = new FailedPlugin(plugin_name, directory.getAbsolutePath());
                        }
                    } else {
                        plugin_class_loader = plugin.getClass().getClassLoader();
                    }
                }
                MessageText.integratePluginMessages((String)props.get("plugin.langfile"), plugin_class_loader);
                PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, directory, plugin_class_loader, verified_files, directory.getName(), new_props, directory.getAbsolutePath(), pid, plugin_version[0]);
                boolean bEnabled = loading_for_startup ? plugin_interface.getPluginState().isLoadedAtStartup() : initialise;
                plugin_interface.getPluginState().setDisabled(!bEnabled);
                try {
                    Method load_method = plugin.getClass().getMethod("load", PluginInterface.class);
                    load_method.invoke((Object)plugin, plugin_interface);
                }
                catch (NoSuchMethodException e) {
                }
                catch (Throwable e) {
                    load_failure = e;
                }
                loaded_pis.add(plugin_interface);
                if (load_failure == null) continue;
                plugin_interface.setAsFailed();
                if (pid.equals(UpdaterUpdateChecker.getPluginID())) continue;
                String msg = MessageText.getString("plugin.init.load.failed", new String[]{plugin_name == null ? pluginName : plugin_name, directory.getAbsolutePath()});
                LogAlert la = load_failure instanceof UnsupportedClassVersionError ? new LogAlert(false, 3, msg + ".\n\n" + MessageText.getString("plugin.install.class_version_error")) : (load_failure instanceof ClassNotFoundException ? new LogAlert(false, 3, msg + ".\n\n" + MessageText.getString("plugin.init.load.failed.classmissing") + "\n\n", load_failure) : new LogAlert(false, msg, load_failure));
                Logger.log(la);
                System.out.println(msg + ": " + load_failure);
            } while (p1 != -1);
            return loaded_pis;
        }
        catch (Throwable e) {
            if (e instanceof PluginException) {
                throw (PluginException)e;
            }
            Debug.printStackTrace(e);
            String msg = "Error loading plugin '" + pluginName + "' / '" + plugin_class_string + "'";
            Logger.log(new LogAlert(false, msg, e));
            System.out.println(msg + ": " + e);
            throw new PluginException(msg, e);
        }
    }

    private void log(String str) {
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, str));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialisePlugins() {
        try {
            int idx;
            PluginInitializer.addInitThread();
            final LinkedList<Runnable> initQueue = new LinkedList<Runnable>();
            int i = 0;
            while (i < this.loaded_pi_list.size()) {
                final int idx2 = i++;
                initQueue.add(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run() {
                        block10: {
                            try {
                                block9: {
                                    try {
                                        List l = (List)PluginInitializer.this.loaded_pi_list.get(idx2);
                                        if (l.size() <= 0) break block9;
                                        PluginInterfaceImpl plugin_interface = (PluginInterfaceImpl)l.get(0);
                                        if (Logger.isEnabled()) {
                                            Logger.log(new LogEvent(LOGID, "Initializing plugin '" + plugin_interface.getPluginName() + "'"));
                                        }
                                        if (PluginInitializer.this.core_operation != null) {
                                            PluginInitializer.this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin.init") + " " + plugin_interface.getPluginName());
                                        }
                                        PluginInitializer.this.initialisePlugin(l);
                                        if (!Logger.isEnabled()) break block9;
                                        Logger.log(new LogEvent(LOGID, "Initialization of plugin '" + plugin_interface.getPluginName() + "' complete"));
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_5 = null;
                                        if (PluginInitializer.this.core_operation != null) {
                                            PluginInitializer.this.core_operation.reportPercent(100 * (idx2 + 1) / PluginInitializer.this.loaded_pi_list.size());
                                        }
                                        break block10;
                                    }
                                }
                                Object var4_4 = null;
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                if (PluginInitializer.this.core_operation != null) {
                                    PluginInitializer.this.core_operation.reportPercent(100 * (idx2 + 1) / PluginInitializer.this.loaded_pi_list.size());
                                }
                                throw throwable;
                            }
                            if (PluginInitializer.this.core_operation != null) {
                                PluginInitializer.this.core_operation.reportPercent(100 * (idx2 + 1) / PluginInitializer.this.loaded_pi_list.size());
                            }
                        }
                        Logger.doRedirects();
                    }
                });
            }
            initQueue.add(new Runnable(){

                public void run() {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Initializing built-in plugins"));
                    }
                }
            });
            final PluginManagerDefaults def = PluginManager.getDefaults();
            int i2 = 0;
            while (i2 < this.builtin_plugins.length) {
                idx = i2++;
                initQueue.add(new Runnable(){

                    public void run() {
                        block9: {
                            if (def.isDefaultPluginEnabled(PluginInitializer.this.builtin_plugins[idx][0])) {
                                String id = PluginInitializer.this.builtin_plugins[idx][2];
                                String key = PluginInitializer.this.builtin_plugins[idx][3];
                                try {
                                    Class<?> cla = PluginInitializer.this.root_class_loader.loadClass(PluginInitializer.this.builtin_plugins[idx][1]);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, "Initializing built-in plugin '" + PluginInitializer.this.builtin_plugins[idx][2] + "'"));
                                    }
                                    PluginInitializer.this.initializePluginFromClass(cla, id, key, "true".equals(PluginInitializer.this.builtin_plugins[idx][5]), true, true);
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 1, "Initialization of built in plugin '" + PluginInitializer.this.builtin_plugins[idx][2] + "' complete"));
                                    }
                                    break block9;
                                }
                                catch (Throwable e) {
                                    try {
                                        PluginInitializer.this.initializePluginFromClass(FailedPlugin.class, id, key, false, false, true);
                                    }
                                    catch (Throwable f) {
                                        // empty catch block
                                    }
                                    if (PluginInitializer.this.builtin_plugins[idx][4].equalsIgnoreCase("true")) {
                                        Debug.printStackTrace(e);
                                        Logger.log(new LogAlert(false, "Initialization of built in plugin '" + PluginInitializer.this.builtin_plugins[idx][2] + "' fails", e));
                                    }
                                    break block9;
                                }
                            }
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, 1, "Built-in plugin '" + PluginInitializer.this.builtin_plugins[idx][2] + "' is disabled"));
                            }
                        }
                    }
                });
            }
            initQueue.add(new Runnable(){

                public void run() {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Initializing dynamically registered plugins"));
                    }
                }
            });
            i2 = 0;
            while (i2 < registration_queue.size()) {
                idx = i2++;
                initQueue.add(new Runnable(){

                    public void run() {
                        try {
                            Object entry = registration_queue.get(idx);
                            if (entry instanceof Class) {
                                Class cla = (Class)entry;
                                singleton.initializePluginFromClass(cla, PluginInitializer.INTERNAL_PLUGIN_ID, cla.getName(), false, true, true);
                            } else {
                                Object[] x = (Object[])entry;
                                Plugin plugin = (Plugin)x[0];
                                singleton.initializePluginFromInstance(plugin, (String)x[1], plugin.getClass().getName());
                            }
                        }
                        catch (PluginException pluginException) {
                            // empty catch block
                        }
                    }
                });
            }
            AEThread2 secondaryInitializer = new AEThread2("2nd PluginInitializer Thread", true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        PluginInitializer.addInitThread();
                        while (true) {
                            Runnable toRun;
                            LinkedList linkedList = initQueue;
                            synchronized (linkedList) {
                                if (initQueue.isEmpty()) {
                                    break;
                                }
                                toRun = (Runnable)initQueue.remove(0);
                            }
                            try {
                                toRun.run();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        Object var5_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        PluginInitializer.removeInitThread();
                        throw throwable;
                    }
                    PluginInitializer.removeInitThread();
                }
            };
            secondaryInitializer.start();
            while (true) {
                Runnable toRun;
                LinkedList<Runnable> linkedList = initQueue;
                synchronized (linkedList) {
                    if (initQueue.isEmpty()) {
                        break;
                    }
                    toRun = (Runnable)initQueue.remove(0);
                }
                try {
                    toRun.run();
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            secondaryInitializer.join();
            registration_queue.clear();
            this.plugins_initialised = true;
            PluginInitializer.fireEvent(7);
            Object var8_11 = null;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            PluginInitializer.removeInitThread();
            throw throwable;
        }
        PluginInitializer.removeInitThread();
    }

    protected void checkPluginsInitialised() {
        if (!this.plugins_initialised) {
            Debug.out("Wait until plugin initialisation is complete until doing this!");
        }
    }

    protected boolean isInitialized() {
        return this.plugins_initialised;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialisePlugin(List l) throws PluginException {
        PluginException last_load_failure = null;
        for (int i = 0; i < l.size(); ++i) {
            final PluginInterfaceImpl plugin_interface = (PluginInterfaceImpl)l.get(i);
            if (plugin_interface.getPluginState().isDisabled()) {
                List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
                synchronized (list) {
                    this.s_plugin_interfaces.add(plugin_interface);
                    continue;
                }
            }
            if (plugin_interface.getPluginState().isOperational()) continue;
            Throwable load_failure = null;
            final Plugin plugin = plugin_interface.getPlugin();
            try {
                UtilitiesImpl.callWithPluginThreadContext((PluginInterface)plugin_interface, new UtilitiesImpl.runnableWithException<PluginException>(){

                    @Override
                    public void run() throws PluginException {
                        PluginInitializer.this.fireCreated(plugin_interface);
                        plugin.initialize(plugin_interface);
                        if (!(plugin instanceof FailedPlugin)) {
                            plugin_interface.getPluginStateImpl().setOperational(true, false);
                        }
                    }
                });
            }
            catch (Throwable e) {
                load_failure = e;
            }
            List<PluginInterfaceImpl> e = this.s_plugin_interfaces;
            synchronized (e) {
                this.s_plugins.add(plugin);
                this.s_plugin_interfaces.add(plugin_interface);
            }
            if (load_failure == null) continue;
            Debug.printStackTrace(load_failure);
            String msg = "Error initializing plugin '" + plugin_interface.getPluginName() + "'";
            Logger.log(new LogAlert(false, msg, load_failure));
            System.out.println(msg + " : " + load_failure);
            last_load_failure = new PluginException(msg, load_failure);
        }
        if (last_load_failure != null) {
            throw last_load_failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePluginFromClass(final Class plugin_class, final String plugin_id, String plugin_config_key, boolean force_enabled, boolean loading_for_startup, boolean initialise) throws PluginException {
        if (plugin_class != FailedPlugin.class && this.getPluginFromClass(plugin_class) != null) {
            Logger.log(new LogAlert(false, 1, "Error loading '" + plugin_id + "', plugin class '" + plugin_class.getName() + "' is already loaded"));
            return;
        }
        try {
            boolean bEnabled;
            String plugin_name;
            final Plugin plugin = (Plugin)plugin_class.newInstance();
            if (plugin_config_key.length() == 0) {
                plugin_name = plugin_class.getName();
                int pos = plugin_name.lastIndexOf(".");
                if (pos != -1) {
                    plugin_name = plugin_name.substring(pos + 1);
                }
            } else {
                plugin_name = plugin_config_key;
            }
            Properties properties = new Properties();
            properties.put("plugin.name", plugin_name);
            final PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, plugin_class, plugin_class.getClassLoader(), null, plugin_config_key, properties, "", plugin_id, null);
            boolean bl = bEnabled = loading_for_startup ? plugin_interface.getPluginState().isLoadedAtStartup() : initialise;
            if (force_enabled && !bEnabled) {
                plugin_interface.getPluginState().setLoadedAtStartup(true);
                bEnabled = true;
                Logger.log(new LogAlert(false, 1, MessageText.getString("plugins.init.force_enabled", new String[]{plugin_id})));
            }
            plugin_interface.getPluginState().setDisabled(!bEnabled);
            final boolean f_enabled = bEnabled;
            UtilitiesImpl.callWithPluginThreadContext((PluginInterface)plugin_interface, new UtilitiesImpl.runnableWithException<PluginException>(){

                @Override
                public void run() throws PluginException {
                    try {
                        Method load_method = plugin_class.getMethod("load", PluginInterface.class);
                        load_method.invoke((Object)plugin, plugin_interface);
                    }
                    catch (NoSuchMethodException e) {
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                        Logger.log(new LogAlert(false, "Load of built in plugin '" + plugin_id + "' fails", e));
                    }
                    if (f_enabled) {
                        if (PluginInitializer.this.core_operation != null) {
                            PluginInitializer.this.core_operation.reportCurrentTask(MessageText.getString("splash.plugin.init") + " " + plugin_interface.getPluginName());
                        }
                        PluginInitializer.this.fireCreated(plugin_interface);
                        plugin.initialize(plugin_interface);
                        if (!(plugin instanceof FailedPlugin)) {
                            plugin_interface.getPluginStateImpl().setOperational(true, false);
                        }
                    }
                }
            });
            List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
            synchronized (list) {
                this.s_plugins.add(plugin);
                this.s_plugin_interfaces.add(plugin_interface);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            String msg = "Error loading internal plugin '" + plugin_class.getName() + "'";
            Logger.log(new LogAlert(false, msg, e));
            System.out.println(msg + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializePluginFromInstance(final Plugin plugin, String plugin_id, String plugin_config_key) throws PluginException {
        try {
            final PluginInterfaceImpl plugin_interface = new PluginInterfaceImpl(plugin, this, plugin.getClass(), plugin.getClass().getClassLoader(), null, plugin_config_key, new Properties(), "", plugin_id, null);
            UtilitiesImpl.callWithPluginThreadContext((PluginInterface)plugin_interface, new UtilitiesImpl.runnableWithException<PluginException>(){

                @Override
                public void run() throws PluginException {
                    PluginInitializer.this.fireCreated(plugin_interface);
                    plugin.initialize(plugin_interface);
                    if (!(plugin instanceof FailedPlugin)) {
                        plugin_interface.getPluginStateImpl().setOperational(true, false);
                    }
                }
            });
            List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
            synchronized (list) {
                this.s_plugins.add(plugin);
                this.s_plugin_interfaces.add(plugin_interface);
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            String msg = "Error loading internal plugin '" + plugin.getClass().getName() + "'";
            Logger.log(new LogAlert(false, msg, e));
            System.out.println(msg + " : " + e);
            throw new PluginException(msg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unloadPlugin(PluginInterfaceImpl pi) {
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            this.s_plugins.remove(pi.getPlugin());
            this.s_plugin_interfaces.remove(pi);
        }
        pi.unloadSupport();
        for (int i = 0; i < this.loaded_pi_list.size(); ++i) {
            List l = (List)this.loaded_pi_list.get(i);
            if (!l.remove(pi)) continue;
            if (l.size() != 0) break;
            this.loaded_pi_list.remove(i);
            break;
        }
        verified_plugin_holder.removeValue(pi);
    }

    protected void reloadPlugin(PluginInterfaceImpl pi) throws PluginException {
        this.reloadPlugin(pi, false, true);
    }

    protected void reloadPlugin(PluginInterfaceImpl pi, boolean loading_for_startup, boolean initialise) throws PluginException {
        this.unloadPlugin(pi);
        Object key = pi.getInitializerKey();
        String config_key = pi.getPluginConfigKey();
        if (key instanceof File) {
            List pis = this.loadPluginFromDir((File)key, false, loading_for_startup, initialise);
            this.initialisePlugin(pis);
        } else {
            this.initializePluginFromClass((Class)key, pi.getPluginID(), config_key, false, loading_for_startup, initialise);
        }
    }

    protected AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    protected GlobalManager getGlobalManager() {
        return this.azureus_core.getGlobalManager();
    }

    public static PluginInterface getDefaultInterface() {
        if (singleton == null) {
            throw new AzureusCoreException("PluginInitializer not instantiated by AzureusCore.create yet");
        }
        return singleton.getDefaultInterfaceSupport();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PluginInterface getDefaultInterfaceSupport() {
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            if (this.default_plugin == null) {
                try {
                    this.default_plugin = new PluginInterfaceImpl(new Plugin(){

                        public void initialize(PluginInterface pi) {
                        }
                    }, this, this.getClass(), this.getClass().getClassLoader(), null, "default", new Properties(), null, INTERNAL_PLUGIN_ID, null);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
        return this.default_plugin;
    }

    @Override
    public void downloadManagerAdded(DownloadManager dm) {
    }

    @Override
    public void downloadManagerRemoved(DownloadManager dm) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyInitiated() {
        ArrayList<PluginInterfaceImpl> plugin_interfaces;
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            plugin_interfaces = new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
        }
        for (int i = 0; i < plugin_interfaces.size(); ++i) {
            ((PluginInterfaceImpl)plugin_interfaces.get(i)).closedownInitiated();
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownInitiated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroyed() {
        ArrayList<PluginInterfaceImpl> plugin_interfaces;
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            plugin_interfaces = new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
        }
        for (int i = 0; i < plugin_interfaces.size(); ++i) {
            ((PluginInterfaceImpl)plugin_interfaces.get(i)).closedownComplete();
        }
        if (this.default_plugin != null) {
            this.default_plugin.closedownComplete();
        }
    }

    @Override
    public void seedingStatusChanged(boolean seeding_only_mode, boolean b) {
    }

    protected void runPEVTask(AERunnable run) {
        async_dispatcher.dispatch(run);
    }

    protected List<PluginEvent> getPEVHistory() {
        return plugin_event_history;
    }

    protected void fireEventSupport(final int type, final Object value) {
        async_dispatcher.dispatch(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                ArrayList plugin_interfaces;
                PluginEvent ev = new PluginEvent(){

                    public int getType() {
                        return type;
                    }

                    public Object getValue() {
                        return value;
                    }
                };
                if (type == 1 || type == 2 || type == 5 || type == 6 || type == 7) {
                    plugin_event_history.add(ev);
                    if (plugin_event_history.size() > 1024) {
                        Debug.out("Plugin event history too large!!!!");
                        plugin_event_history.remove(0);
                    }
                }
                List list = PluginInitializer.this.s_plugin_interfaces;
                synchronized (list) {
                    plugin_interfaces = new ArrayList(PluginInitializer.this.s_plugin_interfaces);
                }
                for (int i = 0; i < plugin_interfaces.size(); ++i) {
                    try {
                        ((PluginInterfaceImpl)plugin_interfaces.get(i)).firePluginEventSupport(ev);
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                if (PluginInitializer.this.default_plugin != null) {
                    PluginInitializer.this.default_plugin.firePluginEventSupport(ev);
                }
            }
        });
    }

    private void waitForEvents() {
        if (async_dispatcher.isDispatchThread()) {
            Debug.out("Deadlock - recode this monkey boy");
        } else {
            final AESemaphore sem = new AESemaphore("waiter");
            async_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    sem.release();
                }
            });
            if (!sem.reserve(10000L)) {
                Debug.out("Timeout waiting for event dispatch");
            }
        }
    }

    public static void fireEvent(int type) {
        singleton.fireEventSupport(type, null);
    }

    public static void fireEvent(int type, Object value) {
        singleton.fireEventSupport(type, value);
    }

    public static void waitForPluginEvents() {
        singleton.waitForEvents();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialisationComplete() {
        ArrayList<PluginInterfaceImpl> plugin_interfaces;
        this.initialisation_complete = true;
        UIManagerImpl.initialisationComplete();
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            plugin_interfaces = new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
        }
        for (int i = 0; i < plugin_interfaces.size(); ++i) {
            ((PluginInterfaceImpl)plugin_interfaces.get(i)).initialisationComplete();
        }
        if (this.default_plugin != null) {
            this.default_plugin.initialisationComplete();
        }
    }

    protected boolean isInitialisationComplete() {
        return this.initialisation_complete;
    }

    public static List<PluginInterfaceImpl> getPluginInterfaces() {
        return singleton.getPluginInterfacesSupport(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PluginInterfaceImpl> getPluginInterfacesSupport(boolean expect_partial_result) {
        if (!expect_partial_result) {
            this.checkPluginsInitialised();
        }
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            return new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
        }
    }

    public PluginInterface[] getPlugins() {
        return this.getPlugins(false);
    }

    public PluginInterface[] getPlugins(boolean expect_partial_result) {
        List<PluginInterfaceImpl> pis = this.getPluginInterfacesSupport(expect_partial_result);
        PluginInterface[] res = new PluginInterface[pis.size()];
        pis.toArray(res);
        return res;
    }

    protected PluginManager getPluginManager() {
        return this.plugin_manager;
    }

    protected PluginInterfaceImpl getPluginFromClass(Class cla) {
        return this.getPluginFromClass(cla.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PluginInterfaceImpl getPluginFromClass(String class_name) {
        int i;
        ArrayList<PluginInterfaceImpl> plugin_interfaces;
        List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
        synchronized (list) {
            plugin_interfaces = new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
        }
        for (i = 0; i < plugin_interfaces.size(); ++i) {
            PluginInterfaceImpl pi = (PluginInterfaceImpl)plugin_interfaces.get(i);
            if (!pi.getPlugin().getClass().getName().equals(class_name)) continue;
            return pi;
        }
        for (i = 0; i < this.loaded_pi_list.size(); ++i) {
            List l = (List)this.loaded_pi_list.get(i);
            for (int j = 0; j < l.size(); ++j) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)l.get(j);
                if (!pi.getPlugin().getClass().getName().equals(class_name)) continue;
                return pi;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(IndentWriter writer) {
        writer.println("Plugins");
        try {
            ArrayList<PluginInterfaceImpl> plugin_interfaces;
            writer.indent();
            List<PluginInterfaceImpl> list = this.s_plugin_interfaces;
            synchronized (list) {
                plugin_interfaces = new ArrayList<PluginInterfaceImpl>(this.s_plugin_interfaces);
            }
            for (int i = 0; i < plugin_interfaces.size(); ++i) {
                PluginInterfaceImpl pi = (PluginInterfaceImpl)plugin_interfaces.get(i);
                pi.generateEvidence(writer);
            }
            Object var6_7 = null;
            writer.exdent();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            writer.exdent();
            throw throwable;
        }
    }

    protected static void setVerified(PluginInterfaceImpl pi, Plugin plugin, boolean v, boolean bad) throws PluginException {
        Object[] existing = (Object[])verified_plugin_holder.setValue(pi, new Object[]{plugin, v});
        if (existing != null && (existing[0] != plugin || (Boolean)existing[1] != v)) {
            throw new PluginException("Verified status change not permitted");
        }
        if (bad) {
            throw new RuntimeException("Plugin verification failed");
        }
    }

    public static boolean isVerified(PluginInterface pi, Plugin plugin) {
        if (!(pi instanceof PluginInterfaceImpl)) {
            return false;
        }
        VerifiedPluginHolder holder = verified_plugin_holder;
        if (holder.getClass() != VerifiedPluginHolder.class) {
            Debug.out("class mismatch");
            return false;
        }
        Object[] ver = (Object[])verified_plugin_holder.getValue(pi);
        return ver != null && ver[0] == plugin && (Boolean)ver[1] != false;
    }

    public static boolean isCoreOrVerifiedPlugin() {
        Class[] stack = SESecurityManager.getClassContext();
        ClassLoader core = PluginInitializer.class.getClassLoader();
        PluginInitializer singleton = PluginInitializer.peekSingleton();
        PluginInterface[] pis = singleton == null ? new PluginInterface[]{} : singleton.getPlugins();
        HashSet<ClassLoader> ok_loaders = new HashSet<ClassLoader>();
        ok_loaders.add(core);
        for (Class c : stack) {
            ClassLoader cl = c.getClassLoader();
            if (cl == null || ok_loaders.contains(cl)) continue;
            boolean ok = false;
            for (PluginInterface pi : pis) {
                Plugin plugin = pi.getPlugin();
                if (plugin.getClass().getClassLoader() != cl || !PluginInitializer.isVerified(pi, plugin)) continue;
                ok_loaders.add(cl);
                ok = true;
                break;
            }
            if (ok) continue;
            Debug.out("Class " + c.getCanonicalName() + " with loader " + cl + " isn't trusted");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Class<PluginInitializer> clazz = PluginInitializer.class;
        synchronized (PluginInitializer.class) {
            verified_plugin_holder = new VerifiedPluginHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            default_version_details = new String[][]{{"org.cneclipse.multiport.MultiPortPlugin", "multi-ports", "Mutli-Port Trackers", "1.0"}};
            class_mon = new AEMonitor("PluginInitializer");
            registration_queue = new ArrayList();
            initThreads = new ArrayList(1);
            async_dispatcher = new AsyncDispatcher();
            plugin_event_history = new ArrayList<PluginEvent>();
            return;
        }
    }

    private static final class VerifiedPluginHolder {
        private static final Object NULL_VALUE = new Object();
        private volatile boolean initialised;
        private AESemaphore request_sem = new AESemaphore("ValueHolder");
        private List<Object[]> request_queue = new ArrayList<Object[]>();

        private VerifiedPluginHolder() {
            Class[] context2 = SESecurityManager.getClassContext();
            if (context2.length == 0) {
                return;
            }
            if (context2[2] != PluginInitializer.class) {
                Debug.out("Illegal operation");
                return;
            }
            AEThread2 t = new AEThread2("PluginVerifier"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IdentityHashMap<Object, Object> values = new IdentityHashMap<Object, Object>();
                    while (true) {
                        Object[] req;
                        VerifiedPluginHolder.this.request_sem.reserve();
                        List list = VerifiedPluginHolder.this.request_queue;
                        synchronized (list) {
                            req = (Object[])VerifiedPluginHolder.this.request_queue.remove(0);
                        }
                        if (req[1] == null) {
                            req[1] = values.get(req[0]);
                        } else {
                            Object existing = values.get(req[0]);
                            if (req[1] == NULL_VALUE) {
                                req[1] = existing;
                                values.remove(req[0]);
                            } else if (existing != null) {
                                req[1] = existing;
                            } else {
                                values.put(req[0], req[1]);
                            }
                        }
                        ((AESemaphore)req[2]).release();
                    }
                }
            };
            t.start();
            this.initialised = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object removeValue(Object key) {
            if (!this.initialised) {
                return null;
            }
            AESemaphore sem = new AESemaphore("ValueHolder:remove");
            Object[] request2 = new Object[]{key, NULL_VALUE, sem};
            List<Object[]> list = this.request_queue;
            synchronized (list) {
                this.request_queue.add(request2);
            }
            this.request_sem.release();
            sem.reserve();
            return request2[1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object setValue(Object key, Object value) {
            if (!this.initialised) {
                return null;
            }
            AESemaphore sem = new AESemaphore("ValueHolder:set");
            Object[] request2 = new Object[]{key, value, sem};
            List<Object[]> list = this.request_queue;
            synchronized (list) {
                this.request_queue.add(request2);
            }
            this.request_sem.release();
            sem.reserve();
            return request2[1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getValue(Object key) {
            if (!this.initialised) {
                return null;
            }
            AESemaphore sem = new AESemaphore("ValueHolder:get");
            Object[] request2 = new Object[]{key, null, sem};
            List<Object[]> list = this.request_queue;
            synchronized (list) {
                this.request_queue.add(request2);
            }
            this.request_sem.release();
            sem.reserve();
            return request2[1];
        }
    }
}

