/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ddb;

import com.aelitis.azureus.plugins.dht.DHTPluginProgressListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseException;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseKey;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferHandler;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseTransferType;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.torrent.TorrentAttribute;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseContactImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseHelpers;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseKeyImpl;
import org.gudy.azureus2.pluginsimpl.local.ddb.DDBaseValueImpl;

public class DDBaseTTTorrent
implements DistributedDatabaseTransferType,
DistributedDatabaseTransferHandler {
    private static final boolean TRACE = false;
    private static final byte CRYPTO_VERSION = 1;
    private DDBaseImpl ddb;
    private TorrentAttribute ta_sha1;
    private boolean crypto_tested;
    private boolean crypto_available;
    private List external_downloads;
    private Map data_cache = new LinkedHashMap(5, 0.75f, true){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 5;
        }
    };

    protected DDBaseTTTorrent(DDBaseImpl _ddb) {
        this.ddb = _ddb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownload(Download download) {
        DDBaseTTTorrent dDBaseTTTorrent = this;
        synchronized (dDBaseTTTorrent) {
            if (this.external_downloads == null) {
                this.external_downloads = new ArrayList();
            }
            this.external_downloads.add(download);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownload(Download download) {
        DDBaseTTTorrent dDBaseTTTorrent = this;
        synchronized (dDBaseTTTorrent) {
            if (this.external_downloads != null) {
                this.external_downloads.remove(download);
                if (this.external_downloads.size() == 0) {
                    this.external_downloads = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedDatabaseValue read(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key) throws DistributedDatabaseException {
        try {
            byte[] search_key = ((DDBaseKeyImpl)key).getBytes();
            Download download = null;
            PluginInterface pi = PluginInitializer.getDefaultInterface();
            String search_sha1 = pi.getUtilities().getFormatters().encodeBytesToString(search_key);
            if (this.ta_sha1 == null) {
                this.ta_sha1 = pi.getTorrentManager().getPluginAttribute("DDBaseTTTorrent::sha1");
            }
            Download[] downloads = pi.getDownloadManager().getDownloads();
            for (int i = 0; i < downloads.length; ++i) {
                Download dl = downloads[i];
                if (dl.getTorrent() == null) continue;
                String sha1 = dl.getAttribute(this.ta_sha1);
                if (sha1 == null) {
                    sha1 = pi.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(dl.getTorrent().getHash()));
                    dl.setAttribute(this.ta_sha1, sha1);
                }
                if (!sha1.equals(search_sha1)) continue;
                download = dl;
                break;
            }
            if (download == null) {
                DDBaseTTTorrent i = this;
                synchronized (i) {
                    if (this.external_downloads != null) {
                        for (int i2 = 0; i2 < this.external_downloads.size(); ++i2) {
                            Download dl = (Download)this.external_downloads.get(i2);
                            if (dl.getTorrent() == null) continue;
                            String sha1 = dl.getAttribute(this.ta_sha1);
                            if (sha1 == null) {
                                sha1 = pi.getUtilities().getFormatters().encodeBytesToString(new SHA1Simple().calculateHash(dl.getTorrent().getHash()));
                                dl.setAttribute(this.ta_sha1, sha1);
                            }
                            if (!sha1.equals(search_sha1)) continue;
                            download = dl;
                            break;
                        }
                    }
                }
            }
            String originator = contact.getName();
            if (download == null) {
                String msg = "TorrentDownload: request from " + originator + " for '" + pi.getUtilities().getFormatters().encodeBytesToString(search_key) + "' not found";
                this.ddb.log(msg);
                return null;
            }
            Torrent torrent = download.getTorrent();
            if (torrent.isPrivate()) {
                Debug.out("Attempt to download private torrent");
                this.ddb.log("TorrentDownload: request from " + originator + "  for '" + download.getName() + "' denied as it is private");
                return null;
            }
            try {
                DownloadManager dm = PluginCoreUtils.unwrapIfPossible(download);
                if (dm != null && !dm.getDownloadState().isPeerSourceEnabled("DHT")) {
                    this.ddb.log("TorrentDownload: request from " + originator + "  for '" + download.getName() + "' denied as DHT peer source disabled");
                    return null;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            String msg = "TorrentDownload: request from " + originator + "  for '" + download.getName() + "' OK";
            this.ddb.log(msg);
            HashWrapper hw = new HashWrapper(torrent.getHash());
            Map map = this.data_cache;
            synchronized (map) {
                Object[] data = (Object[])this.data_cache.get(hw);
                if (data != null) {
                    data[1] = new Long(SystemTime.getCurrentTime());
                    return this.ddb.createValue((byte[])data[0]);
                }
            }
            torrent = torrent.removeAdditionalProperties();
            torrent.setDecentralisedBackupRequested(true);
            byte[] data = torrent.writeToBEncodedData();
            data = this.encrypt(torrent.getHash(), data);
            if (data == null) {
                return null;
            }
            Map map2 = this.data_cache;
            synchronized (map2) {
                if (this.data_cache.size() == 0) {
                    final TimerEventPeriodic[] pe = new TimerEventPeriodic[]{null};
                    pe[0] = SimpleTimer.addPeriodicEvent("DDBTorrent:timeout", 30000L, new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            long now = SystemTime.getCurrentTime();
                            Map map = DDBaseTTTorrent.this.data_cache;
                            synchronized (map) {
                                Iterator it = DDBaseTTTorrent.this.data_cache.values().iterator();
                                while (it.hasNext()) {
                                    long time = (Long)((Object[])it.next())[1];
                                    if (now >= time && now - time <= 120000L) continue;
                                    it.remove();
                                }
                                if (DDBaseTTTorrent.this.data_cache.size() == 0) {
                                    pe[0].cancel();
                                }
                            }
                        }
                    });
                }
                this.data_cache.put(hw, new Object[]{data, new Long(SystemTime.getCurrentTime())});
            }
            return this.ddb.createValue(data);
        }
        catch (Throwable e) {
            throw new DistributedDatabaseException("Torrent write fails", e);
        }
    }

    public DistributedDatabaseValue write(DistributedDatabaseContact contact, DistributedDatabaseTransferType type, DistributedDatabaseKey key, DistributedDatabaseValue value) throws DistributedDatabaseException {
        throw new DistributedDatabaseException("not supported");
    }

    protected DistributedDatabaseValue read(DDBaseContactImpl contact, final DistributedDatabaseProgressListener listener, DistributedDatabaseTransferType type, DistributedDatabaseKey key, long timeout) throws DistributedDatabaseException {
        byte[] torrent_hash = ((DDBaseKeyImpl)key).getBytes();
        byte[] lookup_key = new SHA1Simple().calculateHash(torrent_hash);
        byte[] data = contact.getContact().read(new DHTPluginProgressListener(){

            public void reportSize(long size) {
                listener.reportSize(size);
            }

            public void reportActivity(String str) {
                listener.reportActivity(str);
            }

            public void reportCompleteness(int percent) {
                listener.reportCompleteness(percent);
            }
        }, DDBaseHelpers.getKey(type.getClass()).getHash(), lookup_key, timeout);
        if (data == null) {
            return null;
        }
        if ((data = this.decrypt(torrent_hash, data)) == null) {
            return null;
        }
        return new DDBaseValueImpl(contact, data, SystemTime.getCurrentTime(), -1L);
    }

    protected byte[] encrypt(byte[] hash, byte[] data) {
        if (!this.testCrypto()) {
            return null;
        }
        byte[] enc = this.doCrypt(1, hash, data, 0);
        if (enc == null) {
            byte[] res = new byte[data.length + 2];
            res[0] = 1;
            res[1] = 0;
            System.arraycopy(data, 0, res, 2, data.length);
            return res;
        }
        byte[] res = new byte[enc.length + 2];
        res[0] = 1;
        res[1] = 1;
        System.arraycopy(enc, 0, res, 2, enc.length);
        return res;
    }

    protected byte[] decrypt(byte[] hash, byte[] data) {
        if (!this.testCrypto()) {
            return null;
        }
        if (data[0] != 1) {
            Debug.out("Invalid crypto version received");
            return data;
        }
        if (data[1] == 0) {
            byte[] res = new byte[data.length - 2];
            System.arraycopy(data, 2, res, 0, res.length);
            return res;
        }
        byte[] res = this.doCrypt(2, hash, data, 2);
        return res;
    }

    protected byte[] doCrypt(int mode, byte[] hash, byte[] data, int data_offset) {
        try {
            byte[] key_data = new byte[24];
            System.arraycopy(hash, 0, key_data, 0, hash.length);
            SecretKeySpec tdes_key = new SecretKeySpec(key_data, "DESede");
            Cipher cipher = Cipher.getInstance("DESede");
            cipher.init(mode, tdes_key);
            return cipher.doFinal(data, data_offset, data.length - data_offset);
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    protected boolean testCrypto() {
        if (!this.crypto_tested) {
            this.crypto_tested = true;
            try {
                Cipher.getInstance("DESede");
                this.crypto_available = true;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(false, "Unable to initialise cryptographic framework for magnet-based torrent downloads, please re-install Java", e));
            }
        }
        return this.crypto_available;
    }
}

