/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.proxy.AEProxySelectorFactory;
import com.aelitis.azureus.core.util.DeleteFileOnCloseInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.util.protocol.magnet.MagnetConnection2;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderCancelledException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    private static final int MAX_IN_MEM_READ_SIZE = 262144;
    private URL original_url;
    private boolean auth_supplied;
    private String user_name;
    private String password;
    private InputStream input_stream;
    private boolean cancel_download = false;
    private boolean download_initiated;
    private long size = -2L;
    private boolean force_no_proxy = false;
    private Proxy force_proxy;
    private boolean auto_plugin_proxy;
    private final byte[] post_data;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url) {
        this(_parent, _url, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _user_name, String _password) {
        this(_parent, _url, true, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, boolean _auth_supplied, String _user_name, String _password) {
        this(_parent, _url, null, _auth_supplied, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, byte[] _data, boolean _auth_supplied, String _user_name, String _password) {
        super(_parent);
        this.original_url = _url;
        this.post_data = _data;
        this.auth_supplied = _auth_supplied;
        this.user_name = _user_name;
        this.password = _password;
    }

    protected void setForceNoProxy(boolean force_no_proxy) {
        this.force_no_proxy = force_no_proxy;
    }

    protected void setForceProxy(Proxy proxy) {
        this.force_proxy = proxy;
    }

    protected void setAutoPluginProxy() {
        this.auto_plugin_proxy = true;
    }

    protected URL getURL() {
        return this.original_url;
    }

    public String getName() {
        return this.original_url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl c = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(c);
                this.size = c.getSizeSupport();
                this.setProperties(c);
                Object var3_2 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.size == -2L) {
                    this.size = -1L;
                }
                throw throwable;
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    public void setProperty(String name, Object value) throws ResourceDownloaderException {
        this.setPropertySupport(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String protocol = this.original_url.getProtocol().toLowerCase();
            if (protocol.equals("magnet")) return -1L;
            if (protocol.equals("maggot")) return -1L;
            if (protocol.equals("dht")) return -1L;
            if (protocol.equals("vuze")) return -1L;
            if (protocol.equals("azplug")) return -1L;
            if (protocol.equals("ftp")) {
                return -1L;
            }
            if (protocol.equals("file")) {
                return new File(this.original_url.toURI()).length();
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                AEProxyFactory.PluginProxy plugin_proxy;
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                URL initial_url = url = AddressUtils.adjustURL(url);
                boolean ok = false;
                if (this.auto_plugin_proxy) {
                    plugin_proxy = AEProxyFactory.getPluginProxy("downloading resource", url);
                    if (plugin_proxy == null) {
                        throw new ResourceDownloaderException(this, "No plugin proxy available");
                    }
                    url = plugin_proxy.getURL();
                    this.force_proxy = plugin_proxy.getProxy();
                } else {
                    plugin_proxy = null;
                }
                try {
                    if (this.force_no_proxy) {
                        AEProxySelectorFactory.getSelector().startNoProxy();
                    }
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, this);
                    }
                    int i = 0;
                    while (i < 2) {
                        long l;
                        try {
                            HttpURLConnection con;
                            if (url.getProtocol().equalsIgnoreCase("https")) {
                                HttpsURLConnection ssl_con = (HttpsURLConnection)this.openConnection(this.force_proxy, url);
                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String host, SSLSession session) {
                                        return true;
                                    }
                                });
                                con = ssl_con;
                            } else {
                                con = (HttpURLConnection)this.openConnection(this.force_proxy, url);
                            }
                            if (plugin_proxy != null) {
                                con.setRequestProperty("HOST", plugin_proxy.getURLHostRewrite() + (initial_url.getPort() == -1 ? "" : ":" + initial_url.getPort()));
                            }
                            con.setRequestMethod("HEAD");
                            con.setRequestProperty("User-Agent", "Azureus 5.5.0.1_B13");
                            this.setRequestProperties(con, false);
                            try {
                                con.connect();
                            }
                            catch (AEProxyFactory.UnknownHostException e) {
                                throw new UnknownHostException(e.getMessage());
                            }
                            int response = con.getResponseCode();
                            this.setProperty("URL_HTTP_Response", new Long(response));
                            if (response != 202 && response != 200) {
                                throw new ResourceDownloaderException(this, "Error on connect for '" + this.trimForDisplay(url) + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                            }
                            this.getRequestProperties(con);
                            ok = true;
                            l = UrlUtils.getContentLength(con);
                        }
                        catch (SSLException e) {
                            if (i != 0) throw e;
                            if (SESecurityManager.installServerCertificates(url) == null) throw e;
                        }
                        catch (IOException e) {
                            if (i != 0) throw e;
                            URL retry_url = UrlUtils.getIPV4Fallback(url);
                            if (retry_url == null) throw e;
                            url = retry_url;
                        }
                        Object var12_19 = null;
                        if (this.auth_supplied) {
                            SESecurityManager.setPasswordHandler(url, null);
                        }
                        if (this.force_no_proxy) {
                            AEProxySelectorFactory.getSelector().endNoProxy();
                        }
                        if (plugin_proxy == null) return l;
                        plugin_proxy.setOK(ok);
                        this.force_proxy = null;
                        return l;
                        ++i;
                    }
                    throw new ResourceDownloaderException(this, "Should never get here");
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(url, null);
                    }
                    if (this.force_no_proxy) {
                        AEProxySelectorFactory.getSelector().endNoProxy();
                    }
                    if (plugin_proxy == null) throw throwable;
                    plugin_proxy.setOK(ok);
                    this.force_proxy = null;
                    throw throwable;
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde;
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
                throw rde;
            }
            Debug.out(e);
            rde = new ResourceDownloaderException(this, "Unexpected error", e);
            throw rde;
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(parent, this.original_url, this.post_data, this.auth_supplied, this.user_name, this.password);
        c.setSize(this.size);
        c.setProperties(this);
        c.setForceNoProxy(this.force_no_proxy);
        if (this.force_proxy != null) {
            c.setForceProxy(this.force_proxy);
        }
        if (this.auto_plugin_proxy) {
            c.setAutoPluginProxy();
        }
        return c;
    }

    public void asyncDownload() {
        final Object parent_tls = TorrentUtils.getTLS();
        AEThread2 t = new AEThread2("ResourceDownloader:asyncDownload - " + this.trimForDisplay(this.original_url), true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                Object child_tls = TorrentUtils.getTLS();
                TorrentUtils.setTLS(parent_tls);
                try {
                    try {
                        ResourceDownloaderURLImpl.this.download();
                    }
                    catch (ResourceDownloaderException resourceDownloaderException) {
                        Object var4_3 = null;
                        TorrentUtils.setTLS(child_tls);
                        return;
                    }
                    Object var4_2 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    TorrentUtils.setTLS(child_tls);
                    throw throwable;
                }
                TorrentUtils.setTLS(child_tls);
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream download() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, this.getLogIndent() + "Downloading: " + this.trimForDisplay(this.original_url));
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException(this, "Download already initiated");
                }
                this.download_initiated = true;
                var2_1 = null;
                this.this_mon.exit();
            }
            catch (Throwable var1_4) {
                var2_2 = null;
                this.this_mon.exit();
                throw var1_4;
            }
            try {
                outer_url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                protocol = outer_url.getProtocol().toLowerCase();
                if (protocol.equals("vuze")) {
                    outer_url = this.original_url;
                } else {
                    if (protocol.equals("file")) {
                        file = new File(this.original_url.toURI());
                        fis = new FileInputStream(file);
                        this.informAmountComplete(file.length());
                        this.informPercentDone(100);
                        this.informComplete(fis);
                        return fis;
                    }
                    if (outer_url.getPort() == -1 && (protocol.equals("http") || protocol.equals("https"))) {
                        target_port = protocol.equals("http") != false ? 80 : 443;
                        try {
                            str = this.original_url.toString().replaceAll(" ", "%20");
                            pos = str.indexOf("://");
                            pos = str.indexOf("/", pos + 4);
                            outer_url = pos == -1 ? new URL(str + ":" + target_port + "/") : new URL(str.substring(0, pos) + ":" + target_port + str.substring(pos));
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                outer_url = AddressUtils.adjustURL(outer_url);
                try {
                    if (this.force_no_proxy) {
                        AEProxySelectorFactory.getSelector().startNoProxy();
                    }
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(outer_url, this);
                    }
                    use_compression = true;
                    follow_redirect = true;
                    redirect_urls = new HashSet<String>();
                    current_url = outer_url;
                    current_proxy = this.force_proxy;
                    initial_url = current_url;
                    while (follow_redirect != false) {
                        block115: {
                            block112: {
                                follow_redirect = false;
                                ok = false;
                                if (this.auto_plugin_proxy) {
                                    plugin_proxy = AEProxyFactory.getPluginProxy("downloading resource", current_url);
                                    if (plugin_proxy == null) {
                                        throw new ResourceDownloaderException(this, "No plugin proxy available");
                                    }
                                    current_url = plugin_proxy.getURL();
                                    current_proxy = plugin_proxy.getProxy();
                                } else {
                                    plugin_proxy = null;
                                }
                                connect_loop = 0;
lbl66:
                                // 2 sources

                                while (connect_loop < 2) {
                                    block113: {
                                        block111: {
                                            temp_file = null;
                                            try {
                                                v0 = current_plugin_proxy = plugin_proxy == null ? AEProxyFactory.getPluginProxy(this.force_proxy) : plugin_proxy;
                                                if (current_url.getProtocol().equalsIgnoreCase("https")) {
                                                    ssl_con = (HttpsURLConnection)this.openConnection(current_proxy, current_url);
                                                    ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                                        public boolean verify(String host, SSLSession session) {
                                                            return true;
                                                        }
                                                    });
                                                    if (current_plugin_proxy != null) {
                                                        tmf = SESecurityManager.getTrustManagerFactory();
                                                        default_tms = new ArrayList<X509TrustManager>();
                                                        if (tmf != null) {
                                                            for (TrustManager tm : tmf.getTrustManagers()) {
                                                                if (!(tm instanceof X509TrustManager)) continue;
                                                                default_tms.add((X509TrustManager)tm);
                                                            }
                                                        }
                                                        tms_delegate = new TrustManager[]{new X509TrustManager(){

                                                            public X509Certificate[] getAcceptedIssuers() {
                                                                ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
                                                                for (X509TrustManager tm : default_tms) {
                                                                    result.addAll(Arrays.asList(tm.getAcceptedIssuers()));
                                                                }
                                                                return result.toArray(new X509Certificate[result.size()]);
                                                            }

                                                            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                                                for (X509TrustManager tm : default_tms) {
                                                                    tm.checkClientTrusted(chain, authType);
                                                                }
                                                            }

                                                            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                                                                for (X509TrustManager tm : default_tms) {
                                                                    tm.checkServerTrusted(chain, authType);
                                                                }
                                                            }
                                                        }};
                                                        sc = SSLContext.getInstance("SSL");
                                                        sc.init(null, tms_delegate, RandomUtils.SECURE_RANDOM);
                                                        factory = sc.getSocketFactory();
                                                        ssl_con.setSSLSocketFactory(factory);
                                                    }
                                                    con = ssl_con;
                                                } else {
                                                    con = this.openConnection(current_proxy, current_url);
                                                }
                                                if (con instanceof HttpURLConnection) {
                                                    if (current_plugin_proxy != null) {
                                                        ((HttpURLConnection)con).setInstanceFollowRedirects(false);
                                                    } else {
                                                        ((HttpURLConnection)con).setInstanceFollowRedirects(true);
                                                    }
                                                }
                                                if (current_plugin_proxy != null) {
                                                    con.setRequestProperty("HOST", current_plugin_proxy.getURLHostRewrite() + (initial_url.getPort() == -1 ? "" : ":" + initial_url.getPort()));
                                                }
                                                con.setRequestProperty("User-Agent", "Azureus 5.5.0.1_B13");
                                                connection = this.getStringProperty("URL_Connection");
                                                if (connection != null && connection.equalsIgnoreCase("Keep-Alive")) {
                                                    con.setRequestProperty("Connection", "Keep-Alive");
                                                } else if (connection == null || !connection.equals("skip")) {
                                                    con.setRequestProperty("Connection", "close");
                                                }
                                                if (use_compression) {
                                                    con.addRequestProperty("Accept-Encoding", "gzip");
                                                }
                                                this.setRequestProperties(con, use_compression);
                                                if (this.post_data != null && con instanceof HttpURLConnection) {
                                                    con.setDoOutput(true);
                                                    verb = this.getStringProperty("URL_HTTP_VERB");
                                                    if (verb == null) {
                                                        verb = "POST";
                                                    }
                                                    ((HttpURLConnection)con).setRequestMethod(verb);
                                                    if (this.post_data.length > 0) {
                                                        os = con.getOutputStream();
                                                        os.write(this.post_data);
                                                        os.flush();
                                                    }
                                                }
                                                if ((connect_timeout = this.getLongProperty("URL_Connect_Timeout")) >= 0L) {
                                                    con.setConnectTimeout((int)connect_timeout);
                                                }
                                                if ((read_timeout = this.getLongProperty("URL_Read_Timeout")) >= 0L) {
                                                    con.setReadTimeout((int)read_timeout);
                                                }
                                                trust_content_length = this.getBooleanProperty("URL_Trust_Content_Length");
                                                try {
                                                    con.connect();
                                                }
                                                catch (AEProxyFactory.UnknownHostException e) {
                                                    throw new UnknownHostException(e.getMessage());
                                                }
                                                response = con instanceof HttpURLConnection != false ? ((HttpURLConnection)con).getResponseCode() : 200;
                                                ok = true;
                                                if (response != 302 && response != 301 || (move_to = con.getHeaderField("location")) == null) break block111;
                                                if (redirect_urls.contains(move_to) != false) throw new ResourceDownloaderException(this, "redirect loop");
                                                if (redirect_urls.size() > 32) {
                                                    throw new ResourceDownloaderException(this, "redirect loop");
                                                }
                                                redirect_urls.add(move_to);
                                                try {
                                                    move_to_url = new URL(move_to);
                                                    follow = false;
                                                    if (current_plugin_proxy != null && (child = current_plugin_proxy.getChildProxy("redirect", move_to_url)) != null) {
                                                        initial_url = move_to_url;
                                                        this.setProperty("URL_HOST", initial_url.getHost() + (initial_url.getPort() == -1 ? "" : ":" + initial_url.getPort()));
                                                        current_proxy = child.getProxy();
                                                        move_to_url = child.getURL();
                                                        follow = true;
                                                    }
                                                    original_protocol = current_url.getProtocol().toLowerCase();
                                                    new_protocol = move_to_url.getProtocol().toLowerCase();
                                                    if (!follow && original_protocol.equals(new_protocol)) break block111;
                                                    current_url = move_to_url;
                                                    try {
                                                        cookies_list = con.getHeaderFields().get("Set-cookie");
                                                        cookies_set = new ArrayList<String>();
                                                        if (cookies_list != null) {
                                                            for (i = 0; i < cookies_list.size(); ++i) {
                                                                cookie_bits = cookies_list.get(i).split(";");
                                                                if (cookie_bits.length <= 0) continue;
                                                                cookies_set.add(cookie_bits[0]);
                                                            }
                                                        }
                                                        if (cookies_set.size() > 0) {
                                                            new_cookies = "";
                                                            properties = this.getLCKeyProperties();
                                                            obj = properties.get("url_cookie");
                                                            if (obj instanceof String) {
                                                                new_cookies = (String)obj;
                                                            }
                                                            for (String s : cookies_set) {
                                                                new_cookies = new_cookies + (new_cookies.length() == 0 ? "" : "; ") + s;
                                                            }
                                                            this.setProperty("URL_Cookie", new_cookies);
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        Debug.out(e);
                                                    }
                                                    follow_redirect = true;
                                                }
                                                catch (Throwable e) {
                                                    // empty catch block
                                                    break block111;
                                                }
                                                var42_69 = null;
                                                if (temp_file != null) {
                                                    temp_file.delete();
                                                }
                                                ** GOTO lbl348
                                            }
                                            catch (SSLException e) {
                                                if (connect_loop != 0) throw e;
                                                if (SESecurityManager.installServerCertificates(current_url) == null) throw e;
                                                var42_69 = null;
                                                if (temp_file != null) {
                                                    temp_file.delete();
                                                }
                                                break block112;
                                            }
                                            catch (ZipException e) {
                                                if (connect_loop == 0) {
                                                    use_compression = false;
                                                    var42_69 = null;
                                                    if (temp_file != null) {
                                                        temp_file.delete();
                                                    }
                                                    break block112;
                                                }
                                                var42_69 = null;
                                                if (temp_file != null) {
                                                    temp_file.delete();
                                                }
                                                break block112;
                                            }
                                            catch (IOException e) {
                                                if (connect_loop != 0) throw e;
                                                msg = e.getMessage();
                                                if (msg != null && (msg = msg.toLowerCase(MessageText.LOCALE_ENGLISH)).indexOf("gzip") != -1) {
                                                    use_compression = false;
                                                    var42_69 = null;
                                                    if (temp_file != null) {
                                                        temp_file.delete();
                                                    }
                                                    break block112;
                                                }
                                                retry_url = UrlUtils.getIPV4Fallback(current_url);
                                                if (retry_url == null) throw e;
                                                current_url = retry_url;
                                                var42_69 = null;
                                                if (temp_file != null) {
                                                    temp_file.delete();
                                                }
                                                break block112;
                                            }
                                            catch (Throwable var41_79) {
                                                var42_69 = null;
                                                if (temp_file == null) throw var41_79;
                                                temp_file.delete();
                                                throw var41_79;
                                            }
                                        }
                                        this.setProperty("URL_HTTP_Response", new Long(response));
                                        if (response != 201 && response != 202 && response != 204 && response != 200) {
                                            http_con = (HttpURLConnection)con;
                                            error_stream = http_con.getErrorStream();
                                            error_str = null;
                                            if (error_stream != null) {
                                                encoding = con.getHeaderField("content-encoding");
                                                if (encoding != null) {
                                                    if (encoding.equalsIgnoreCase("gzip")) {
                                                        error_stream = new GZIPInputStream(error_stream);
                                                    } else if (encoding.equalsIgnoreCase("deflate")) {
                                                        error_stream = new InflaterInputStream(error_stream);
                                                    }
                                                }
                                                error_str = FileUtil.readInputStreamAsString(error_stream, 512);
                                            }
                                            this.getRequestProperties(con);
                                            v1 = new StringBuilder().append("Error on connect for '").append(this.trimForDisplay(current_url)).append("': ").append(Integer.toString(response)).append(" ").append(http_con.getResponseMessage());
                                            if (error_str == null) {
                                                v2 = "";
                                                throw new ResourceDownloaderException(this, v1.append(v2).toString());
                                            }
                                            v2 = ": error=" + error_str;
                                            throw new ResourceDownloaderException(this, v1.append(v2).toString());
                                        }
                                        this.getRequestProperties(con);
                                        compressed = false;
                                        try {
                                            this.this_mon.enter();
                                            this.input_stream = con.getInputStream();
                                            encoding = con.getHeaderField("content-encoding");
                                            if (encoding != null) {
                                                if (encoding.equalsIgnoreCase("gzip")) {
                                                    compressed = true;
                                                    this.input_stream = new GZIPInputStream(this.input_stream);
                                                } else if (encoding.equalsIgnoreCase("deflate")) {
                                                    compressed = true;
                                                    this.input_stream = new InflaterInputStream(this.input_stream);
                                                }
                                            }
                                            var35_66 = null;
                                            this.this_mon.exit();
                                        }
                                        catch (Throwable var34_71) {
                                            var35_66 = null;
                                            this.this_mon.exit();
                                            throw var34_71;
                                        }
                                        if (con instanceof MagnetConnection2 && (errors = ((MagnetConnection2)con).getResponseMessages(true)).size() > 0) {
                                            throw new ResourceDownloaderException(this, errors.get(0));
                                        }
                                        baos = null;
                                        fos = null;
                                        try {
                                            buf = new byte[32768];
                                            total_read = 0L;
                                            v3 = size = compressed != false ? -1L : UrlUtils.getContentLength(con);
                                            v4 = size > 0L ? new ByteArrayOutputStream(size > 262144L ? 262144 : (int)size) : (baos = new ByteArrayOutputStream());
                                            while (!(this.cancel_download || size >= 0L && total_read >= size && trust_content_length || (read = this.input_stream.read(buf)) <= 0)) {
                                                if (total_read > 262144L) {
                                                    if (fos == null) {
                                                        temp_file = AETemporaryFileHandler.createTempFile();
                                                        fos = new FileOutputStream(temp_file);
                                                        fos.write(baos.toByteArray());
                                                        baos = null;
                                                    }
                                                    fos.write(buf, 0, read);
                                                } else {
                                                    baos.write(buf, 0, read);
                                                }
                                                this.informAmountComplete(total_read += (long)read);
                                                if (size <= 0L) continue;
                                                this.informPercentDone((int)(100L * total_read / size));
                                            }
                                            if (size > 0L && total_read != size) {
                                                if (total_read <= size) throw new IOException("Premature end of stream");
                                                Debug.outNoStack("Inconsistent stream length for '" + this.trimForDisplay(this.original_url) + "': expected = " + size + ", actual = " + total_read);
                                            }
                                            var37_67 = null;
                                            if (fos == null) break block113;
                                        }
                                        catch (Throwable var36_72) {
                                            var37_67 = null;
                                            if (fos != null) {
                                                try {
                                                    fos.close();
                                                }
                                                catch (Throwable e) {
                                                    // empty catch block
                                                }
                                            }
                                            this.input_stream.close();
                                            throw var36_72;
                                        }
                                        ** try [egrp 13[TRYBLOCK] [10 : 2326->2334)] { 
lbl317:
                                        // 1 sources

                                        fos.close();
                                        break block113;
lbl319:
                                        // 1 sources

                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                    }
                                    this.input_stream.close();
                                    if (temp_file != null) {
                                        res = new DeleteFileOnCloseInputStream(temp_file);
                                        temp_file = null;
                                    } else {
                                        res = new ByteArrayInputStream(baos.toByteArray());
                                    }
                                    handed_over = false;
                                    if (!this.informComplete(res)) ** GOTO lbl-1000
                                    handed_over = true;
                                    var27_55 = res;
                                    ** GOTO lbl352
                                    {
                                        catch (Throwable var39_78) {
                                            var40_75 = null;
                                            if (handed_over != false) throw var39_78;
                                            res.close();
                                            throw var39_78;
                                        }
                                    }
                                }
                                break block115;
                                {
                                    catch (Throwable var43_80) {
                                        var44_70 = null;
                                        if (plugin_proxy == null) throw var43_80;
                                        plugin_proxy.setOK(ok);
                                        throw var43_80;
                                    }
lbl348:
                                    // 1 sources

                                    var44_70 = null;
                                    if (plugin_proxy == null) continue;
                                    plugin_proxy.setOK(ok);
                                    continue;
lbl352:
                                    // 1 sources

                                    var40_73 = null;
                                    if (!handed_over) {
                                        res.close();
                                    }
                                    var42_69 = null;
                                    if (temp_file != null) {
                                        temp_file.delete();
                                    }
                                    var44_70 = null;
                                    if (plugin_proxy != null) {
                                        plugin_proxy.setOK(ok);
                                    }
                                    var46_76 = null;
                                    if (this.auth_supplied) {
                                        SESecurityManager.setPasswordHandler(outer_url, null);
                                    }
                                    if (this.force_no_proxy == false) return var27_55;
                                    AEProxySelectorFactory.getSelector().endNoProxy();
                                    return var27_55;
lbl-1000:
                                    // 1 sources

                                    {
                                        var40_74 = null;
                                        if (handed_over != false) throw new ResourceDownloaderException(this, "Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                                        res.close();
                                        throw new ResourceDownloaderException(this, "Contents downloaded but rejected: '" + this.trimForDisplay(this.original_url) + "'");
                                    }
                                }
                            }
                            ++connect_loop;
                            ** GOTO lbl66
                        }
                        var44_70 = null;
                        if (plugin_proxy == null) continue;
                        plugin_proxy.setOK(ok);
                    }
                    throw new ResourceDownloaderException(this, "Should never get here");
                }
                catch (Throwable var45_81) {
                    var46_77 = null;
                    if (this.auth_supplied) {
                        SESecurityManager.setPasswordHandler(outer_url, null);
                    }
                    if (this.force_no_proxy == false) throw var45_81;
                    AEProxySelectorFactory.getSelector().endNoProxy();
                    throw var45_81;
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException(this, "Exception while parsing URL '" + this.trimForDisplay(this.original_url) + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException(this, "Exception while initializing download of '" + this.trimForDisplay(this.original_url) + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException(this, "I/O Exception while downloading '" + this.trimForDisplay(this.original_url) + "'", e);
            }
        }
        catch (Throwable e) {
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
            } else {
                Debug.out(e);
                rde = new ResourceDownloaderException(this, "Unexpected error", e);
            }
            this.informFailed(rde);
            throw rde;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {
                }
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.informFailed(new ResourceDownloaderCancelledException(this));
    }

    protected void setRequestProperties(URLConnection con, boolean use_compression) {
        Map properties = this.getLCKeyProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (!key.startsWith("url_") || !(value instanceof String) || value.equals("skip") || key.equalsIgnoreCase("URL_HTTP_VERB") || (key = key.substring(4)).equals("accept-encoding") && !use_compression) continue;
            con.setRequestProperty(key, (String)value);
        }
    }

    protected void getRequestProperties(URLConnection con) {
        try {
            this.setProperty("ContentType", con.getContentType());
            this.setProperty("URL_URL", con.getURL());
            Map<String, List<String>> headers = con.getHeaderFields();
            for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
                String key = entry.getKey();
                List<String> val = entry.getValue();
                if (key == null) continue;
                this.setProperty("URL_" + key, val);
            }
            this.setPropertiesSet();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        if (this.user_name == null || this.password == null) {
            String user_info = tracker.getUserInfo();
            if (user_info == null) {
                return null;
            }
            String user_bit = user_info;
            String pw_bit = "";
            int pos = user_info.indexOf(58);
            if (pos != -1) {
                user_bit = user_info.substring(0, pos);
                pw_bit = user_info.substring(pos + 1);
            }
            return new PasswordAuthentication(user_bit, pw_bit.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    public void clearPasswords() {
    }

    private URLConnection openConnection(Proxy proxy, URL url) throws IOException {
        if (this.force_no_proxy) {
            return url.openConnection(Proxy.NO_PROXY);
        }
        if (proxy != null) {
            return url.openConnection(proxy);
        }
        return url.openConnection();
    }

    protected String trimForDisplay(URL url) {
        String str = url.toString();
        int pos = str.indexOf(63);
        if (pos != -1) {
            str = str.substring(0, pos);
        }
        return str;
    }
}

