/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote.tracker;

import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.tracker.TrackerException;
import org.gudy.azureus2.plugins.tracker.TrackerPeer;
import org.gudy.azureus2.plugins.tracker.TrackerTorrent;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentListener;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentRemovalVetoException;
import org.gudy.azureus2.plugins.tracker.TrackerTorrentWillBeRemovedListener;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;
import org.gudy.azureus2.pluginsimpl.remote.torrent.RPTorrent;

public class RPTrackerTorrent
extends RPObject
implements TrackerTorrent {
    protected transient TrackerTorrent delegate;
    public RPTorrent torrent;
    public int status;
    public long total_uploaded;
    public long total_downloaded;
    public long average_uploaded;
    public long average_downloaded;
    public long total_left;
    public long completed_count;
    public long total_bytes_in;
    public long average_bytes_in;
    public long total_bytes_out;
    public long average_bytes_out;
    public long scrape_count;
    public long average_scrape_count;
    public long announce_count;
    public long average_announce_count;
    public int seed_count;
    public int leecher_count;
    public int bad_NAT_count;

    public static RPTrackerTorrent create(TrackerTorrent _delegate) {
        RPTrackerTorrent res = (RPTrackerTorrent)RPTrackerTorrent._lookupLocal(_delegate);
        if (res == null) {
            res = new RPTrackerTorrent(_delegate);
        }
        return res;
    }

    protected RPTrackerTorrent(TrackerTorrent _delegate) {
        super(_delegate);
        if (this.delegate.getTorrent() != null) {
            this.torrent = (RPTorrent)RPTrackerTorrent._lookupLocal(this.delegate.getTorrent());
            if (this.torrent == null) {
                this.torrent = RPTorrent.create(this.delegate.getTorrent());
            }
        }
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (TrackerTorrent)_delegate;
        this.status = this.delegate.getStatus();
        this.total_uploaded = this.delegate.getTotalUploaded();
        this.total_downloaded = this.delegate.getTotalDownloaded();
        this.average_uploaded = this.delegate.getAverageUploaded();
        this.average_downloaded = this.delegate.getAverageDownloaded();
        this.total_left = this.delegate.getTotalLeft();
        this.completed_count = this.delegate.getCompletedCount();
        this.total_bytes_in = this.delegate.getTotalBytesIn();
        this.average_bytes_in = this.delegate.getAverageBytesIn();
        this.total_bytes_out = this.delegate.getTotalBytesOut();
        this.average_bytes_out = this.delegate.getAverageBytesOut();
        this.scrape_count = this.delegate.getScrapeCount();
        this.average_scrape_count = this.delegate.getAverageScrapeCount();
        this.announce_count = this.delegate.getAnnounceCount();
        this.average_announce_count = this.delegate.getAverageAnnounceCount();
        this.seed_count = this.delegate.getSeedCount();
        this.leecher_count = this.delegate.getLeecherCount();
        this.bad_NAT_count = this.delegate.getBadNATCount();
    }

    public Object _setLocal() throws RPException {
        Object res = this._fixupLocal();
        if (this.torrent != null) {
            this.torrent._setLocal();
        }
        return res;
    }

    public void _setRemote(RPRequestDispatcher dispatcher) {
        super._setRemote(dispatcher);
        if (this.torrent != null) {
            this.torrent._setRemote(dispatcher);
        }
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        throw new RPException("Unknown method: " + method);
    }

    public void start() throws TrackerException {
        this.notSupported();
    }

    public void stop() throws TrackerException {
        this.notSupported();
    }

    public void remove() throws TrackerTorrentRemovalVetoException {
        this.notSupported();
    }

    public boolean canBeRemoved() throws TrackerTorrentRemovalVetoException {
        this.notSupported();
        return false;
    }

    public Torrent getTorrent() {
        return this.torrent;
    }

    public TrackerPeer[] getPeers() {
        this.notSupported();
        return null;
    }

    public int getStatus() {
        return this.status;
    }

    public long getTotalUploaded() {
        return this.total_uploaded;
    }

    public long getTotalDownloaded() {
        return this.total_downloaded;
    }

    public long getAverageUploaded() {
        return this.average_uploaded;
    }

    public long getAverageDownloaded() {
        return this.average_downloaded;
    }

    public long getTotalLeft() {
        return this.total_left;
    }

    public long getCompletedCount() {
        return this.completed_count;
    }

    public long getTotalBytesIn() {
        return this.total_bytes_in;
    }

    public long getAverageBytesIn() {
        return this.average_bytes_in;
    }

    public long getTotalBytesOut() {
        return this.total_bytes_out;
    }

    public long getAverageBytesOut() {
        return this.average_bytes_out;
    }

    public long getScrapeCount() {
        return this.scrape_count;
    }

    public long getAverageScrapeCount() {
        return this.average_scrape_count;
    }

    public long getAnnounceCount() {
        return this.announce_count;
    }

    public long getAverageAnnounceCount() {
        return this.average_announce_count;
    }

    public int getSeedCount() {
        return this.seed_count;
    }

    public int getLeecherCount() {
        return this.leecher_count;
    }

    public int getBadNATCount() {
        return this.bad_NAT_count;
    }

    public void disableReplyCaching() {
        this.notSupported();
    }

    public boolean isPassive() {
        this.notSupported();
        return false;
    }

    public long getDateAdded() {
        this.notSupported();
        return 0L;
    }

    public void addListener(TrackerTorrentListener listener) {
        this.notSupported();
    }

    public void removeListener(TrackerTorrentListener listener) {
        this.notSupported();
    }

    public void addRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
        this.notSupported();
    }

    public void removeRemovalListener(TrackerTorrentWillBeRemovedListener listener) {
        this.notSupported();
    }
}

