/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import java.util.Comparator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem1;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableItemImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.components.InPaintInfo;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableItemOrTreeItem;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellSWTBase;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWTImpl;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_EraseItem;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewSWT_PaintItem;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnSWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableCellImpl
extends TableCellSWTBase {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final boolean canUseQuickDraw = Constants.isWindows;
    private BufferedTableItem bufferedTableItem;
    private static final boolean QUICK_WIDTH = true;
    public static final Comparator TEXT_COMPARATOR = new TextComparator();

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn, int position, BufferedTableItem item) {
        super(_tableRow, _tableColumn);
        if (item != null) {
            this.bufferedTableItem = item;
        } else {
            this.createBufferedTableItem(position);
        }
        this.constructionCompleter();
    }

    @Override
    protected void constructionCompleter() {
        this.constructionComplete();
        this.tableColumn.invokeCellAddedListeners(this);
    }

    public TableCellImpl(TableRowSWT _tableRow, TableColumnCore _tableColumn, int position) {
        this(_tableRow, _tableColumn, position, null);
    }

    private void createBufferedTableItem(int position) {
        BufferedTableRow bufRow = (BufferedTableRow)((Object)this.tableRow);
        if (this.tableColumn.getType() == 2) {
            this.bufferedTableItem = new BufferedGraphicTableItem1(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.clearFlag(1);
                    this.redraw();
                }

                protected void quickRedrawCell(TableOrTreeSWT table, Rectangle dirty, Rectangle cellBounds) {
                    boolean ourQuickRedraw;
                    TableItemOrTreeItem item = this.row.getItem();
                    boolean bl = ourQuickRedraw = canUseQuickDraw && TableCellImpl.this.tableRow != null && !TableCellImpl.this.tableRow.isMouseOver() && !TableCellImpl.this.tableRow.isSelected();
                    if (ourQuickRedraw) {
                        TableCellImpl.this.quickRedrawCell2(table, item, dirty, cellBounds);
                    } else {
                        super.quickRedrawCell(table, dirty, cellBounds);
                    }
                }
            };
            this.setOrientationViaColumn();
        } else {
            this.bufferedTableItem = new BufferedTableItemImpl(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.clearFlag(1);
                }

                protected void quickRedrawCell(TableOrTreeSWT table, Rectangle dirty, Rectangle cellBounds) {
                    boolean ourQuickRedraw;
                    TableItemOrTreeItem item = this.row.getItem();
                    boolean bl = ourQuickRedraw = canUseQuickDraw && TableCellImpl.this.tableRow != null && !TableCellImpl.this.tableRow.isMouseOver() && !TableCellImpl.this.tableRow.isSelected();
                    if (ourQuickRedraw) {
                        TableCellImpl.this.quickRedrawCell2(table, item, dirty, cellBounds);
                    } else {
                        super.quickRedrawCell(table, dirty, cellBounds);
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quickRedrawCell2(TableOrTreeSWT table, TableItemOrTreeItem tableItemOrTreeItem, Rectangle dirty, Rectangle cellBounds) {
        if (this.bufferedTableItem.isInPaintItem()) {
            return;
        }
        Rectangle bounds = new Rectangle(0, 0, cellBounds.width, cellBounds.height);
        Point pt = new Point(cellBounds.x, cellBounds.y);
        Image img = new Image((Device)table.getDisplay(), bounds);
        int colPos = this.bufferedTableItem.getPosition();
        Item item = tableItemOrTreeItem.getItem();
        table.setData("inPaintInfo", new InPaintInfo(item, colPos, bounds));
        table.setData("fullPaint", Boolean.TRUE);
        GC gc = new GC((Drawable)img);
        try {
            TableViewSWTImpl tv = (TableViewSWTImpl)this.tableRow.getView();
            TableViewSWT_EraseItem.eraseItem(null, gc, tableItemOrTreeItem, colPos, false, bounds, tv, true);
            Color fg = this.getForegroundSWT();
            if (fg != null) {
                gc.setForeground(fg);
            }
            gc.setBackground(this.getBackgroundSWT());
            TableViewSWT_PaintItem.paintItem(gc, (TableRowSWT)this.tableRow, colPos, this.tableRow.getIndex(), bounds, tv, true);
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        gc = new GC((Drawable)table.getComposite());
        try {
            gc.drawImage(img, pt.x, pt.y);
            Object var16_16 = null;
        }
        catch (Throwable throwable) {
            Object var16_17 = null;
            img.dispose();
            gc.dispose();
            throw throwable;
        }
        img.dispose();
        gc.dispose();
        table.setData("inPaintInfo", null);
        table.setData("fullPaint", Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void quickRedrawCell(TableOrTreeSWT table, TableItemOrTreeItem tableItemOrTreeItem, Rectangle dirty, Rectangle cellBounds) {
        if (this.bufferedTableItem.isInPaintItem()) {
            return;
        }
        int colPos = this.bufferedTableItem.getPosition();
        Item item = tableItemOrTreeItem.getItem();
        table.setData("inPaintInfo", new InPaintInfo(item, colPos, cellBounds));
        table.setData("fullPaint", Boolean.TRUE);
        GC gc = new GC((Drawable)table.getComposite());
        try {
            TableViewSWTImpl tv = (TableViewSWTImpl)this.tableRow.getView();
            TableViewSWT_EraseItem.eraseItem(null, gc, tableItemOrTreeItem, this.bufferedTableItem.getPosition(), true, cellBounds, tv, true);
            Color fg = this.getForegroundSWT();
            if (fg != null) {
                gc.setForeground(fg);
            }
            gc.setBackground(this.getBackgroundSWT());
            TableViewSWT_PaintItem.paintItem(gc, (TableRowSWT)this.tableRow, this.bufferedTableItem.getPosition(), this.tableRow.getIndex(), cellBounds, tv, true);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        table.setData("inPaintInfo", null);
        table.setData("fullPaint", Boolean.FALSE);
    }

    @Override
    protected void pluginError(Throwable e) {
        String sTitleLanguageKey = this.tableColumn == null ? "?" : this.tableColumn.getTitleLanguageKey();
        String sPosition = this.bufferedTableItem == null ? "null" : "" + this.bufferedTableItem.getPosition() + " (" + MessageText.getString(sTitleLanguageKey) + ")";
        Logger.log(new LogEvent(LOGID, "Table Cell Plugin for Column #" + sPosition + " generated an exception ", e));
    }

    @Override
    protected void pluginError(String s) {
        String sTitleLanguageKey = this.tableColumn == null ? "?" : this.tableColumn.getTitleLanguageKey();
        String sPosition = "r" + this.tableRow.getIndex() + (this.bufferedTableItem == null ? "null" : "c" + this.bufferedTableItem.getPosition() + " (" + MessageText.getString(sTitleLanguageKey) + ")");
        Logger.log(new LogEvent(LOGID, 3, "Table Cell Plugin for Column #" + sPosition + ":" + s + "\n  " + Debug.getStackTrace(true, true)));
    }

    @Override
    public Object getDataSource() {
        TableRowCore row = this.tableRow;
        TableColumnCore col = this.tableColumn;
        if (row == null || col == null) {
            return null;
        }
        return row.getDataSource(col.getUseCoreDataSource());
    }

    @Override
    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    @Override
    public TableRow getTableRow() {
        return this.tableRow;
    }

    @Override
    public String getTableID() {
        return this.tableRow.getTableID();
    }

    @Override
    public Color getForegroundSWT() {
        if (this.isDisposed()) {
            return null;
        }
        return this.bufferedTableItem.getForeground();
    }

    @Override
    public Color getBackgroundSWT() {
        if (this.isDisposed()) {
            return null;
        }
        return this.bufferedTableItem.getBackground();
    }

    @Override
    public boolean setForeground(Color color) {
        if (this.isDisposed()) {
            return false;
        }
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        boolean set = this.bufferedTableItem.setForeground(color);
        if (set) {
            this.setFlag(64);
        }
        return set;
    }

    @Override
    public boolean uiSetText(String text) {
        return this.bufferedTableItem.setText(text);
    }

    @Override
    public boolean setGraphic(Graphic img) {
        boolean changed = super.setGraphic(img);
        if (changed && img != null) {
            Image imgSWT = ((UISWTGraphic)img).getImage();
            ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(imgSWT);
        }
        return changed;
    }

    @Override
    public String getText() {
        if (this.hasFlag(2) && this.sortValue instanceof String) {
            return (String)((Object)this.sortValue);
        }
        if (this.bufferedTableItem == null) {
            return null;
        }
        return this.bufferedTableItem.getText();
    }

    @Override
    public boolean isShown() {
        if (this.bufferedTableItem == null || this.tableRow == null) {
            return false;
        }
        return this.bufferedTableItem.isShown() && this.tableRow.getView().isColumnVisible(this.tableColumn);
    }

    @Override
    public Comparable<?> getSortValue() {
        Comparable v = super.getSortValue();
        if (v == null) {
            if (this.bufferedTableItem != null) {
                return this.bufferedTableItem.getText();
            }
            return "";
        }
        return v;
    }

    @Override
    public int getMaxLines() {
        if (this.bufferedTableItem == null) {
            return 1;
        }
        return this.bufferedTableItem.getMaxLines();
    }

    @Override
    public Point getSize() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
    }

    @Override
    public int getWidthRaw() {
        return this.tableColumn.getWidth() - 2;
    }

    @Override
    public int getWidth() {
        if (this.isDisposed()) {
            return -1;
        }
        return this.tableColumn.getWidth() - 2 - this.getMarginWidth() * 2;
    }

    @Override
    public int getHeight() {
        return this.bufferedTableItem.getHeight();
    }

    @Override
    public void setFillCell(boolean bFillCell) {
        super.setFillCell(bFillCell);
        if (this.isDisposed()) {
            return;
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        if (bFillCell) {
            ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setOrientation(4);
        } else {
            this.setOrientationViaColumn();
        }
        this.setFlag(64);
    }

    @Override
    public void setMarginHeight(int height) {
        if (this.isDisposed()) {
            return;
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setMargin(-1, height);
        this.setFlag(64);
    }

    @Override
    public void setMarginWidth(int width) {
        if (this.isDisposed()) {
            return;
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setMargin(width, -1);
        this.setFlag(64);
    }

    @Override
    public int getMarginHeight() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return 0;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getMarginHeight();
    }

    @Override
    public int getMarginWidth() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return 0;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getMarginWidth();
    }

    @Override
    public void redraw() {
        if (!this.tableRow.isVisible()) {
            return;
        }
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.redraw();
        }
    }

    @Override
    public void invalidate(boolean bMustRefresh) {
        super.invalidate(bMustRefresh);
        if (bMustRefresh && this.bufferedTableItem != null) {
            this.bufferedTableItem.invalidate();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.dispose();
        }
        this.bufferedTableItem = null;
    }

    @Override
    public boolean needsPainting() {
        if (this.isDisposed()) {
            return false;
        }
        if (this.cellSWTPaintListeners != null || this.tableColumn.hasCellOtherListeners("SWTPaint")) {
            return true;
        }
        if (this.bufferedTableItem == null) {
            return false;
        }
        return this.bufferedTableItem.needsPainting();
    }

    @Override
    public void locationChanged() {
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.locationChanged();
        }
    }

    public String toString() {
        return "TableCell {" + (this.tableColumn == null ? "disposed" : this.tableColumn.getName()) + "," + (this.tableRow == null ? "" : "r" + this.tableRow.getIndex()) + (this.bufferedTableItem == null ? "c?" : "c" + this.bufferedTableItem.getPosition()) + "," + this.getText() + "," + this.getSortValue() + "}";
    }

    @Override
    public Rectangle getBounds() {
        if (this.isDisposed()) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle bounds = this.bufferedTableItem.getBounds();
        if (bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return bounds;
    }

    private void setOrientationViaColumn() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        int align = this.tableColumn.getAlignment();
        BufferedGraphicTableItem ti = (BufferedGraphicTableItem)((Object)this.bufferedTableItem);
        ti.setOrientation(TableColumnSWTUtils.convertColumnAlignmentToSWT(align));
    }

    @Override
    public Graphic getBackgroundGraphic() {
        if (this.bufferedTableItem == null) {
            return null;
        }
        return new UISWTGraphicImpl(this.bufferedTableItem.getBackgroundImage());
    }

    @Override
    public Image getBackgroundImage() {
        if (this.bufferedTableItem == null) {
            return null;
        }
        return this.bufferedTableItem.getBackgroundImage();
    }

    public BufferedTableItem getBufferedTableItem() {
        return this.bufferedTableItem;
    }

    @Override
    public boolean setCursorID(int cursorID) {
        if (!super.setCursorID(cursorID)) {
            return false;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TableCellImpl.this.isMouseOver()) {
                    TableCellImpl.this.bufferedTableItem.setCursor(TableCellImpl.this.getCursorID());
                }
            }
        });
        return true;
    }

    @Override
    public boolean isMouseOver() {
        if (this.bufferedTableItem == null) {
            return false;
        }
        if (!this.tableRow.isVisible()) {
            return false;
        }
        return this.bufferedTableItem.isMouseOver();
    }

    @Override
    public Rectangle getBoundsOnDisplay() {
        Rectangle bounds = this.getBounds();
        Point pt = ((TableViewSWT)this.tableRow.getView()).getTableOrTreeSWT().toDisplay(bounds.x, bounds.y);
        bounds.x = pt.x;
        bounds.y = pt.y;
        return bounds;
    }

    @Override
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible, boolean bCellVisible) {
        return super.refresh(bDoGraphics, bRowVisible, bCellVisible);
    }

    private static class TextComparator
    implements Comparator {
        private TextComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    }
}

