/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.magnet.MagnetPluginListener;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerException;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.sharing.ShareException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.IntParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagnetPlugin
implements Plugin {
    public static final int FL_NONE = 0;
    public static final int FL_DISABLE_MD_LOOKUP = 1;
    private static final String SECONDARY_LOOKUP = "http://magnet.vuze.com/";
    private static final int SECONDARY_LOOKUP_DELAY = 20000;
    private static final int SECONDARY_LOOKUP_MAX_TIME = 120000;
    private static final int MD_LOOKUP_DELAY_SECS_DEFAULT = 20;
    private static final String PLUGIN_NAME = "Magnet URI Handler";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.magnetplugin";
    private PluginInterface plugin_interface;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean first_download = true;
    private BooleanParameter secondary_lookup;
    private BooleanParameter md_lookup;
    private IntParameter md_lookup_delay;
    private static ByteArrayHashMap<DownloadActivity> download_activities = new ByteArrayHashMap();

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        Download[] downloads;
        this.plugin_interface = _plugin_interface;
        MagnetURIHandler uri_handler = MagnetURIHandler.getSingleton();
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addInfoParameter2("MagnetPlugin.current.port", String.valueOf(uri_handler.getPort()));
        this.secondary_lookup = config.addBooleanParameter2("MagnetPlugin.use.lookup.service", "MagnetPlugin.use.lookup.service", true);
        this.md_lookup = config.addBooleanParameter2("MagnetPlugin.use.md.download", "MagnetPlugin.use.md.download", true);
        this.md_lookup_delay = config.addIntParameter2("MagnetPlugin.use.md.download.delay", "MagnetPlugin.use.md.download.delay", 20);
        this.md_lookup.addEnabledOnSelection(this.md_lookup_delay);
        MenuItemListener listener = new MenuItemListener(){

            public void selected(MenuItem _menu, Object _target) {
                String name;
                Torrent torrent;
                Object ds = ((TableRow)_target).getDataSource();
                Download download = null;
                if (ds instanceof ShareResourceFile) {
                    try {
                        torrent = ((ShareResourceFile)ds).getItem().getTorrent();
                    }
                    catch (ShareException e) {
                        return;
                    }
                    name = ((ShareResourceFile)ds).getName();
                } else if (ds instanceof ShareResourceDir) {
                    try {
                        torrent = ((ShareResourceDir)ds).getItem().getTorrent();
                    }
                    catch (ShareException e) {
                        return;
                    }
                    name = ((ShareResourceDir)ds).getName();
                } else if (ds instanceof Download) {
                    download = (Download)((TableRow)_target).getDataSource();
                    torrent = download.getTorrent();
                    name = download.getName();
                } else {
                    return;
                }
                String cb_data = download == null ? UrlUtils.getMagnetURI(name, torrent) : UrlUtils.getMagnetURI(download);
                try {
                    MagnetPlugin.this.plugin_interface.getUIManager().copyToClipBoard(cb_data);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        final TableContextMenuItem menu1 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu2 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu3 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyShares", "MagnetPlugin.contextmenu.exporturi");
        menu1.addListener(listener);
        menu2.addListener(listener);
        menu3.addListener(listener);
        uri_handler.addListener(new MagnetURIHandlerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] badge() {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/magnet/Magnet.gif");
                if (is == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    return baos.toByteArray();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            public byte[] download(final MagnetURIHandlerProgressListener muh_listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
                try {
                    Torrent torrent;
                    Download dl = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(hash);
                    if (dl != null && (torrent = dl.getTorrent()) != null) {
                        byte[] torrent_data = torrent.writeToBEncodedData();
                        torrent_data = MagnetPlugin.this.addTrackersAndWebSeedsEtc(torrent_data, args, new HashSet());
                        return torrent_data;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                return MagnetPlugin.this.download(new MagnetPluginProgressListener(){

                    public void reportSize(long size) {
                        muh_listener.reportSize(size);
                    }

                    public void reportActivity(String str) {
                        muh_listener.reportActivity(str);
                    }

                    public void reportCompleteness(int percent) {
                        muh_listener.reportCompleteness(percent);
                    }

                    public void reportContributor(InetSocketAddress address) {
                    }

                    public boolean cancelled() {
                        return muh_listener.cancelled();
                    }

                    public boolean verbose() {
                        return muh_listener.verbose();
                    }
                }, hash, args, sources, timeout, 0);
            }

            public boolean download(URL url) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(url, false);
                    return true;
                }
                catch (DownloadException e) {
                    throw new MagnetURIHandlerException("Operation failed", e);
                }
            }

            public boolean set(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                for (int i = 0; i < l.size(); ++i) {
                    if (!((MagnetPluginListener)l.get(i)).set(name, values)) continue;
                    return true;
                }
                return false;
            }

            public int get(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                for (int i = 0; i < l.size(); ++i) {
                    int res = ((MagnetPluginListener)l.get(i)).get(name, values);
                    if (res == Integer.MIN_VALUE) continue;
                    return res;
                }
                return Integer.MIN_VALUE;
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread2 t = new AEThread2("MagnetPlugin:init", true){

                    public void run() {
                        MagnetPlugin.this.plugin_interface.getDistributedDatabase();
                    }
                };
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance.getUIType() == 1) {
                    try {
                        Class.forName("com.aelitis.azureus.plugins.magnet.swt.MagnetPluginUISWT").getConstructor(UIInstance.class, TableContextMenuItem[].class).newInstance(instance, new TableContextMenuItem[]{menu1, menu2, menu3});
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
        final ArrayList<Download> to_delete = new ArrayList<Download>();
        for (Download download : downloads = this.plugin_interface.getDownloadManager().getDownloads()) {
            if (!download.getFlag(512L)) continue;
            to_delete.add(download);
        }
        if (to_delete.size() > 0) {
            AEThread2 t = new AEThread2("MagnetPlugin:delmds", true){

                public void run() {
                    for (Download download : to_delete) {
                        try {
                            download.stop();
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                        try {
                            download.remove(true, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
            };
            t.start();
        }
    }

    public URL getMagnetURL(Download d) {
        Torrent torrent = d.getTorrent();
        if (torrent == null) {
            return null;
        }
        return this.getMagnetURL(torrent.getHash());
    }

    public URL getMagnetURL(byte[] hash) {
        try {
            return new URL("magnet:?xt=urn:btih:" + Base32.encode(hash));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public byte[] badge() {
        return null;
    }

    public byte[] download(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout, int flags) throws MagnetURIHandlerException {
        DownloadResult result = this.downloadSupport(listener, hash, args, sources, timeout, flags);
        if (result == null) {
            return null;
        }
        return this.addTrackersAndWebSeedsEtc(result, args);
    }

    private byte[] addTrackersAndWebSeedsEtc(DownloadResult result, String args) {
        byte[] torrent_data = result.getTorrentData();
        Set networks = result.getNetworks();
        return this.addTrackersAndWebSeedsEtc(torrent_data, args, networks);
    }

    private byte[] addTrackersAndWebSeedsEtc(byte[] torrent_data, String args, Set<String> networks) {
        ArrayList<String> new_web_seeds = new ArrayList<String>();
        ArrayList<String> new_trackers = new ArrayList<String>();
        if (args != null) {
            String[] bits;
            for (String bit : bits = args.split("&")) {
                String[] x = bit.split("=");
                if (x.length != 2) continue;
                String lhs = x[0].toLowerCase();
                if (lhs.equals("ws")) {
                    try {
                        new_web_seeds.add(new URL(UrlUtils.decode(x[1])).toExternalForm());
                    }
                    catch (Throwable e) {}
                    continue;
                }
                if (!lhs.equals("tr")) continue;
                try {
                    new_trackers.add(new URL(UrlUtils.decode(x[1])).toExternalForm());
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        if (new_web_seeds.size() > 0 || new_trackers.size() > 0 || networks.size() > 0) {
            try {
                TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrent_data);
                boolean update_torrent = false;
                if (new_web_seeds.size() > 0) {
                    Object obj = torrent.getAdditionalProperty("url-list");
                    ArrayList<String> existing = new ArrayList<String>();
                    if (obj instanceof byte[]) {
                        try {
                            new_web_seeds.remove(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
                        }
                        catch (Throwable e) {}
                    } else if (obj instanceof List) {
                        List l = (List)obj;
                        for (byte[] b : l) {
                            try {
                                existing.add(new URL(new String(b, "UTF-8")).toExternalForm());
                            }
                            catch (Throwable e) {}
                        }
                    }
                    boolean update_ws = false;
                    for (String e : new_web_seeds) {
                        if (existing.contains(e)) continue;
                        existing.add(e);
                        update_ws = true;
                    }
                    if (update_ws) {
                        ArrayList<byte[]> l = new ArrayList<byte[]>();
                        for (String s : existing) {
                            l.add(s.getBytes("UTF-8"));
                        }
                        torrent.setAdditionalProperty("url-list", l);
                        update_torrent = true;
                    }
                }
                if (new_trackers.size() > 0) {
                    TOTorrentAnnounceURLSet[] sets;
                    URL announce_url = torrent.getAnnounceURL();
                    new_trackers.remove(announce_url.toExternalForm());
                    TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                    for (TOTorrentAnnounceURLSet set : sets = group.getAnnounceURLSets()) {
                        URL[] set_urls;
                        for (URL set_url : set_urls = set.getAnnounceURLs()) {
                            new_trackers.remove(set_url.toExternalForm());
                        }
                    }
                    if (new_trackers.size() > 0) {
                        int i;
                        TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + new_trackers.size()];
                        for (i = 0; i < sets.length; ++i) {
                            new_sets[i] = sets[i];
                        }
                        for (i = 0; i < new_trackers.size(); ++i) {
                            TOTorrentAnnounceURLSet new_set;
                            new_sets[i + sets.length] = new_set = group.createAnnounceURLSet(new URL[]{new URL((String)new_trackers.get(i))});
                        }
                        group.setAnnounceURLSets(new_sets);
                        update_torrent = true;
                    }
                }
                if (networks.size() > 0) {
                    TorrentUtils.setNetworkCache(torrent, new ArrayList<String>(networks));
                    update_torrent = true;
                }
                if (update_torrent) {
                    torrent_data = BEncoder.encode(torrent.serialiseToMap());
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return torrent_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadResult downloadSupport(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout, int flags) throws MagnetURIHandlerException {
        ByteArrayHashMap<DownloadActivity> byteArrayHashMap;
        DownloadActivity activity;
        boolean new_activity = false;
        ByteArrayHashMap<DownloadActivity> byteArrayHashMap2 = download_activities;
        synchronized (byteArrayHashMap2) {
            activity = download_activities.get(hash);
            if (activity == null) {
                activity = new DownloadActivity();
                download_activities.put(hash, activity);
                new_activity = true;
            }
        }
        if (!new_activity) return activity.getResult();
        try {
            try {
                activity.setResult(this._downloadSupport(listener, hash, args, sources, timeout, flags));
            }
            catch (Throwable e) {
                activity.setResult(e);
                Object var13_12 = null;
                ByteArrayHashMap<DownloadActivity> byteArrayHashMap22 = download_activities;
                synchronized (byteArrayHashMap22) {
                    download_activities.remove(hash);
                    return activity.getResult();
                }
            }
            Object var13_11 = null;
            byteArrayHashMap = download_activities;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            ByteArrayHashMap<DownloadActivity> byteArrayHashMap4 = download_activities;
            synchronized (byteArrayHashMap4) {
                download_activities.remove(hash);
                throw throwable;
            }
        }
        synchronized (byteArrayHashMap) {
            download_activities.remove(hash);
            return activity.getResult();
        }
    }

    /*
     * Exception decompiling
     */
    private DownloadResult _downloadSupport(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout, int flags) throws MagnetURIHandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [50[MONITOR]], but top level block is 133[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void doSecondaryLookup(final MagnetPluginProgressListener listener, final Object[] result, byte[] hash, Set<String> networks_enabled, String args) {
        listener.reportActivity(this.getMessageText("report.secondarylookup", null));
        AEProxyFactory.PluginProxy plugin_proxy = null;
        try {
            ResourceDownloader rd;
            URL original_sl_url;
            URL sl_url = original_sl_url = new URL("http://magnet.vuze.com/magnetLookup?hash=" + Base32.encode(hash) + (args.length() == 0 ? "" : "&args=" + UrlUtils.encode(args)));
            Proxy proxy = null;
            if (!networks_enabled.contains("Public")) {
                plugin_proxy = AEProxyFactory.getPluginProxy("secondary magnet lookup", sl_url);
                if (plugin_proxy == null) {
                    throw new NoRouteToHostException("plugin proxy unavailable");
                }
                proxy = plugin_proxy.getProxy();
                sl_url = plugin_proxy.getURL();
            }
            ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            if (proxy == null) {
                rd = rdf.create(sl_url);
            } else {
                rd = rdf.create(sl_url, proxy);
                rd.setProperty("URL_HOST", original_sl_url.getHost());
            }
            final AEProxyFactory.PluginProxy f_pp = plugin_proxy;
            rd.addListener(new ResourceDownloaderAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean completed(ResourceDownloader downloader, InputStream data) {
                    try {
                        listener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.ok", null));
                        Object[] objectArray = result;
                        synchronized (result) {
                            result[0] = data;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            boolean bl = true;
                            Object var6_6 = null;
                            this.complete();
                            return bl;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        this.complete();
                        throw throwable;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                    try {
                        Object[] objectArray = result;
                        synchronized (result) {
                            result[0] = e;
                            // ** MonitorExit[var3_3] (shouldn't be in output)
                            listener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.fail"));
                            Object var6_5 = null;
                            this.complete();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        this.complete();
                        throw throwable;
                    }
                }

                private void complete() {
                    if (f_pp != null) {
                        f_pp.setOK(true);
                    }
                }
            });
            rd.asyncDownload();
        }
        catch (Throwable e) {
            if (plugin_proxy != null) {
                plugin_proxy.setOK(true);
            }
            listener.reportActivity(this.getMessageText("report.secondarylookup.fail", Debug.getNestedExceptionMessage(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSecondaryLookupResult(Object[] result) throws ResourceDownloaderException {
        if (result == null) {
            return null;
        }
        Object[] objectArray = result;
        synchronized (result) {
            Object x = result[0];
            result[0] = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (x instanceof InputStream) {
                InputStream is = (InputStream)x;
                try {
                    TOTorrent t = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
                    TorrentUtils.setPeerCacheValid(t);
                    return BEncoder.encode(t.serialiseToMap());
                }
                catch (Throwable e) {}
            } else if (x instanceof ResourceDownloaderException) {
                throw (ResourceDownloaderException)x;
            }
            return null;
        }
    }

    protected String getMessageText(String resource) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource, new String[]{param});
    }

    public void addListener(MagnetPluginListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MagnetPluginListener listener) {
        this.listeners.remove(listener);
    }

    private static class DownloadActivity {
        private volatile DownloadResult result;
        private volatile MagnetURIHandlerException error;
        private AESemaphore sem = new AESemaphore("MP:DA");

        private DownloadActivity() {
        }

        public void setResult(DownloadResult _result) {
            this.result = _result;
            this.sem.releaseForever();
        }

        public void setResult(Throwable _error) {
            this.error = _error instanceof MagnetURIHandlerException ? (MagnetURIHandlerException)_error : new MagnetURIHandlerException("Download failed", _error);
            this.sem.releaseForever();
        }

        public DownloadResult getResult() throws MagnetURIHandlerException {
            this.sem.reserve();
            if (this.error != null) {
                throw this.error;
            }
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DownloadResult {
        private byte[] data;
        private Set<String> networks;

        private DownloadResult(byte[] torrent_data, Set<String> networks_enabled, Set<String> additional_networks) {
            this.data = torrent_data;
            this.networks = new HashSet<String>();
            this.networks.addAll(networks_enabled);
            this.networks.addAll(additional_networks);
        }

        private byte[] getTorrentData() {
            return this.data;
        }

        private Set<String> getNetworks() {
            return this.networks;
        }
    }
}

