/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreComponent;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.AzureusCoreListener;
import com.aelitis.azureus.core.AzureusCoreOperation;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import com.aelitis.azureus.core.versioncheck.VersionCheckClientListener;
import com.aelitis.azureus.ui.IUIIntializer;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIConfigDefaultsSWTv3;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.browser.listener.ConfigListener;
import com.aelitis.azureus.ui.swt.browser.listener.DisplayListener;
import com.aelitis.azureus.ui.swt.browser.listener.TorrentListener;
import com.aelitis.azureus.ui.swt.browser.listener.VuzeListener;
import com.aelitis.azureus.ui.swt.browser.msg.MessageDispatcherSWT;
import com.aelitis.azureus.ui.swt.devices.DeviceManagerUI;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUI;
import com.aelitis.azureus.ui.swt.shells.main.MainWindowFactory;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.utils.UIMagnetHandler;
import com.aelitis.azureus.util.InitialisationFunctions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.PluginEvent;
import org.gudy.azureus2.plugins.PluginEventListener;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.UtilitiesImpl;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.LocaleUtilSWT;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.UIConfigDefaultsSWT;
import org.gudy.azureus2.ui.swt.UISwitcherUtil;
import org.gudy.azureus2.ui.swt.UserAlerts;
import org.gudy.azureus2.ui.swt.auth.AuthenticatorWindow;
import org.gudy.azureus2.ui.swt.auth.CertificateTrustWindow;
import org.gudy.azureus2.ui.swt.auth.CryptoWindow;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;
import org.gudy.azureus2.ui.swt.mainwindow.SplashWindow;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.networks.SWTNetworkSelection;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.updater2.PreUpdateChecker;
import org.gudy.azureus2.ui.swt.updater2.SWTUpdateChecker;

public class Initializer
implements IUIIntializer {
    private static boolean STARTUP_UIFIRST = System.getProperty("ui.startfirst", "1").equals("1");
    public static final long startTime = System.currentTimeMillis();
    private StartServer startServer;
    private final AzureusCore core;
    private final String[] args;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private AEMonitor listeners_mon = new AEMonitor("Initializer:l");
    private int curPercent = 0;
    private AESemaphore semFilterLoader = new AESemaphore("filter loader");
    private AESemaphore init_task = new AESemaphore("delayed init");
    private MainWindowFactory.MainWindowInitStub windowInitStub;
    private static Initializer lastInitializer;

    public Initializer(final AzureusCore core, StartServer startServer, String[] args) {
        this.core = core;
        this.args = args;
        this.startServer = startServer;
        lastInitializer = this;
        AEThread filterLoaderThread = new AEThread("filter loader", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    core.getIpFilterManager().getIPFilter();
                    Object var2_1 = null;
                    Initializer.this.semFilterLoader.releaseForever();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    Initializer.this.semFilterLoader.releaseForever();
                    throw throwable;
                }
            }
        };
        filterLoaderThread.setPriority(1);
        filterLoaderThread.start();
        try {
            SWTThread.createInstance(this);
        }
        catch (SWTThreadAlreadyInstanciatedException e) {
            Debug.printStackTrace(e);
        }
    }

    private void cleanupOldStuff() {
        File dirMedia;
        File dirFriends;
        File v3Shares = new File(SystemProperties.getUserPath(), "v3shares");
        if (v3Shares.isDirectory()) {
            FileUtil.recursiveDeleteNoCheck(v3Shares);
        }
        if ((dirFriends = new File(SystemProperties.getUserPath(), "friends")).isDirectory()) {
            FileUtil.recursiveDeleteNoCheck(dirFriends);
        }
        if ((dirMedia = new File(SystemProperties.getUserPath(), "media")).isDirectory()) {
            FileUtil.recursiveDeleteNoCheck(dirMedia);
        }
        this.deleteConfig("v3.Friends.dat");
        this.deleteConfig("unsentdata.config");
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                new AEThread2("cleanupOldStuff", true){

                    public void run() {
                        GlobalManager gm = core.getGlobalManager();
                        List<DownloadManager> dms = gm.getDownloadManagers();
                        for (DownloadManager o : dms) {
                            String val;
                            DownloadManager dm = o;
                            if (dm == null || (val = PlatformTorrentUtils.getContentMapString(dm.getTorrent(), "Ad ID")) == null) continue;
                            try {
                                gm.removeDownloadManager(dm, true, true);
                            }
                            catch (Exception e) {}
                        }
                    }
                }.start();
            }
        });
    }

    private void deleteConfig(String name) {
        File file;
        try {
            file = new File(SystemProperties.getUserPath(), name);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            file = new File(SystemProperties.getUserPath(), name + ".bak");
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void runInSWTThread() {
        UISwitcherUtil.calcUIMode();
        try {
            this.initializePlatformClientMessageContext();
        }
        catch (Exception e) {
            Debug.out(e);
        }
        new AEThread2("cleanupOldStuff", true){

            public void run() {
                Initializer.this.cleanupOldStuff();
            }
        }.start();
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (!uiClassic) {
            PlatformConfigMessenger.login(0L);
        }
        VersionCheckClient.getSingleton().addVersionCheckClientListener(true, new VersionCheckClientListener(){

            public void versionCheckStarted(String reason) {
                if ("us".equals(reason) || "up".equals(reason)) {
                    PlatformConfigMessenger.sendVersionServerMap(VersionCheckClient.constructVersionCheckMessage(reason));
                }
            }
        });
        FeatureManagerUI.registerWithFeatureManager();
        COConfigurationManager.setBooleanDefault("ui.startfirst", true);
        boolean bl = STARTUP_UIFIRST = STARTUP_UIFIRST && COConfigurationManager.getBooleanParameter("ui.startfirst", true);
        if (!STARTUP_UIFIRST) {
            return;
        }
        Colors.getInstance();
        UIConfigDefaultsSWT.initialize();
        UIConfigDefaultsSWTv3.initialize(this.core);
        this.checkInstallID();
        this.windowInitStub = MainWindowFactory.createAsync(Display.getDefault(), this);
    }

    private void checkInstallID() {
        String storedInstallID = COConfigurationManager.getStringParameter("install.id", null);
        String installID = "";
        File file = FileUtil.getApplicationFile("installer.log");
        if (file != null) {
            try {
                String s = FileUtil.readFileAsString(file, 1024);
                String[] split = s.split("[\r\n]");
                for (int i = 0; i < split.length; ++i) {
                    int posEquals = split[i].indexOf(61);
                    if (posEquals <= 0 || split[i].length() <= posEquals + 1) continue;
                    installID = split[i].substring(posEquals + 1);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (storedInstallID == null || !storedInstallID.equals(installID)) {
            COConfigurationManager.setParameter("install.id", installID);
        }
    }

    public void run() {
        DelayedTask delayed_task = UtilitiesImpl.addDelayedTask("SWT Initialisation", new Runnable(){

            public void run() {
                Initializer.this.init_task.reserve();
            }
        });
        delayed_task.queueFirst();
        long startTime = SystemTime.getCurrentTime();
        new LocaleUtilSWT(this.core);
        final Display display = SWTThread.getInstance().getDisplay();
        new UIMagnetHandler(this.core);
        if (!STARTUP_UIFIRST) {
            Colors.getInstance();
            UIConfigDefaultsSWT.initialize();
            UIConfigDefaultsSWTv3.initialize(this.core);
        } else {
            COConfigurationManager.setBooleanDefault("Show Splash", false);
        }
        if (COConfigurationManager.getBooleanParameter("Show Splash")) {
            display.asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    new SplashWindow(display, Initializer.this);
                }
            });
        }
        System.out.println("Locale Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.core.addListener(new AzureusCoreListener(){
            int fakePercent;
            long startTime;
            long lastTaskTimeSecs;
            String sLastTask;
            {
                this.fakePercent = Math.min(70, 100 - Initializer.this.curPercent);
                this.startTime = SystemTime.getCurrentTime();
                this.lastTaskTimeSecs = this.startTime / 500L;
            }

            public void reportCurrentTask(AzureusCoreOperation op, String currentTask) {
                if (op.getOperationType() != 1) {
                    return;
                }
                Initializer.this.reportCurrentTask(currentTask);
                long now = SystemTime.getCurrentTime();
                if (this.fakePercent > 0 && this.lastTaskTimeSecs != now / 200L) {
                    this.lastTaskTimeSecs = SystemTime.getCurrentTime() / 200L;
                    --this.fakePercent;
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                }
                if (Constants.IS_CVS_VERSION && this.sLastTask != null && !this.sLastTask.startsWith("Loading Torrent")) {
                    long diff = now - this.startTime;
                    if (diff > 10L && diff < 300000L) {
                        System.out.println(TimeFormatter.milliStamp() + "   Core: " + diff + "ms for activity between '" + this.sLastTask + "' and '" + currentTask + "'");
                    }
                    this.startTime = SystemTime.getCurrentTime();
                }
                this.sLastTask = currentTask;
            }

            public void reportPercent(AzureusCoreOperation op, int percent) {
            }
        });
        this.core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){
            private GlobalManager gm;

            public void componentCreated(AzureusCore core, AzureusCoreComponent component) {
                Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                if (component instanceof GlobalManager) {
                    Initializer.this.reportCurrentTaskByKey("splash.initializePlugins");
                    this.gm = (GlobalManager)component;
                    InitialisationFunctions.earlyInitialisation(core);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void started(AzureusCore core) {
                boolean main_window_will_report_complete = false;
                try {
                    InitialisationFunctions.lateInitialisation(core);
                    if (this.gm == null) {
                        Object var7_3 = null;
                        if (!main_window_will_report_complete) {
                            Initializer.this.init_task.release();
                        }
                        return;
                    }
                    Colors.getInstance();
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                    new UserAlerts(this.gm);
                    Initializer.this.reportCurrentTaskByKey("splash.initializeGui");
                    Initializer.this.reportPercent(Initializer.this.curPercent + 1);
                    main_window_will_report_complete = true;
                    if (STARTUP_UIFIRST) {
                        Initializer.this.windowInitStub.init(core);
                    } else {
                        MainWindowFactory.create(core, Display.getDefault(), Initializer.this);
                    }
                    Initializer.this.reportCurrentTaskByKey("splash.openViews");
                    SWTUpdateChecker.initialize();
                    PreUpdateChecker.initialize(core, COConfigurationManager.getStringParameter("ui"));
                    UpdateMonitor.getSingleton(core);
                    Alerts.initComplete();
                    for (int i = 0; i < Initializer.this.args.length; ++i) {
                        String arg = Initializer.this.args[i];
                        if (arg.equalsIgnoreCase("--open")) continue;
                        try {
                            TorrentOpener.openTorrent(arg);
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var7_5 = null;
                    if (!main_window_will_report_complete) {
                        Initializer.this.init_task.release();
                    }
                    throw throwable;
                }
                Object var7_4 = null;
                if (!main_window_will_report_complete) {
                    Initializer.this.init_task.release();
                }
            }

            public void stopping(AzureusCore core) {
                Alerts.stopInitiated();
            }

            public void stopped(AzureusCore core) {
            }

            public boolean syncInvokeRequired() {
                return true;
            }

            public boolean requiresPluginInitCompleteBeforeStartedEvent() {
                return false;
            }

            public boolean stopRequested(AzureusCore _core) throws AzureusCoreException {
                return Initializer.handleStopRestart(false);
            }

            public boolean restartRequested(AzureusCore core) {
                return Initializer.handleStopRestart(true);
            }
        });
        this.reportCurrentTaskByKey("splash.initializeCore");
        boolean uiClassic = COConfigurationManager.getStringParameter("ui").equals("az2");
        if (!uiClassic) {
            try {
                new SubscriptionManagerUI();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
            try {
                new DeviceManagerUI(this.core);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.core.start();
        this.reportPercent(50);
        System.out.println("Core Initializing took " + (SystemTime.getCurrentTime() - startTime) + "ms");
        startTime = SystemTime.getCurrentTime();
        this.reportCurrentTaskByKey("splash.initializeUIElements");
        Colors.getInstance();
        this.reportPercent(this.curPercent + 1);
        Alerts.init();
        this.reportPercent(this.curPercent + 1);
        ProgressWindow.register(this.core);
        this.reportPercent(this.curPercent + 1);
        new SWTNetworkSelection();
        this.reportPercent(this.curPercent + 1);
        new AuthenticatorWindow();
        new CryptoWindow();
        this.reportPercent(this.curPercent + 1);
        new CertificateTrustWindow();
        InstallPluginWizard.register(this.core, display);
        for (int i = 0; i < this.args.length; ++i) {
            String arg = this.args[i];
            if (!arg.equalsIgnoreCase("--open")) continue;
            UIFunctions uif = UIFunctionsManager.getUIFunctions();
            if (uif == null) break;
            uif.bringToFront();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopIt(boolean isForRestart, boolean isCloseAreadyInProgress) throws AzureusCoreException {
        Object v1;
        if (this.core != null && !isCloseAreadyInProgress && isForRestart) {
            this.core.checkRestartSupported();
        }
        try {
            try {
                UIFunctionsManager.getUIFunctions().getUIUpdater().stopIt();
            }
            catch (Exception e) {
                Debug.out(e);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object v0;
            Object var5_5 = null;
            try {
                if (this.core != null && !isCloseAreadyInProgress) {
                    try {
                        if (isForRestart) {
                            this.core.restart();
                        } else {
                            long lStopStarted = System.currentTimeMillis();
                            System.out.println("core.stop");
                            this.core.stop();
                            System.out.println("core.stop done in " + (System.currentTimeMillis() - lStopStarted));
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
                v0 = null;
            }
            catch (Throwable throwable2) {
                Object var9_13;
                v0 = var9_13 = null;
            }
            if (this.startServer != null) {
                this.startServer.stopIt();
            }
            throw throwable;
        }
        try {
            if (this.core != null && !isCloseAreadyInProgress) {
                try {
                    if (isForRestart) {
                        this.core.restart();
                    } else {
                        long lStopStarted = System.currentTimeMillis();
                        System.out.println("core.stop");
                        this.core.stop();
                        System.out.println("core.stop done in " + (System.currentTimeMillis() - lStopStarted));
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
            v1 = null;
        }
        catch (Throwable throwable) {
            Object var9_12;
            v1 = var9_12 = null;
        }
        if (this.startServer != null) {
            this.startServer.stopIt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.add(listener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(InitializerListener listener) {
        try {
            this.listeners_mon.enter();
            this.listeners.remove(listener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportCurrentTask(String currentTaskString) {
        try {
            this.listeners_mon.enter();
            for (InitializerListener listener : this.listeners) {
                try {
                    listener.reportCurrentTask(currentTaskString);
                }
                catch (Exception e) {}
            }
            Object var6_5 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    private void reportCurrentTaskByKey(String key) {
        this.reportCurrentTask(MessageText.getString(key));
    }

    public void increaseProgress() {
        if (this.curPercent < 100) {
            this.reportPercent(this.curPercent + 1);
        }
    }

    public void abortProgress() {
        this.reportPercent(101);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportPercent(int percent) {
        if (this.curPercent > percent) {
            return;
        }
        this.curPercent = percent;
        try {
            this.listeners_mon.enter();
            for (InitializerListener listener : this.listeners) {
                try {
                    listener.reportPercent(percent);
                }
                catch (Exception e) {}
            }
            if (percent > 100) {
                this.listeners.clear();
            }
            Object var6_5 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public void initializationComplete() {
        this.core.getPluginManager().firePluginEvent(6);
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                new DelayedEvent("SWTInitComplete:delay", 500L, new AERunnable(){

                    public void runSupport() {
                        Initializer.this.init_task.release();
                    }
                });
            }
        });
    }

    private void initializePlatformClientMessageContext() {
        ClientMessageContext clientMsgContext = PlatformMessenger.getClientMessageContext();
        if (clientMsgContext != null) {
            clientMsgContext.setMessageDispatcher(new MessageDispatcherSWT(clientMsgContext));
            clientMsgContext.addMessageListener(new TorrentListener());
            clientMsgContext.addMessageListener(new VuzeListener());
            clientMsgContext.addMessageListener(new DisplayListener(null));
            clientMsgContext.addMessageListener(new ConfigListener(null));
        }
        PluginInitializer.getDefaultInterface().addEventListener(new PluginEventListener(){

            public void handleEvent(PluginEvent ev) {
                try {
                    int type = ev.getType();
                    String event2 = null;
                    if (type == 10) {
                        event2 = "installed";
                    } else if (type == 12) {
                        event2 = "uninstalled";
                    }
                    if (event2 != null && ev.getValue() instanceof String) {
                        PlatformConfigMessenger.logPlugin(event2, (String)ev.getValue());
                    }
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        });
    }

    public static boolean handleStopRestart(boolean restart) {
        UIFunctionsSWT functionsSWT = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (functionsSWT != null) {
            return functionsSWT.dispose(restart, true);
        }
        return false;
    }

    public static Initializer getLastInitializer() {
        return lastInitializer;
    }
}

