/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.core.util.average.MovingImmediateAverage;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManagerAdapter;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.peer.impl.control.PEPeerControlImpl;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPeerManagerStatsImpl
implements PEPeerManagerStats {
    private PEPeerManagerAdapter adapter;
    private long total_data_bytes_received = 0L;
    private long total_protocol_bytes_received = 0L;
    private long total_data_bytes_sent = 0L;
    private long total_protocol_bytes_sent = 0L;
    private long total_data_bytes_received_lan = 0L;
    private long total_protocol_bytes_received_lan = 0L;
    private long total_data_bytes_sent_lan = 0L;
    private long total_protocol_bytes_sent_lan = 0L;
    private long totalDiscarded;
    private long hash_fail_bytes;
    private int last_data_received_seconds;
    private int last_data_sent_seconds;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private final Average data_send_speed = Average.getInstance(1000, 10);
    private final Average protocol_send_speed = Average.getInstance(1000, 10);
    private final Average overallSpeed = Average.getInstance(5000, 100);
    private long smooth_last_sent;
    private long smooth_last_received;
    private int current_smoothing_window = GeneralUtils.getSmoothUpdateWindow();
    private int current_smoothing_interval = GeneralUtils.getSmoothUpdateInterval();
    private MovingImmediateAverage smoothed_receive_rate = GeneralUtils.getSmoothAverage();
    private MovingImmediateAverage smoothed_send_rate = GeneralUtils.getSmoothAverage();
    private long peak_receive_rate;
    private long peak_send_rate;
    private int total_incoming;
    private int total_outgoing;

    public PEPeerManagerStatsImpl(PEPeerControlImpl _manager) {
        this.adapter = _manager.getAdapter();
    }

    public void discarded(PEPeer peer, int length) {
        this.totalDiscarded += (long)length;
        this.adapter.discarded(peer, length);
    }

    public void hashFailed(int length) {
        this.hash_fail_bytes += (long)length;
    }

    public long getTotalHashFailBytes() {
        return this.hash_fail_bytes;
    }

    public void dataBytesReceived(PEPeer peer, int length) {
        this.total_data_bytes_received += (long)length;
        if (peer.isLANLocal()) {
            this.total_data_bytes_received_lan += (long)length;
        }
        this.data_receive_speed.addValue(length);
        if (length > 0) {
            this.last_data_received_seconds = (int)(SystemTime.getCurrentTime() / 1000L);
        }
        this.adapter.dataBytesReceived(peer, length);
    }

    public void protocolBytesReceived(PEPeer peer, int length) {
        this.total_protocol_bytes_received += (long)length;
        if (peer.isLANLocal()) {
            this.total_protocol_bytes_received_lan += (long)length;
        }
        this.protocol_receive_speed.addValue(length);
        this.adapter.protocolBytesReceived(peer, length);
    }

    public void dataBytesSent(PEPeer peer, int length) {
        this.total_data_bytes_sent += (long)length;
        if (peer.isLANLocal()) {
            this.total_data_bytes_sent_lan += (long)length;
        }
        this.data_send_speed.addValue(length);
        if (length > 0) {
            this.last_data_sent_seconds = (int)(SystemTime.getCurrentTime() / 1000L);
        }
        this.adapter.dataBytesSent(peer, length);
    }

    public void protocolBytesSent(PEPeer peer, int length) {
        this.total_protocol_bytes_sent += (long)length;
        if (peer.isLANLocal()) {
            this.total_protocol_bytes_sent_lan += (long)length;
        }
        this.protocol_send_speed.addValue(length);
        this.adapter.protocolBytesSent(peer, length);
    }

    public void haveNewPiece(int pieceLength) {
        this.overallSpeed.addValue(pieceLength);
    }

    public long getDataReceiveRate() {
        return this.data_receive_speed.getAverage();
    }

    public long getProtocolReceiveRate() {
        return this.protocol_receive_speed.getAverage();
    }

    public long getDataSendRate() {
        return this.data_send_speed.getAverage();
    }

    public long getProtocolSendRate() {
        return this.protocol_send_speed.getAverage();
    }

    public long getTotalDiscarded() {
        return this.totalDiscarded;
    }

    public void setTotalDiscarded(long total) {
        this.totalDiscarded = total;
    }

    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDataBytesSentNoLan() {
        return Math.max(this.total_data_bytes_sent - this.total_data_bytes_sent_lan, 0L);
    }

    public long getTotalProtocolBytesSentNoLan() {
        return Math.max(this.total_protocol_bytes_sent - this.total_protocol_bytes_sent_lan, 0L);
    }

    public long getTotalDataBytesReceivedNoLan() {
        return Math.max(this.total_data_bytes_received - this.total_data_bytes_received_lan, 0L);
    }

    public long getTotalProtocolBytesReceivedNoLan() {
        return Math.max(this.total_protocol_bytes_received - this.total_protocol_bytes_received_lan, 0L);
    }

    public long getTotalAverage() {
        return this.overallSpeed.getAverage() + this.getDataReceiveRate();
    }

    public int getTimeSinceLastDataReceivedInSeconds() {
        if (this.last_data_received_seconds == 0) {
            return -1;
        }
        int now = (int)(SystemTime.getCurrentTime() / 1000L);
        if (now < this.last_data_received_seconds) {
            this.last_data_received_seconds = now;
        }
        return now - this.last_data_received_seconds;
    }

    public int getTimeSinceLastDataSentInSeconds() {
        if (this.last_data_sent_seconds == 0) {
            return -1;
        }
        int now = (int)(SystemTime.getCurrentTime() / 1000L);
        if (now < this.last_data_sent_seconds) {
            this.last_data_sent_seconds = now;
        }
        return now - this.last_data_sent_seconds;
    }

    public void haveNewConnection(boolean incoming) {
        if (incoming) {
            ++this.total_incoming;
        } else {
            ++this.total_outgoing;
        }
    }

    public int getTotalIncomingConnections() {
        return this.total_incoming;
    }

    public int getTotalOutgoingConnections() {
        return this.total_outgoing;
    }

    public int getPermittedBytesToReceive() {
        return this.adapter.getPermittedBytesToReceive();
    }

    public void permittedReceiveBytesUsed(int bytes) {
        this.adapter.permittedReceiveBytesUsed(bytes);
    }

    public int getPermittedBytesToSend() {
        return this.adapter.getPermittedBytesToSend();
    }

    public void permittedSendBytesUsed(int bytes) {
        this.adapter.permittedSendBytesUsed(bytes);
    }

    public long getSmoothedDataReceiveRate() {
        return (long)(this.smoothed_receive_rate.getAverage() / (double)this.current_smoothing_interval);
    }

    public long getSmoothedDataSendRate() {
        return (long)(this.smoothed_send_rate.getAverage() / (double)this.current_smoothing_interval);
    }

    public long getPeakDataReceiveRate() {
        return this.peak_receive_rate;
    }

    public long getPeakDataSendRate() {
        return this.peak_send_rate;
    }

    public void update(int tick_count) {
        this.peak_receive_rate = Math.max(this.peak_receive_rate, this.data_receive_speed.getAverage());
        this.peak_send_rate = Math.max(this.peak_send_rate, this.data_send_speed.getAverage());
        if (tick_count % this.current_smoothing_interval == 0) {
            int current_window = GeneralUtils.getSmoothUpdateWindow();
            if (this.current_smoothing_window != current_window) {
                this.current_smoothing_window = current_window;
                this.current_smoothing_interval = GeneralUtils.getSmoothUpdateInterval();
                this.smoothed_receive_rate = GeneralUtils.getSmoothAverage();
                this.smoothed_send_rate = GeneralUtils.getSmoothAverage();
            }
            long up = this.total_data_bytes_sent;
            long down = this.total_data_bytes_received;
            this.smoothed_send_rate.update(up - this.smooth_last_sent);
            this.smoothed_receive_rate.update(down - this.smooth_last_received);
            this.smooth_last_sent = up;
            this.smooth_last_received = down;
        }
    }
}

