/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.security.CryptoManagerKeyListener;
import com.aelitis.azureus.core.security.CryptoManagerPasswordException;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.auth.CertificateCreatorWindow;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class ConfigSectionSecurity
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "security";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(final Composite parent) {
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        ArrayList<Button> buttons = new ArrayList<Button>();
        Composite gSecurity = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        gSecurity.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        gSecurity.setLayout((Layout)layout);
        Label cert_label = new Label(gSecurity, 0);
        Messages.setLanguageText((Widget)cert_label, "ConfigView.section.tracker.createcert");
        Button cert_button = new Button(gSecurity, 8);
        buttons.add(cert_button);
        Messages.setLanguageText((Widget)cert_button, "ConfigView.section.tracker.createbutton");
        cert_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                new CertificateCreatorWindow();
            }
        });
        new Label(gSecurity, 0);
        Label reset_certs_label = new Label(gSecurity, 0);
        Messages.setLanguageText((Widget)reset_certs_label, "ConfigView.section.security.resetcerts");
        Button reset_certs_button = new Button(gSecurity, 8);
        buttons.add(reset_certs_button);
        Messages.setLanguageText((Widget)reset_certs_button, "Button.reset");
        reset_certs_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MessageBoxShell mb = new MessageBoxShell(296, MessageText.getString("ConfigView.section.security.resetcerts.warning.title"), MessageText.getString("ConfigView.section.security.resetcerts.warning.msg"));
                mb.setDefaultButtonUsingStyle(256);
                mb.setParent(parent.getShell());
                mb.open(new UserPrompterResultListener(){

                    public void prompterClosed(int returnVal) {
                        if (returnVal != 32) {
                            return;
                        }
                        if (SESecurityManager.resetTrustStore(false)) {
                            MessageBoxShell mb = new MessageBoxShell(34, MessageText.getString("ConfigView.section.security.restart.title"), MessageText.getString("ConfigView.section.security.restart.msg"));
                            mb.setParent(parent.getShell());
                            mb.open(null);
                            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                            if (uiFunctions != null) {
                                uiFunctions.dispose(true, false);
                            }
                        } else {
                            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.resetcerts.error.title"), MessageText.getString("ConfigView.section.security.resetcerts.error.msg"));
                            mb.setParent(parent.getShell());
                            mb.open(null);
                        }
                    }
                });
            }
        });
        reset_certs_button.setEnabled(SESecurityManager.resetTrustStore(true));
        new Label(gSecurity, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        new BooleanParameter(gSecurity, "security.cert.auto.install", "security.cert.auto.install").setLayoutData(gridData);
        Label info_label = new Label(gSecurity, 64);
        Messages.setLanguageText((Widget)info_label, "ConfigView.section.security.toolsinfo");
        info_label.setLayoutData((Object)Utils.getWrappableLabelGridData(3, 0));
        Label lStatsPath = new Label(gSecurity, 0);
        Messages.setLanguageText((Widget)lStatsPath, "ConfigView.section.security.toolsdir");
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        gridData = new GridData();
        gridData.widthHint = 150;
        final StringParameter pathParameter = new StringParameter(gSecurity, "Security.JAR.tools.dir", "");
        pathParameter.setLayoutData(gridData);
        Button browse = new Button(gSecurity, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.security.choosetoolssavedir"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        Label pw_label = new Label(gSecurity, 0);
        Messages.setLanguageText((Widget)pw_label, "ConfigView.section.security.clearpasswords");
        Button pw_button = new Button(gSecurity, 8);
        buttons.add(pw_button);
        Messages.setLanguageText((Widget)pw_button, "ConfigView.section.security.clearpasswords.button");
        pw_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                SESecurityManager.clearPasswords();
                CryptoManagerFactory.getSingleton().clearPasswords();
            }
        });
        new Label(gSecurity, 0);
        if (userMode >= 2) {
            final CryptoManager crypt_man = CryptoManagerFactory.getSingleton();
            final Group crypto_group = new Group(gSecurity, 0);
            gridData = new GridData(784);
            gridData.horizontalSpan = 3;
            crypto_group.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 3;
            crypto_group.setLayout((Layout)layout);
            Messages.setLanguageText((Widget)crypto_group, "ConfigView.section.security.group.crypto");
            Label linkLabel = new Label((Composite)crypto_group, 0);
            linkLabel.setText(MessageText.getString("ConfigView.label.please.visit.here"));
            linkLabel.setData((Object)"http://wiki.vuze.com/w/Public_Private_Keys");
            linkLabel.setCursor(linkLabel.getDisplay().getSystemCursor(21));
            linkLabel.setForeground(Colors.blue);
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            linkLabel.setLayoutData((Object)gridData);
            linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    Utils.launch((String)((Label)arg0.widget).getData());
                }

                public void mouseDown(MouseEvent arg0) {
                    Utils.launch((String)((Label)arg0.widget).getData());
                }
            });
            ClipboardCopy.addCopyToClipMenu((Control)linkLabel);
            byte[] public_key = crypt_man.getECCHandler().peekPublicKey();
            Label public_key_label = new Label((Composite)crypto_group, 0);
            Messages.setLanguageText((Widget)public_key_label, "ConfigView.section.security.publickey");
            final Label public_key_value = new Label((Composite)crypto_group, 0);
            if (public_key == null) {
                Messages.setLanguageText((Widget)public_key_value, "ConfigView.section.security.publickey.undef");
            } else {
                public_key_value.setText(Base32.encode(public_key));
            }
            Messages.setLanguageText((Widget)public_key_value, "ConfigView.copy.to.clipboard.tooltip", true);
            public_key_value.setCursor(public_key_value.getDisplay().getSystemCursor(21));
            public_key_value.setForeground(Colors.blue);
            public_key_value.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    this.copyToClipboard();
                }

                public void mouseDown(MouseEvent arg0) {
                    this.copyToClipboard();
                }

                protected void copyToClipboard() {
                    new Clipboard(parent.getDisplay()).setContents(new Object[]{public_key_value.getText()}, new Transfer[]{TextTransfer.getInstance()});
                }
            });
            crypt_man.addKeyListener(new CryptoManagerKeyListener(){

                public void keyChanged(final CryptoHandler handler) {
                    final 7 me = this;
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            if (public_key_value.isDisposed()) {
                                crypt_man.removeKeyListener(me);
                            } else if (handler.getType() == 1) {
                                byte[] public_key = handler.peekPublicKey();
                                if (public_key == null) {
                                    Messages.setLanguageText((Widget)public_key_value, "ConfigView.section.security.publickey.undef");
                                } else {
                                    public_key_value.setText(Base32.encode(public_key));
                                }
                                crypto_group.layout();
                            }
                        }
                    });
                }

                public void keyLockStatusChanged(CryptoHandler handler) {
                }
            });
            new Label((Composite)crypto_group, 0);
            Label reset_key_label = new Label((Composite)crypto_group, 0);
            Messages.setLanguageText((Widget)reset_key_label, "ConfigView.section.security.resetkey");
            Button reset_key_button = new Button((Composite)crypto_group, 8);
            buttons.add(reset_key_button);
            Messages.setLanguageText((Widget)reset_key_button, "ConfigView.section.security.clearpasswords.button");
            reset_key_button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    MessageBoxShell mb = new MessageBoxShell(296, MessageText.getString("ConfigView.section.security.resetkey.warning.title"), MessageText.getString("ConfigView.section.security.resetkey.warning"));
                    mb.setDefaultButtonUsingStyle(256);
                    mb.setParent(parent.getShell());
                    mb.open(new UserPrompterResultListener(){

                        public void prompterClosed(int returnVal) {
                            if (returnVal != 32) {
                                return;
                            }
                            try {
                                crypt_man.getECCHandler().resetKeys("Manual key reset");
                            }
                            catch (Throwable e) {
                                MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.resetkey.error.title"), ConfigSectionSecurity.this.getError(e));
                                mb.setParent(parent.getShell());
                                mb.open(null);
                            }
                        }
                    });
                }
            });
            new Label((Composite)crypto_group, 0);
            Label priv_key_label = new Label((Composite)crypto_group, 0);
            Messages.setLanguageText((Widget)priv_key_label, "ConfigView.section.security.unlockkey");
            Button priv_key_button = new Button((Composite)crypto_group, 8);
            buttons.add(priv_key_button);
            Messages.setLanguageText((Widget)priv_key_button, "ConfigView.section.security.unlockkey.button");
            priv_key_button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    try {
                        crypt_man.getECCHandler().getEncryptedPrivateKey("Manual unlock");
                    }
                    catch (Throwable e) {
                        MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.resetkey.error.title"), ConfigSectionSecurity.this.getError(e));
                        mb.setParent(parent.getShell());
                        mb.open(null);
                    }
                }
            });
            new Label((Composite)crypto_group, 0);
            Label backup_keys_label = new Label((Composite)crypto_group, 0);
            Messages.setLanguageText((Widget)backup_keys_label, "ConfigView.section.security.backupkeys");
            final Button backup_keys_button = new Button((Composite)crypto_group, 8);
            buttons.add(backup_keys_button);
            Messages.setLanguageText((Widget)backup_keys_button, "ConfigView.section.security.backupkeys.button");
            backup_keys_button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    FileDialog dialog = new FileDialog(backup_keys_button.getShell(), 65536);
                    String target = dialog.open();
                    if (target != null) {
                        try {
                            String keys = crypt_man.getECCHandler().exportKeys();
                            PrintWriter pw = new PrintWriter(new FileWriter(target));
                            pw.println(keys);
                            pw.close();
                        }
                        catch (Throwable e) {
                            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("ConfigView.section.security.op.error", new String[]{ConfigSectionSecurity.this.getError(e)}));
                            mb.setParent(parent.getShell());
                            mb.open(null);
                        }
                    }
                }
            });
            new Label((Composite)crypto_group, 0);
            Label restore_keys_label = new Label((Composite)crypto_group, 0);
            Messages.setLanguageText((Widget)restore_keys_label, "ConfigView.section.security.restorekeys");
            Button restore_keys_button = new Button((Composite)crypto_group, 8);
            buttons.add(restore_keys_button);
            Messages.setLanguageText((Widget)restore_keys_button, "ConfigView.section.security.restorekeys.button");
            restore_keys_button.addListener(13, new Listener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleEvent(Event event2) {
                    FileDialog dialog = new FileDialog(backup_keys_button.getShell(), 65536);
                    String target = dialog.open();
                    if (target != null) {
                        try {
                            LineNumberReader reader = new LineNumberReader(new FileReader(target));
                            String str = "";
                            try {
                                String line;
                                while ((line = reader.readLine()) != null) {
                                    str = str + line + "\r\n";
                                }
                                Object var8_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var8_11 = null;
                                reader.close();
                                throw throwable;
                            }
                            reader.close();
                            boolean restart = crypt_man.getECCHandler().importKeys(str);
                            if (restart) {
                                MessageBoxShell mb = new MessageBoxShell(34, MessageText.getString("ConfigView.section.security.restart.title"), MessageText.getString("ConfigView.section.security.restart.msg"));
                                mb.setParent(parent.getShell());
                                mb.open(null);
                                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                                if (uiFunctions != null) {
                                    uiFunctions.dispose(true, false);
                                }
                            }
                        }
                        catch (Throwable e) {
                            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("ConfigView.section.security.op.error.title"), MessageText.getString("ConfigView.section.security.op.error", new String[]{ConfigSectionSecurity.this.getError(e)}));
                            mb.setParent(parent.getShell());
                            mb.open(null);
                        }
                    }
                }
            });
            new Label((Composite)crypto_group, 0);
        }
        Utils.makeButtonsEqualWidth(buttons);
        return gSecurity;
    }

    protected String getError(Throwable e) {
        String error;
        if (e instanceof CryptoManagerPasswordException) {
            if (((CryptoManagerPasswordException)e).wasIncorrect()) {
                error = MessageText.getString("ConfigView.section.security.unlockkey.error");
            } else {
                CryptoManager crypto_man = CryptoManagerFactory.getSingleton();
                CryptoHandler ecc_handler = crypto_man.getECCHandler();
                error = MessageText.getString("ConfigView.section.security.nopw");
            }
        } else {
            error = MessageText.getString("ConfigView.section.security.resetkey.error") + ": " + Debug.getNestedExceptionMessage(e);
        }
        return error;
    }
}

