/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderPHE;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public abstract class ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final int TIMEOUT_CHECK = 5000;
    private static final int LOG_TICKS = 12;
    private static List<ProtocolDecoder> decoders = new ArrayList<ProtocolDecoder>();
    private static AEMonitor class_mon = new AEMonitor("TCPProtocolDecoder:class");
    private static int loop = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtocolDecoder(boolean run_timer) {
        if (run_timer) {
            try {
                class_mon.enter();
                decoders.add(this);
                Object var3_2 = null;
                class_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                class_mon.exit();
                throw throwable;
            }
        }
    }

    public abstract boolean isComplete(long var1);

    public abstract TransportHelperFilter getFilter();

    public static void addSecrets(byte[][] secrets) {
        ProtocolDecoderPHE.addSecretsSupport(secrets);
    }

    public static void removeSecrets(byte[][] secrets) {
        ProtocolDecoderPHE.removeSecretsSupport(secrets);
    }

    static {
        SimpleTimer.addPeriodicEvent("ProtocolDecoder:timeouts", 5000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent ev) {
                ArrayList copy;
                loop++;
                try {
                    class_mon.enter();
                    if (loop % 12 == 0 && Logger.isEnabled() && decoders.size() > 0) {
                        Logger.log(new LogEvent(LOGID, "Active protocol decoders = " + decoders.size()));
                    }
                    copy = new ArrayList(decoders);
                    Object var4_3 = null;
                    class_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    class_mon.exit();
                    throw throwable;
                }
                if (copy.size() > 0) {
                    ArrayList<ProtocolDecoder> to_remove = new ArrayList<ProtocolDecoder>();
                    long now = SystemTime.getCurrentTime();
                    for (ProtocolDecoder decoder : copy) {
                        if (!decoder.isComplete(now)) continue;
                        to_remove.add(decoder);
                    }
                    if (to_remove.size() > 0) {
                        try {
                            class_mon.enter();
                            for (ProtocolDecoder decoder : to_remove) {
                                decoders.remove(decoder);
                            }
                            Object var9_10 = null;
                            class_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var9_11 = null;
                            class_mon.exit();
                            throw throwable;
                        }
                    }
                }
            }
        });
    }
}

