/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualChannelSelector;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class TCPConnectionManager {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static int CONNECT_SELECT_LOOP_TIME = 100;
    private static int CONNECT_SELECT_LOOP_MIN_TIME = 0;
    private static int MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 3;
    public static int MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
    private static int max_outbound_connections;
    private int rcv_size;
    private int snd_size;
    private String ip_tos;
    private int local_bind_port;
    private static final int CONNECT_ATTEMPT_TIMEOUT = 15000;
    private static final int CONNECT_ATTEMPT_STALL_TIME = 3000;
    private static final boolean SHOW_CONNECT_STATS = false;
    private final VirtualChannelSelector connect_selector;
    private long connection_request_id_next;
    private final Set<ConnectionRequest> new_requests;
    private final List<ConnectListener> canceled_requests;
    private final AEMonitor new_canceled_mon;
    private final Map<ConnectionRequest, Object> pending_attempts;
    private final LinkedList<SocketChannel> pending_closes;
    private final Map<SocketChannel, Long> delayed_closes;
    private final AEMonitor pending_closes_mon;
    private boolean max_conn_exceeded_logged;

    public TCPConnectionManager() {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.socket.SO_RCVBUF", "network.tcp.socket.SO_SNDBUF", "network.tcp.socket.IPDiffServ", "network.bind.local.port"}, new ParameterListener(){

            public void parameterChanged(String name) {
                TCPConnectionManager.this.rcv_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_RCVBUF");
                TCPConnectionManager.this.snd_size = COConfigurationManager.getIntParameter("network.tcp.socket.SO_SNDBUF");
                TCPConnectionManager.this.ip_tos = COConfigurationManager.getStringParameter("network.tcp.socket.IPDiffServ");
                TCPConnectionManager.this.local_bind_port = COConfigurationManager.getIntParameter("network.bind.local.port");
            }
        });
        this.connect_selector = new VirtualChannelSelector("Connect/Disconnect Manager", 8, true);
        this.new_requests = new TreeSet<ConnectionRequest>(new Comparator<ConnectionRequest>(){

            @Override
            public int compare(ConnectionRequest r1, ConnectionRequest r2) {
                if (r1 == r2) {
                    return 0;
                }
                int res = r1.getPriority() - r2.getPriority();
                if (res == 0 && (res = r1.getRandom() - r2.getRandom()) == 0) {
                    long l = r1.getID() - r2.getID();
                    if (l < 0L) {
                        res = -1;
                    } else if (l > 0L) {
                        res = 1;
                    } else {
                        Debug.out("arghhh, borkage");
                    }
                }
                return res;
            }
        });
        this.canceled_requests = new ArrayList<ConnectListener>();
        this.new_canceled_mon = new AEMonitor("ConnectDisconnectManager:NCM");
        this.pending_attempts = new HashMap<ConnectionRequest, Object>();
        this.pending_closes = new LinkedList();
        this.delayed_closes = new HashMap<SocketChannel, Long>();
        this.pending_closes_mon = new AEMonitor("ConnectDisconnectManager:PC");
        HashSet<String> types = new HashSet<String>();
        types.add("net.tcp.outbound.connect.queue.length");
        types.add("net.tcp.outbound.cancel.queue.length");
        types.add("net.tcp.outbound.close.queue.length");
        types.add("net.tcp.outbound.pending.queue.length");
        AzureusCoreStats.registerProvider(types, new AzureusCoreStatsProvider(){

            @Override
            public void updateStats(Set<String> types, Map<String, Object> values) {
                if (types.contains("net.tcp.outbound.connect.queue.length")) {
                    values.put("net.tcp.outbound.connect.queue.length", new Long(TCPConnectionManager.this.new_requests.size()));
                }
                if (types.contains("net.tcp.outbound.cancel.queue.length")) {
                    values.put("net.tcp.outbound.cancel.queue.length", new Long(TCPConnectionManager.this.canceled_requests.size()));
                }
                if (types.contains("net.tcp.outbound.close.queue.length")) {
                    values.put("net.tcp.outbound.close.queue.length", new Long(TCPConnectionManager.this.pending_closes.size()));
                }
                if (types.contains("net.tcp.outbound.pending.queue.length")) {
                    values.put("net.tcp.outbound.pending.queue.length", new Long(TCPConnectionManager.this.pending_attempts.size()));
                }
            }
        });
        new AEThread2("ConnectDisconnectManager", true){

            public void run() {
                while (true) {
                    TCPConnectionManager.this.addNewOutboundRequests();
                    TCPConnectionManager.this.runSelect();
                    TCPConnectionManager.this.doClosings();
                }
            }
        }.start();
    }

    public int getMaxOutboundPermitted() {
        return Math.max(max_outbound_connections - this.new_requests.size(), 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewOutboundRequests() {
        while (this.pending_attempts.size() < MIN_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            ConnectionRequest cr = null;
            try {
                this.new_canceled_mon.enter();
                if (this.new_requests.isEmpty()) break;
                Iterator<ConnectionRequest> it = this.new_requests.iterator();
                cr = it.next();
                it.remove();
            }
            finally {
                this.new_canceled_mon.exit();
            }
            if (cr == null) continue;
            this.addNewRequest(cr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewRequest(final ConnectionRequest request2) {
        block31: {
            request2.setConnectTimeout(request2.listener.connectAttemptStarted(request2.getConnectTimeout()));
            boolean ipv6problem = false;
            boolean bind_failed = false;
            try {
                request2.channel = SocketChannel.open();
                InetAddress bindIP = null;
                try {
                    if (this.rcv_size > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Setting socket receive buffer size for outgoing connection [" + request2.address + "] to: " + this.rcv_size));
                        }
                        request2.channel.socket().setReceiveBufferSize(this.rcv_size);
                    }
                    if (this.snd_size > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Setting socket send buffer size for outgoing connection [" + request2.address + "] to: " + this.snd_size));
                        }
                        request2.channel.socket().setSendBufferSize(this.snd_size);
                    }
                    if (this.ip_tos.length() > 0) {
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "Setting socket TOS field for outgoing connection [" + request2.address + "] to: " + this.ip_tos));
                        }
                        request2.channel.socket().setTrafficClass(Integer.decode(this.ip_tos));
                    }
                    if (this.local_bind_port > 0) {
                        request2.channel.socket().setReuseAddress(true);
                    }
                    try {
                        bindIP = NetworkAdmin.getSingleton().getMultiHomedOutgoingRoundRobinBindAddress(request2.address.getAddress());
                        if (bindIP != null) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Binding outgoing connection [" + request2.address + "] to local IP address: " + bindIP + ":" + this.local_bind_port));
                            }
                            request2.channel.socket().bind(new InetSocketAddress(bindIP, this.local_bind_port));
                        } else if (this.local_bind_port > 0) {
                            if (Logger.isEnabled()) {
                                Logger.log(new LogEvent(LOGID, "Binding outgoing connection [" + request2.address + "] to local port #: " + this.local_bind_port));
                            }
                            request2.channel.socket().bind(new InetSocketAddress(this.local_bind_port));
                        }
                    }
                    catch (SocketException e) {
                        bind_failed = true;
                        String msg = e.getMessage().toLowerCase();
                        if ((msg.contains("address family not supported by protocol family") || msg.contains("protocol family unavailable")) && !NetworkAdmin.getSingleton().hasIPV6Potential(true)) {
                            ipv6problem = true;
                        }
                        throw e;
                    }
                }
                catch (Throwable t) {
                    if (bind_failed && NetworkAdmin.getSingleton().mustBind()) {
                        throw t;
                    }
                    if (!ipv6problem) {
                        String msg = "Error while processing advanced socket options (rcv=" + this.rcv_size + ", snd=" + this.snd_size + ", tos=" + this.ip_tos + ", port=" + this.local_bind_port + ", bind=" + bindIP + ")";
                        Logger.log(new LogAlert(false, msg, t));
                    }
                    throw t;
                }
                request2.channel.configureBlocking(false);
                request2.connect_start_time = SystemTime.getMonotonousTime();
                if (request2.channel.connect(request2.address)) {
                    this.finishConnect(request2);
                    break block31;
                }
                try {
                    this.new_canceled_mon.enter();
                    this.pending_attempts.put(request2, null);
                }
                finally {
                    this.new_canceled_mon.exit();
                }
                this.connect_selector.register(request2.channel, new VirtualChannelSelector.VirtualSelectorListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public boolean selectSuccess(VirtualChannelSelector selector, SocketChannel sc, Object attachment) {
                        try {
                            TCPConnectionManager.this.new_canceled_mon.enter();
                            TCPConnectionManager.this.pending_attempts.remove(request2);
                        }
                        finally {
                            TCPConnectionManager.this.new_canceled_mon.exit();
                        }
                        TCPConnectionManager.this.finishConnect(request2);
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void selectFailure(VirtualChannelSelector selector, SocketChannel sc, Object attachment, Throwable msg) {
                        try {
                            TCPConnectionManager.this.new_canceled_mon.enter();
                            TCPConnectionManager.this.pending_attempts.remove(request2);
                        }
                        finally {
                            TCPConnectionManager.this.new_canceled_mon.exit();
                        }
                        TCPConnectionManager.this.closeConnection(request2.channel);
                        request2.listener.connectFailure(msg);
                    }
                }, null);
            }
            catch (Throwable t) {
                String full = request2.address.toString();
                String hostname = request2.address.getHostName();
                int port = request2.address.getPort();
                boolean unresolved = request2.address.isUnresolved();
                InetAddress inet_address = request2.address.getAddress();
                String full_sub = inet_address == null ? request2.address.toString() : inet_address.toString();
                String host_address = inet_address == null ? request2.address.toString() : inet_address.getHostAddress();
                String msg = "ConnectDisconnectManager::address exception: full=" + full + ", hostname=" + hostname + ", port=" + port + ", unresolved=" + unresolved + ", full_sub=" + full_sub + ", host_address=" + host_address;
                if (request2.channel != null) {
                    String channel2 = request2.channel.toString();
                    String socket = request2.channel.socket().toString();
                    String local_address = request2.channel.socket().getLocalAddress().toString();
                    int local_port = request2.channel.socket().getLocalPort();
                    SocketAddress ra = request2.channel.socket().getRemoteSocketAddress();
                    String remote_address = ra != null ? ra.toString() : "<null>";
                    int remote_port = request2.channel.socket().getPort();
                    msg = msg + "\n channel=" + channel2 + ", socket=" + socket + ", local_address=" + local_address + ", local_port=" + local_port + ", remote_address=" + remote_address + ", remote_port=" + remote_port;
                } else {
                    msg = msg + "\n channel=<null>";
                }
                if (ipv6problem || t instanceof UnresolvedAddressException || t instanceof NoRouteToHostException) {
                    Logger.log(new LogEvent(LOGID, 1, msg));
                } else {
                    Logger.log(new LogEvent(LOGID, 3, msg, t));
                }
                if (request2.channel != null) {
                    this.closeConnection(request2.channel);
                }
                request2.listener.connectFailure(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishConnect(ConnectionRequest request2) {
        block9: {
            try {
                if (request2.channel.finishConnect()) {
                    boolean canceled = false;
                    try {
                        this.new_canceled_mon.enter();
                        canceled = this.canceled_requests.contains(request2.listener);
                    }
                    finally {
                        this.new_canceled_mon.exit();
                    }
                    if (canceled) {
                        this.closeConnection(request2.channel);
                    } else {
                        this.connect_selector.cancel(request2.channel);
                        request2.listener.connectSuccess(request2.channel);
                    }
                    break block9;
                }
                Debug.out("finishConnect() failed");
                request2.listener.connectFailure(new Throwable("finishConnect() failed"));
                this.closeConnection(request2.channel);
            }
            catch (Throwable t) {
                request2.listener.connectFailure(t);
                this.closeConnection(request2.channel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSelect() {
        try {
            this.new_canceled_mon.enter();
            block13: for (ConnectListener key : this.canceled_requests) {
                Iterator<ConnectionRequest> pen_it = this.pending_attempts.keySet().iterator();
                while (pen_it.hasNext()) {
                    ConnectionRequest request2 = pen_it.next();
                    if (request2.listener != key) continue;
                    this.connect_selector.cancel(request2.channel);
                    this.closeConnection(request2.channel);
                    pen_it.remove();
                    continue block13;
                }
            }
            this.canceled_requests.clear();
        }
        finally {
            this.new_canceled_mon.exit();
        }
        try {
            if (CONNECT_SELECT_LOOP_MIN_TIME > 0) {
                long start = SystemTime.getHighPrecisionCounter();
                this.connect_selector.select(CONNECT_SELECT_LOOP_TIME);
                long duration = SystemTime.getHighPrecisionCounter() - start;
                long sleep = (long)CONNECT_SELECT_LOOP_MIN_TIME - (duration /= 1000000L);
                if (sleep > 0L) {
                    try {
                        Thread.sleep(sleep);
                    }
                    catch (Throwable e) {}
                }
            } else {
                this.connect_selector.select(CONNECT_SELECT_LOOP_TIME);
            }
        }
        catch (Throwable t) {
            Debug.out("connnectSelectLoop() EXCEPTION: ", t);
        }
        int num_stalled_requests = 0;
        long now = SystemTime.getMonotonousTime();
        ArrayList<ConnectionRequest> timeouts = null;
        try {
            this.new_canceled_mon.enter();
            Iterator<ConnectionRequest> i = this.pending_attempts.keySet().iterator();
            while (i.hasNext()) {
                ConnectionRequest request3 = i.next();
                long waiting_time = now - request3.connect_start_time;
                if (waiting_time > (long)request3.connect_timeout) {
                    i.remove();
                    SocketChannel channel2 = request3.channel;
                    this.connect_selector.cancel(channel2);
                    this.closeConnection(channel2);
                    if (timeouts == null) {
                        timeouts = new ArrayList<ConnectionRequest>();
                    }
                    timeouts.add(request3);
                    continue;
                }
                if (waiting_time >= 3000L) {
                    ++num_stalled_requests;
                    continue;
                }
                if (waiting_time >= 0L) continue;
                request3.connect_start_time = now;
            }
        }
        finally {
            this.new_canceled_mon.exit();
        }
        if (timeouts != null) {
            for (ConnectionRequest request3 : timeouts) {
                InetSocketAddress sock_address = request3.address;
                InetAddress a = sock_address.getAddress();
                String target = a != null ? a.getHostAddress() + ":" + sock_address.getPort() : sock_address.toString();
                request3.listener.connectFailure(new SocketTimeoutException("Connection attempt to " + target + " aborted: timed out after " + request3.connect_timeout / 1000 + "sec"));
            }
        }
        if (num_stalled_requests == this.pending_attempts.size() && this.pending_attempts.size() < MAX_SIMULTANIOUS_CONNECT_ATTEMPTS) {
            ConnectionRequest cr = null;
            try {
                this.new_canceled_mon.enter();
                if (!this.new_requests.isEmpty()) {
                    Iterator<ConnectionRequest> it = this.new_requests.iterator();
                    cr = it.next();
                    it.remove();
                }
            }
            finally {
                this.new_canceled_mon.exit();
            }
            if (cr != null) {
                this.addNewRequest(cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClosings() {
        try {
            this.pending_closes_mon.enter();
            long now = SystemTime.getMonotonousTime();
            if (this.delayed_closes.size() > 0) {
                Iterator<Map.Entry<SocketChannel, Long>> it = this.delayed_closes.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<SocketChannel, Long> entry = it.next();
                    long wait = entry.getValue() - now;
                    if (wait >= 0L && wait <= 60000L) continue;
                    this.pending_closes.addLast(entry.getKey());
                    it.remove();
                }
            }
            while (!this.pending_closes.isEmpty()) {
                SocketChannel channel2 = this.pending_closes.removeFirst();
                if (channel2 == null) continue;
                this.connect_selector.cancel(channel2);
                try {
                    channel2.close();
                }
                catch (Throwable t) {}
            }
        }
        finally {
            this.pending_closes_mon.exit();
        }
    }

    public void requestNewConnection(InetSocketAddress address, ConnectListener listener, int priority) {
        this.requestNewConnection(address, listener, 15000, priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestNewConnection(InetSocketAddress address, ConnectListener listener, int connect_timeout, int priority) {
        if (address.getPort() == 0) {
            try {
                listener.connectFailure(new Exception("Invalid port, connection to " + address + " abandoned"));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
            return;
        }
        ArrayList<ConnectionRequest> kicked = null;
        boolean duplicate = false;
        try {
            this.new_canceled_mon.enter();
            ConnectionRequest cr = new ConnectionRequest(this.connection_request_id_next++, address, listener, connect_timeout, priority);
            if (this.new_requests.contains(cr)) {
                duplicate = true;
            } else {
                this.new_requests.add(cr);
                if (this.new_requests.size() >= max_outbound_connections && !this.max_conn_exceeded_logged) {
                    this.max_conn_exceeded_logged = true;
                    Debug.out("TCPConnectionManager: max outbound connection limit reached (" + max_outbound_connections + ")");
                }
                if (priority == 1) {
                    for (ConnectionRequest request2 : this.pending_attempts.keySet()) {
                        if (request2.priority != 4 || this.canceled_requests.contains(request2.listener)) continue;
                        this.canceled_requests.add(request2.listener);
                        if (kicked == null) {
                            kicked = new ArrayList<ConnectionRequest>();
                        }
                        kicked.add(request2);
                    }
                }
            }
        }
        finally {
            this.new_canceled_mon.exit();
        }
        if (duplicate) {
            try {
                listener.connectFailure(new Exception("Connection request already queued for " + address));
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (kicked != null) {
            for (int i = 0; i < kicked.size(); ++i) {
                try {
                    ((ConnectionRequest)kicked.get(i)).listener.connectFailure(new Exception("Low priority connection request abandoned in favour of high priority"));
                    continue;
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public void closeConnection(SocketChannel channel2) {
        this.closeConnection(channel2, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(SocketChannel channel2, int delay) {
        try {
            this.pending_closes_mon.enter();
            if (delay == 0) {
                if (!this.delayed_closes.containsKey(channel2) && !this.pending_closes.contains(channel2)) {
                    this.pending_closes.addLast(channel2);
                }
            } else {
                this.delayed_closes.put(channel2, new Long(SystemTime.getMonotonousTime() + (long)delay));
            }
        }
        finally {
            this.pending_closes_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelRequest(ConnectListener listener_key) {
        try {
            this.new_canceled_mon.enter();
            Iterator<ConnectionRequest> i = this.new_requests.iterator();
            while (i.hasNext()) {
                ConnectionRequest request2 = i.next();
                if (request2.listener != listener_key) continue;
                i.remove();
                return;
            }
            this.canceled_requests.add(listener_key);
        }
        finally {
            this.new_canceled_mon.exit();
        }
    }

    static {
        if (MAX_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
            MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
            COConfigurationManager.setParameter("network.max.simultaneous.connect.attempts", 1);
        }
        if ((MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2) < 1) {
            MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
        }
        COConfigurationManager.addParameterListener("network.max.simultaneous.connect.attempts", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MAX_SIMULTANIOUS_CONNECT_ATTEMPTS = COConfigurationManager.getIntParameter("network.max.simultaneous.connect.attempts");
                MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = MAX_SIMULTANIOUS_CONNECT_ATTEMPTS - 2;
                if (MIN_SIMULTANIOUS_CONNECT_ATTEMPTS < 1) {
                    MIN_SIMULTANIOUS_CONNECT_ATTEMPTS = 1;
                }
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.max.connections.outstanding"}, new ParameterListener(){

            public void parameterChanged(String name) {
                max_outbound_connections = COConfigurationManager.getIntParameter("network.tcp.max.connections.outstanding");
            }
        });
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.tcp.connect.select.time", "network.tcp.connect.select.min.time"}, new ParameterListener(){

            public void parameterChanged(String name) {
                CONNECT_SELECT_LOOP_TIME = COConfigurationManager.getIntParameter("network.tcp.connect.select.time");
                CONNECT_SELECT_LOOP_MIN_TIME = COConfigurationManager.getIntParameter("network.tcp.connect.select.min.time");
            }
        });
    }

    public static interface ConnectListener {
        public int connectAttemptStarted(int var1);

        public void connectSuccess(SocketChannel var1);

        public void connectFailure(Throwable var1);
    }

    private static class ConnectionRequest {
        private final InetSocketAddress address;
        private final ConnectListener listener;
        private final long request_start_time;
        private long connect_start_time;
        private int connect_timeout;
        private SocketChannel channel;
        private final short rand;
        private final int priority;
        private final long id;

        private ConnectionRequest(long _id, InetSocketAddress _address, ConnectListener _listener, int _connect_timeout, int _priority) {
            this.id = _id;
            this.address = _address;
            this.listener = _listener;
            this.connect_timeout = _connect_timeout;
            this.request_start_time = SystemTime.getMonotonousTime();
            this.rand = (short)RandomUtils.nextInt(Short.MAX_VALUE);
            this.priority = _priority;
        }

        private int getConnectTimeout() {
            return this.connect_timeout;
        }

        private void setConnectTimeout(int _ct) {
            this.connect_timeout = _ct;
        }

        private long getID() {
            return this.id;
        }

        private int getPriority() {
            return this.priority;
        }

        private short getRandom() {
            return this.rand;
        }
    }
}

