/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.skin;

import com.aelitis.azureus.ui.skin.SkinProperties;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.internat.IntegratedResourceBundle;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class SkinPropertiesImpl
implements SkinProperties {
    private static final LogIDs LOGID = LogIDs.UI3;
    public static final String PATH_SKIN_DEFS = "com/aelitis/azureus/ui/skin/";
    private static final String FILE_SKIN_DEFS = "skin3.properties";
    private static final Pattern PAT_PARAM_ALPHA = Pattern.compile("\\{([^0-9].+?)\\}");
    private static final Pattern PAT_PARAM_NUM = Pattern.compile("\\{([0-9]+?)\\}");
    private IntegratedResourceBundle rb;
    private final ClassLoader classLoader;

    public SkinPropertiesImpl() {
        this(SkinPropertiesImpl.class.getClassLoader(), PATH_SKIN_DEFS, FILE_SKIN_DEFS);
    }

    public SkinPropertiesImpl(ClassLoader classLoader, String skinPath, String mainSkinFile) {
        this.classLoader = classLoader;
        skinPath = skinPath.replaceAll("/", ".");
        if (!skinPath.endsWith(".")) {
            skinPath = skinPath + ".";
        }
        if (mainSkinFile.endsWith(".properties")) {
            mainSkinFile = mainSkinFile.substring(0, mainSkinFile.length() - 11);
        }
        ResourceBundle bundle = ResourceBundle.getBundle(skinPath + mainSkinFile, Locale.getDefault(), classLoader);
        this.rb = new IntegratedResourceBundle(bundle, Collections.EMPTY_MAP, 1200);
        this.rb.setUseNullList(true);
        String sFiles = this.rb.getString("skin.include", null);
        if (sFiles != null) {
            String[] sFilesArray = sFiles.split(",");
            for (int i = 0; i < sFilesArray.length; ++i) {
                String sFile = sFilesArray[i].startsWith("/") ? sFilesArray[i].substring(1) : skinPath + sFilesArray[i];
                sFile = sFile.replaceAll("/", ".");
                try {
                    ResourceBundle subBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), classLoader);
                    this.rb.addResourceMessages(subBundle);
                    continue;
                }
                catch (Throwable t) {
                    Debug.out("Err loading skin include: " + sFile, t);
                }
            }
        }
    }

    public void addResourceBundle(ResourceBundle subBundle, String skinPath) {
        this.addResourceBundle(subBundle, skinPath, this.classLoader);
    }

    public void addResourceBundle(ResourceBundle subBundle, String skinPath, ClassLoader loader) {
        try {
            this.clearCache();
            this.rb.addResourceMessages(subBundle);
            try {
                String sFiles = subBundle.getString("skin.include");
                if (sFiles != null && skinPath != null) {
                    String[] sFilesArray = Constants.PAT_SPLIT_COMMA.split(sFiles);
                    for (int i = 0; i < sFilesArray.length; ++i) {
                        String sFile = sFilesArray[i].startsWith("/") ? sFilesArray[i].substring(1) : skinPath + sFilesArray[i];
                        sFile = sFile.replaceAll("/", ".");
                        try {
                            ResourceBundle incBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), loader);
                            this.rb.addResourceMessages(incBundle);
                            continue;
                        }
                        catch (Throwable t) {
                            Debug.out("Err loading skin include: " + sFile, t);
                        }
                    }
                }
            }
            catch (MissingResourceException e) {
            }
        }
        catch (Throwable t) {
            Debug.out("Err loading skin include: " + subBundle, t);
        }
    }

    public void addProperty(String name, String value) {
        this.rb.addString(name, value);
    }

    public boolean hasKey(String name) {
        if (name == null) {
            return false;
        }
        String osName = null;
        if (Constants.isWindows) {
            osName = name + "._windows";
        } else if (Constants.isOSX) {
            osName = name + "._mac";
        } else if (Constants.isUnix) {
            osName = name + "._unix";
        } else if (Constants.isFreeBSD) {
            osName = name + "._freebsd";
        } else if (Constants.isLinux) {
            osName = name + "._linux";
        } else if (Constants.isSolaris) {
            osName = name + "._solaris";
        }
        boolean contains = false;
        if (osName != null) {
            boolean bl = contains = this.rb.getString(osName, null) != null;
        }
        if (!contains) {
            contains = this.rb.getString(name, null) != null;
        }
        return contains;
    }

    public String getReferenceID(String name) {
        String value = this.getValue(name, null, false);
        if (value == null || value.length() < 2) {
            return null;
        }
        if (value.charAt(0) == '{' && value.charAt(value.length() - 1) == '}') {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    private String getValue(String name, String[] params) {
        return this.getValue(name, params, true);
    }

    private String getValue(String name, String[] params, boolean expandReferences) {
        String value = null;
        String osName = null;
        if (name == null) {
            return null;
        }
        if (Constants.isWindows) {
            osName = name + "._windows";
        } else if (Constants.isOSX) {
            osName = name + "._mac";
        } else if (Constants.isUnix) {
            osName = name + "._unix";
        } else if (Constants.isFreeBSD) {
            osName = name + "._freebsd";
        } else if (Constants.isLinux) {
            osName = name + "._linux";
        } else if (Constants.isSolaris) {
            osName = name + "._solaris";
        }
        if (osName != null) {
            value = this.rb.getString(osName, null);
        }
        if (value == null) {
            value = this.rb.getString(name, null);
        }
        if (expandReferences && value != null && value.indexOf(125) > 0) {
            String key;
            Matcher matcher;
            if (params != null) {
                matcher = PAT_PARAM_NUM.matcher(value);
                while (matcher.find()) {
                    key = matcher.group(1);
                    try {
                        int i = Integer.parseInt(key);
                        if (i < params.length) {
                            value = value.replaceAll("\\Q{" + key + "}\\E", params[i]);
                            continue;
                        }
                        value = value.replaceAll("\\Q{" + key + "}\\E", "");
                    }
                    catch (Exception e) {}
                }
            }
            matcher = PAT_PARAM_ALPHA.matcher(value);
            while (matcher.find()) {
                key = matcher.group(1);
                String text = this.getValue(key, params);
                if (text == null) {
                    text = MessageText.getString(key);
                }
                value = value.replaceAll("\\Q{" + key + "}\\E", text);
            }
        }
        return value;
    }

    public int getIntValue(String name, int def) {
        String value = this.getValue(name, null);
        if (value == null) {
            return def;
        }
        int result = def;
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return result;
    }

    public int[] getColorValue(String name) {
        int[] colors = new int[4];
        String value = this.getValue(name, null);
        if (value == null || value.length() == 0 || value.startsWith("COLOR_")) {
            colors[2] = -1;
            colors[1] = -1;
            colors[0] = -1;
            return colors;
        }
        try {
            if (value.charAt(0) == '#') {
                long l = Long.parseLong(value.substring(1), 16);
                if (value.length() == 9) {
                    colors = new int[]{(int)(l >> 24 & 0xFFL), (int)(l >> 16 & 0xFFL), (int)(l >> 8 & 0xFFL), (int)(l & 0xFFL)};
                } else {
                    colors[0] = (int)(l >> 16 & 0xFFL);
                    colors[1] = (int)(l >> 8 & 0xFFL);
                    colors[2] = (int)(l & 0xFFL);
                    colors[3] = 255;
                }
            } else {
                StringTokenizer st = new StringTokenizer(value, ",");
                colors[0] = Integer.parseInt(st.nextToken());
                colors[1] = Integer.parseInt(st.nextToken());
                colors[2] = Integer.parseInt(st.nextToken());
                colors[3] = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : 255;
            }
        }
        catch (Exception e) {
            colors[2] = -1;
            colors[1] = -1;
            colors[0] = -1;
        }
        return colors;
    }

    public String getStringValue(String name) {
        return this.getStringValue(name, (String[])null);
    }

    public String getStringValue(String name, String def) {
        return this.getStringValue(name, null, def);
    }

    public String[] getStringArray(String name) {
        return this.getStringArray(name, null);
    }

    public String[] getStringArray(String name, String[] params) {
        String s = this.getValue(name, params);
        if (s == null) {
            return null;
        }
        String[] values = Constants.PAT_SPLIT_COMMAWORDS.split(s);
        if (values == null) {
            return new String[]{s};
        }
        return values;
    }

    public String getStringValue(String name, String[] params) {
        return this.getValue(name, params);
    }

    public String getStringValue(String name, String[] params, String def) {
        String s = this.getValue(name, params);
        return s == null ? def : s;
    }

    public boolean getBooleanValue(String name, boolean def) {
        String s = this.getStringValue(name, (String)null);
        if (s == null) {
            return def;
        }
        return s.toLowerCase().equals("true") || s.equals("1");
    }

    public void clearCache() {
        this.rb.clearUsedMessagesMap(1);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

