/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.browser;

import com.aelitis.azureus.core.messenger.ClientMessageContext;
import com.aelitis.azureus.core.messenger.ClientMessageContextImpl;
import com.aelitis.azureus.core.messenger.browser.listeners.BrowserMessageListener;
import com.aelitis.azureus.core.messenger.config.PlatformConfigMessenger;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.ui.swt.browser.BrowserWrapper;
import com.aelitis.azureus.ui.swt.browser.msg.MessageDispatcherSWT;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class BrowserContext
extends ClientMessageContextImpl
implements DisposeListener {
    private static final String CONTEXT_KEY = "BrowserContext";
    private static final String KEY_ENABLE_MENU = "browser.menu.enable";
    private BrowserWrapper browser;
    private Display display;
    private boolean pageLoading = false;
    private long pageLoadingStart = 0L;
    private long pageLoadingEnd = 0L;
    private String lastValidURL = null;
    private final boolean forceVisibleAfterLoad;
    private TimerEventPeriodic checkURLEvent;
    private Control widgetWaitIndicator;
    private MessageDispatcherSWT messageDispatcherSWT;
    protected boolean wiggleBrowser = Utils.isCarbon;
    private ClientMessageContext.torrentURLHandler torrentURLHandler;
    private List loadingListeners = Collections.EMPTY_LIST;
    private long pageLoadTime;
    private long contentNetworkID = 1L;
    private AEMonitor mon_listJS = new AEMonitor("listJS");
    private List<String> listJS = new ArrayList<String>(1);
    private boolean allowPopups = true;
    private volatile boolean autoReloadPending = false;
    private String[] lastRetryData;

    public BrowserContext(String _id, BrowserWrapper _browser, Control _widgetWaitingIndicator, boolean _forceVisibleAfterLoad) {
        super(_id, null);
        this.browser = _browser;
        this.forceVisibleAfterLoad = _forceVisibleAfterLoad;
        this.widgetWaitIndicator = _widgetWaitingIndicator;
        this.messageDispatcherSWT = new MessageDispatcherSWT(this);
        this.setMessageDispatcher(this.messageDispatcherSWT);
        final TimerEventPerformer showBrowersPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (BrowserContext.this.forceVisibleAfterLoad && BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed() && !BrowserContext.this.browser.isVisible()) {
                                BrowserContext.this.browser.setVisible(true);
                            }
                        }
                    });
                }
            }
        };
        final TimerEventPerformer hideIndicatorPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                BrowserContext.this.setPageLoading(false, BrowserContext.this.browser.getUrl());
                if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                                BrowserContext.this.widgetWaitIndicator.setVisible(false);
                            }
                        }
                    });
                }
            }
        };
        final TimerEventPerformer checkURLEventPerformer = new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                if (BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed()) {
                    Utils.execSWTThreadLater(0, new AERunnable(){

                        public void runSupport() {
                            if (BrowserContext.this.browser != null && !BrowserContext.this.browser.isDisposed()) {
                                BrowserContext.this.browser.execute("try { tuxLocString = document.location.toString();if (tuxLocString.indexOf('res://') == 0) {  document.title = 'err: ' + tuxLocString;} else {  tuxTitleString = document.title.toString();  if (tuxTitleString.indexOf('408 ') == 0 || tuxTitleString.indexOf('503 ') == 0 || tuxTitleString.indexOf('500 ') == 0)   { document.title = 'err: ' + tuxTitleString; } }} catch (e) { }");
                            }
                        }
                    });
                }
            }
        };
        if (this.forceVisibleAfterLoad) {
            this.browser.setVisible(false);
        }
        this.setPageLoading(false, this.browser.getUrl());
        if (this.widgetWaitIndicator != null && !this.widgetWaitIndicator.isDisposed()) {
            this.widgetWaitIndicator.setVisible(false);
        }
        this.browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event2) {
                if (BrowserContext.this.browser == null || BrowserContext.this.browser.isDisposed() || BrowserContext.this.browser.getShell().isDisposed()) {
                    return;
                }
                if (!BrowserContext.this.browser.isVisible()) {
                    SimpleTimer.addEvent("Show Browser", System.currentTimeMillis() + 700L, showBrowersPerformer);
                }
                if (event2.title.startsWith("err: ")) {
                    BrowserContext.this.fillWithRetry(event2.title, "err in title");
                }
            }
        });
        this.browser.addProgressListener(new ProgressListener(){

            public void changed(ProgressEvent event2) {
            }

            public void completed(ProgressEvent event2) {
                if (BrowserContext.this.browser == null || BrowserContext.this.browser.isDisposed() || BrowserContext.this.browser.getShell().isDisposed()) {
                    return;
                }
                checkURLEventPerformer.perform(null);
                if (BrowserContext.this.forceVisibleAfterLoad && !BrowserContext.this.browser.isVisible()) {
                    BrowserContext.this.browser.setVisible(true);
                }
                BrowserContext.this.browser.execute("try { if (azureusClientWelcome) { azureusClientWelcome('" + ConstantsVuze.AZID + "'," + "{ 'azv':'" + "5.5.0.1_B17" + "', 'browser-id':'" + BrowserContext.this.getID() + "' }" + ");} } catch (e) { }");
                if ((Constants.isCVSVersion() || System.getProperty("debug.https", null) != null) && BrowserContext.this.browser.getUrl().indexOf("https") == 0) {
                    BrowserContext.this.browser.execute("try { o = document.getElementsByTagName('body'); if (o) o[0].style.borderTop = '2px dotted #3b3b3b'; } catch (e) {}");
                }
                if (BrowserContext.this.wiggleBrowser) {
                    Shell shell = BrowserContext.this.browser.getShell();
                    Point size = shell.getSize();
                    --size.x;
                    --size.y;
                    shell.setSize(size);
                    ++size.x;
                    ++size.y;
                    shell.setSize(size);
                }
            }
        });
        this.checkURLEvent = SimpleTimer.addPeriodicEvent("checkURL", 10000L, checkURLEventPerformer);
        this.browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event2) {
                if (BrowserContext.this.browser == null || BrowserContext.this.browser.isDisposed() || BrowserContext.this.browser.getShell().isDisposed()) {
                    return;
                }
                event2.required = true;
                if (BrowserContext.this.browser.getUrl().contains("js.debug=1")) {
                    final Shell shell = ShellFactory.createMainShell(1264);
                    shell.setLayout((Layout)new FillLayout());
                    shell.setSize(920, 500);
                    Browser subBrowser = new Browser((Composite)shell, Utils.getInitialBrowserStyle(0));
                    subBrowser.addCloseWindowListener(new CloseWindowListener(){

                        public void close(WindowEvent event2) {
                            shell.dispose();
                        }
                    });
                    shell.open();
                    event2.browser = subBrowser;
                } else {
                    final BrowserWrapper subBrowser = new BrowserWrapper((Composite)BrowserContext.this.browser.getBrowser(), Utils.getInitialBrowserStyle(0));
                    subBrowser.addLocationListener(new LocationListener(){

                        public void changed(LocationEvent arg0) {
                        }

                        public void changing(LocationEvent event2) {
                            event2.doit = false;
                            boolean doLinkExternally = PlatformConfigMessenger.areLinksExternal(BrowserContext.this.browser.getUrl());
                            if (doLinkExternally) {
                                Utils.launch(event2.location);
                            } else if (BrowserContext.this.allowPopups() && !UrlFilter.getInstance().urlIsBlocked(event2.location) && (event2.location.startsWith("http://") || event2.location.startsWith("https://"))) {
                                BrowserContext.this.debug("open sub browser: " + event2.location);
                                Utils.launch(event2.location);
                            } else {
                                BrowserContext.this.debug("blocked open sub browser: " + event2.location);
                            }
                            Utils.execSWTThreadLater(1000, new AERunnable(){

                                public void runSupport() {
                                    subBrowser.dispose();
                                }
                            });
                        }
                    });
                    event2.browser = subBrowser.getBrowser();
                }
            }
        });
        this.browser.addLocationListener(new LocationListener(){
            private TimerEvent timerevent;

            public void changed(LocationEvent event2) {
                boolean isWebURL;
                if (BrowserContext.this.browser.isDisposed() || BrowserContext.this.browser.getShell().isDisposed()) {
                    return;
                }
                BrowserContext.this.debug("browser.changed " + event2.location);
                if (this.timerevent != null) {
                    this.timerevent.cancel();
                }
                checkURLEventPerformer.perform(null);
                BrowserContext.this.setPageLoading(false, event2.top ? event2.location : null);
                if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                    BrowserContext.this.widgetWaitIndicator.setVisible(false);
                }
                if (!event2.top) {
                    return;
                }
                String location = event2.location.toLowerCase();
                boolean bl = isWebURL = location.startsWith("http://") || location.startsWith("https://");
                if (!isWebURL && event2.location.startsWith("res://")) {
                    BrowserContext.this.fillWithRetry(event2.location, "top changed");
                    return;
                }
                if (UrlFilter.getInstance().isWhitelisted(event2.location)) {
                    BrowserContext.this.lastValidURL = event2.location;
                }
            }

            public void changing(LocationEvent event2) {
                boolean isWebURL;
                boolean isOurURI;
                BrowserContext.this.debug("browser.changing " + event2.location + " from " + BrowserContext.this.browser.getUrl() + ";" + event2.top);
                if (BrowserContext.this.browser.isDisposed() || BrowserContext.this.browser.getShell().isDisposed()) {
                    return;
                }
                String event_location = event2.location;
                if (event_location.startsWith("javascript") && event_location.indexOf("back()") > 0) {
                    if (BrowserContext.this.browser.isBackEnabled()) {
                        BrowserContext.this.browser.back();
                    } else if (BrowserContext.this.lastValidURL != null) {
                        BrowserContext.this.fillWithRetry(event_location, "back");
                    }
                    return;
                }
                String lowerLocation = event_location.toLowerCase();
                boolean bl = isOurURI = lowerLocation.startsWith("magnet:") || lowerLocation.startsWith("vuze:") || lowerLocation.startsWith("bc:") || lowerLocation.startsWith("bctp:") || lowerLocation.startsWith("dht:");
                if (isOurURI) {
                    event2.doit = false;
                    TorrentOpener.openTorrent(event_location);
                    return;
                }
                boolean bl2 = isWebURL = lowerLocation.startsWith("http://") || lowerLocation.startsWith("https://");
                if (!isWebURL) {
                    return;
                }
                boolean blocked = UrlFilter.getInstance().urlIsBlocked(event_location);
                if (!BrowserContext.this.allowPopups()) {
                    boolean isSearch;
                    if (blocked) {
                        return;
                    }
                    String curURL = BrowserContext.this.browser.getUrl().toLowerCase();
                    boolean isPageLoadingOrRecent = BrowserContext.this.isPageLoading() || BrowserContext.this.pageLoadingEnd > 0L && BrowserContext.this.pageLoadingEnd + 500L > SystemTime.getCurrentTime() || event_location.contains(".admonkey.");
                    boolean wasSearch = curURL.startsWith("http://www.google.com/#q") || curURL.startsWith("http://www.google.com/search") || PlatformConfigMessenger.areLinksExternal(curURL);
                    boolean bl3 = isSearch = event_location.startsWith("http://www.google.com/#q") || event_location.startsWith("http://www.google.com/search") || PlatformConfigMessenger.areLinksExternal(event_location);
                    if (!(!wasSearch || isSearch || curURL.equalsIgnoreCase(event_location) || event_location.equals("about:blank") || isPageLoadingOrRecent)) {
                        event2.doit = false;
                        String[] contentTypes = BrowserContext.this.getContentTypes(event_location, ((Browser)event2.widget).getUrl());
                        boolean isTorrent = false;
                        for (String s : contentTypes) {
                            if (s == null || s.indexOf("torrent") == -1) continue;
                            isTorrent = true;
                        }
                        if (!isTorrent || !BrowserContext.this.openTorrent(event2)) {
                            Utils.launch(event2.location);
                        }
                        return;
                    }
                }
                if (blocked) {
                    event2.doit = false;
                    new MessageBoxShell(32, "URL blocked", "Tried to open " + event_location + " but it's blocked").open(null);
                    BrowserContext.this.browser.back();
                } else {
                    if (UrlFilter.getInstance().isWhitelisted(event_location)) {
                        BrowserContext.this.lastValidURL = event_location;
                    }
                    BrowserContext.this.setPageLoading(true, event2.location);
                    if (event2.top) {
                        if (BrowserContext.this.widgetWaitIndicator != null && !BrowserContext.this.widgetWaitIndicator.isDisposed()) {
                            BrowserContext.this.widgetWaitIndicator.setVisible(true);
                        }
                        this.timerevent = SimpleTimer.addEvent("Hide Indicator", System.currentTimeMillis() + 20000L, hideIndicatorPerformer);
                    } else {
                        boolean isTorrent = false;
                        boolean isVuzeFile = false;
                        if (event_location.endsWith(".torrent") || event_location.endsWith("?torrent")) {
                            isTorrent = true;
                        } else {
                            boolean test_for_vuze;
                            boolean can_rpc = UrlFilter.getInstance().urlCanRPC(event_location);
                            boolean test_for_torrent = !can_rpc && event_location.indexOf(".htm") == -1;
                            boolean bl4 = test_for_vuze = can_rpc && (event_location.endsWith(".xml") || event_location.endsWith(".vuze"));
                            if (test_for_torrent || test_for_vuze) {
                                String[] contentTypes;
                                for (String s : contentTypes = BrowserContext.this.getContentTypes(event_location, ((Browser)event2.widget).getUrl())) {
                                    if (s == null) continue;
                                    if (test_for_torrent && s.indexOf("torrent") != -1) {
                                        isTorrent = true;
                                    }
                                    if (!test_for_vuze || s.indexOf("vuze") == -1) continue;
                                    isVuzeFile = true;
                                }
                            }
                        }
                        if (isTorrent) {
                            BrowserContext.this.openTorrent(event2);
                        } else if (isVuzeFile) {
                            event2.doit = false;
                            BrowserContext.this.setPageLoading(false, event2.location);
                            try {
                                String referer_str = null;
                                try {
                                    referer_str = new URL(((Browser)event2.widget).getUrl()).toExternalForm();
                                }
                                catch (Throwable e) {
                                    // empty catch block
                                }
                                Map headers = UrlUtils.getBrowserHeaders(referer_str);
                                String cookies = (String)((Browser)event2.widget).getData("current-cookies");
                                if (cookies != null) {
                                    headers.put("Cookie", cookies);
                                }
                                ResourceDownloader rd = StaticUtilities.getResourceDownloaderFactory().create(new URL(event_location));
                                VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                                VuzeFile vf = vfh.loadVuzeFile(rd.download());
                                if (vf == null) {
                                    event2.doit = true;
                                    BrowserContext.this.setPageLoading(true, event2.location);
                                } else {
                                    vfh.handleFiles(new VuzeFile[]{vf}, 0);
                                }
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
        });
        this.browser.setData(CONTEXT_KEY, this);
        this.browser.addDisposeListener(this);
        final boolean enableMenu = System.getProperty(KEY_ENABLE_MENU, "0").equals("1");
        this.browser.addListener(35, new Listener(){

            public void handleEvent(Event event2) {
                event2.doit = enableMenu;
            }
        });
        this.messageDispatcherSWT.registerBrowser(this.browser);
        this.display = this.browser.getDisplay();
    }

    protected boolean openTorrent(LocationEvent event2) {
        event2.doit = false;
        this.setPageLoading(false, event2.location);
        try {
            String referer_str = null;
            try {
                referer_str = new URL(((Browser)event2.widget).getUrl()).toExternalForm();
            }
            catch (Throwable e) {
                // empty catch block
            }
            final Map headers = UrlUtils.getBrowserHeaders(referer_str);
            String cookies = (String)((Browser)event2.widget).getData("current-cookies");
            if (cookies != null) {
                headers.put("Cookie", cookies);
            }
            final String url = event2.location;
            if (this.torrentURLHandler != null) {
                try {
                    this.torrentURLHandler.handleTorrentURL(url);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            Utils.getOffOfSWTThread(new AERunnable(){

                public void runSupport() {
                    try {
                        PluginInitializer.getDefaultInterface().getDownloadManager().addDownload(new URL(url), headers);
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
            });
            return true;
        }
        catch (Throwable e) {
            Debug.out(e);
            return false;
        }
    }

    protected String[] getContentTypes(String event_location, String _referer) {
        try {
            URL url = new URL(event_location);
            URLConnection conn = url.openConnection();
            ((HttpURLConnection)conn).setRequestMethod("HEAD");
            String referer_str = null;
            try {
                URL referer = new URL(_referer);
                if (referer != null) {
                    referer_str = referer.toExternalForm();
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
            UrlUtils.setBrowserHeaders(conn, referer_str);
            UrlUtils.connectWithTimeouts(conn, 1500L, 5000L);
            String contentType = conn.getContentType();
            String contentDisposition = conn.getHeaderField("Content-Disposition");
            String server = conn.getHeaderField("Server");
            if ("application/x-bittorrent".equals(contentType) && ":3".equals(server)) {
                Thread.sleep(6000L);
            }
            return new String[]{contentType, contentDisposition};
        }
        catch (Throwable throwable) {
            return new String[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setPageLoading(boolean b, String url) {
        if (b && this.pageLoading) {
            return;
        }
        this.mon_listJS.enter();
        try {
            this.pageLoading = b;
            if (this.pageLoading) {
                this.pageLoadingStart = SystemTime.getCurrentTime();
                this.pageLoadTime = -1L;
            } else if (this.pageLoadingStart > 0L && url != null) {
                this.pageLoadingEnd = SystemTime.getCurrentTime();
                this.pageLoadTime = this.pageLoadingEnd - this.pageLoadingStart;
                this.executeInBrowser("clientSetLoadTime(" + this.pageLoadTime + ");");
                this.pageLoadingStart = 0L;
            }
            if (!this.pageLoading && this.listJS.size() > 0) {
                this.debug(this.listJS.size() + " javascripts queued.  Executing now..");
                for (String js : this.listJS) {
                    this.executeInBrowser(js);
                }
                this.listJS.clear();
            }
            Object var6_6 = null;
            this.mon_listJS.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.mon_listJS.exit();
            throw throwable;
        }
        Object[] listeners = this.loadingListeners.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            loadingListener l = (loadingListener)listeners[i];
            l.browserLoadingChanged(b, url);
        }
    }

    public void setTorrentURLHandler(ClientMessageContext.torrentURLHandler handler) {
        this.torrentURLHandler = handler;
    }

    public void setAutoReloadPending(final boolean is_pending, final boolean aborted) {
        this.autoReloadPending = is_pending;
        Utils.execSWTThread(new Runnable(){

            public void run() {
                if (!is_pending && aborted && BrowserContext.this.lastRetryData != null && !BrowserContext.this.browser.isDisposed()) {
                    BrowserContext.this.fillWithRetry(BrowserContext.this.lastRetryData[0], BrowserContext.this.lastRetryData[1]);
                }
            }
        });
    }

    public void fillWithRetry(String s, String s2) {
        Color bg = this.browser.getDisplay().getSystemColor(22);
        Color fg = this.browser.getDisplay().getSystemColor(21);
        if (this.autoReloadPending) {
            this.lastRetryData = new String[]{s, s2};
            this.browser.setText("<html><body style='overflow:auto; font-family: verdana; font-size: 10pt' bgcolor=#" + Utils.toColorHexString(bg) + " text=#" + Utils.toColorHexString(fg) + ">" + "<br>Please wait while Vuze attempts to load the page (this can take a moment or two initially) ...<br>" + "</body></html>");
        } else {
            this.browser.setText("<html><body style='overflow:auto; font-family: verdana; font-size: 10pt' bgcolor=#" + Utils.toColorHexString(bg) + " text=#" + Utils.toColorHexString(fg) + ">" + "<br>Sorry, there was a problem loading this page.<br> " + "Please check if your internet connection is working and click <a href='" + this.lastValidURL + "' style=\"color: rgb(100, 155, 255); \">retry</a> to continue." + "<div style='word-wrap: break-word'><font size=1 color=#" + Utils.toColorHexString(bg) + ">" + s + "<br><br>" + s2 + "</font></div>" + "</body></html>");
        }
    }

    private void deregisterBrowser() {
        if (this.browser == null) {
            throw new IllegalStateException("Context " + this.getID() + " doesn't have a registered browser");
        }
        if (!this.browser.isDisposed()) {
            this.browser.setData(CONTEXT_KEY, null);
            this.browser.removeDisposeListener(this);
            this.messageDispatcherSWT.deregisterBrowser(this.browser);
        }
        this.browser = null;
        if (this.checkURLEvent != null && !this.checkURLEvent.isCancelled()) {
            this.checkURLEvent.cancel();
            this.checkURLEvent = null;
        }
    }

    public static BrowserContext getContext(Browser browser) {
        Object data = browser.getData(CONTEXT_KEY);
        if (data != null && !(data instanceof BrowserContext)) {
            Debug.out("Data in Browser with key BrowserContext is not a BrowserContext");
            return null;
        }
        return (BrowserContext)data;
    }

    public void addMessageListener(BrowserMessageListener listener) {
        this.messageDispatcherSWT.addListener(listener);
    }

    public Object getBrowserData(String key) {
        return this.browser.getData(key);
    }

    public void setBrowserData(String key, Object value) {
        this.browser.setData(key, value);
    }

    public boolean sendBrowserMessage(String key, String op) {
        return this.sendBrowserMessage(key, op, (Map)null);
    }

    public boolean sendBrowserMessage(String key, String op, Map params) {
        StringBuffer msg = new StringBuffer();
        msg.append("az.msg.dispatch('").append(key).append("', '").append(op).append("'");
        if (params != null) {
            msg.append(", ").append(JSONUtils.encodeToJSON(params));
        }
        msg.append(")");
        return this.executeInBrowser(msg.toString());
    }

    public boolean sendBrowserMessage(String key, String op, Collection params) {
        StringBuffer msg = new StringBuffer();
        msg.append("az.msg.dispatch('").append(key).append("', '").append(op).append("'");
        if (params != null) {
            msg.append(", ").append(JSONUtils.encodeToJSON(params));
        }
        msg.append(")");
        return this.executeInBrowser(msg.toString());
    }

    protected boolean maySend(String key, String op, Map params) {
        return !this.pageLoading;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeInBrowser(final String javascript) {
        block4: {
            this.mon_listJS.enter();
            try {
                if (this.mayExecute(javascript)) break block4;
                this.listJS.add(javascript);
                boolean bl = false;
                Object var4_4 = null;
                this.mon_listJS.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.mon_listJS.exit();
                throw throwable;
            }
        }
        Object var4_5 = null;
        this.mon_listJS.exit();
        if (this.display == null || this.display.isDisposed()) {
            this.debug("CANNOT: browser.execute( " + this.getShortJavascript(javascript) + " )");
            return false;
        }
        final String reallyExecute = "try { " + javascript + " } catch ( e ) { }";
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (BrowserContext.this.browser == null || BrowserContext.this.browser.isDisposed()) {
                    BrowserContext.this.debug("CANNOT: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                } else if (!BrowserContext.this.browser.execute(reallyExecute)) {
                    BrowserContext.this.debug("FAILED: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                } else {
                    BrowserContext.this.debug("SUCCESS: browser.execute( " + BrowserContext.this.getShortJavascript(javascript) + " )");
                }
            }
        });
        return true;
    }

    protected boolean mayExecute(String javascript) {
        return !this.pageLoading;
    }

    public void widgetDisposed(DisposeEvent event2) {
        if (event2.widget == this.browser.getBrowser()) {
            this.deregisterBrowser();
        }
    }

    private String getShortJavascript(String javascript) {
        if (javascript.length() < 515) {
            return javascript;
        }
        StringBuffer result = new StringBuffer();
        result.append(javascript.substring(0, 256));
        result.append("...");
        result.append(javascript.substring(javascript.length() - 256));
        return result.toString();
    }

    public void setWiggleBrowser(boolean wiggleBrowser) {
        this.wiggleBrowser = wiggleBrowser;
    }

    public boolean isPageLoading() {
        return this.pageLoading;
    }

    public void addListener(loadingListener l) {
        if (this.loadingListeners == Collections.EMPTY_LIST) {
            this.loadingListeners = new ArrayList(1);
        }
        this.loadingListeners.add(l);
    }

    public long getContentNetworkID() {
        return this.contentNetworkID;
    }

    public void setContentNetworkID(long contentNetworkID) {
        this.contentNetworkID = contentNetworkID;
    }

    public void setAllowPopups(boolean allowPopups) {
        this.allowPopups = allowPopups;
    }

    public boolean allowPopups() {
        return this.allowPopups;
    }

    public static interface loadingListener {
        public void browserLoadingChanged(boolean var1, String var2);
    }
}

