/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.torrent;

import com.aelitis.azureus.core.torrent.PlatformTorrentUtils;
import com.aelitis.azureus.ui.common.table.impl.TableColumnImpl;
import com.aelitis.azureus.ui.swt.utils.TorrentUIUtilsV3;
import com.aelitis.azureus.util.DataSourceUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnThumbnail
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "Thumbnail";
    private static final int WIDTH_SMALL = 35;
    private static final int WIDTH_BIG = 60;
    private static final int WIDTH_ACTIVITY = 80;
    private Map mapCellTorrent = new HashMap();

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public ColumnThumbnail(String sTableID) {
        super(COLUMN_ID, 3, -2, 0, sTableID);
        if ("Activity.big".equals(sTableID)) {
            this.initializeAsGraphic(80);
        } else {
            this.initializeAsGraphic(sTableID.endsWith(".big") ? 60 : 35);
        }
    }

    public ColumnThumbnail(TableColumn column) {
        super(null, null);
        column.initialize(3, -2, 60);
        column.addListeners(this);
        ((TableColumnImpl)column).addCellOtherListener("SWTPaint", this);
    }

    public void dispose(TableCell cell) {
        this.mapCellTorrent.remove(cell);
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        TOTorrent newTorrent = DataSourceUtils.getTorrent(ds);
        long sortIndex = PlatformTorrentUtils.isContent(newTorrent, true) ? 0L : 1L;
        boolean bChanged = cell.setSortValue(sortIndex);
        TOTorrent torrent = (TOTorrent)this.mapCellTorrent.get(cell);
        if (!cell.isShown() || newTorrent == torrent && !bChanged && cell.isValid()) {
            return;
        }
        torrent = newTorrent;
        this.mapCellTorrent.put(cell, torrent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cellPaint(GC gc, final TableCellSWT cell) {
        Object ds;
        block17: {
            int dstWidth;
            int dstHeight;
            ds = cell.getDataSource();
            Rectangle cellBounds = cell.getBounds();
            Image[] imgThumbnail = TorrentUIUtilsV3.getContentImage(ds, cellBounds.width >= 20 && cellBounds.height >= 20, new TorrentUIUtilsV3.ContentImageLoadedListener(){

                public void contentImageLoaded(Image image, boolean wasReturned) {
                    if (!wasReturned) {
                        cell.invalidate();
                    }
                }
            });
            if (imgThumbnail == null || imgThumbnail[0] == null) {
                return;
            }
            if (cellBounds.height > 30) {
                cellBounds.y += 2;
                cellBounds.height -= 4;
            }
            Rectangle imgBounds = imgThumbnail[0].getBounds();
            if (imgBounds.height > cellBounds.height) {
                dstHeight = cellBounds.height;
                dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
            } else if (imgBounds.width > cellBounds.width) {
                dstWidth = cellBounds.width - 4;
                dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
            } else {
                dstWidth = imgBounds.width;
                dstHeight = imgBounds.height;
            }
            try {
                gc.setAdvanced(true);
                gc.setInterpolation(2);
            }
            catch (Exception e) {
                // empty catch block
            }
            int x = cellBounds.x + (cellBounds.width - dstWidth + 1) / 2;
            int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
            if (dstWidth > 0 && dstHeight > 0 && !imgBounds.isEmpty()) {
                Rectangle dst = new Rectangle(x, y, dstWidth, dstHeight);
                Rectangle lastClipping = gc.getClipping();
                try {
                    try {
                        gc.setClipping(cellBounds);
                        for (int i = 0; i < imgThumbnail.length; ++i) {
                            int h;
                            int w;
                            Image image = imgThumbnail[i];
                            if (image == null) continue;
                            Rectangle srcBounds = image.getBounds();
                            if (i == 0) {
                                w = dstWidth;
                                h = dstHeight;
                                if (imgThumbnail.length > 1) {
                                    w = w * 9 / 10;
                                    h = h * 9 / 10;
                                }
                                gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                continue;
                            }
                            w = dstWidth * 3 / 8;
                            h = dstHeight * 3 / 8;
                            gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                        }
                        Object var19_20 = null;
                    }
                    catch (Exception e) {
                        Debug.out(e);
                        Object var19_21 = null;
                        gc.setClipping(lastClipping);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    Object var19_22 = null;
                    gc.setClipping(lastClipping);
                    throw throwable;
                }
                gc.setClipping(lastClipping);
            }
        }
        TorrentUIUtilsV3.releaseContentImage(ds);
    }

    public void cellHover(TableCell cell) {
        final Object ds = cell.getDataSource();
        Image[] imgThumbnail = TorrentUIUtilsV3.getContentImage(ds, true, new TorrentUIUtilsV3.ContentImageLoadedListener(){

            public void contentImageLoaded(Image image, boolean wasReturned) {
                TorrentUIUtilsV3.releaseContentImage(ds);
            }
        });
        cell.setToolTip(imgThumbnail == null ? null : imgThumbnail[0]);
    }

    public void cellHoverComplete(TableCell cell) {
        Object ds = cell.getDataSource();
        TorrentUIUtilsV3.releaseContentImage(ds);
    }
}

