/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.mdi.BaseMdiEntry;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.List;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class SubscriptionMDIEntry
implements SubscriptionListener,
ViewTitleInfo {
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String AUTH_IMAGE_ID = "image.sidebar.vitality.auth";
    private final MdiEntry mdiEntry;
    MdiEntryVitalityImage spinnerImage;
    private MdiEntryVitalityImage warningImage;
    private final Subscription subs;
    private String key;

    public SubscriptionMDIEntry(Subscription subs, MdiEntry entry) {
        this.subs = subs;
        this.mdiEntry = entry;
        this.key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        this.setupMdiEntry();
    }

    private void setupMdiEntry() {
        Engine engine;
        if (this.mdiEntry == null) {
            return;
        }
        this.mdiEntry.setViewTitleInfo(this);
        this.mdiEntry.setImageLeftID("image.sidebar.subscriptions");
        this.warningImage = this.mdiEntry.addVitalityImage(ALERT_IMAGE_ID);
        this.spinnerImage = this.mdiEntry.addVitalityImage("image.sidebar.vitality.dots");
        if (this.spinnerImage != null) {
            this.spinnerImage.setVisible(false);
        }
        this.setWarning();
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.forcecheck");
        menuItem.setText(MessageText.getString("Subscription.menu.forcecheck"));
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                try {
                    subs.getManager().getScheduler().downloadAsync(subs, true);
                }
                catch (SubscriptionException e) {
                    Debug.out(e);
                }
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.clearall");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().markAllResultsRead();
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.dirtyall");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().markAllResultsUnread();
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.deleteall");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().deleteAllResults();
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.reset");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().reset();
                try {
                    subs.getEngine().reset();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                try {
                    subs.getManager().getScheduler().downloadAsync(subs, true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        try {
            engine = this.subs.getEngine();
            if (engine instanceof WebEngine && ((WebEngine)engine).isNeedsAuth()) {
                menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.resetauth");
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(MdiEntry info, Subscription subs) {
                        try {
                            Engine engine = subs.getEngine();
                            if (engine instanceof WebEngine) {
                                ((WebEngine)engine).setCookies(null);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        try {
                            subs.getManager().getScheduler().downloadAsync(subs, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.setcookies");
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(MdiEntry info, final Subscription subs) {
                        try {
                            Engine engine = subs.getEngine();
                            if (engine instanceof WebEngine) {
                                final WebEngine we = (WebEngine)engine;
                                SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                                String[] req = we.getRequiredCookies();
                                String req_str = "";
                                for (String r : req) {
                                    req_str = req_str + (req_str.length() == 0 ? "" : ";") + r + "=?";
                                }
                                entry.setPreenteredText(req_str, true);
                                entry.maintainWhitespace(false);
                                entry.allowEmptyInput(false);
                                entry.setTitle("general.enter.cookies");
                                entry.prompt(new UIInputReceiverListener(){

                                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                                        if (!entry.hasSubmittedInput()) {
                                            return;
                                        }
                                        try {
                                            String input = entry.getSubmittedInput().trim();
                                            if (input.length() > 0) {
                                                we.setCookies(input);
                                                subs.getManager().getScheduler().downloadAsync(subs, true);
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        menuManager.addMenuItem("sidebar." + this.key, "s1").setStyle(4);
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "MyTorrentsView.menu.setCategory");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                SubscriptionMDIEntry.this.addCategorySubMenu(menuManager, menu);
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "label.tag");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                SubscriptionMDIEntry.this.addTagSubMenu(menuManager, menu);
            }
        });
        if (this.subs.isUpdateable()) {
            menuItem = menuManager.addMenuItem("sidebar." + this.key, "MyTorrentsView.menu.rename");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(MdiEntry info, final Subscription subs) {
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.setPreenteredText(subs.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{subs.getName()}));
                    entry.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                try {
                                    subs.setName(input);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                    });
                }
            });
        }
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.upgrade");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.resetHighestVersion();
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setVisible(SubscriptionMDIEntry.this.subs.getHighestVersion() > SubscriptionMDIEntry.this.subs.getVersion());
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.export");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                SubscriptionMDIEntry.this.export();
            }
        });
        menuManager.addMenuItem("sidebar." + this.key, "s2").setStyle(4);
        try {
            engine = this.subs.getEngine();
            if (engine instanceof WebEngine) {
                menuItem = menuManager.addMenuItem("sidebar." + this.key, "menu.change.url");
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(MdiEntry info, Subscription _subs) {
                        SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                        try {
                            WebEngine web_engine = (WebEngine)SubscriptionMDIEntry.this.subs.getEngine();
                            entry.setPreenteredText(web_engine.getSearchUrl(true), false);
                            entry.maintainWhitespace(false);
                            entry.allowEmptyInput(false);
                            entry.setLocalisedTitle(MessageText.getString("change.url.msg.title", new String[]{SubscriptionMDIEntry.this.subs.getName()}));
                            entry.setMessage("change.url.msg.desc");
                            entry.prompt(new UIInputReceiverListener(){

                                public void UIInputReceiverClosed(UIInputReceiver entry) {
                                    if (!entry.hasSubmittedInput()) {
                                        return;
                                    }
                                    String input = entry.getSubmittedInput().trim();
                                    if (input.length() > 0) {
                                        try {
                                            WebEngine web_engine = (WebEngine)SubscriptionMDIEntry.this.subs.getEngine();
                                            web_engine.setSearchUrl(input);
                                            SubscriptionMDIEntry.this.subs.cloneWithNewEngine(web_engine);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            });
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "subs.prop.is_public");
        menuItem.setStyle(2);
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(SubscriptionMDIEntry.this.subs.isPublic());
            }
        });
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription _subs) {
                try {
                    SubscriptionMDIEntry.this.subs.setPublic(!SubscriptionMDIEntry.this.subs.isPublic());
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        if (this.subs.isAutoDownloadSupported()) {
            menuItem = menuManager.addMenuItem("sidebar." + this.key, "subs.prop.is_auto");
            menuItem.setStyle(2);
            menuItem.addFillListener(new MenuItemFillListener(){

                public void menuWillBeShown(MenuItem menu, Object data) {
                    menu.setData(SubscriptionMDIEntry.this.subs.getHistory().isAutoDownload());
                }
            });
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(MdiEntry info, Subscription _subs) {
                    try {
                        SubscriptionMDIEntry.this.subs.getHistory().setAutoDownload(!SubscriptionMDIEntry.this.subs.getHistory().isAutoDownload());
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            });
        }
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "subs.prop.update_period");
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                int check_freq = SubscriptionMDIEntry.this.subs.getHistory().getCheckFrequencyMins();
                String text = MessageText.getString("subs.prop.update_period");
                if (check_freq != Integer.MAX_VALUE) {
                    text = text + " (" + check_freq + " " + MessageText.getString("ConfigView.text.minutes") + ")";
                }
                menu.setText(text + "...");
            }
        });
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, final Subscription subs) {
                SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                entry.maintainWhitespace(false);
                entry.allowEmptyInput(false);
                int check_freq = subs.getHistory().getCheckFrequencyMins();
                entry.setPreenteredText(check_freq == Integer.MAX_VALUE ? "" : String.valueOf(check_freq), false);
                entry.maintainWhitespace(false);
                entry.allowEmptyInput(false);
                entry.setLocalisedTitle(MessageText.getString("subscriptions.enter.freq"));
                entry.prompt(new UIInputReceiverListener(){

                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                        if (!entry.hasSubmittedInput()) {
                            return;
                        }
                        String input = entry.getSubmittedInput().trim();
                        if (input.length() > 0) {
                            try {
                                subs.getHistory().setCheckFrequencyMins(Integer.parseInt(input));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                });
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "MyTorrentsView.menu.rename");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, final Subscription subs) {
                SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                entry.maintainWhitespace(false);
                entry.allowEmptyInput(false);
                entry.setPreenteredText(subs.getName(), false);
                entry.maintainWhitespace(false);
                entry.allowEmptyInput(false);
                entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{subs.getName()}));
                entry.prompt(new UIInputReceiverListener(){

                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                        if (!entry.hasSubmittedInput()) {
                            return;
                        }
                        String input = entry.getSubmittedInput().trim();
                        if (input.length() > 0) {
                            subs.setLocalName(input);
                        }
                    }
                });
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.remove");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                SubscriptionMDIEntry.this.removeWithConfirm();
            }
        });
        menuManager.addMenuItem("sidebar." + this.key, "s3").setStyle(4);
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.properties");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                SubscriptionMDIEntry.this.showProperties();
            }
        });
        this.subs.addListener(this);
    }

    public void subscriptionDownloaded(Subscription subs, boolean auto) {
    }

    public void subscriptionChanged(Subscription subs) {
        this.mdiEntry.redraw();
        ViewTitleInfoManager.refreshTitleInfo(this.mdiEntry.getViewTitleInfo());
    }

    protected void refreshView() {
        if (!(this.mdiEntry instanceof BaseMdiEntry)) {
            return;
        }
        UISWTViewEventListener eventListener = ((BaseMdiEntry)this.mdiEntry).getEventListener();
        if (eventListener instanceof SubscriptionView) {
            SubscriptionView subsView = (SubscriptionView)eventListener;
            subsView.refreshView();
        }
    }

    protected void setWarning() {
        boolean trouble;
        if (this.warningImage == null) {
            return;
        }
        SubscriptionHistory history = this.subs.getHistory();
        String last_error = history.getLastError();
        boolean auth_fail = history.isAuthFail();
        if (history.getConsecFails() < 3 && !auth_fail) {
            last_error = null;
        }
        boolean bl = trouble = last_error != null;
        if (trouble) {
            this.warningImage.setToolTip(last_error);
            this.warningImage.setImageID(auth_fail ? AUTH_IMAGE_ID : ALERT_IMAGE_ID);
            this.warningImage.setVisible(true);
        } else {
            this.warningImage.setVisible(false);
            this.warningImage.setToolTip("");
        }
    }

    private void addCategorySubMenu(MenuManager menu_manager, MenuItem menu) {
        MenuItem m;
        menu.removeAllChildItems();
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            String assigned_category = this.subs.getCategory();
            final Category uncat = CategoryManager.getCategory(2);
            if (uncat != null) {
                m = menu_manager.addMenuItem(menu, uncat.getName());
                m.setStyle(3);
                m.setData(new Boolean(assigned_category == null));
                m.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionMDIEntry.this.assignSelectedToCategory(uncat);
                    }
                });
                m = menu_manager.addMenuItem(menu, "sep1");
                m.setStyle(4);
            }
            for (int i = 0; i < categories.length; ++i) {
                Object cat = categories[i];
                if (cat.getType() != 0) continue;
                m = menu_manager.addMenuItem(menu, "!" + cat.getName() + "!");
                m.setStyle(3);
                m.setData(new Boolean(assigned_category != null && assigned_category.equals(cat.getName())));
                m.addListener(new MenuItemListener((Category)cat){
                    final /* synthetic */ Category val$cat;
                    {
                        this.val$cat = category;
                    }

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionMDIEntry.this.assignSelectedToCategory(this.val$cat);
                    }
                });
            }
            m = menu_manager.addMenuItem(menu, "sep2");
            m.setStyle(4);
        }
        m = menu_manager.addMenuItem(menu, "MyTorrentsView.menu.setCategory.add");
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SubscriptionMDIEntry.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(Category category) {
        if (category.getType() == 2) {
            this.subs.setCategory(null);
        } else {
            this.subs.setCategory(category.getName());
        }
    }

    private void addTagSubMenu(MenuManager menu_manager, MenuItem menu) {
        menu.removeAllChildItems();
        TagManager tm = TagManagerFactory.getTagManager();
        List<Tag> tags = tm.getTagType(3).getTags();
        tags = TagUIUtils.sortTags(tags);
        long tag_id = this.subs.getTagID();
        Tag assigned_tag = tm.lookupTagByUID(tag_id);
        MenuItem m = menu_manager.addMenuItem(menu, "label.no.tag");
        m.setStyle(3);
        m.setData(new Boolean(assigned_tag == null));
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SubscriptionMDIEntry.this.subs.setTagID(-1L);
            }
        });
        m = menu_manager.addMenuItem(menu, "sep1");
        m.setStyle(4);
        ArrayList<String> menu_names = new ArrayList<String>();
        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
        for (Tag t : tags) {
            if (t.isTagAuto()) continue;
            String name = t.getTagName(true);
            menu_names.add(name);
            menu_name_map.put(name, t);
        }
        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
        for (Object obj : menu_structure) {
            MenuItem parent_menu;
            ArrayList<Object> bucket_tags = new ArrayList<Object>();
            if (obj instanceof String) {
                parent_menu = menu;
                bucket_tags.add(menu_name_map.get((String)obj));
            } else {
                Object[] entry = (Object[])obj;
                List list = (List)entry[1];
                boolean has_selected = false;
                for (String name : list) {
                    Tag tag = (Tag)menu_name_map.get(name);
                    bucket_tags.add(tag);
                    if (assigned_tag != tag) continue;
                    has_selected = true;
                }
                parent_menu = menu_manager.addMenuItem(menu, "!" + (String)entry[0] + (has_selected ? " (*)" : "") + "!");
                parent_menu.setStyle(5);
            }
            for (final Tag tag : bucket_tags) {
                m = menu_manager.addMenuItem(parent_menu, tag.getTagName(false));
                m.setStyle(3);
                m.setData(new Boolean(assigned_tag == tag));
                m.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionMDIEntry.this.subs.setTagID(tag.getTagUID());
                    }
                });
            }
        }
        m = menu_manager.addMenuItem(menu, "sep2");
        m.setStyle(4);
        m = menu_manager.addMenuItem(menu, "label.add.tag");
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SubscriptionMDIEntry.this.addTag();
            }
        });
    }

    private void addTag() {
        Tag new_tag = TagUIUtils.createManualTag();
        if (new_tag != null) {
            this.subs.setTagID(new_tag.getTagUID());
        }
    }

    protected void export() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("subscript.export.select.template.file"));
                dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    String lc = path.toLowerCase();
                    if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                        path = path + ".vuze";
                    }
                    try {
                        VuzeFile vf = SubscriptionMDIEntry.this.subs.getVuzeFile();
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void removeWithConfirm() {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{this.subs.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
        mb.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == 0) {
                    SubscriptionMDIEntry.this.subs.setSubscribed(false);
                }
            }
        });
    }

    protected void showProperties() {
        String engine_str;
        SubscriptionHistory history = this.subs.getHistory();
        SimpleDateFormat df = new SimpleDateFormat();
        String last_error = history.getLastError();
        if (last_error == null) {
            last_error = "";
        }
        String auth_str = String.valueOf(false);
        try {
            WebEngine web_engine;
            Engine engine = this.subs.getEngine();
            engine_str = engine.getNameEx();
            if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                auth_str = String.valueOf(true) + ": cookies=" + this.toString(web_engine.getRequiredCookies());
            }
        }
        catch (Throwable e) {
            engine_str = "Unknown";
            auth_str = "";
        }
        String[] keys = new String[]{"subs.prop.enabled", "subs.prop.is_public", "subs.prop.is_auto", "subs.prop.is_auto_ok", "subs.prop.update_period", "subs.prop.last_scan", "subs.prop.last_result", "subs.prop.next_scan", "subs.prop.last_error", "subs.prop.num_read", "subs.prop.num_unread", "subs.prop.assoc", "subs.prop.version", "subs.prop.high_version", "subscriptions.listwindow.popularity", "subs.prop.template", "subs.prop.auth", "TableColumn.header.category", "TableColumn.header.tag.name"};
        String category = this.subs.getCategory();
        String category_str = category == null ? MessageText.getString("Categories.uncategorized") : category;
        Tag tag = TagManagerFactory.getTagManager().lookupTagByUID(this.subs.getTagID());
        String tag_str = tag == null ? "" : tag.getTagName(true);
        int check_freq = history.getCheckFrequencyMins();
        long last_new_result = history.getLastNewResultTime();
        long next_scan = history.getNextScanTime();
        String[] values = new String[]{String.valueOf(history.isEnabled()), String.valueOf(this.subs.isPublic()), String.valueOf(history.isAutoDownload()), String.valueOf(this.subs.isAutoDownloadSupported()), check_freq == Integer.MAX_VALUE ? "" : String.valueOf(history.getCheckFrequencyMins() + " " + MessageText.getString("ConfigView.text.minutes")), df.format(new Date(history.getLastScanTime())), last_new_result == 0L ? "" : df.format(new Date(last_new_result)), next_scan == Long.MAX_VALUE ? "" : df.format(new Date(next_scan)), last_error.length() == 0 ? MessageText.getString("PeersView.uniquepiece.none") : last_error, String.valueOf(history.getNumRead()), String.valueOf(history.getNumUnread()), String.valueOf(this.subs.getAssociationCount()), String.valueOf(this.subs.getVersion()), this.subs.getHighestVersion() > this.subs.getVersion() ? String.valueOf(this.subs.getHighestVersion()) : null, this.subs.getCachedPopularity() <= 1L ? null : String.valueOf(this.subs.getCachedPopularity()), engine_str, auth_str, category_str, tag_str};
        new PropertiesWindow(this.subs.getName(), keys, values);
    }

    private String toString(String[] strs) {
        String res = "";
        for (int i = 0; i < strs.length; ++i) {
            res = res + (i == 0 ? "" : ",") + strs[i];
        }
        return res;
    }

    public Object getTitleInfoProperty(int propertyID) {
        switch (propertyID) {
            case 5: {
                return this.subs.getName();
            }
            case 1: {
                long pop = this.subs.getCachedPopularity();
                String res = this.subs.getName();
                if (pop > 1L) {
                    res = res + " (" + MessageText.getString("subscriptions.listwindow.popularity").toLowerCase() + "=" + pop + ")";
                }
                return res;
            }
            case 0: {
                SubscriptionMDIEntry mdi = (SubscriptionMDIEntry)this.subs.getUserData(SubscriptionManagerUI.SUB_ENTRYINFO_KEY);
                if (mdi != null) {
                    mdi.setWarning();
                }
                if (this.subs.getHistory().getNumUnread() > 0) {
                    return "" + this.subs.getHistory().getNumUnread();
                }
                return null;
            }
        }
        return null;
    }

    public static abstract class SubsMenuItemListener
    implements MenuItemListener {
        public final void selected(MenuItem menu, Object target) {
            if (target instanceof MdiEntry) {
                MdiEntry info = (MdiEntry)target;
                Subscription subs = (Subscription)info.getDatasource();
                try {
                    this.selected(info, subs);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }

        public abstract void selected(MdiEntry var1, Subscription var2);
    }
}

