/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc.impl;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerException;
import com.aelitis.net.udp.uc.PRUDPPacketHandlerStats;
import com.aelitis.net.udp.uc.PRUDPPacketReceiver;
import com.aelitis.net.udp.uc.PRUDPPrimordialHandler;
import com.aelitis.net.udp.uc.PRUDPRequestHandler;
import com.aelitis.net.udp.uc.impl.PRUDPPacketHandlerImpl;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Socket;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.Debug;

public class PRUDPPacketHandlerSocks
implements PRUDPPacketHandler,
PRUDPPacketHandlerImpl.PacketTransformer {
    private static String socks_host;
    private static int socks_port;
    private static String socks_user;
    private static String socks_password;
    private final InetSocketAddress target;
    private Socket control_socket;
    private InetSocketAddress relay;
    private PRUDPPacketHandler delegate;
    private byte[] packet_out_header;

    /*
     * Exception decompiling
     */
    protected PRUDPPacketHandlerSocks(InetSocketAddress _target) throws PRUDPPacketHandlerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Missing node tying up JSR block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.tieUpRelations(Op02WithProcessedDataAndRefs.java:2900)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.copyBlock(Op02WithProcessedDataAndRefs.java:2889)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.inlineJSR(Op02WithProcessedDataAndRefs.java:2845)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSRs(Op02WithProcessedDataAndRefs.java:2591)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.processJSR(Op02WithProcessedDataAndRefs.java:2481)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:444)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void transformSend(DatagramPacket packet) {
        if (this.relay == null) {
            return;
        }
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        byte[] new_data = new byte[data_len + this.packet_out_header.length];
        System.arraycopy(this.packet_out_header, 0, new_data, 0, this.packet_out_header.length);
        System.arraycopy(data, 0, new_data, this.packet_out_header.length, data_len);
        packet.setData(new_data);
    }

    public void transformReceive(DatagramPacket packet) {
        if (this.relay == null) {
            return;
        }
        byte[] data = packet.getData();
        int data_len = packet.getLength();
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data, 0, data_len));
        try {
            dis.readByte();
            dis.readByte();
            dis.readByte();
            byte atype = dis.readByte();
            int encap_len = 4;
            encap_len = atype == 1 ? (encap_len += 4) : (atype == 3 ? (encap_len += 1 + (dis.readByte() & 0xFF)) : (encap_len += 16));
            byte[] new_data = new byte[data_len - (encap_len += 2)];
            System.arraycopy(data, encap_len, new_data, 0, data_len - encap_len);
            packet.setData(new_data);
        }
        catch (IOException e) {
            Debug.out(e);
        }
    }

    private void checkAddress(InetSocketAddress destination) throws PRUDPPacketHandlerException {
        if (!destination.equals(this.target)) {
            throw new PRUDPPacketHandlerException("Destination mismatch");
        }
    }

    public void sendAndReceive(PRUDPPacket request_packet, InetSocketAddress destination_address, PRUDPPacketReceiver receiver, long timeout, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        this.delegate.sendAndReceive(request_packet, destination_address, receiver, timeout, priority);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address, timeout_millis);
    }

    public PRUDPPacket sendAndReceive(PasswordAuthentication auth, PRUDPPacket request_packet, InetSocketAddress destination_address, long timeout_millis, int priority) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        return this.delegate.sendAndReceive(auth, request_packet, destination_address, timeout_millis, priority);
    }

    public void send(PRUDPPacket request_packet, InetSocketAddress destination_address) throws PRUDPPacketHandlerException {
        this.checkAddress(destination_address);
        if (this.relay != null) {
            destination_address = this.relay;
        }
        this.delegate.send(request_packet, destination_address);
    }

    public PRUDPRequestHandler getRequestHandler() {
        return this.delegate.getRequestHandler();
    }

    public void setRequestHandler(PRUDPRequestHandler request_handler) {
        this.delegate.setRequestHandler(request_handler);
    }

    public void primordialSend(byte[] data, InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not imp");
    }

    public boolean hasPrimordialHandler() {
        return this.delegate.hasPrimordialHandler();
    }

    public void addPrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    public void removePrimordialHandler(PRUDPPrimordialHandler handler) {
    }

    public int getPort() {
        return this.delegate.getPort();
    }

    public InetAddress getBindIP() {
        return this.delegate.getBindIP();
    }

    public void setDelays(int send_delay, int receive_delay, int queued_request_timeout) {
        this.delegate.setDelays(send_delay, receive_delay, queued_request_timeout);
    }

    public void setExplicitBindAddress(InetAddress address) {
        this.delegate.setExplicitBindAddress(address);
    }

    public PRUDPPacketHandlerStats getStats() {
        return this.delegate.getStats();
    }

    public PRUDPPacketHandler openSession(InetSocketAddress target) throws PRUDPPacketHandlerException {
        throw new PRUDPPacketHandlerException("not supported");
    }

    public void closeSession() throws PRUDPPacketHandlerException {
        if (this.control_socket != null) {
            try {
                this.control_socket.close();
                this.control_socket = null;
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        if (this.delegate != null) {
            this.delegate.destroy();
        }
    }

    public void destroy() {
        try {
            this.closeSession();
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Host", "Proxy.Port", "Proxy.Username", "Proxy.Password"}, new ParameterListener(){

            public void parameterChanged(String parameter_name) {
                socks_host = COConfigurationManager.getStringParameter("Proxy.Host").trim();
                socks_port = Integer.parseInt(COConfigurationManager.getStringParameter("Proxy.Port").trim());
                socks_user = COConfigurationManager.getStringParameter("Proxy.Username").trim();
                socks_password = COConfigurationManager.getStringParameter("Proxy.Password").trim();
                if (socks_user.equalsIgnoreCase("<none>")) {
                    socks_user = "";
                }
            }
        });
    }
}

