/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerLimitEstimate;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingMapper;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerManagerStats;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class DownloadManagerRateController {
    private static AzureusCore core;
    private static SpeedManager speed_manager;
    private static Map<PEPeerManager, PMState> pm_map;
    private static TimerEventPeriodic timer;
    private static AsyncDispatcher dispatcher;
    private static boolean enable;
    private static boolean enable_limit_handling;
    private static int slack_bytes_per_sec;
    private static volatile int rate_limit;
    private static LimitedRateGroup limiter;
    private static final int TIMER_MILLIS = 1000;
    private static final int WAIT_AFTER_CHOKE_PERIOD = 10000;
    private static final int WAIT_AFTER_CHOKE_TICKS = 10;
    private static final int DEFAULT_UP_LIMIT = 256000;
    private static final int MAX_UP_DIFF = 15360;
    private static final int MAX_DOWN_DIFF = 10240;
    private static final int MIN_DIFF = 2048;
    private static final int SAMPLE_COUNT = 5;
    private static int sample_num;
    private static double incomplete_samples;
    private static double complete_samples;
    private static int ticks_to_sample_start;
    private static int last_rate_limit;
    private static double last_incomplete_average;
    private static double last_complete_average;
    private static double last_overall_average;
    private static int tick_count;
    private static int last_tick_processed;
    private static long pm_last_bad_limit;
    private static int latest_choke;
    private static int wait_until_tick;

    public static String getString() {
        if (enable) {
            String str = "reserved=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(slack_bytes_per_sec);
            if (enable_limit_handling) {
                str = str + ", limit=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(rate_limit);
                str = str + ", last[choke=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(latest_choke) + ", ratio=" + DisplayFormatters.formatDecimal(last_incomplete_average / last_complete_average, 2) + "]";
                return str;
            }
            return str;
        }
        return "Disabled";
    }

    public static void addPeerManager(final PEPeerManager pm) {
        dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                if (core == null) {
                    core = AzureusCoreFactory.getSingleton();
                    speed_manager = core.getSpeedManager();
                }
                boolean is_complete = !pm.hasDownloadablePiece();
                PEPeerManagerStats pm_stats = pm.getStats();
                long up_bytes = pm_stats.getTotalDataBytesSentNoLan() + pm_stats.getTotalProtocolBytesSentNoLan();
                if (is_complete) {
                    pm.addRateLimiter(limiter, true);
                }
                pm_map.put(pm, new PMState(pm, is_complete, up_bytes));
                if (timer == null) {
                    timer = SimpleTimer.addPeriodicEvent("DMRC", 1000L, new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            dispatcher.dispatch(new AERunnable(){

                                public void runSupport() {
                                    DownloadManagerRateController.update();
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    public static void removePeerManager(final PEPeerManager pm) {
        dispatcher.dispatch(new AERunnable(){

            public void runSupport() {
                pm_map.remove(pm);
                if (pm_map.size() == 0) {
                    timer.cancel();
                    timer = null;
                    rate_limit = 0;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void update() {
        block46: {
            ++tick_count;
            if (!enable_limit_handling || pm_map.size() == 0 || NetworkManager.isSeedingOnlyUploadRate() || NetworkManager.getMaxUploadRateBPSNormal() != 0 || core == null || speed_manager == null || speed_manager.getSpeedTester() == null) {
                rate_limit = 0;
                return;
            }
            int num_complete = 0;
            int num_incomplete = 0;
            int num_interesting = 0;
            int i_up_total = 0;
            int c_up_total = 0;
            long mono_now = SystemTime.getMonotonousTime();
            for (Map.Entry<PEPeerManager, PMState> entry : pm_map.entrySet()) {
                PEPeerManager pm = entry.getKey();
                PMState state = entry.getValue();
                boolean is_complete = !pm.hasDownloadablePiece();
                PEPeerManagerStats pm_stats = pm.getStats();
                long up_bytes = pm_stats.getTotalDataBytesSentNoLan() + pm_stats.getTotalProtocolBytesSentNoLan();
                long diff = state.setBytesUp(up_bytes);
                if (is_complete) {
                    ++num_complete;
                    c_up_total = (int)((long)c_up_total + diff);
                } else {
                    ++num_incomplete;
                    i_up_total = (int)((long)i_up_total + diff);
                    if (state.isInteresting(mono_now)) {
                        ++num_interesting;
                    }
                }
                if (state.isComplete() == is_complete) continue;
                if (is_complete) {
                    pm.addRateLimiter(limiter, true);
                } else {
                    pm.removeRateLimiter(limiter, true);
                }
                state.setComplete(is_complete);
            }
            if (num_incomplete == 0 || num_complete == 0 || num_interesting == 0) {
                rate_limit = 0;
                return;
            }
            boolean skipped_tick = false;
            if (last_tick_processed != tick_count - 1) {
                pm_last_bad_limit = 0L;
                latest_choke = 0;
                wait_until_tick = 0;
                ticks_to_sample_start = 0;
                sample_num = 0;
                incomplete_samples = 0.0;
                complete_samples = 0.0;
                skipped_tick = true;
            }
            last_tick_processed = tick_count;
            if (skipped_tick || tick_count < wait_until_tick) {
                return;
            }
            try {
                int new_rate_limit3;
                double overall_average;
                double complete_average;
                double incomplete_average;
                block48: {
                    int action;
                    block47: {
                        int last_bad_limit;
                        SpeedManagerLimitEstimate last_bad;
                        long real_now = SystemTime.getCurrentTime();
                        SpeedManagerPingMapper mapper = speed_manager.getActiveMapper();
                        if (rate_limit == 0 && (rate_limit = speed_manager.getEstimatedUploadCapacityBytesPerSec().getBytesPerSec()) == 0) {
                            rate_limit = 256000;
                        }
                        if ((last_bad = mapper.getLastBadUploadLimit()) != null && (long)(last_bad_limit = last_bad.getBytesPerSec()) != pm_last_bad_limit) {
                            pm_last_bad_limit = last_bad_limit;
                            SpeedManagerLimitEstimate[] bad_ups = mapper.getBadUploadHistory();
                            int total = last_bad.getBytesPerSec();
                            int count = 1;
                            for (SpeedManagerLimitEstimate bad : bad_ups) {
                                long t = bad.getWhen();
                                if (real_now - t > 30000L || bad.getBytesPerSec() == last_bad_limit) continue;
                                total += bad.getBytesPerSec();
                                ++count;
                            }
                            latest_choke = total / count;
                            int new_rate_limit2 = rate_limit == 0 ? latest_choke / 2 : rate_limit / 2;
                            if (new_rate_limit2 < slack_bytes_per_sec) {
                                new_rate_limit2 = slack_bytes_per_sec;
                            }
                            rate_limit = new_rate_limit2;
                            wait_until_tick = tick_count + 10;
                            ticks_to_sample_start = 0;
                            sample_num = 0;
                            complete_samples = 0.0;
                            incomplete_samples = 0.0;
                            last_rate_limit = 0;
                            Object var33_32 = null;
                            return;
                        }
                        if (ticks_to_sample_start > 0) {
                            --ticks_to_sample_start;
                            break block46;
                        }
                        if (sample_num < 5) {
                            complete_samples += (double)c_up_total;
                            incomplete_samples += (double)i_up_total;
                            ++sample_num;
                            break block46;
                        }
                        incomplete_average = incomplete_samples / 5.0;
                        complete_average = complete_samples / 5.0;
                        overall_average = (complete_samples + incomplete_samples) / 5.0;
                        action = -1;
                        try {
                            if (last_rate_limit == 0) {
                                action = 1;
                            } else {
                                double overall_change = overall_average - last_overall_average;
                                if (overall_change < 0.0) {
                                    action = rate_limit < last_rate_limit ? 1 : 0;
                                } else {
                                    double i_up_change;
                                    double last_ratio = last_incomplete_average / last_complete_average;
                                    double ratio = incomplete_average / complete_average;
                                    action = rate_limit < last_rate_limit && ratio >= last_ratio ? -1 : (rate_limit > last_rate_limit && ratio <= last_ratio ? ((i_up_change = incomplete_average - last_incomplete_average) >= 1024.0 ? -1 : 1) : 1);
                                }
                            }
                            Object var28_38 = null;
                            if (action <= 0) break block47;
                        }
                        catch (Throwable throwable) {
                            int new_rate_limit3;
                            Object var28_39 = null;
                            if (action > 0) {
                                int ceiling = latest_choke == 0 ? 256000 : latest_choke;
                                int diff = (ceiling - rate_limit) / 4;
                                if (diff > 15360) {
                                    diff = 15360;
                                } else if (diff < 2048) {
                                    diff = 2048;
                                }
                                new_rate_limit3 = rate_limit + diff;
                                if (new_rate_limit3 > 0x6400000) {
                                    new_rate_limit3 = 0x6400000;
                                }
                            } else if (action < 0) {
                                int diff = rate_limit / 5;
                                if (diff > 10240) {
                                    diff = 10240;
                                } else if (diff < 2048) {
                                    diff = 2048;
                                }
                                new_rate_limit3 = rate_limit - diff;
                                if (new_rate_limit3 < slack_bytes_per_sec) {
                                    new_rate_limit3 = slack_bytes_per_sec;
                                }
                            } else {
                                new_rate_limit3 = rate_limit;
                            }
                            last_rate_limit = rate_limit;
                            last_overall_average = overall_average;
                            last_complete_average = complete_average;
                            last_incomplete_average = incomplete_average;
                            rate_limit = new_rate_limit3;
                            sample_num = 0;
                            complete_samples = 0.0;
                            incomplete_samples = 0.0;
                            throw throwable;
                        }
                        int ceiling = latest_choke == 0 ? 256000 : latest_choke;
                        int diff = (ceiling - rate_limit) / 4;
                        if (diff > 15360) {
                            diff = 15360;
                        } else if (diff < 2048) {
                            diff = 2048;
                        }
                        new_rate_limit3 = rate_limit + diff;
                        if (new_rate_limit3 > 0x6400000) {
                            new_rate_limit3 = 0x6400000;
                        }
                        break block48;
                    }
                    if (action < 0) {
                        int diff = rate_limit / 5;
                        if (diff > 10240) {
                            diff = 10240;
                        } else if (diff < 2048) {
                            diff = 2048;
                        }
                        new_rate_limit3 = rate_limit - diff;
                        if (new_rate_limit3 < slack_bytes_per_sec) {
                            new_rate_limit3 = slack_bytes_per_sec;
                        }
                    } else {
                        new_rate_limit3 = rate_limit;
                    }
                }
                last_rate_limit = rate_limit;
                last_overall_average = overall_average;
                last_complete_average = complete_average;
                last_incomplete_average = incomplete_average;
                rate_limit = new_rate_limit3;
                sample_num = 0;
                complete_samples = 0.0;
                incomplete_samples = 0.0;
                {
                }
            }
            catch (Throwable throwable) {
                Object var33_34 = null;
                throw throwable;
            }
        }
        Object var33_33 = null;
    }

    static {
        pm_map = new HashMap<PEPeerManager, PMState>();
        dispatcher = new AsyncDispatcher("DMCRateController");
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Bias Upload Enable", "Bias Upload Handle No Limit", "Bias Upload Slack KBs"}, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                enable = COConfigurationManager.getBooleanParameter("Bias Upload Enable");
                enable_limit_handling = COConfigurationManager.getBooleanParameter("Bias Upload Handle No Limit") && enable;
                slack_bytes_per_sec = COConfigurationManager.getIntParameter("Bias Upload Slack KBs") * 1024;
            }
        });
        rate_limit = 0;
        limiter = new LimitedRateGroup(){

            public String getName() {
                return "DMRC";
            }

            public int getRateLimitBytesPerSecond() {
                return rate_limit;
            }

            public void updateBytesUsed(int used) {
            }
        };
        tick_count = 0;
        last_tick_processed = -1;
    }

    private static class PMState {
        private final PEPeerManager manager;
        private boolean complete;
        private long bytes_up;
        private boolean interesting;
        private long last_interesting_calc;

        private PMState(PEPeerManager _manager, boolean _complete, long _bytes_up) {
            this.manager = _manager;
            this.complete = _complete;
            this.bytes_up = _bytes_up;
        }

        private boolean isComplete() {
            return this.complete;
        }

        private void setComplete(boolean c) {
            this.complete = c;
        }

        private long setBytesUp(long b) {
            long diff = b - this.bytes_up;
            this.bytes_up = b;
            return diff;
        }

        private boolean isInteresting(long now) {
            boolean calc;
            if (this.last_interesting_calc == 0L) {
                calc = true;
            } else if (!this.interesting) {
                calc = now - this.last_interesting_calc >= 5000L;
            } else {
                boolean bl = calc = now - this.last_interesting_calc >= 60000L;
            }
            if (calc) {
                int limit;
                this.last_interesting_calc = now;
                PEPeerManagerStats stats2 = this.manager.getStats();
                long dl_rate = stats2.getDataReceiveRate();
                this.interesting = dl_rate < 5120L ? false : (this.manager.getNbPeersUnchoked() < 3 ? false : (limit = this.manager.getUploadRateLimitBytesPerSecond()) <= 0 || stats2.getDataSendRate() + stats2.getProtocolSendRate() < (long)(limit - 5120));
            }
            return this.interesting;
        }
    }
}

