/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.painted;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsLogger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableCellSWTBase;
import org.gudy.azureus2.ui.swt.views.table.impl.TableRowSWTBase;
import org.gudy.azureus2.ui.swt.views.table.painted.TableCellPainted;
import org.gudy.azureus2.ui.swt.views.table.painted.TableViewPainted;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnSWTUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableRowPainted
extends TableRowSWTBase {
    private static final boolean DEBUG_SUBS = true;
    private Point drawOffset = new Point(0, 0);
    private int numSubItems;
    private Object[] subDataSources;
    private TableRowPainted[] subRows;
    private Object subRows_sync;
    private int subRowsHeight;
    private TableCellCore cellSort;
    public static final Color[] alternatingColors = new Color[]{null, Colors.colorAltRow};
    private int height = 0;
    private boolean initializing = true;
    private Color colorFG = null;

    public TableRowPainted(TableRowCore parentRow, TableViewPainted tv, Object dataSource, boolean triggerHeightChange) {
        super(tv.getSyncObject(), parentRow, tv, dataSource);
        this.subRows_sync = tv.getSyncObject();
        TableColumnCore sortColumn = tv.getSortColumn();
        if (sortColumn != null && (parentRow == null || sortColumn.handlesDataSourceType(this.getDataSource(false).getClass()))) {
            this.cellSort = new TableCellPainted(this, sortColumn, sortColumn.getPosition());
        }
        if (this.height == 0) {
            this.setHeight(tv.getRowDefaultHeight(), false);
        }
        this.initializing = false;
        if (triggerHeightChange) {
            this.heightChanged(0, this.height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildCells() {
        TableColumnCore[] visibleColumns = this.getView().getVisibleColumns();
        if (visibleColumns == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.mTableCells = new LinkedHashMap(visibleColumns.length, 1.0f);
            TableColumn currentSortColumn = null;
            if (this.cellSort != null) {
                currentSortColumn = this.cellSort.getTableColumn();
            }
            TableRowCore parentRow = this.getParentRowCore();
            for (int i = 0; i < visibleColumns.length; ++i) {
                if (visibleColumns[i] == null) continue;
                if (parentRow != null && !visibleColumns[i].handlesDataSourceType(this.getDataSource(false).getClass())) {
                    this.mTableCells.put(visibleColumns[i].getName(), null);
                    continue;
                }
                TableCellCore cell = currentSortColumn != null && visibleColumns[i].equals(currentSortColumn) ? this.cellSort : new TableCellPainted(this, visibleColumns[i], i);
                this.mTableCells.put(visibleColumns[i].getName(), cell);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyCells() {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells != null) {
                for (TableCellCore cell : this.mTableCells.values()) {
                    if (cell == null || cell == this.cellSort || cell.isDisposed()) continue;
                    cell.dispose();
                }
                this.mTableCells = null;
            }
        }
    }

    public TableViewPainted getViewPainted() {
        return (TableViewPainted)this.getView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swt_paintGC(GC gc, Rectangle drawBounds, int rowStartX, int rowStartY, int pos) {
        if (this.isRowDisposed() || gc == null || gc.isDisposed() || drawBounds == null) {
            return;
        }
        TableColumnCore[] visibleColumns = this.getView().getVisibleColumns();
        if (visibleColumns == null || visibleColumns.length == 0) {
            return;
        }
        boolean isSelected = this.isSelected();
        boolean isSelectedNotFocused = isSelected && !this.getViewPainted().isTableSelected();
        Color origBG = gc.getBackground();
        Color origFG = gc.getForeground();
        Color altColor = alternatingColors[pos >= 0 ? pos % 2 : 0];
        if (altColor == null) {
            altColor = gc.getDevice().getSystemColor(25);
        }
        if (isSelected) {
            Color color = gc.getDevice().getSystemColor(26);
            gc.setBackground(color);
        } else {
            gc.setBackground(altColor);
        }
        Color bg = this.getBackground();
        if (bg == null) {
            bg = gc.getBackground();
        } else {
            gc.setBackground(bg);
        }
        Color fg = this.getForeground();
        Color shadowColor = null;
        if (isSelected) {
            shadowColor = fg;
            fg = gc.getDevice().getSystemColor(27);
            gc.setForeground(fg);
        } else if (fg == null) {
            fg = gc.getDevice().getSystemColor(24);
            gc.setForeground(fg);
        } else {
            gc.setForeground(fg);
        }
        int rowAlpha = this.getAlpha();
        Font font = gc.getFont();
        Rectangle clipping = gc.getClipping();
        int x = rowStartX;
        Object object = this.lock;
        synchronized (object) {
            Rectangle r;
            int w;
            if (this.mTableCells == null) {
                this.setShown(true, true);
            }
            if (this.mTableCells != null) {
                for (TableColumnCore tc : visibleColumns) {
                    TableCellCore cell = (TableCellCore)this.mTableCells.get(tc.getName());
                    int w2 = tc.getWidth();
                    if (!(cell instanceof TableCellPainted) || cell.isDisposed()) {
                        gc.fillRectangle(x, rowStartY, w2, this.getHeight());
                        x += w2;
                        continue;
                    }
                    TableCellPainted cellSWT = (TableCellPainted)cell;
                    Rectangle r2 = new Rectangle(x, rowStartY, w2, this.getHeight());
                    cellSWT.setBoundsRaw(r2);
                    if (drawBounds.intersects(r2)) {
                        gc.setAlpha(255);
                        if (isSelectedNotFocused) {
                            gc.setBackground(altColor);
                            gc.fillRectangle(r2);
                            gc.setAlpha(100);
                            gc.setBackground(bg);
                            gc.fillRectangle(r2);
                        } else {
                            gc.setBackground(bg);
                            gc.fillRectangle(r2);
                            if (isSelected) {
                                gc.setAlpha(80);
                                gc.setForeground(altColor);
                                gc.fillGradientRectangle(r2.x, r2.y, r2.width, r2.height, true);
                                gc.setForeground(fg);
                            }
                        }
                        gc.setAlpha(rowAlpha);
                        if (this.swt_paintCell(gc, cellSWT.getBounds(), cellSWT, shadowColor)) {
                            gc.setBackground(bg);
                            gc.setForeground(fg);
                            gc.setFont(font);
                            gc.setClipping(clipping);
                        }
                        if (DEBUG_ROW_PAINT) {
                            ((TableCellSWTBase)cell).debug("painted " + (cell.getVisuallyChangedSinceRefresh() ? "VC" : "!P") + " @ " + r2);
                        }
                    } else if (DEBUG_ROW_PAINT) {
                        ((TableCellSWTBase)cell).debug("Skip paintItem; no intersects; r=" + r2 + ";dB=" + drawBounds + " from " + Debug.getCompressedStackTrace(4));
                    }
                    x += w2;
                }
            }
            if ((w = drawBounds.width - x) > 0 && clipping.intersects(r = new Rectangle(x, rowStartY, w, this.getHeight()))) {
                gc.setAlpha(255);
                if (isSelectedNotFocused) {
                    gc.setBackground(altColor);
                    gc.fillRectangle(r);
                    gc.setAlpha(100);
                    gc.setBackground(bg);
                    gc.fillRectangle(r);
                } else {
                    gc.fillRectangle(r);
                    if (isSelected) {
                        gc.setAlpha(80);
                        gc.setForeground(altColor);
                        gc.fillGradientRectangle(r.x, r.y, r.width, r.height, true);
                        gc.setForeground(fg);
                    }
                }
                gc.setAlpha(rowAlpha);
            }
        }
        if (this.isFocused()) {
            gc.setAlpha(40);
            gc.setForeground(origFG);
            gc.setLineStyle(3);
            gc.drawRectangle(0, rowStartY, this.getViewPainted().getClientArea().width - 1, this.getHeight() - 1);
            gc.setLineStyle(1);
        }
        gc.setAlpha(255);
        gc.setBackground(origBG);
        gc.setForeground(origFG);
    }

    private boolean swt_paintCell(GC gc, Rectangle cellBounds, TableCellSWTBase cell, Color shadowColor) {
        if (cellBounds == null) {
            return false;
        }
        boolean gcChanged = false;
        try {
            Color bg;
            gc.setTextAntialias(-1);
            TableViewSWT view = (TableViewSWT)this.getView();
            TableColumnCore column = (TableColumnCore)cell.getTableColumn();
            view.invokePaintListeners(gc, this, column, cellBounds);
            int fontStyle = this.getFontStyle();
            Font oldFont = null;
            if (fontStyle == 1) {
                oldFont = gc.getFont();
                gc.setFont(FontUtils.getAnyFontBold(gc));
                gcChanged = true;
            }
            if (!cell.isUpToDate()) {
                cell.refresh(true, true);
            }
            String text = cell.getText();
            Color fg = cell.getForegroundSWT();
            if (fg != null) {
                gcChanged = true;
                if (this.isSelected()) {
                    shadowColor = fg;
                } else {
                    gc.setForeground(fg);
                }
            }
            if ((bg = cell.getBackgroundSWT()) != null) {
                gcChanged = true;
                gc.setBackground(bg);
            }
            if (cell.needsPainting()) {
                Image graphicSWT = cell.getGraphicSWT();
                if (graphicSWT != null && !graphicSWT.isDisposed()) {
                    Rectangle imageBounds = graphicSWT.getBounds();
                    Rectangle graphicBounds = new Rectangle(cellBounds.x, cellBounds.y, cellBounds.width, cellBounds.height);
                    if (cell.getFillCell()) {
                        if (!graphicBounds.isEmpty()) {
                            gc.setAdvanced(true);
                            gc.drawImage(graphicSWT, 0, 0, imageBounds.width, imageBounds.height, graphicBounds.x, graphicBounds.y, graphicBounds.width, graphicBounds.height);
                        }
                    } else {
                        if (imageBounds.width < graphicBounds.width) {
                            int alignment = column.getAlignment();
                            if ((alignment & 3) > 0) {
                                graphicBounds.x += (graphicBounds.width - imageBounds.width) / 2;
                            } else if ((alignment & 2) > 0) {
                                graphicBounds.x = graphicBounds.x + graphicBounds.width - imageBounds.width;
                            }
                        }
                        if (imageBounds.height < graphicBounds.height) {
                            graphicBounds.y += (graphicBounds.height - imageBounds.height) / 2;
                        }
                        gc.drawImage(graphicSWT, graphicBounds.x, graphicBounds.y);
                    }
                }
                cell.doPaint(gc);
                gcChanged = true;
            }
            if (text.length() > 0) {
                int textOpacity;
                int ofsx = 0;
                Image image = cell.getIcon();
                Rectangle imageBounds = null;
                if (image != null && !image.isDisposed()) {
                    imageBounds = image.getBounds();
                    int ofs = imageBounds.width;
                    ofsx += ofs;
                    cellBounds.x += ofs;
                    cellBounds.width -= ofs;
                }
                int style = TableColumnSWTUtils.convertColumnAlignmentToSWT(column.getAlignment());
                if (cellBounds.height > 20) {
                    style |= 0x40;
                }
                if ((textOpacity = cell.getTextAlpha()) < 255) {
                    gc.setAlpha(textOpacity);
                    gcChanged = true;
                } else if (textOpacity > 255) {
                    gc.setFont(FontUtils.getAnyFontBold(gc));
                    gcChanged = true;
                }
                ofsx += 6;
                cellBounds.x += 3;
                cellBounds.width -= 6;
                cellBounds.y += 2;
                cellBounds.height -= 4;
                if (!cellBounds.isEmpty()) {
                    boolean fit;
                    GCStringPrinter sp = new GCStringPrinter(gc, text, cellBounds, true, cellBounds.height > 20, style);
                    if (shadowColor != null) {
                        Color oldFG = gc.getForeground();
                        gc.setForeground(shadowColor);
                        ++cellBounds.x;
                        ++cellBounds.y;
                        int alpha = gc.getAlpha();
                        gc.setAlpha(64);
                        sp.printString(gc, cellBounds, style);
                        gc.setAlpha(alpha);
                        gc.setForeground(oldFG);
                        --cellBounds.x;
                        --cellBounds.y;
                        fit = sp.printString2(gc, cellBounds, style);
                    } else {
                        fit = sp.printString();
                    }
                    if (fit) {
                        cell.setDefaultToolTip(null);
                    } else {
                        cell.setDefaultToolTip(text);
                    }
                    Point size = sp.getCalculatedSize();
                    size.x += ofsx;
                    TableColumn tableColumn = cell.getTableColumn();
                    if (tableColumn != null && tableColumn.getPreferredWidth() < size.x) {
                        tableColumn.setPreferredWidth(size.x);
                    }
                    if (imageBounds != null) {
                        boolean hack_adv;
                        int drawToY = cellBounds.y + cellBounds.height / 2 - imageBounds.height / 2;
                        boolean bl = hack_adv = Constants.isWindows8OrHigher && gc.getAdvanced();
                        if (hack_adv) {
                            gc.setAdvanced(false);
                        }
                        if ((style & 0x20000) != 0) {
                            int drawToX = cellBounds.x + cellBounds.width - size.x;
                            gc.drawImage(image, drawToX, drawToY);
                        } else {
                            gc.drawImage(image, cellBounds.x - imageBounds.width - 3, drawToY);
                        }
                        if (hack_adv) {
                            gc.setAdvanced(true);
                        }
                    }
                } else {
                    cell.setDefaultToolTip(null);
                }
            }
            cell.clearVisuallyChangedSinceRefresh();
            if (oldFont != null) {
                gc.setFont(oldFont);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return gcChanged;
    }

    private Font getRandomFont() {
        FontData[] fontList = Display.getDefault().getFontList(null, Math.random() > 0.5);
        FontData fontData = fontList[(int)(Math.random() * (double)fontList.length)];
        fontData.setStyle((int)(Math.random() * 4.0));
        fontData.height = (float)(Math.random() * 50.0);
        return new Font((Device)Display.getDefault(), fontData);
    }

    @Override
    public List<TableCellCore> refresh(boolean bDoGraphics, boolean bVisible) {
        final List<TableCellCore> invalidCells = super.refresh(bDoGraphics, bVisible);
        if (invalidCells.size() > 0) {
            Utils.execSWTThread(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runSupport() {
                    boolean allCells;
                    Composite composite = TableRowPainted.this.getViewPainted().getComposite();
                    if (composite == null || composite.isDisposed() || !TableRowPainted.this.isVisible()) {
                        return;
                    }
                    Object object = TableRowPainted.this.lock;
                    synchronized (object) {
                        allCells = TableRowPainted.this.mTableCells != null && invalidCells.size() == TableRowPainted.this.mTableCells.size();
                    }
                    if (allCells) {
                        TableRowPainted.this.getViewPainted().swt_updateCanvasImage(TableRowPainted.this.getDrawBounds(), false);
                    } else {
                        for (TableCellCore o : invalidCells) {
                            TableCellPainted cell;
                            Rectangle bounds;
                            if (!(o instanceof TableCellPainted) || (bounds = (cell = (TableCellPainted)o).getBoundsRaw()) == null) continue;
                            TableRowPainted.this.getViewPainted().swt_updateCanvasImage(bounds, false);
                        }
                    }
                }
            });
        }
        return invalidCells;
    }

    @Override
    public void redraw(boolean doChildren) {
        this.redraw(doChildren, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redraw(boolean doChildren, boolean immediateRedraw) {
        if (this.isRowDisposed()) {
            return;
        }
        this.getViewPainted().redrawRow(this, immediateRedraw);
        if (!doChildren) {
            return;
        }
        Object object = this.subRows_sync;
        synchronized (object) {
            if (this.subRows != null) {
                for (TableRowPainted subrow : this.subRows) {
                    subrow.redraw();
                }
            }
        }
    }

    protected void debug(String s) {
        AEDiagnosticsLogger diag_logger = AEDiagnostics.getLogger("table");
        String prefix = SystemTime.getCurrentTime() + ":" + this.getTableID() + ": r" + this.getIndex();
        if (this.getParentRowCore() != null) {
            prefix = prefix + "of" + this.getParentRowCore().getIndex();
        }
        prefix = prefix + ": ";
        diag_logger.log(prefix + s);
        System.out.println(prefix + s);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, this.drawOffset.y, 9990, this.getHeight());
    }

    public Rectangle getDrawBounds() {
        TableViewPainted view = (TableViewPainted)this.getView();
        Rectangle clientArea = view.getClientArea();
        Rectangle bounds = new Rectangle(0, this.drawOffset.y - clientArea.y, 9990, this.getHeight());
        return bounds;
    }

    @Override
    public int getFullHeight() {
        int h = this.getHeight();
        if (this.numSubItems > 0 && this.isExpanded()) {
            h += this.subRowsHeight;
        }
        return h;
    }

    public Point getDrawOffset() {
        return this.drawOffset;
    }

    public void heightChanged(int oldHeight, int newHeight) {
        this.getViewPainted().rowHeightChanged(this, oldHeight, newHeight);
        TableRowCore row = this.getParentRowCore();
        if (row instanceof TableRowPainted) {
            ((TableRowPainted)row).subRowHeightChanged(this, oldHeight, newHeight);
        }
    }

    public void subRowHeightChanged(TableRowCore row, int oldHeight, int newHeight) {
        this.subRowsHeight += newHeight - oldHeight;
    }

    public boolean setDrawOffset(Point drawOffset) {
        if (drawOffset.equals((Object)this.drawOffset)) {
            return false;
        }
        this.drawOffset = drawOffset;
        return true;
    }

    @Override
    public void setWidgetSelected(boolean selected) {
        this.redraw(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setShown(boolean b, boolean force) {
        if (b == this.wasShown && !force) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (b && this.mTableCells == null) {
                this.buildCells();
            }
        }
        boolean ret = super.setShown(b, force);
        if (b) {
            this.invalidate();
            this.redraw(false, false);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            if (!b && this.mTableCells != null) {
                this.destroyCells();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        super.delete();
        Object object = this.lock;
        synchronized (object) {
            if (this.cellSort != null && !this.cellSort.isDisposed()) {
                this.cellSort.dispose();
                this.cellSort = null;
            }
        }
        this.deleteExistingSubRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteExistingSubRows() {
        Object object = this.subRows_sync;
        synchronized (object) {
            if (this.subRows != null) {
                for (TableRowPainted subrow : this.subRows) {
                    subrow.delete();
                }
            }
            this.subRows = null;
        }
    }

    @Override
    public void setSubItemCount(int length) {
        this.numSubItems = length;
        if (this.isExpanded() && this.subDataSources.length == length) {
            this.debug("setSubItemCount to " + length);
            this.deleteExistingSubRows();
            TableRowCore[] newSubRows = new TableRowPainted[length];
            TableViewPainted tv = this.getViewPainted();
            int h = 0;
            for (int i = 0; i < newSubRows.length; ++i) {
                newSubRows[i] = new TableRowPainted(this, tv, this.subDataSources[i], false);
                newSubRows[i].setTableItem(i, false);
                h += ((TableRowPainted)newSubRows[i]).getHeight();
            }
            int oldHeight = this.getFullHeight();
            this.subRowsHeight = h;
            this.getViewPainted().rowHeightChanged(this, oldHeight, this.getFullHeight());
            this.getViewPainted().triggerListenerRowAdded(newSubRows);
            this.subRows = newSubRows;
        }
    }

    @Override
    public int getSubItemCount() {
        return this.numSubItems;
    }

    @Override
    public TableRowCore linkSubItem(int indexOf) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSubItems(Object[] datasources) {
        this.deleteExistingSubRows();
        Object object = this.subRows_sync;
        synchronized (object) {
            this.subDataSources = datasources;
            this.subRowsHeight = 0;
            this.setSubItemCount(datasources.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore[] getSubRowsWithNull() {
        Object object = this.subRows_sync;
        synchronized (object) {
            return this.subRows == null ? new TableRowCore[]{} : this.subRows;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubRow(Object datasource) {
        Object object = this.subRows_sync;
        synchronized (object) {
            for (int i = 0; i < this.subDataSources.length; ++i) {
                Object ds = this.subDataSources[i];
                if (ds != datasource) continue;
                TableRowPainted rowToDel = this.subRows[i];
                TableRowPainted[] newSubRows = new TableRowPainted[this.subRows.length - 1];
                System.arraycopy(this.subRows, 0, newSubRows, 0, i);
                System.arraycopy(this.subRows, i + 1, newSubRows, i, this.subRows.length - i - 1);
                this.subRows = newSubRows;
                Object[] newDatasources = new Object[this.subRows.length];
                System.arraycopy(this.subDataSources, 0, newDatasources, 0, i);
                System.arraycopy(this.subDataSources, i + 1, newDatasources, i, this.subDataSources.length - i - 1);
                this.subDataSources = newDatasources;
                rowToDel.delete();
                this.setSubItemCount(this.subRows.length);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExpanded(boolean b) {
        if (this.canExpand()) {
            int oldHeight = this.getFullHeight();
            super.setExpanded(b);
            Object object = this.subRows_sync;
            synchronized (object) {
                TableRowPainted[] newSubRows = null;
                if (b && (this.subRows == null || this.subRows.length != this.numSubItems) && this.subDataSources != null && this.subDataSources.length == this.numSubItems) {
                    this.debug("building subrows " + this.numSubItems);
                    this.deleteExistingSubRows();
                    newSubRows = new TableRowPainted[this.numSubItems];
                    TableViewPainted tv = this.getViewPainted();
                    int h = 0;
                    for (int i = 0; i < newSubRows.length; ++i) {
                        newSubRows[i] = new TableRowPainted(this, tv, this.subDataSources[i], false);
                        newSubRows[i].setTableItem(i, false);
                        h += newSubRows[i].getHeight();
                    }
                    this.subRowsHeight = h;
                    this.subRows = newSubRows;
                }
                this.getViewPainted().rowHeightChanged(this, oldHeight, this.getFullHeight());
                if (newSubRows != null) {
                    this.getViewPainted().triggerListenerRowAdded(newSubRows);
                }
            }
            if (this.isVisible()) {
                this.getViewPainted().visibleRowsChanged();
                this.getViewPainted().redrawTable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableRowCore getSubRow(int pos) {
        Object object = this.subRows_sync;
        synchronized (object) {
            if (this.subRows == null) {
                return null;
            }
            if (pos >= 0 && pos < this.subRows.length) {
                return this.subRows[pos];
            }
            return null;
        }
    }

    @Override
    public boolean setForeground(Color color) {
        if (this.isRowDisposed()) {
            return false;
        }
        if (color == this.colorFG || color != null && color.equals((Object)this.colorFG) || this.colorFG != null && this.colorFG.equals((Object)color)) {
            return false;
        }
        this.colorFG = color;
        Utils.getOffOfSWTThread(new AERunnable(){

            public void runSupport() {
                TableRowPainted.this.redraw(false, false);
            }
        });
        return true;
    }

    @Override
    public boolean setIconSize(Point pt) {
        return false;
    }

    @Override
    public Color getForeground() {
        return this.colorFG;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public void setBackgroundImage(Image image) {
    }

    @Override
    public int getHeight() {
        return this.height == 0 ? this.getView().getRowDefaultHeight() : this.height;
    }

    @Override
    public boolean setHeight(int newHeight) {
        TableRowCore parentRowCore = this.getParentRowCore();
        boolean trigger = parentRowCore == null || parentRowCore.isExpanded();
        return this.setHeight(newHeight, trigger);
    }

    public boolean setHeight(int newHeight, boolean trigger) {
        if (this.height == newHeight) {
            return false;
        }
        int oldHeight = this.height;
        this.height = newHeight;
        if (trigger && !this.initializing) {
            this.heightChanged(oldHeight, newHeight);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore getTableCellCore(String name) {
        if (this.isRowDisposed()) {
            return null;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells == null) {
                if (this.cellSort != null && !this.cellSort.isDisposed() && this.cellSort.getTableColumn().getName().equals(name)) {
                    return this.cellSort;
                }
                return null;
            }
            return (TableCellCore)this.mTableCells.get(name);
        }
    }

    @Override
    public TableCellSWT getTableCellSWT(String name) {
        TableCellCore cell = this.getTableCellCore(name);
        return cell instanceof TableCellSWT ? (TableCellSWT)cell : null;
    }

    @Override
    public TableCell getTableCell(String field) {
        return this.getTableCellCore(field);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableCellCore getSortColumnCell(String hint) {
        Object object = this.lock;
        synchronized (object) {
            return this.cellSort;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSortColumn(String columnID) {
        Object object = this.lock;
        synchronized (object) {
            if (this.mTableCells == null) {
                if (this.cellSort != null && !this.cellSort.isDisposed()) {
                    if (this.cellSort.getTableColumn().getName().equals(columnID)) {
                        return;
                    }
                    this.cellSort.dispose();
                    this.cellSort = null;
                }
                TableColumnCore sortColumn = (TableColumnCore)this.getView().getTableColumn(columnID);
                this.cellSort = this.getParentRowCore() == null || sortColumn.handlesDataSourceType(this.getDataSource(false).getClass()) ? new TableCellPainted(this, sortColumn, sortColumn.getPosition()) : null;
            } else {
                this.cellSort = (TableCellCore)this.mTableCells.get(columnID);
            }
        }
    }

    static {
        Colors.getInstance().addColorsChangedListener(new ParameterListener(){

            public void parameterChanged(String parameterName) {
                TableRowPainted.alternatingColors[1] = Colors.colorAltRow;
            }
        });
    }
}

