/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.db.impl;

import com.aelitis.azureus.core.dht.DHTLogger;
import com.aelitis.azureus.core.dht.DHTOperationAdapter;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.DHTStorageBlock;
import com.aelitis.azureus.core.dht.DHTStorageKey;
import com.aelitis.azureus.core.dht.DHTStorageKeyStats;
import com.aelitis.azureus.core.dht.control.DHTControl;
import com.aelitis.azureus.core.dht.db.DHTDB;
import com.aelitis.azureus.core.dht.db.DHTDBLookupResult;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.db.DHTDBValue;
import com.aelitis.azureus.core.dht.db.impl.DHTDBMapping;
import com.aelitis.azureus.core.dht.db.impl.DHTDBValueImpl;
import com.aelitis.azureus.core.dht.impl.DHTLog;
import com.aelitis.azureus.core.dht.router.DHTRouter;
import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.DHTTransportQueryStoreReply;
import com.aelitis.azureus.core.dht.transport.DHTTransportReplyHandlerAdapter;
import com.aelitis.azureus.core.dht.transport.DHTTransportValue;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.ByteArrayHashMap;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DHTDBImpl
implements DHTDB,
DHTDBStats {
    private static final int MAX_VALUE_LIFETIME = 259200000;
    private int original_republish_interval;
    public static int ORIGINAL_REPUBLISH_INTERVAL_GRACE = 3600000;
    private static final boolean ENABLE_PRECIOUS_STUFF = false;
    private static final int PRECIOUS_CHECK_INTERVAL = 0x6DDD00;
    private int cache_republish_interval;
    private long MIN_CACHE_EXPIRY_CHECK_INTERVAL = 60000L;
    private long last_cache_expiry_check;
    private static final long IP_BLOOM_FILTER_REBUILD_PERIOD = 900000L;
    private static final int IP_COUNT_BLOOM_SIZE_INCREASE_CHUNK = 1000;
    private BloomFilter ip_count_bloom_filter = BloomFilterFactory.createAddRemove8Bit(1000);
    private static final int VALUE_VERSION_CHUNK = 128;
    private int next_value_version;
    private int next_value_version_left;
    protected static final int QUERY_STORE_REQUEST_ENTRY_SIZE = 6;
    protected static final int QUERY_STORE_REPLY_ENTRY_SIZE = 2;
    private Map<HashWrapper, DHTDBMapping> stored_values = new HashMap<HashWrapper, DHTDBMapping>();
    private Map<DHTDBMapping.ShortHash, DHTDBMapping> stored_values_prefix_map = new HashMap<DHTDBMapping.ShortHash, DHTDBMapping>();
    private DHTControl control;
    private DHTStorageAdapter adapter;
    private DHTRouter router;
    private DHTTransportContact local_contact;
    private DHTLogger logger;
    private static final long MAX_TOTAL_SIZE = 0x400000L;
    private int total_size;
    private int total_values;
    private int total_keys;
    private int total_local_keys;
    private boolean force_original_republish;
    private IpFilter ip_filter = IpFilterManagerFactory.getSingleton().getIPFilter();
    private AEMonitor this_mon = new AEMonitor("DHTDB");
    private static final boolean DEBUG_SURVEY = false;
    private static final boolean SURVEY_ONLY_RF_KEYS = true;
    private static final int SURVEY_PERIOD = 900000;
    private static final int SURVEY_STATE_INACT_TIMEOUT = 3600000;
    private static final int SURVEY_STATE_MAX_LIFE_TIMEOUT = 12600000;
    private static final int SURVEY_STATE_MAX_LIFE_RAND = 3600000;
    private static final int MAX_SURVEY_SIZE = 100;
    private static final int MAX_SURVEY_STATE_SIZE = 150;
    private final boolean survey_enabled;
    private volatile boolean survey_in_progress;
    private Map<HashWrapper, Long> survey_mapping_times = new HashMap<HashWrapper, Long>();
    private Map<HashWrapper, SurveyContactState> survey_state = new LinkedHashMap<HashWrapper, SurveyContactState>(150, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<HashWrapper, SurveyContactState> eldest) {
            return this.size() > 150;
        }
    };
    private TimerEventPeriodic precious_timer;
    private TimerEventPeriodic original_republish_timer;
    private TimerEventPeriodic cache_republish_timer;
    private TimerEventPeriodic bloom_timer;
    private TimerEventPeriodic survey_timer;
    private boolean sleeping;
    private boolean suspended;
    private volatile boolean destroyed;

    public DHTDBImpl(DHTStorageAdapter _adapter, int _original_republish_interval, int _cache_republish_interval, byte _protocol_version, DHTLogger _logger) {
        this.adapter = _adapter == null ? null : new adapterFacade(_adapter);
        this.original_republish_interval = _original_republish_interval;
        this.cache_republish_interval = _cache_republish_interval;
        this.logger = _logger;
        boolean bl = this.survey_enabled = _protocol_version >= 26 && (this.adapter == null || this.adapter.getNetwork() == 1 || FeatureAvailability.isDHTRepV2Enabled());
        if (this.original_republish_interval > 0) {
            this.original_republish_timer = SimpleTimer.addPeriodicEvent("DHTDB:op", this.original_republish_interval, true, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    DHTDBImpl.this.logger.log("Republish of original mappings starts");
                    long start = SystemTime.getCurrentTime();
                    int stats2 = DHTDBImpl.this.republishOriginalMappings();
                    long end = SystemTime.getCurrentTime();
                    DHTDBImpl.this.logger.log("Republish of original mappings completed in " + (end - start) + ": " + "values = " + stats2);
                }
            });
        }
        if (this.cache_republish_interval > 0) {
            this.cache_republish_timer = SimpleTimer.addPeriodicEvent("DHTDB:cp", this.cache_republish_interval + 10000 - RandomUtils.nextInt(20000), true, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    DHTDBImpl.this.logger.log("Republish of cached mappings starts");
                    long start = SystemTime.getCurrentTime();
                    int[] stats2 = DHTDBImpl.this.republishCachedMappings();
                    long end = SystemTime.getCurrentTime();
                    DHTDBImpl.this.logger.log("Republish of cached mappings completed in " + (end - start) + ": " + "values = " + stats2[0] + ", keys = " + stats2[1] + ", ops = " + stats2[2]);
                    if (DHTDBImpl.this.force_original_republish) {
                        DHTDBImpl.this.force_original_republish = false;
                        DHTDBImpl.this.logger.log("Force republish of original mappings due to router change starts");
                        start = SystemTime.getCurrentTime();
                        int stats22 = DHTDBImpl.this.republishOriginalMappings();
                        end = SystemTime.getCurrentTime();
                        DHTDBImpl.this.logger.log("Force republish of original mappings due to router change completed in " + (end - start) + ": " + "values = " + stats22);
                    }
                }
            });
        }
        this.bloom_timer = SimpleTimer.addPeriodicEvent("DHTDB:bloom", 900000L, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                try {
                    DHTDBImpl.this.this_mon.enter();
                    DHTDBImpl.this.rebuildIPBloomFilter(false);
                    Object var3_2 = null;
                    DHTDBImpl.this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    DHTDBImpl.this.this_mon.exit();
                    throw throwable;
                }
            }
        });
        if (this.survey_enabled) {
            this.survey_timer = SimpleTimer.addPeriodicEvent("DHTDB:survey", 900000L, true, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    DHTDBImpl.this.survey();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setControl(DHTControl _control) {
        this.control = _control;
        this.force_original_republish = this.router != null;
        this.router = this.control.getRouter();
        this.local_contact = this.control.getTransport().getLocalContact();
        try {
            this.this_mon.enter();
            this.survey_state.clear();
            for (DHTDBMapping mapping2 : this.stored_values.values()) {
                mapping2.updateLocalContact(this.local_contact);
            }
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue store(HashWrapper key, byte[] value, short flags, byte life_hours, byte replication_control) {
        if ((flags & 0x40) == 0) {
            if ((flags & 0x80) != 0) {
                Debug.out("Obfuscated puts without 'put-and-forget' are not supported as original-republishing of them is not implemented");
            }
            if (life_hours > 0 && life_hours * 60 * 60 * 1000 < this.original_republish_interval) {
                Debug.out("Don't put persistent values with a lifetime less than republish period - lifetime over-ridden");
                life_hours = 0;
            }
            try {
                this.this_mon.enter();
                ++this.total_local_keys;
                DHTDBMapping mapping2 = this.stored_values.get(key);
                if (mapping2 == null) {
                    mapping2 = new DHTDBMapping(this, key, true);
                    this.stored_values.put(key, mapping2);
                    this.addToPrefixMap(mapping2);
                }
                DHTDBValueImpl res = new DHTDBValueImpl(SystemTime.getCurrentTime(), value, this.getNextValueVersion(), this.local_contact, this.local_contact, true, flags, life_hours, replication_control);
                mapping2.add(res);
                DHTDBValueImpl dHTDBValueImpl = res;
                Object var10_10 = null;
                this.this_mon.exit();
                return dHTDBValueImpl;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        DHTDBValueImpl res = new DHTDBValueImpl(SystemTime.getCurrentTime(), value, this.getNextValueVersion(), this.local_contact, this.local_contact, true, flags, life_hours, replication_control);
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte store(DHTTransportContact sender, HashWrapper key, DHTTransportValue[] values) {
        block6: {
            if ((long)(this.total_size + this.total_values * 4) > 0x400000L) {
                DHTLog.log("Not storing " + DHTLog.getString2(key.getHash()) + " as maximum storage limit exceeded");
                return 3;
            }
            this.this_mon.enter();
            if (!this.sleeping && !this.suspended) break block6;
            byte by = 1;
            Object var9_6 = null;
            this.this_mon.exit();
            return by;
        }
        try {
            this.checkCacheExpiration(false);
            DHTDBMapping mapping2 = this.stored_values.get(key);
            if (mapping2 == null) {
                mapping2 = new DHTDBMapping(this, key, false);
                this.stored_values.put(key, mapping2);
                this.addToPrefixMap(mapping2);
            }
            for (int i = 0; i < values.length; ++i) {
                DHTTransportValue value = values[i];
                DHTDBValueImpl mapping_value = new DHTDBValueImpl(sender, value, false);
                mapping2.add(mapping_value);
            }
            byte by = mapping2.getDiversificationType();
            Object var9_7 = null;
            this.this_mon.exit();
            return by;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBLookupResult get(DHTTransportContact reader, HashWrapper key, int max_values, short flags, boolean external_request) {
        DHTDBMapping mapping2;
        block4: {
            try {
                this.this_mon.enter();
                this.checkCacheExpiration(false);
                mapping2 = this.stored_values.get(key);
                if (mapping2 != null) break block4;
                DHTDBLookupResult dHTDBLookupResult = null;
                Object var10_9 = null;
                this.this_mon.exit();
                return dHTDBLookupResult;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        if (external_request) {
            mapping2.addHit();
        }
        final DHTDBValue[] values = mapping2.get(reader, max_values, flags);
        DHTDBLookupResult dHTDBLookupResult = new DHTDBLookupResult(){

            public DHTDBValue[] getValues() {
                return values;
            }

            public byte getDiversificationType() {
                return mapping2.getDiversificationType();
            }
        };
        Object var10_10 = null;
        this.this_mon.exit();
        return dHTDBLookupResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue get(HashWrapper key) {
        block3: {
            try {
                this.this_mon.enter();
                DHTDBMapping mapping2 = this.stored_values.get(key);
                if (mapping2 == null) break block3;
                DHTDBValueImpl dHTDBValueImpl = mapping2.get(this.local_contact);
                Object var5_5 = null;
                this.this_mon.exit();
                return dHTDBValueImpl;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        DHTDBValue dHTDBValue = null;
        Object var5_6 = null;
        this.this_mon.exit();
        return dHTDBValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue getAnyValue(HashWrapper key) {
        block3: {
            try {
                this.this_mon.enter();
                DHTDBMapping mapping2 = this.stored_values.get(key);
                if (mapping2 == null) break block3;
                DHTDBValueImpl dHTDBValueImpl = mapping2.getAnyValue(this.local_contact);
                Object var5_5 = null;
                this.this_mon.exit();
                return dHTDBValueImpl;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        DHTDBValue dHTDBValue = null;
        Object var5_6 = null;
        this.this_mon.exit();
        return dHTDBValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasKey(HashWrapper key) {
        try {
            this.this_mon.enter();
            boolean bl = this.stored_values.containsKey(key);
            Object var4_3 = null;
            this.this_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTDBValue remove(DHTTransportContact originator, HashWrapper key) {
        block5: {
            block6: {
                try {
                    this.this_mon.enter();
                    DHTDBMapping mapping2 = this.stored_values.get(key);
                    if (mapping2 == null) break block5;
                    DHTDBValueImpl res = mapping2.remove(originator);
                    if (res == null) break block6;
                    --this.total_local_keys;
                    if (!mapping2.getValues().hasNext()) {
                        this.stored_values.remove(key);
                        this.removeFromPrefixMap(mapping2);
                        mapping2.destroy();
                    }
                    DHTDBValue dHTDBValue = res.getValueForDeletion(this.getNextValueVersion());
                    Object var7_8 = null;
                    this.this_mon.exit();
                    return dHTDBValue;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            DHTDBValue dHTDBValue = null;
            Object var7_9 = null;
            this.this_mon.exit();
            return dHTDBValue;
        }
        DHTDBValue dHTDBValue = null;
        Object var7_10 = null;
        this.this_mon.exit();
        return dHTDBValue;
    }

    @Override
    public DHTStorageBlock keyBlockRequest(DHTTransportContact direct_sender, byte[] request2, byte[] signature) {
        if (this.adapter == null) {
            return null;
        }
        if (direct_sender != null) {
            byte[] key = this.adapter.getKeyForKeyBlock(request2);
            List<DHTTransportContact> closest_contacts = this.control.getClosestKContactsList(key, true);
            boolean process_it = false;
            for (int i = 0; i < closest_contacts.size(); ++i) {
                if (!this.router.isID(closest_contacts.get(i).getID())) continue;
                process_it = true;
                break;
            }
            if (!process_it) {
                DHTLog.log("Not processing key block for  " + DHTLog.getString2(key) + " as key too far away");
                return null;
            }
            if (!this.control.verifyContact(direct_sender, true)) {
                DHTLog.log("Not processing key block for  " + DHTLog.getString2(key) + " as verification failed");
                return null;
            }
        }
        return this.adapter.keyBlockRequest(direct_sender, request2, signature);
    }

    @Override
    public DHTStorageBlock getKeyBlockDetails(byte[] key) {
        if (this.adapter == null) {
            return null;
        }
        return this.adapter.getKeyBlockDetails(key);
    }

    @Override
    public boolean isKeyBlocked(byte[] key) {
        return this.getKeyBlockDetails(key) != null;
    }

    @Override
    public DHTStorageBlock[] getDirectKeyBlocks() {
        if (this.adapter == null) {
            return new DHTStorageBlock[0];
        }
        return this.adapter.getDirectKeyBlocks();
    }

    @Override
    public boolean isEmpty() {
        return this.total_keys == 0;
    }

    @Override
    public int getKeyCount() {
        return this.total_keys;
    }

    @Override
    public int getLocalKeyCount() {
        return this.total_local_keys;
    }

    @Override
    public int getValueCount() {
        return this.total_values;
    }

    @Override
    public int getSize() {
        return this.total_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getValueDetails() {
        try {
            this.this_mon.enter();
            int[] res = new int[6];
            for (DHTDBMapping mapping2 : this.stored_values.values()) {
                res[0] = res[0] + mapping2.getValueCount();
                res[1] = res[1] + mapping2.getLocalSize();
                res[2] = res[2] + mapping2.getDirectSize();
                res[3] = res[3] + mapping2.getIndirectSize();
                byte dt = mapping2.getDiversificationType();
                if (dt == 2) {
                    res[4] = res[4] + 1;
                    continue;
                }
                if (dt != 3) continue;
                res[5] = res[5] + 1;
            }
            int[] nArray = res;
            Object var6_5 = null;
            this.this_mon.exit();
            return nArray;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public int getKeyBlockCount() {
        if (this.adapter == null) {
            return 0;
        }
        return this.adapter.getDirectKeyBlocks().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<HashWrapper> getKeys() {
        try {
            this.this_mon.enter();
            Iterator<HashWrapper> iterator = new ArrayList<HashWrapper>(this.stored_values.keySet()).iterator();
            Object var3_2 = null;
            this.this_mon.exit();
            return iterator;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int republishOriginalMappings() {
        List<DHTDBValueImpl> values;
        if (this.suspended) {
            this.logger.log("Original republish skipped as suspended");
            return 0;
        }
        int values_published = 0;
        HashMap republish = new HashMap();
        try {
            this.this_mon.enter();
            for (Map.Entry<HashWrapper, DHTDBMapping> entry : this.stored_values.entrySet()) {
                HashWrapper key = entry.getKey();
                DHTDBMapping mapping2 = entry.getValue();
                Iterator<DHTDBValueImpl> it2 = mapping2.getValues();
                values = new ArrayList();
                while (it2.hasNext()) {
                    DHTDBValueImpl value = it2.next();
                    if (value == null || !value.isLocal()) continue;
                    value.setCreationTime();
                    values.add(value);
                }
                if (values.size() <= 0) continue;
                republish.put(key, values);
            }
            Object var11_13 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Iterator<Map.Entry<HashWrapper, DHTDBMapping>> it = republish.entrySet().iterator();
        int key_tot = republish.size();
        int key_num = 0;
        while (it.hasNext()) {
            ++key_num;
            Map.Entry<HashWrapper, DHTDBMapping> entry = it.next();
            HashWrapper key = entry.getKey();
            values = (List)((Object)entry.getValue());
            for (int i = 0; i < values.size(); ++i) {
                ++values_published;
                this.control.putEncodedKey(key.getHash(), "Republish orig: " + key_num + " of " + key_tot, (DHTTransportValue)values.get(i), 0L, true);
            }
        }
        return values_published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int[] republishCachedMappings() {
        DHTStorageBlock[] direct_key_blocks;
        if (this.suspended) {
            this.logger.log("Cache republish skipped as suspended");
            return new int[]{0, 0, 0};
        }
        this.router.refreshIdleLeaves(this.cache_republish_interval);
        final HashMap republish = new HashMap();
        ArrayList<DHTDBMapping> republish_via_survey = new ArrayList<DHTDBMapping>();
        long now = System.currentTimeMillis();
        try {
            this.this_mon.enter();
            this.checkCacheExpiration(true);
            for (Map.Entry<HashWrapper, DHTDBMapping> entry : this.stored_values.entrySet()) {
                HashWrapper key = entry.getKey();
                DHTDBMapping mapping2 = entry.getValue();
                if (mapping2.getDiversificationType() != 1) continue;
                Iterator<DHTDBValueImpl> it2 = mapping2.getValues();
                boolean all_rf_values = it2.hasNext();
                ArrayList<DHTDBValueImpl> values = new ArrayList<DHTDBValueImpl>();
                while (it2.hasNext()) {
                    DHTDBValueImpl value = it2.next();
                    if (value.isLocal()) {
                        all_rf_values = false;
                        continue;
                    }
                    if (value.getReplicationFactor() == -1) {
                        all_rf_values = false;
                    }
                    if (now < value.getStoreTime()) {
                        value.setStoreTime(now);
                        continue;
                    }
                    if (now - value.getStoreTime() <= (long)this.cache_republish_interval) continue;
                    values.add(value);
                }
                if (all_rf_values) {
                    values.clear();
                    republish_via_survey.add(mapping2);
                }
                if (values.size() <= 0) continue;
                republish.put(key, values);
            }
            Object var14_25 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var14_26 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (republish_via_survey.size() > 0) {
            ArrayList<HashWrapper> stop_caching = new ArrayList<HashWrapper>();
            for (DHTDBMapping mapping3 : republish_via_survey) {
                HashWrapper key = mapping3.getKey();
                byte[] lookup_id = key.getHash();
                List<DHTTransportContact> contacts = this.control.getClosestKContactsList(lookup_id, false);
                boolean keep_caching = false;
                for (int j = 0; j < contacts.size(); ++j) {
                    if (!this.router.isID(contacts.get(j).getID())) continue;
                    keep_caching = true;
                    break;
                }
                if (keep_caching) continue;
                DHTLog.log("Dropping cache entry for " + DHTLog.getString(lookup_id) + " as now too far away");
                stop_caching.add(key);
            }
            if (stop_caching.size() > 0) {
                try {
                    this.this_mon.enter();
                    for (int i = 0; i < stop_caching.size(); ++i) {
                        DHTDBMapping mapping3;
                        mapping3 = this.stored_values.remove(stop_caching.get(i));
                        if (mapping3 == null) continue;
                        this.removeFromPrefixMap(mapping3);
                        mapping3.destroy();
                    }
                    Object var16_32 = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var16_33 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
        }
        final int[] values_published = new int[]{0};
        final int[] keys_published = new int[]{0};
        final int[] republish_ops = new int[]{0};
        final HashSet anti_spoof_done = new HashSet();
        if (republish.size() > 0) {
            Iterator it1 = republish.entrySet().iterator();
            ArrayList<HashWrapper> stop_caching = new ArrayList<HashWrapper>();
            HashMap<HashWrapper, Object[]> contact_map = new HashMap<HashWrapper, Object[]>();
            while (it1.hasNext()) {
                int j;
                Map.Entry entry = it1.next();
                HashWrapper key = (HashWrapper)entry.getKey();
                byte[] lookup_id = key.getHash();
                List<DHTTransportContact> contacts = this.control.getClosestKContactsList(lookup_id, false);
                boolean keep_caching = false;
                for (j = 0; j < contacts.size(); ++j) {
                    if (!this.router.isID(contacts.get(j).getID())) continue;
                    keep_caching = true;
                    break;
                }
                if (!keep_caching) {
                    DHTLog.log("Dropping cache entry for " + DHTLog.getString(lookup_id) + " as now too far away");
                    stop_caching.add(key);
                }
                for (j = 0; j < contacts.size(); ++j) {
                    DHTTransportContact contact = contacts.get(j);
                    if (this.router.isID(contact.getID())) continue;
                    Object[] data = (Object[])contact_map.get(new HashWrapper(contact.getID()));
                    if (data == null) {
                        data = new Object[]{contact, new ArrayList()};
                        contact_map.put(new HashWrapper(contact.getID()), data);
                    }
                    ((List)data[1]).add(key);
                }
            }
            Iterator it2 = contact_map.values().iterator();
            final int con_tot = contact_map.size();
            int con_num = 0;
            while (it2.hasNext()) {
                final int f_con_num = ++con_num;
                final Object[] data = (Object[])it2.next();
                final DHTTransportContact contact = (DHTTransportContact)data[0];
                final AESemaphore sem = new AESemaphore("DHTDB:cacheForward");
                contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void findNodeReply(DHTTransportContact _contact, DHTTransportContact[] _contacts) {
                        anti_spoof_done.add(_contact);
                        try {
                            List keys = (List)data[1];
                            byte[][] store_keys = new byte[keys.size()][];
                            DHTTransportValue[][] store_values = new DHTTransportValue[store_keys.length][];
                            keys_published[0] = keys_published[0] + store_keys.length;
                            for (int i = 0; i < store_keys.length; ++i) {
                                HashWrapper wrapper2 = (HashWrapper)keys.get(i);
                                store_keys[i] = wrapper2.getHash();
                                List values = (List)republish.get(wrapper2);
                                store_values[i] = new DHTTransportValue[values.size()];
                                values_published[0] = values_published[0] + store_values[i].length;
                                for (int j = 0; j < values.size(); ++j) {
                                    DHTDBValueImpl value = (DHTDBValueImpl)values.get(j);
                                    store_values[i][j] = value.getValueForRelay(DHTDBImpl.this.local_contact);
                                }
                            }
                            ArrayList<DHTTransportContact> contacts = new ArrayList<DHTTransportContact>();
                            contacts.add(contact);
                            republish_ops[0] = republish_ops[0] + 1;
                            DHTDBImpl.this.control.putDirectEncodedKeys(store_keys, "Republish cache: " + f_con_num + " of " + con_tot, store_values, contacts);
                            Object var12_12 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var12_13 = null;
                            sem.release();
                            throw throwable;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact _contact, Throwable _error) {
                        try {
                            DHTLog.log("cacheForward: pre-store findNode failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            DHTDBImpl.this.router.contactDead(_contact.getID(), false);
                            Object var4_3 = null;
                            sem.release();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            sem.release();
                            throw throwable;
                        }
                    }
                }, contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20], (short)256);
                sem.reserve();
            }
            try {
                this.this_mon.enter();
                for (int i = 0; i < stop_caching.size(); ++i) {
                    DHTDBMapping mapping4 = this.stored_values.remove(stop_caching.get(i));
                    if (mapping4 == null) continue;
                    this.removeFromPrefixMap(mapping4);
                    mapping4.destroy();
                }
                Object var21_46 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var21_47 = null;
                this.this_mon.exit();
                throw throwable;
            }
        }
        if ((direct_key_blocks = this.getDirectKeyBlocks()).length > 0) {
            for (int i = 0; i < direct_key_blocks.length; ++i) {
                int j;
                final DHTStorageBlock key_block = direct_key_blocks[i];
                List<DHTTransportContact> contacts = this.control.getClosestKContactsList(key_block.getKey(), false);
                boolean forward_it = false;
                for (j = 0; j < contacts.size(); ++j) {
                    DHTTransportContact contact = contacts.get(j);
                    if (!this.router.isID(contact.getID())) continue;
                    forward_it = true;
                    break;
                }
                for (j = 0; forward_it && j < contacts.size(); ++j) {
                    final DHTTransportContact contact = contacts.get(j);
                    if (key_block.hasBeenSentTo(contact) || this.router.isID(contact.getID()) || contact.getProtocolVersion() < 14) continue;
                    final Runnable task2 = new Runnable(){

                        public void run() {
                            contact.sendKeyBlock(new DHTTransportReplyHandlerAdapter(){

                                public void keyBlockReply(DHTTransportContact _contact) {
                                    DHTLog.log("key block forward ok " + DHTLog.getString(_contact));
                                    key_block.sentTo(_contact);
                                }

                                public void failed(DHTTransportContact _contact, Throwable _error) {
                                    DHTLog.log("key block forward failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                                }
                            }, key_block.getRequest(), key_block.getCertificate());
                        }
                    };
                    if (anti_spoof_done.contains(contact)) {
                        task2.run();
                        continue;
                    }
                    contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                        public void findNodeReply(DHTTransportContact contact, DHTTransportContact[] contacts) {
                            task2.run();
                        }

                        public void failed(DHTTransportContact _contact, Throwable _error) {
                            DHTLog.log("pre-kb findNode failed " + DHTLog.getString(_contact) + " -> failed: " + _error.getMessage());
                            DHTDBImpl.this.router.contactDead(_contact.getID(), false);
                        }
                    }, contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20], (short)256);
                }
            }
        }
        return new int[]{values_published[0], keys_published[0], republish_ops[0]};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCacheExpiration(boolean force) {
        long elapsed;
        long now = SystemTime.getCurrentTime();
        if (!force && (elapsed = now - this.last_cache_expiry_check) > 0L && elapsed < this.MIN_CACHE_EXPIRY_CHECK_INTERVAL) {
            return;
        }
        try {
            this.this_mon.enter();
            this.last_cache_expiry_check = now;
            Iterator<DHTDBMapping> it = this.stored_values.values().iterator();
            while (it.hasNext()) {
                DHTDBMapping mapping2 = it.next();
                if (mapping2.getValueCount() == 0) {
                    it.remove();
                    this.removeFromPrefixMap(mapping2);
                    mapping2.destroy();
                    continue;
                }
                Iterator<DHTDBValueImpl> it2 = mapping2.getValues();
                while (it2.hasNext()) {
                    int max_age;
                    DHTDBValueImpl value = it2.next();
                    if (value.isLocal()) continue;
                    int life_hours = value.getLifeTimeHours();
                    if (life_hours < 1) {
                        max_age = this.original_republish_interval;
                    } else {
                        max_age = life_hours * 60 * 60 * 1000;
                        if (max_age > 259200000) {
                            max_age = 259200000;
                        }
                    }
                    int grace = (value.getFlags() & 0x40) != 0 ? 0 : Math.min(ORIGINAL_REPUBLISH_INTERVAL_GRACE, max_age / 4);
                    if (now <= value.getCreationTime() + (long)max_age + (long)grace) continue;
                    DHTLog.log("removing cache entry (" + value.getString() + ")");
                    it2.remove();
                }
            }
            Object var12_11 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void addToPrefixMap(DHTDBMapping mapping2) {
        byte[] new_full;
        byte[] existing_full;
        DHTDBMapping.ShortHash key = mapping2.getShortKey();
        DHTDBMapping existing = this.stored_values_prefix_map.get(key);
        if (existing != null && this.control.computeAndCompareDistances(existing_full = existing.getKey().getBytes(), new_full = mapping2.getKey().getBytes(), this.local_contact.getID()) < 0) {
            return;
        }
        this.stored_values_prefix_map.put(key, mapping2);
        if (this.stored_values_prefix_map.size() > this.stored_values.size()) {
            Debug.out("inconsistent");
        }
    }

    protected void removeFromPrefixMap(DHTDBMapping mapping2) {
        DHTDBMapping.ShortHash key = mapping2.getShortKey();
        DHTDBMapping existing = this.stored_values_prefix_map.get(key);
        if (existing == mapping2) {
            this.stored_values_prefix_map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPreciousStuff() {
        HashWrapper key;
        long now = SystemTime.getCurrentTime();
        HashMap republish = new HashMap();
        try {
            this.this_mon.enter();
            for (Map.Entry<HashWrapper, DHTDBMapping> entry : this.stored_values.entrySet()) {
                key = entry.getKey();
                DHTDBMapping mapping2 = entry.getValue();
                Iterator<DHTDBValueImpl> it2 = mapping2.getValues();
                ArrayList<DHTDBValueImpl> values = new ArrayList<DHTDBValueImpl>();
                while (it2.hasNext()) {
                    DHTDBValueImpl value = it2.next();
                    if (!value.isLocal() || (value.getFlags() & 0x20) == 0 || now - value.getCreationTime() <= 0x6DDD00L) continue;
                    value.setCreationTime();
                    values.add(value);
                }
                if (values.size() <= 0) continue;
                republish.put(key, values);
            }
            Object var12_13 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (Map.Entry<HashWrapper, DHTDBMapping> entry : republish.entrySet()) {
            key = entry.getKey();
            List values = (List)((Object)entry.getValue());
            for (int i = 0; i < values.size(); ++i) {
                this.control.putEncodedKey(key.getHash(), "Precious republish", (DHTTransportValue)values.get(i), 0L, true);
            }
        }
    }

    protected DHTTransportContact getLocalContact() {
        return this.local_contact;
    }

    protected DHTStorageAdapter getAdapter() {
        return this.adapter;
    }

    protected void log(String str) {
        this.logger.log(str);
    }

    @Override
    public DHTDBStats getStats() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void survey() {
        block11: {
            if (this.survey_in_progress) {
                return;
            }
            this.checkCacheExpiration(false);
            final byte[] my_id = this.router.getID();
            final ByteArrayHashMap<DHTTransportContact> id_map = new ByteArrayHashMap<DHTTransportContact>();
            List<DHTTransportContact> all_contacts = this.control.getClosestContactsList(my_id, this.router.getK() * 3, true);
            for (DHTTransportContact contact : all_contacts) {
                id_map.put(contact.getID(), contact);
            }
            byte[] max_key = my_id;
            byte[] max_dist = null;
            final ArrayList<HashWrapper> applicable_keys = new ArrayList<HashWrapper>();
            try {
                this.this_mon.enter();
                long now = SystemTime.getMonotonousTime();
                Iterator<SurveyContactState> s_it = this.survey_state.values().iterator();
                while (s_it.hasNext()) {
                    if (!s_it.next().timeout(now)) continue;
                    s_it.remove();
                }
                Iterator<DHTDBMapping> it = this.stored_values.values().iterator();
                HashSet<HashWrapper> existing_times = new HashSet<HashWrapper>(this.survey_mapping_times.keySet());
                while (it.hasNext()) {
                    DHTDBMapping mapping2 = it.next();
                    HashWrapper hw = mapping2.getKey();
                    if (existing_times.size() > 0) {
                        existing_times.remove(hw);
                    }
                    if (!this.applyRF(mapping2)) continue;
                    applicable_keys.add(hw);
                    byte[] key = hw.getBytes();
                    byte[] distance = this.control.computeDistance(my_id, key);
                    if (max_dist != null && this.control.compareDistances(distance, max_dist) <= 0) continue;
                    max_dist = distance;
                    max_key = key;
                }
                for (HashWrapper hw : existing_times) {
                    this.survey_mapping_times.remove(hw);
                }
                this.logger.log("Survey starts: state size=" + this.survey_state.size() + ", all keys=" + this.stored_values.size() + ", applicable keys=" + applicable_keys.size());
                Object var17_17 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var17_18 = null;
                this.this_mon.exit();
                throw throwable;
            }
            if (max_key == my_id) {
                this.logger.log("Survey complete - no applicable values");
                return;
            }
            byte[] obscured_key = this.control.getObfuscatedKey(max_key);
            final int[] requery_count = new int[]{0};
            final boolean[] processing = new boolean[]{false};
            try {
                this.survey_in_progress = true;
                this.control.lookupEncoded(obscured_key, "Neighbourhood survey: basic", 0L, true, new DHTOperationAdapter(){
                    private List<DHTTransportContact> contacts = new ArrayList<DHTTransportContact>();
                    private boolean survey_complete;

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void found(DHTTransportContact contact, boolean is_closest) {
                        if (is_closest) {
                            List<DHTTransportContact> list = this.contacts;
                            synchronized (list) {
                                if (!this.survey_complete) {
                                    this.contacts.add(contact);
                                }
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void complete(boolean timeout) {
                        block16: {
                            List<DHTTransportContact> list;
                            boolean requeried = false;
                            try {
                                int hits = 0;
                                int misses = 0;
                                byte[] min_dist = null;
                                byte[] min_id = null;
                                List<DHTTransportContact> list2 = this.contacts;
                                synchronized (list2) {
                                    for (DHTTransportContact c : this.contacts) {
                                        byte[] id = c.getID();
                                        if (id_map.containsKey(id)) {
                                            ++hits;
                                            continue;
                                        }
                                        ++misses;
                                        if (id_map.size() >= 100) {
                                            DHTDBImpl.this.log("Max survery size exceeded");
                                            break;
                                        }
                                        id_map.put(id, c);
                                        byte[] distance = DHTDBImpl.this.control.computeDistance(my_id, id);
                                        if (min_dist != null && DHTDBImpl.this.control.compareDistances(distance, min_dist) >= 0) continue;
                                        min_dist = distance;
                                        min_id = id;
                                    }
                                    this.contacts.clear();
                                }
                                if (misses > 0 && misses * 100 / (hits + misses) >= 25 && id_map.size() < 100) {
                                    int n = requery_count[0];
                                    requery_count[0] = n + 1;
                                    if (n < 5) {
                                        DHTDBImpl.this.control.lookupEncoded(min_id, "Neighbourhood survey: level=" + requery_count[0], 0L, true, this);
                                        requeried = true;
                                    }
                                }
                                Object var14_13 = null;
                                if (requeried) break block16;
                                list = this.contacts;
                            }
                            catch (Throwable throwable) {
                                Object var14_14 = null;
                                if (!requeried) {
                                    List<DHTTransportContact> list3 = this.contacts;
                                    synchronized (list3) {
                                        this.survey_complete = true;
                                    }
                                    DHTDBImpl.this.processSurvey(my_id, applicable_keys, id_map);
                                    processing[0] = true;
                                }
                                throw throwable;
                            }
                            synchronized (list) {
                                this.survey_complete = true;
                            }
                            DHTDBImpl.this.processSurvey(my_id, applicable_keys, id_map);
                            processing[0] = true;
                            {
                            }
                        }
                    }
                });
            }
            catch (Throwable e) {
                if (processing[0]) break block11;
                this.logger.log("Survey complete - no applicable nodes");
                this.survey_in_progress = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processSurvey(byte[] survey_my_id, List<HashWrapper> applicable_keys, ByteArrayHashMap<DHTTransportContact> survey) {
        boolean went_async = false;
        try {
            byte[][] node_ids = new byte[survey.size()][];
            int pos = 0;
            for (byte[] id : survey.keys()) {
                node_ids[pos++] = id;
            }
            ByteArrayHashMap<ArrayList<DHTDBMapping>> value_map = new ByteArrayHashMap<ArrayList<DHTDBMapping>>();
            HashMap request_map = new HashMap();
            HashMap<DHTDBMapping, List<DHTTransportContact>> mapping_to_node_map = new HashMap<DHTDBMapping, List<DHTTransportContact>>();
            int max_nodes = Math.min(node_ids.length, this.router.getK());
            try {
                this.this_mon.enter();
                Iterator<HashWrapper> it = applicable_keys.iterator();
                int value_count = 0;
                while (it.hasNext()) {
                    DHTDBMapping mapping2 = this.stored_values.get(it.next());
                    if (mapping2 == null) continue;
                    ++value_count;
                    final byte[] key = mapping2.getKey().getBytes();
                    Arrays.sort(node_ids, new Comparator<byte[]>(){

                        @Override
                        public int compare(byte[] o1, byte[] o2) {
                            return DHTDBImpl.this.control.computeAndCompareDistances(o1, o2, key);
                        }
                    });
                    boolean found_myself = false;
                    for (int i = 0; i < max_nodes; ++i) {
                        byte[] id = node_ids[i];
                        if (!Arrays.equals(survey_my_id, id)) continue;
                        found_myself = true;
                        break;
                    }
                    if (!found_myself) continue;
                    ArrayList<DHTTransportContact> node_list = new ArrayList<DHTTransportContact>(max_nodes);
                    mapping_to_node_map.put(mapping2, node_list);
                    for (int i = 0; i < max_nodes; ++i) {
                        byte[] id = node_ids[i];
                        if (Arrays.equals(survey_my_id, id)) continue;
                        ArrayList<DHTDBMapping> list = (ArrayList<DHTDBMapping>)value_map.get(id);
                        if (list == null) {
                            list = new ArrayList<DHTDBMapping>();
                            value_map.put(id, list);
                        }
                        list.add(mapping2);
                        node_list.add(survey.get(id));
                    }
                }
                for (byte[] id : node_ids) {
                    int MAX_PREFIX_TEST = 3;
                    List all_entries = (List)value_map.remove(id);
                    ByteArrayHashMap<List> prefix_map = new ByteArrayHashMap<List>();
                    if (all_entries == null) continue;
                    prefix_map.put(new byte[0], all_entries);
                    for (int i = 0; i < 3; ++i) {
                        List<byte[]> prefixes = prefix_map.keys();
                        for (byte[] prefix : prefixes) {
                            ArrayList<DHTDBMapping> entries;
                            List list;
                            if (prefix.length != i || (list = (List)prefix_map.get(prefix)).size() < 2) continue;
                            ByteArrayHashMap<ArrayList<DHTDBMapping>> temp_map = new ByteArrayHashMap<ArrayList<DHTDBMapping>>();
                            for (DHTDBMapping mapping3 : list) {
                                byte[] key = mapping3.getKey().getBytes();
                                byte[] sub_prefix = new byte[i + 1];
                                System.arraycopy(key, 0, sub_prefix, 0, i + 1);
                                entries = (List)temp_map.get(sub_prefix);
                                if (entries == null) {
                                    entries = new ArrayList<DHTDBMapping>();
                                    temp_map.put(sub_prefix, entries);
                                }
                                entries.add(mapping3);
                            }
                            ArrayList<DHTDBMapping> new_list = new ArrayList<DHTDBMapping>(list.size());
                            List<byte[]> temp_keys = temp_map.keys();
                            for (byte[] k : temp_keys) {
                                int outer_cost;
                                entries = (ArrayList<DHTDBMapping>)temp_map.get(k);
                                int num = entries.size();
                                int inner_cost = i + 4 + num * (6 - i - 1);
                                if (inner_cost < (outer_cost = num * (6 - i))) {
                                    prefix_map.put(k, entries);
                                    continue;
                                }
                                new_list.addAll(entries);
                            }
                            if (new_list.size() == 0) {
                                prefix_map.remove(prefix);
                                continue;
                            }
                            prefix_map.put(prefix, new_list);
                        }
                    }
                    String str = "";
                    int encoded_size = 1;
                    List<byte[]> prefixes = prefix_map.keys();
                    for (byte[] prefix : prefixes) {
                        encoded_size += 3 + prefix.length;
                        List entries = (List)prefix_map.get(prefix);
                        encoded_size += (6 - prefix.length) * entries.size();
                        str = str + (str.length() == 0 ? "" : ", ") + ByteFormatter.encodeString(prefix) + "->" + entries.size();
                    }
                    if (prefixes.size() <= 0) continue;
                    request_map.put(survey.get(id), prefix_map);
                }
                Object var35_43 = null;
                this.this_mon.exit();
            }
            catch (Throwable throwable) {
                Object var35_44 = null;
                this.this_mon.exit();
                throw throwable;
            }
            LinkedList<Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>>> to_do = new LinkedList<Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>>>(request_map.entrySet());
            HashMap<DHTTransportContact, Object[]> replies = new HashMap<DHTTransportContact, Object[]>();
            for (int i = 0; i < Math.min(3, to_do.size()); ++i) {
                went_async = true;
                this.doQuery(survey_my_id, request_map.size(), mapping_to_node_map, to_do, replies, null, null, null);
            }
            Object var37_46 = null;
            if (!went_async) {
                this.logger.log("Survey complete - no applicable queries");
                this.survey_in_progress = false;
            }
        }
        catch (Throwable throwable) {
            Object var37_47 = null;
            if (!went_async) {
                this.logger.log("Survey complete - no applicable queries");
                this.survey_in_progress = false;
            }
            throw throwable;
        }
    }

    protected boolean applyRF(DHTDBMapping mapping2) {
        if (mapping2.getDiversificationType() != 1) {
            return false;
        }
        Iterator<DHTDBValueImpl> it2 = mapping2.getValues();
        if (!it2.hasNext()) {
            return false;
        }
        int min_period = Integer.MAX_VALUE;
        long min_create = Long.MAX_VALUE;
        while (it2.hasNext()) {
            DHTDBValueImpl value = it2.next();
            byte rep_fact = value.getReplicationFactor();
            if (rep_fact == -1 || rep_fact == 0) {
                return false;
            }
            int hours = value.getReplicationFrequencyHours() & 0xFF;
            if (hours < min_period) {
                min_period = hours;
            }
            min_create = Math.min(min_create, value.getCreationTime());
        }
        if (min_period > 0) {
            long rand;
            HashWrapper hw = mapping2.getKey();
            Long next_time = this.survey_mapping_times.get(hw);
            long now = SystemTime.getMonotonousTime();
            if (next_time != null && next_time > now) {
                return false;
            }
            long period = min_period * 60 * 60 * 1000;
            long offset_time = (SystemTime.getCurrentTime() - min_create) % period;
            long new_next_time = now - offset_time + period + (rand = (long)(RandomUtils.nextInt(1800000) - 900000));
            if (new_next_time < now + 1800000L) {
                new_next_time += period;
            }
            this.survey_mapping_times.put(hw, new_next_time);
            if (next_time == null) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doQuery(final byte[] survey_my_id, final int total, final Map<DHTDBMapping, List<DHTTransportContact>> mapping_to_node_map, final LinkedList<Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>>> to_do, final Map<DHTTransportContact, Object[]> replies, DHTTransportContact done_contact, List<DHTDBMapping> done_mappings, List<byte[]> done_reply) {
        block17: {
            List<byte[]> prefixes3;
            ByteArrayHashMap<List<DHTDBMapping>> map3;
            ArrayList<DHTDBMapping> mapping_list3;
            Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>> entry;
            LinkedList<Map.Entry<DHTTransportContact, ByteArrayHashMap<List<DHTDBMapping>>>> linkedList = to_do;
            synchronized (linkedList) {
                if (done_contact != null) {
                    replies.put(done_contact, new Object[]{done_mappings, done_reply});
                }
                if (to_do.size() == 0) {
                    if (replies.size() == total) {
                        this.queriesComplete(survey_my_id, mapping_to_node_map, replies);
                    }
                    return;
                }
                entry = to_do.removeFirst();
            }
            DHTTransportContact contact = entry.getKey();
            boolean handled = false;
            try {
                if (contact.getProtocolVersion() >= 26) {
                    final ArrayList<DHTDBMapping> mapping_list2 = new ArrayList<DHTDBMapping>();
                    ByteArrayHashMap<List<DHTDBMapping>> map2 = entry.getValue();
                    List<byte[]> prefixes2 = map2.keys();
                    ArrayList<Object[]> encoded = new ArrayList<Object[]>(prefixes2.size());
                    try {
                        this.this_mon.enter();
                        SurveyContactState contact_state = this.survey_state.get(new HashWrapper(contact.getID()));
                        for (byte[] prefix : prefixes2) {
                            int prefix_len = prefix.length;
                            int suffix_len = 6 - prefix_len;
                            List<DHTDBMapping> mappings = map2.get(prefix);
                            ArrayList<byte[]> l = new ArrayList<byte[]>(mappings.size());
                            encoded.add(new Object[]{prefix, l});
                            for (DHTDBMapping m : mappings) {
                                if (contact_state != null && contact_state.testMapping(m)) continue;
                                mapping_list2.add(m);
                                byte[] k = m.getKey().getBytes();
                                byte[] suffix = new byte[suffix_len];
                                System.arraycopy(k, prefix_len, suffix, 0, suffix_len);
                                l.add(suffix);
                            }
                        }
                        if (Arrays.equals(contact.getID(), survey_my_id)) {
                            Debug.out("inconsistent - we shouldn't query ourselves!");
                        }
                        contact.sendQueryStore(new DHTTransportReplyHandlerAdapter(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void queryStoreReply(DHTTransportContact contact, List<byte[]> response) {
                                try {
                                    Object var4_3 = null;
                                    DHTDBImpl.this.doQuery(survey_my_id, total, mapping_to_node_map, to_do, replies, contact, mapping_list2, response);
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    DHTDBImpl.this.doQuery(survey_my_id, total, mapping_to_node_map, to_do, replies, contact, mapping_list2, response);
                                    throw throwable;
                                }
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void failed(DHTTransportContact contact, Throwable error) {
                                try {
                                    Object var4_3 = null;
                                    DHTDBImpl.this.doQuery(survey_my_id, total, mapping_to_node_map, to_do, replies, contact, mapping_list2, null);
                                }
                                catch (Throwable throwable) {
                                    Object var4_4 = null;
                                    DHTDBImpl.this.doQuery(survey_my_id, total, mapping_to_node_map, to_do, replies, contact, mapping_list2, null);
                                    throw throwable;
                                }
                            }
                        }, 6, encoded);
                        handled = true;
                        Object var28_28 = null;
                        this.this_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var28_29 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var30_31 = null;
                if (handled) break block17;
                mapping_list3 = new ArrayList<DHTDBMapping>();
                map3 = entry.getValue();
                prefixes3 = map3.keys();
            }
            catch (Throwable throwable) {
                Object var30_32 = null;
                if (!handled) {
                    ArrayList<DHTDBMapping> mapping_list3 = new ArrayList<DHTDBMapping>();
                    ByteArrayHashMap<List<DHTDBMapping>> map3 = entry.getValue();
                    List<byte[]> prefixes3 = map3.keys();
                    for (byte[] prefix : prefixes3) {
                        mapping_list3.addAll((Collection)map3.get(prefix));
                    }
                    this.doQuery(survey_my_id, total, mapping_to_node_map, to_do, replies, contact, mapping_list3, null);
                }
                throw throwable;
            }
            for (byte[] prefix : prefixes3) {
                mapping_list3.addAll((Collection)map3.get(prefix));
            }
            this.doQuery(survey_my_id, total, mapping_to_node_map, to_do, replies, contact, mapping_list3, null);
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queriesComplete(byte[] survey_my_id, Map<DHTDBMapping, List<DHTTransportContact>> mapping_to_node_map, Map<DHTTransportContact, Object[]> replies) {
        HashMap<SurveyContactState, ArrayList<DHTDBMapping>> store_ops = new HashMap<SurveyContactState, ArrayList<DHTDBMapping>>();
        try {
            this.this_mon.enter();
            if (!Arrays.equals(survey_my_id, this.router.getID())) {
                this.logger.log("Survey abandoned - router changed");
                Object var25_5 = null;
                this.this_mon.exit();
                this.survey_in_progress = false;
                return;
            }
            HashMap<DHTDBMapping, int[]> totals = new HashMap<DHTDBMapping, int[]>();
            for (Map.Entry<DHTTransportContact, Object[]> entry : replies.entrySet()) {
                DHTTransportContact contact = entry.getKey();
                HashWrapper hw = new HashWrapper(contact.getID());
                SurveyContactState contact_state = this.survey_state.get(hw);
                if (contact_state != null) {
                    contact_state.updateContactDetails(contact);
                } else {
                    contact_state = new SurveyContactState(contact);
                    this.survey_state.put(hw, contact_state);
                }
                contact_state.updateUseTime();
                Object[] temp = entry.getValue();
                List mappings = (List)temp[0];
                List reply = (List)temp[1];
                if (reply == null) {
                    contact_state.contactFailed();
                    continue;
                }
                contact_state.contactOK();
                if (mappings.size() != reply.size()) {
                    Debug.out("Inconsistent: mappings=" + mappings.size() + ", reply=" + reply.size());
                    continue;
                }
                Iterator it1 = mappings.iterator();
                Iterator it2 = reply.iterator();
                while (it1.hasNext()) {
                    DHTDBMapping mapping2 = (DHTDBMapping)it1.next();
                    byte[] rep = (byte[])it2.next();
                    if (rep == null) {
                        contact_state.removeMapping(mapping2);
                        continue;
                    }
                    DHTDBMapping mapping_to_check = this.stored_values_prefix_map.get(mapping2.getShortKey());
                    if (mapping_to_check == null) continue;
                    byte[] k = mapping_to_check.getKey().getBytes();
                    int rep_len = rep.length;
                    if (rep_len < 2 || rep_len >= k.length) {
                        Debug.out("Invalid rep_len: " + rep_len);
                        continue;
                    }
                    boolean match = true;
                    int offset = k.length - rep_len;
                    for (int i = 0; i < rep_len; ++i) {
                        if (rep[i] == k[i + offset]) continue;
                        match = false;
                        break;
                    }
                    if (match) {
                        contact_state.addMapping(mapping2);
                        continue;
                    }
                    contact_state.removeMapping(mapping2);
                }
                Set<DHTDBMapping> contact_mappings = contact_state.getMappings();
                for (DHTDBMapping m : contact_mappings) {
                    int[] t = (int[])totals.get(m);
                    if (t == null) {
                        t = new int[]{2};
                        totals.put(m, t);
                        continue;
                    }
                    t[0] = t[0] + 1;
                }
            }
            for (Map.Entry<Object, Object> entry : mapping_to_node_map.entrySet()) {
                DHTDBMapping mapping3 = (DHTDBMapping)entry.getKey();
                List contacts = (List)entry.getValue();
                int[] t = (int[])totals.get(mapping3);
                int copies = t == null ? 1 : t[0];
                Iterator<DHTDBValueImpl> values = mapping3.getValues();
                if (!values.hasNext()) continue;
                int max_replication_factor = -1;
                while (values.hasNext()) {
                    DHTDBValueImpl value = values.next();
                    byte rf = value.getReplicationFactor();
                    if (rf <= max_replication_factor) continue;
                    max_replication_factor = rf;
                }
                if (max_replication_factor == 0) continue;
                if (max_replication_factor > this.router.getK()) {
                    max_replication_factor = this.router.getK();
                }
                if (copies >= max_replication_factor) continue;
                int required = max_replication_factor - copies;
                ArrayList<SurveyContactState> potential_targets = new ArrayList<SurveyContactState>();
                ArrayList<byte[]> addresses = new ArrayList<byte[]>(contacts.size());
                for (DHTTransportContact c : contacts) {
                    if (c.getProtocolVersion() < 26) continue;
                    addresses.add(AddressUtils.getAddressBytes(c.getAddress()));
                    SurveyContactState contact_state = this.survey_state.get(new HashWrapper(c.getID()));
                    if (contact_state == null || contact_state.testMapping(mapping3)) continue;
                    potential_targets.add(contact_state);
                }
                HashSet<HashWrapper> bad_addresses = new HashSet<HashWrapper>();
                for (byte[] a1 : addresses) {
                    for (byte[] a2 : addresses) {
                        if (a1 == a2 || a1.length != a2.length || a1.length != 4 || a1[0] != a2[0] || a1[1] != a2[1]) continue;
                        this.log("/16 match on " + ByteFormatter.encodeString(a1) + "/" + ByteFormatter.encodeString(a2));
                        bad_addresses.add(new HashWrapper(a1));
                        bad_addresses.add(new HashWrapper(a2));
                    }
                }
                final byte[] key = mapping3.getKey().getBytes();
                Collections.sort(potential_targets, new Comparator<SurveyContactState>(){

                    @Override
                    public int compare(SurveyContactState o1, SurveyContactState o2) {
                        boolean o2_bad;
                        boolean o1_bad = o1.getConsecFails() >= 2;
                        boolean bl = o2_bad = o2.getConsecFails() >= 2;
                        if (o1_bad == o2_bad) {
                            return DHTDBImpl.this.control.computeAndCompareDistances(o1.getContact().getID(), o2.getContact().getID(), key);
                        }
                        if (o1_bad) {
                            return 1;
                        }
                        return -1;
                    }
                });
                int avail = Math.min(required, potential_targets.size());
                for (int i = 0; i < avail; ++i) {
                    SurveyContactState target = (SurveyContactState)potential_targets.get(i);
                    if (bad_addresses.size() > 0 && bad_addresses.contains(new HashWrapper(AddressUtils.getAddressBytes(target.getContact().getAddress())))) {
                        target.addMapping(mapping3);
                        continue;
                    }
                    ArrayList<DHTDBMapping> m = (ArrayList<DHTDBMapping>)store_ops.get(target);
                    if (m == null) {
                        m = new ArrayList<DHTDBMapping>();
                        store_ops.put(target, m);
                    }
                    m.add(mapping3);
                }
            }
        }
        catch (Throwable throwable) {
            Object var25_7 = null;
            this.this_mon.exit();
            this.survey_in_progress = false;
            throw throwable;
        }
        Object var25_6 = null;
        this.this_mon.exit();
        this.survey_in_progress = false;
        this.logger.log("Survey complete - " + store_ops.size() + " store ops");
        for (Map.Entry store_op : store_ops.entrySet()) {
            final SurveyContactState surveyContactState = (SurveyContactState)store_op.getKey();
            final List keys = (List)store_op.getValue();
            final byte[][] store_keys = new byte[keys.size()][];
            final DHTTransportValue[][] store_values = new DHTTransportValue[store_keys.length][];
            for (int i = 0; i < store_keys.length; ++i) {
                DHTDBMapping mapping4 = (DHTDBMapping)keys.get(i);
                store_keys[i] = mapping4.getKey().getBytes();
                ArrayList<DHTDBValue> v = new ArrayList<DHTDBValue>();
                Iterator<DHTDBValueImpl> it = mapping4.getValues();
                while (it.hasNext()) {
                    DHTDBValueImpl value = it.next();
                    if (value.isLocal()) continue;
                    v.add(value.getValueForRelay(this.local_contact));
                }
                store_values[i] = v.toArray(new DHTTransportValue[v.size()]);
            }
            final DHTTransportContact d_contact = surveyContactState.getContact();
            final Runnable store_exec = new Runnable(){

                public void run() {
                    DHTDBImpl.this.control.putDirectEncodedKeys(store_keys, "Replication forward", store_values, d_contact, new DHTOperationAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void complete(boolean timeout) {
                            try {
                                DHTDBImpl.this.this_mon.enter();
                                if (timeout) {
                                    surveyContactState.contactFailed();
                                } else {
                                    surveyContactState.contactOK();
                                    for (DHTDBMapping m : keys) {
                                        surveyContactState.addMapping(m);
                                    }
                                }
                                Object var5_4 = null;
                                DHTDBImpl.this.this_mon.exit();
                            }
                            catch (Throwable throwable) {
                                Object var5_5 = null;
                                DHTDBImpl.this.this_mon.exit();
                                throw throwable;
                            }
                        }
                    });
                }
            };
            if (d_contact.getRandomIDType() != 1) {
                Debug.out("derp");
            }
            if (d_contact.getRandomID() == 0) {
                d_contact.sendFindNode(new DHTTransportReplyHandlerAdapter(){

                    public void findNodeReply(DHTTransportContact _contact, DHTTransportContact[] _contacts) {
                        store_exec.run();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void failed(DHTTransportContact _contact, Throwable _error) {
                        try {
                            DHTDBImpl.this.this_mon.enter();
                            surveyContactState.contactFailed();
                            Object var4_3 = null;
                            DHTDBImpl.this.this_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            DHTDBImpl.this.this_mon.exit();
                            throw throwable;
                        }
                    }
                }, d_contact.getProtocolVersion() >= 8 ? new byte[]{} : new byte[20], (short)256);
                continue;
            }
            store_exec.run();
        }
    }

    private void sleep() {
        Iterator<Map.Entry<HashWrapper, DHTDBMapping>> it = this.stored_values.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<HashWrapper, DHTDBMapping> entry = it.next();
            HashWrapper key = entry.getKey();
            DHTDBMapping mapping2 = entry.getValue();
            Iterator<DHTDBValueImpl> it2 = mapping2.getValues();
            boolean all_remote = it2.hasNext();
            while (it2.hasNext()) {
                DHTDBValueImpl value = it2.next();
                if (!value.isLocal()) continue;
                all_remote = false;
                break;
            }
            if (!all_remote) continue;
            it.remove();
            this.removeFromPrefixMap(mapping2);
            mapping2.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSleeping(boolean asleep) {
        try {
            this.this_mon.enter();
            this.sleeping = asleep;
            if (asleep) {
                this.sleep();
            }
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSuspended(boolean susp) {
        boolean waking_up;
        try {
            this.this_mon.enter();
            waking_up = this.suspended && !susp;
            this.suspended = susp;
            if (susp) {
                this.sleep();
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        if (waking_up) {
            new AEThread2("DHTB:resume"){

                public void run() {
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                    DHTDBImpl.this.logger.log("Force republish of original mappings due to resume from suspend");
                    long start = SystemTime.getMonotonousTime();
                    int stats2 = DHTDBImpl.this.republishOriginalMappings();
                    long end = SystemTime.getMonotonousTime();
                    DHTDBImpl.this.logger.log("Force republish of original mappings due to resume from suspend completed in " + (end - start) + ": " + "values = " + stats2);
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DHTTransportQueryStoreReply queryStore(DHTTransportContact originating_contact, int header_len, List<Object[]> keys) {
        final ArrayList<byte[]> reply = new ArrayList<byte[]>();
        try {
            this.this_mon.enter();
            SurveyContactState existing_state = this.survey_state.get(new HashWrapper(originating_contact.getID()));
            if (existing_state != null) {
                existing_state.updateContactDetails(originating_contact);
            }
            for (Object[] entry : keys) {
                byte[] prefix = (byte[])entry[0];
                List suffixes = (List)entry[1];
                byte[] header = new byte[header_len];
                int prefix_len = prefix.length;
                int suffix_len = header_len - prefix_len;
                System.arraycopy(prefix, 0, header, 0, prefix_len);
                for (byte[] suffix : suffixes) {
                    System.arraycopy(suffix, 0, header, prefix_len, suffix_len);
                    DHTDBMapping mapping2 = this.stored_values_prefix_map.get(new DHTDBMapping.ShortHash(header));
                    if (mapping2 == null) {
                        reply.add(null);
                        continue;
                    }
                    if (existing_state != null) {
                        existing_state.addMapping(mapping2);
                    }
                    byte[] k = mapping2.getKey().getBytes();
                    byte[] r = new byte[2];
                    System.arraycopy(k, k.length - 2, r, 0, 2);
                    reply.add(r);
                }
            }
            DHTTransportQueryStoreReply dHTTransportQueryStoreReply = new DHTTransportQueryStoreReply(){

                @Override
                public int getHeaderSize() {
                    return 2;
                }

                @Override
                public List<byte[]> getEntries() {
                    return reply;
                }
            };
            Object var19_18 = null;
            this.this_mon.exit();
            return dHTTransportQueryStoreReply;
        }
        catch (Throwable throwable) {
            Object var19_19 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(boolean full) {
        TreeMap<Integer, Object[]> count = new TreeMap<Integer, Object[]>();
        try {
            this.this_mon.enter();
            this.logger.log("Stored keys = " + this.stored_values.size() + ", values = " + this.getValueDetails()[0]);
            if (!full) {
                Object var14_3 = null;
                this.this_mon.exit();
                return;
            }
            for (Map.Entry<HashWrapper, DHTDBMapping> entry : this.stored_values.entrySet()) {
                HashWrapper value_key = entry.getKey();
                DHTDBMapping mapping2 = entry.getValue();
                DHTDBValueImpl[] values = mapping2.get(null, 0, (short)0);
                for (int i = 0; i < values.length; ++i) {
                    DHTDBValueImpl value = values[i];
                    Integer key = new Integer(value.isLocal() ? 0 : 1);
                    Object[] data = (Object[])count.get(key);
                    if (data == null) {
                        data = new Object[]{new Integer(1), ""};
                        count.put(key, data);
                    } else {
                        data[0] = new Integer((Integer)data[0] + 1);
                    }
                    String s = (String)data[1];
                    s = s + (s.length() == 0 ? "" : ", ") + "key=" + DHTLog.getString2(value_key.getHash()) + ",val=" + value.getString();
                    data[1] = s;
                }
            }
            for (Integer k : count.keySet()) {
                Object[] data = (Object[])count.get(k);
                this.logger.log("    " + k + " -> " + data[0] + " entries");
            }
            Iterator<Map.Entry<HashWrapper, DHTDBMapping>> it3 = this.stored_values.entrySet().iterator();
            StringBuilder sb = new StringBuilder(1024);
            int str_entries = 0;
            while (it3.hasNext()) {
                Map.Entry<HashWrapper, DHTDBMapping> entry = it3.next();
                HashWrapper value_key = entry.getKey();
                DHTDBMapping mapping3 = entry.getValue();
                if (str_entries == 16) {
                    this.logger.log(sb.toString());
                    sb = new StringBuilder(1024);
                    sb.append("    ");
                    str_entries = 0;
                }
                if (++str_entries > 1) {
                    sb.append(", ");
                }
                sb.append(DHTLog.getString2(value_key.getHash()));
                sb.append(" -> ");
                sb.append(mapping3.getValueCount());
                sb.append("/");
                sb.append(mapping3.getHits());
                sb.append("[");
                sb.append(mapping3.getLocalSize());
                sb.append(",");
                sb.append(mapping3.getDirectSize());
                sb.append(",");
                sb.append(mapping3.getIndirectSize());
                sb.append("]");
            }
            if (str_entries > 0) {
                this.logger.log(sb.toString());
            }
        }
        catch (Throwable throwable) {
            Object var14_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var14_4 = null;
        this.this_mon.exit();
    }

    protected void banContact(final DHTTransportContact contact, String reason) {
        final boolean ban_ip = this.control.getTransport().getNetwork() != 1;
        new AEThread2("DHTDBImpl:delayed flood delete", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    DHTDBImpl.this.this_mon.enter();
                    Iterator it = DHTDBImpl.this.stored_values.values().iterator();
                    boolean overall_deleted = false;
                    HashWrapper value_id = new HashWrapper(contact.getID());
                    while (it.hasNext()) {
                        DHTDBMapping mapping2 = (DHTDBMapping)it.next();
                        boolean deleted = false;
                        if (mapping2.removeDirectValue(value_id) != null) {
                            deleted = true;
                        }
                        if (mapping2.removeIndirectValue(value_id) != null) {
                            deleted = true;
                        }
                        if (!deleted || ban_ip) continue;
                        mapping2.rebuildIPBloomFilter(false);
                        overall_deleted = true;
                    }
                    if (overall_deleted && !ban_ip) {
                        DHTDBImpl.this.rebuildIPBloomFilter(false);
                    }
                    Object var7_6 = null;
                    DHTDBImpl.this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    DHTDBImpl.this.this_mon.exit();
                    throw throwable;
                }
            }
        }.start();
        if (ban_ip) {
            this.logger.log("Banning " + contact.getString() + " due to store flooding (" + reason + ")");
            this.ip_filter.ban(AddressUtils.getHostAddress(contact.getAddress()), "DHT: Sender stored excessive entries at this node (" + reason + ")", false);
        }
    }

    protected void incrementValueAdds(DHTTransportContact contact) {
        byte[] bloom_key = contact.getBloomKey();
        int hit_count = this.ip_count_bloom_filter.add(bloom_key);
        if (this.ip_count_bloom_filter.getSize() / this.ip_count_bloom_filter.getEntryCount() < 10) {
            this.rebuildIPBloomFilter(true);
        }
        if (hit_count > 64) {
            this.banContact(contact, "global flood");
        }
    }

    protected void decrementValueAdds(DHTTransportContact contact) {
        byte[] bloom_key = contact.getBloomKey();
        int hit_count = this.ip_count_bloom_filter.remove(bloom_key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebuildIPBloomFilter(boolean increase_size) {
        BloomFilter new_filter = increase_size ? BloomFilterFactory.createAddRemove8Bit(this.ip_count_bloom_filter.getSize() + 1000) : BloomFilterFactory.createAddRemove8Bit(this.ip_count_bloom_filter.getSize());
        try {
            Iterator<DHTDBMapping> it = this.stored_values.values().iterator();
            int max_hits = 0;
            while (it.hasNext()) {
                DHTDBMapping mapping2 = it.next();
                mapping2.rebuildIPBloomFilter(false);
                Iterator<DHTDBValueImpl> it2 = mapping2.getDirectValues();
                while (it2.hasNext()) {
                    byte[] bloom_key;
                    int hits;
                    DHTDBValueImpl val = it2.next();
                    if (val.isLocal() || (hits = new_filter.add(bloom_key = val.getOriginator().getBloomKey())) <= max_hits) continue;
                    max_hits = hits;
                }
            }
            this.logger.log("Rebuilt global IP bloom filter, size=" + new_filter.getSize() + ", entries=" + new_filter.getEntryCount() + ", max hits=" + max_hits);
            Object var11_10 = null;
            this.ip_count_bloom_filter = new_filter;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            this.ip_count_bloom_filter = new_filter;
            throw throwable;
        }
    }

    protected void reportSizes(String op) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getNextValueVersion() {
        try {
            int res;
            this.this_mon.enter();
            if (this.next_value_version_left == 0) {
                this.next_value_version_left = 128;
                if (this.adapter != null) {
                    this.next_value_version = this.adapter.getNextValueVersions(128);
                }
            }
            --this.next_value_version_left;
            int n = res = this.next_value_version++;
            Object var4_3 = null;
            this.this_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        if (this.precious_timer != null) {
            this.precious_timer.cancel();
        }
        if (this.original_republish_timer != null) {
            this.original_republish_timer.cancel();
        }
        if (this.cache_republish_timer != null) {
            this.cache_republish_timer.cancel();
        }
        if (this.bloom_timer != null) {
            this.bloom_timer.cancel();
        }
        if (this.survey_timer != null) {
            this.survey_timer.cancel();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SurveyContactState {
        private DHTTransportContact contact;
        private long creation_time = SystemTime.getMonotonousTime();
        private long timeout = this.creation_time + 12600000L + (long)RandomUtils.nextInt(3600000);
        private long last_used = this.creation_time;
        private Set<DHTDBMapping> mappings = new HashSet<DHTDBMapping>();
        private int consec_fails;

        protected SurveyContactState(DHTTransportContact c) {
            this.contact = c;
            this.log("new");
        }

        protected boolean timeout(long now) {
            return now - this.last_used > 3600000L || now > this.timeout;
        }

        protected DHTTransportContact getContact() {
            return this.contact;
        }

        protected long getCreationTime() {
            return this.creation_time;
        }

        protected void updateContactDetails(DHTTransportContact c) {
            if (c.getInstanceID() != this.contact.getInstanceID()) {
                this.log("instance id changed");
                this.mappings.clear();
            }
            this.contact = c;
        }

        protected void updateUseTime() {
            this.last_used = SystemTime.getMonotonousTime();
        }

        protected long getLastUseTime() {
            return this.last_used;
        }

        protected void contactOK() {
            this.log("contact ok");
            this.consec_fails = 0;
        }

        protected void contactFailed() {
            ++this.consec_fails;
            this.log("failed, consec=" + this.consec_fails);
            if (this.consec_fails >= 2) {
                this.mappings.clear();
            }
        }

        protected int getConsecFails() {
            return this.consec_fails;
        }

        protected boolean testMapping(DHTDBMapping mapping2) {
            return this.mappings.contains(mapping2);
        }

        protected Set<DHTDBMapping> getMappings() {
            return this.mappings;
        }

        protected void addMapping(DHTDBMapping mapping2) {
            if (this.mappings.add(mapping2)) {
                this.log("add mapping");
            }
        }

        protected void removeMapping(DHTDBMapping mapping2) {
            if (this.mappings.remove(mapping2)) {
                this.log("remove mapping");
            }
        }

        protected void log(String str) {
        }
    }

    protected class adapterFacade
    implements DHTStorageAdapter {
        private DHTStorageAdapter delegate;

        protected adapterFacade(DHTStorageAdapter _delegate) {
            this.delegate = _delegate;
        }

        public int getNetwork() {
            return this.delegate.getNetwork();
        }

        public DHTStorageKey keyCreated(HashWrapper key, boolean local) {
            DHTDBImpl.this.reportSizes("keyAdded");
            DHTDBImpl.this.total_keys++;
            return this.delegate.keyCreated(key, local);
        }

        public void keyDeleted(DHTStorageKey adapter_key) {
            DHTDBImpl.this.total_keys--;
            this.delegate.keyDeleted(adapter_key);
            DHTDBImpl.this.reportSizes("keyDeleted");
        }

        public int getKeyCount() {
            return this.delegate.getKeyCount();
        }

        public void keyRead(DHTStorageKey adapter_key, DHTTransportContact contact) {
            DHTDBImpl.this.reportSizes("keyRead");
            this.delegate.keyRead(adapter_key, contact);
        }

        public DHTStorageKeyStats deserialiseStats(DataInputStream is) throws IOException {
            return this.delegate.deserialiseStats(is);
        }

        public void valueAdded(DHTStorageKey key, DHTTransportValue value) {
            DHTDBImpl.this.total_values++;
            DHTDBImpl.this.total_size += value.getValue().length;
            DHTDBImpl.this.reportSizes("valueAdded");
            if (!value.isLocal()) {
                DHTDBValueImpl val = (DHTDBValueImpl)value;
                boolean direct = Arrays.equals(value.getOriginator().getID(), val.getSender().getID());
                if (direct) {
                    DHTDBImpl.this.incrementValueAdds(value.getOriginator());
                }
            }
            this.delegate.valueAdded(key, value);
        }

        public void valueUpdated(DHTStorageKey key, DHTTransportValue old_value, DHTTransportValue new_value) {
            DHTDBImpl.this.total_size += new_value.getValue().length - old_value.getValue().length;
            DHTDBImpl.this.reportSizes("valueUpdated");
            this.delegate.valueUpdated(key, old_value, new_value);
        }

        public void valueDeleted(DHTStorageKey key, DHTTransportValue value) {
            DHTDBImpl.this.total_values--;
            DHTDBImpl.this.total_size -= value.getValue().length;
            DHTDBImpl.this.reportSizes("valueDeleted");
            if (!value.isLocal()) {
                DHTDBValueImpl val = (DHTDBValueImpl)value;
                boolean direct = Arrays.equals(value.getOriginator().getID(), val.getSender().getID());
                if (direct) {
                    DHTDBImpl.this.decrementValueAdds(value.getOriginator());
                }
            }
            this.delegate.valueDeleted(key, value);
        }

        public boolean isDiversified(byte[] key) {
            return this.delegate.isDiversified(key);
        }

        public byte[][] getExistingDiversification(byte[] key, boolean put_operation, boolean exhaustive_get, int max_depth) {
            return this.delegate.getExistingDiversification(key, put_operation, exhaustive_get, max_depth);
        }

        public byte[][] createNewDiversification(String description, DHTTransportContact cause, byte[] key, boolean put_operation, byte diversification_type, boolean exhaustive_get, int max_depth) {
            return this.delegate.createNewDiversification(description, cause, key, put_operation, diversification_type, exhaustive_get, max_depth);
        }

        public int getNextValueVersions(int num) {
            return this.delegate.getNextValueVersions(num);
        }

        public DHTStorageBlock keyBlockRequest(DHTTransportContact direct_sender, byte[] request2, byte[] signature) {
            return this.delegate.keyBlockRequest(direct_sender, request2, signature);
        }

        public DHTStorageBlock getKeyBlockDetails(byte[] key) {
            return this.delegate.getKeyBlockDetails(key);
        }

        public DHTStorageBlock[] getDirectKeyBlocks() {
            return this.delegate.getDirectKeyBlocks();
        }

        public byte[] getKeyForKeyBlock(byte[] request2) {
            return this.delegate.getKeyForKeyBlock(request2);
        }

        public void setStorageForKey(String key, byte[] data) {
            this.delegate.setStorageForKey(key, data);
        }

        public byte[] getStorageForKey(String key) {
            return this.delegate.getStorageForKey(key);
        }

        public int getRemoteFreqDivCount() {
            return this.delegate.getRemoteFreqDivCount();
        }

        public int getRemoteSizeDivCount() {
            return this.delegate.getRemoteSizeDivCount();
        }
    }
}

