/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.common.table.impl;

import com.aelitis.azureus.ui.common.table.impl.TableViewImpl;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.Timer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class DataSourceCallBackUtil {
    public static final long IMMEDIATE_ADDREMOVE_DELAY = 150L;
    private static final long IMMEDIATE_ADDREMOVE_MAXDELAY = 2000L;
    private static Timer timerProcessDataSources = new Timer("Process Data Sources");
    private static TimerEvent timerEventProcessDS;
    private static List processDataSourcesOutstanding;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addDataSourceAggregated(addDataSourceCallback callback) {
        if (callback == null) {
            return true;
        }
        boolean processQueueImmediately = false;
        List to_do_now = null;
        Timer timer = timerProcessDataSources;
        synchronized (timer) {
            if (timerEventProcessDS != null && !timerEventProcessDS.hasRun()) {
                long now = SystemTime.getCurrentTime();
                if (now - timerEventProcessDS.getCreatedTime() < 2000L) {
                    long lNextTime = now + 150L;
                    timerProcessDataSources.adjustAllBy(lNextTime - timerEventProcessDS.getWhen());
                    if (!processDataSourcesOutstanding.contains(callback)) {
                        processDataSourcesOutstanding.add(callback);
                    }
                } else {
                    timerEventProcessDS.cancel();
                    timerEventProcessDS = null;
                    processQueueImmediately = true;
                    to_do_now = processDataSourcesOutstanding;
                    processDataSourcesOutstanding = new ArrayList();
                }
            } else {
                if (!processDataSourcesOutstanding.contains(callback)) {
                    processDataSourcesOutstanding.add(callback);
                }
                timerEventProcessDS = timerProcessDataSources.addEvent(SystemTime.getCurrentTime() + 150L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent event2) {
                        List to_do;
                        Timer timer = timerProcessDataSources;
                        synchronized (timer) {
                            timerEventProcessDS = null;
                            to_do = processDataSourcesOutstanding;
                            processDataSourcesOutstanding = new ArrayList();
                        }
                        for (int i = 0; i < to_do.size(); ++i) {
                            try {
                                addDataSourceCallback this_callback = (addDataSourceCallback)to_do.get(i);
                                if (TableViewImpl.DEBUGADDREMOVE) {
                                    this_callback.debug("processDataSourceQueue after " + (SystemTime.getCurrentTime() - event2.getCreatedTime()) + "ms");
                                }
                                this_callback.process();
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                });
            }
            if (to_do_now != null) {
                to_do_now.remove(callback);
                for (int i = 0; i < to_do_now.size(); ++i) {
                    try {
                        addDataSourceCallback this_callback = (addDataSourceCallback)to_do_now.get(i);
                        if (TableViewImpl.DEBUGADDREMOVE) {
                            this_callback.debug("Over immediate delay limit, processing queue now");
                        }
                        this_callback.process();
                        continue;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            }
        }
        return processQueueImmediately;
    }

    static {
        processDataSourcesOutstanding = new ArrayList();
    }

    public static interface addDataSourceCallback {
        public void process();

        public void debug(String var1);
    }
}

