/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class SelectedContentManager {
    private static CopyOnWriteList<SelectedContentListener> listeners = new CopyOnWriteList();
    private static volatile ISelectedContent[] currentlySelectedContent = new ISelectedContent[0];
    private static volatile String viewID = null;
    private static volatile TableView tv = null;

    public static String getCurrentySelectedViewID() {
        return viewID;
    }

    public static void addCurrentlySelectedContentListener(SelectedContentListener l) {
        if (listeners.contains(l)) {
            return;
        }
        listeners.add(l);
        l.currentlySelectedContentChanged(currentlySelectedContent, viewID);
    }

    public static void removeCurrentlySelectedContentListener(SelectedContentListener l) {
        listeners.remove(l);
    }

    public static void clearCurrentlySelectedContent() {
        SelectedContentManager.changeCurrentlySelectedContentNoTrigger(null, null, null);
        SelectedContentManager.triggerSelectedContentListeners();
    }

    public static void changeCurrentlySelectedContent(String viewID, ISelectedContent[] currentlySelectedContent) {
        SelectedContentManager.changeCurrentlySelectedContent(viewID, currentlySelectedContent, null);
    }

    public static void changeCurrentlySelectedContent(String viewID, ISelectedContent[] currentlySelectedContent, TableView tv) {
        SelectedContentManager.changeCurrentlySelectedContentNoTrigger(viewID, currentlySelectedContent, tv);
        SelectedContentManager.triggerSelectedContentListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void changeCurrentlySelectedContentNoTrigger(String viewID, ISelectedContent[] currentlySelectedContent, TableView tv) {
        if (currentlySelectedContent == null) {
            currentlySelectedContent = new ISelectedContent[]{};
        }
        if (currentlySelectedContent.length == 0 && SelectedContentManager.viewID != null && viewID != null && !viewID.equals(SelectedContentManager.viewID)) {
            return;
        }
        Class<SelectedContentManager> clazz = SelectedContentManager.class;
        synchronized (SelectedContentManager.class) {
            boolean same;
            boolean bl = same = SelectedContentManager.tv == tv;
            if (same) {
                boolean bl2 = same = SelectedContentManager.viewID == viewID || SelectedContentManager.viewID != null && viewID != null && SelectedContentManager.viewID.equals(viewID);
                if (same && SelectedContentManager.currentlySelectedContent.length == currentlySelectedContent.length) {
                    for (int i = 0; i < currentlySelectedContent.length && same; ++i) {
                        same = currentlySelectedContent[i].sameAs(SelectedContentManager.currentlySelectedContent[i]);
                    }
                    if (same) {
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return;
                    }
                }
            }
            SelectedContentManager.tv = tv;
            SelectedContentManager.currentlySelectedContent = currentlySelectedContent;
            SelectedContentManager.viewID = viewID;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void triggerSelectedContentListeners() {
        for (SelectedContentListener l : listeners) {
            try {
                l.currentlySelectedContentChanged(currentlySelectedContent, viewID);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public static ISelectedContent[] getCurrentlySelectedContent() {
        return currentlySelectedContent;
    }

    public static DownloadManager[] getDMSFromSelectedContent() {
        ISelectedContent[] sc = SelectedContentManager.getCurrentlySelectedContent();
        if (sc.length > 0) {
            int x = 0;
            DownloadManager[] dms = new DownloadManager[sc.length];
            for (int i = 0; i < sc.length; ++i) {
                ISelectedContent selectedContent = sc[i];
                if (selectedContent == null) continue;
                dms[x] = selectedContent.getDownloadManager();
                if (dms[x] == null) continue;
                ++x;
            }
            if (x > 0) {
                System.arraycopy(dms, 0, dms, 0, x);
                return dms;
            }
        }
        return null;
    }

    public static TableView getCurrentlySelectedTableView() {
        return tv;
    }

    public static Object convertSelectedContentToObject(ISelectedContent[] contents) {
        if (contents == null) {
            contents = SelectedContentManager.getCurrentlySelectedContent();
        }
        if (contents.length == 0) {
            return null;
        }
        if (contents.length == 1) {
            return SelectedContentManager.selectedContentToObject(contents[0]);
        }
        Object[] objects = new Object[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            ISelectedContent content = contents[i];
            objects[i] = SelectedContentManager.selectedContentToObject(content);
        }
        return objects;
    }

    private static Object selectedContentToObject(ISelectedContent content) {
        Download dl = PluginCoreUtils.wrap(content.getDownloadManager());
        if (dl == null) {
            return null;
        }
        int i = content.getFileIndex();
        if (i < 0) {
            return dl;
        }
        return dl.getDiskManagerFileInfo(i);
    }
}

