/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.columns.subscriptions;

import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWTPaintListener;

public class ColumnSubscriptionNew
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "new";
    private static int WIDTH = 38;
    private static Image imgNew;
    private Rectangle imgBounds;

    public ColumnSubscriptionNew(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(WIDTH);
        this.setMinWidth(WIDTH);
        this.setMaxWidth(WIDTH);
        this.setVisible(true);
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        this.imgBounds = imgNew.getBounds();
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public void cellPaint(GC gc, TableCellSWT cell) {
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub.getHistory().getNumUnread() > 0) {
            Rectangle cellBounds = cell.getBounds();
            gc.drawImage(imgNew, cellBounds.x + (cellBounds.width - this.imgBounds.width) / 2, cellBounds.y + (cellBounds.height - this.imgBounds.height) / 2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    public void refresh(TableCell cell) {
        int sortVal;
        Subscription sub = (Subscription)cell.getDataSource();
        boolean isRead = sub.getHistory().getNumUnread() > 0;
        int n = sortVal = isRead ? 1 : 0;
        if (!cell.setSortValue(sortVal) && cell.isValid()) {
            return;
        }
        cell.invalidate();
    }
}

