/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesListener;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableSelectionAdapter;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfo;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentV3;
import com.aelitis.azureus.ui.swt.columns.utils.TableColumnCreatorV3;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUIListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.TorrentListViewsUtils;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_ActivityTableView
extends SkinView
implements UIUpdatable,
UIPluginViewToolBarListener,
VuzeActivitiesListener {
    private static final String TABLE_ID_PREFIX = "activity-";
    private TableViewSWT<VuzeActivitiesEntry> view;
    private String tableID;
    private Composite viewComposite;
    private int viewMode = 0;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        skinObject.addListener(new SWTSkinObjectListener(){

            public Object eventOccured(SWTSkinObject skinObject, int eventType, Object params) {
                if (eventType == 0) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, SBC_ActivityTableView.this.getCurrentlySelectedContent(), SBC_ActivityTableView.this.view);
                } else if (eventType == 1) {
                    SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, null, SBC_ActivityTableView.this.view);
                }
                return null;
            }
        });
        SWTSkinObject soParent = skinObject.getParent();
        Object data = soParent.getControl().getData("ViewMode");
        if (data instanceof Long) {
            this.viewMode = (int)((Long)data).longValue();
        }
        boolean big = this.viewMode == -1;
        this.tableID = big ? "Activity.big" : "Activity";
        TableColumnCore[] columns = big ? TableColumnCreatorV3.createActivityBig(this.tableID) : TableColumnCreatorV3.createActivitySmall(this.tableID);
        this.view = TableViewFactory.createTableViewSWT(VuzeActivitiesEntry.class, this.tableID, this.tableID, columns, "name", 0x10010002);
        this.view.setRowDefaultHeight(big ? 50 : 32);
        this.view.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    SBC_ActivityTableView.this.removeSelected();
                } else if (e.keyCode == 0x100000E) {
                    if ((e.stateMask & 0x20000) != 0) {
                        VuzeActivitiesManager.resetRemovedEntries();
                    }
                    if ((e.stateMask & 0x40000) != 0) {
                        System.out.println("pull all vuze news entries");
                        VuzeActivitiesManager.clearLastPullTimes();
                        VuzeActivitiesManager.pullActivitiesNow(0L, "^F5", true);
                    } else {
                        System.out.println("pull latest vuze news entries");
                        VuzeActivitiesManager.pullActivitiesNow(0L, "F5", true);
                    }
                }
            }
        });
        this.view.addSelectionListener(new TableSelectionAdapter(){

            public void selected(TableRowCore[] rows) {
                this.selectionChanged();
                for (int i = 0; i < rows.length; ++i) {
                    VuzeActivitiesEntry entry = (VuzeActivitiesEntry)rows[i].getDataSource(true);
                    if (entry == null || entry.isRead() || !entry.canFlipRead()) continue;
                    entry.setRead(true);
                }
            }

            public void defaultSelected(TableRowCore[] rows, int stateMask) {
                if (rows.length == 1) {
                    TorrentListViewsUtils.playOrStreamDataSource(rows[0].getDataSource(), false);
                }
            }

            public void deselected(TableRowCore[] rows) {
                this.selectionChanged();
            }

            public void selectionChanged() {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        ISelectedContent[] contents = SBC_ActivityTableView.this.getCurrentlySelectedContent();
                        if (SBC_ActivityTableView.this.soMain.isVisible()) {
                            SelectedContentManager.changeCurrentlySelectedContent(SBC_ActivityTableView.this.tableID, contents, SBC_ActivityTableView.this.view);
                        }
                    }
                });
            }
        }, false);
        this.view.addLifeCycleListener(new TableLifeCycleListener(){

            public void tableViewInitialized() {
                SBC_ActivityTableView.this.view.addDataSources(VuzeActivitiesManager.getAllEntries());
            }

            public void tableViewDestroyed() {
            }
        });
        SWTSkinObjectContainer soContents = new SWTSkinObjectContainer(this.skin, this.skin.getSkinProperties(), this.getUpdateUIName(), "", this.soMain);
        this.skin.layout();
        this.viewComposite = soContents.getComposite();
        this.viewComposite.setBackground(this.viewComposite.getDisplay().getSystemColor(22));
        this.viewComposite.setForeground(this.viewComposite.getDisplay().getSystemColor(21));
        this.viewComposite.setLayoutData((Object)Utils.getFilledFormData());
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.viewComposite.setLayout((Layout)gridLayout);
        this.view.initialize(this.viewComposite);
        VuzeActivitiesManager.addListener(this);
        return null;
    }

    @Override
    public Object skinObjectDestroyed(SWTSkinObject skinObject, Object params) {
        if (this.view != null) {
            this.view.delete();
        }
        return super.skinObjectDestroyed(skinObject, params);
    }

    @Override
    public String getUpdateUIName() {
        return this.tableID;
    }

    @Override
    public void updateUI() {
        if (this.view != null) {
            this.view.refreshTable(false);
        }
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        list.put("remove", this.isVisible() && this.view != null && this.view.getSelectedRowsSize() > 0 ? 1L : 0L);
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        if (item.getID().equals("remove")) {
            this.removeSelected();
            return true;
        }
        return false;
    }

    public ISelectedContent[] getCurrentlySelectedContent() {
        if (this.view == null) {
            return null;
        }
        ArrayList<SelectedContentV3> listContent = new ArrayList<SelectedContentV3>();
        Object[] selectedDataSources = this.view.getSelectedDataSources(true);
        for (int i = 0; i < selectedDataSources.length; ++i) {
            VuzeActivitiesEntry ds = (VuzeActivitiesEntry)selectedDataSources[i];
            if (ds == null) continue;
            try {
                SelectedContentV3 currentContent = ds.createSelectedContentObject();
                if (currentContent == null) continue;
                listContent.add(currentContent);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return listContent.toArray(new ISelectedContent[listContent.size()]);
    }

    @Override
    public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
        if (this.view != null) {
            this.view.addDataSources((VuzeActivitiesEntry[])entries);
        }
    }

    @Override
    public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
        if (this.view != null) {
            this.view.removeDataSources((VuzeActivitiesEntry[])entries);
            this.view.processDataSourceQueue();
        }
    }

    @Override
    public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
        if (this.view == null) {
            return;
        }
        TableRowCore row = this.view.getRow(entry);
        if (row != null) {
            row.invalidate();
        }
    }

    private void removeEntries(final VuzeActivitiesEntry[] toRemove, final int startIndex) {
        final VuzeActivitiesEntry entry = toRemove[startIndex];
        if (entry == null || "Header".equals(entry.getTypeID())) {
            int nextIndex = startIndex + 1;
            if (nextIndex < toRemove.length) {
                this.removeEntries(toRemove, nextIndex);
            }
            return;
        }
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("v3.activity.remove.title"), MessageText.getString("v3.activity.remove.text", new String[]{entry.getText()}));
        mb.setRemember(this.tableID + "-Remove", false, MessageText.getString("MessageBoxWindow.nomoreprompting"));
        if (startIndex == toRemove.length - 1) {
            mb.setButtons(0, new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{0, 1});
            mb.setRememberOnlyIfButton(0);
        } else {
            mb.setButtons(1, new String[]{MessageText.getString("Button.removeAll"), MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, new Integer[]{2, 0, 1});
            mb.setRememberOnlyIfButton(1);
        }
        mb.setHandleHTML(false);
        mb.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                int nextIndex;
                if (result == 2) {
                    int numToRemove = toRemove.length - startIndex;
                    VuzeActivitiesEntry[] toGroupRemove = new VuzeActivitiesEntry[numToRemove];
                    System.arraycopy(toRemove, startIndex, toGroupRemove, 0, numToRemove);
                    VuzeActivitiesManager.removeEntries(toGroupRemove);
                    return;
                }
                if (result == 0) {
                    VuzeActivitiesManager.removeEntries(new VuzeActivitiesEntry[]{entry});
                }
                if ((nextIndex = startIndex + 1) < toRemove.length) {
                    SBC_ActivityTableView.this.removeEntries(toRemove, nextIndex);
                }
            }
        });
    }

    protected void removeSelected() {
        if (this.view == null) {
            return;
        }
        VuzeActivitiesEntry[] selectedEntries = this.view.getSelectedDataSources().toArray(new VuzeActivitiesEntry[0]);
        if (selectedEntries.length > 0) {
            this.removeEntries(selectedEntries, 0);
        }
    }

    public TableViewSWT getView() {
        return this.view;
    }

    public static void setupSidebarEntry() {
        final MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        final ViewTitleInfo titleInfoActivityView = new ViewTitleInfo(){

            public Object getTitleInfoProperty(int propertyID) {
                if (propertyID == 0) {
                    int count = 0;
                    VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
                    for (int i = 0; i < allEntries.length; ++i) {
                        VuzeActivitiesEntry entry = allEntries[i];
                        if (entry.isRead()) continue;
                        ++count;
                    }
                    if (count > 0) {
                        return "" + count;
                    }
                    return null;
                }
                if (propertyID == 2) {
                    return "image.sidebar.activity";
                }
                return null;
            }
        };
        VuzeActivitiesManager.addListener(new VuzeActivitiesListener(){

            public void vuzeNewsEntryChanged(VuzeActivitiesEntry entry) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }

            public void vuzeNewsEntriesRemoved(VuzeActivitiesEntry[] entries) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }

            public void vuzeNewsEntriesAdded(VuzeActivitiesEntry[] entries) {
                ViewTitleInfoManager.refreshTitleInfo(titleInfoActivityView);
            }
        });
        MdiEntryCreationListener creationListener = new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                return mdi.createEntryFromSkinRef("header.vuze", "Activity", "activity", "{sidebar.Activity}", titleInfoActivityView, null, false, null);
            }
        };
        mdi.registerEntry("Activity", creationListener);
        mdi.registerEntry("activities", creationListener);
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar.Activity", "v3.activity.button.readall");
        menuItem.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                VuzeActivitiesEntry[] allEntries = VuzeActivitiesManager.getAllEntries();
                for (int i = 0; i < allEntries.length; ++i) {
                    VuzeActivitiesEntry entry = allEntries[i];
                    entry.setRead(true);
                }
            }
        });
        if (Constants.isCVSVersion()) {
            menuItem = menuManager.addMenuItem("sidebar.Activity", "!test update expiry!");
            menuItem.addListener(new MenuItemListener(){

                public void selected(MenuItem menu, Object target) {
                    FeatureManagerUIListener.buildNotifications();
                }
            });
        }
    }
}

