/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPDeviceImage;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImageImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import com.aelitis.net.upnp.impl.services.UPnPServiceImpl;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPDeviceImpl
implements UPnPDevice {
    private UPnPRootDeviceImpl root_device;
    private String device_type;
    private String friendly_name;
    private String manufacturer;
    private String manufacturer_url;
    private String model_description;
    private String model_name;
    private String model_number;
    private String model_url;
    private String presentation_url;
    private List devices = new ArrayList();
    private List services = new ArrayList();
    private List<UPnPDeviceImage> images = new ArrayList<UPnPDeviceImage>();

    protected UPnPDeviceImpl(UPnPRootDeviceImpl _root_device, String indent, SimpleXMLParserDocumentNode device_node) {
        SimpleXMLParserDocumentNode icon_list;
        SimpleXMLParserDocumentNode dev_list;
        this.root_device = _root_device;
        this.device_type = this.getMandatoryField(device_node, "DeviceType");
        this.friendly_name = this.getOptionalField(device_node, "FriendlyName");
        this.manufacturer = this.getOptionalField(device_node, "manufacturer");
        this.manufacturer_url = this.getOptionalField(device_node, "manufacturerURL");
        this.model_description = this.getOptionalField(device_node, "modelDescription");
        this.model_name = this.getOptionalField(device_node, "modelName");
        this.model_number = this.getOptionalField(device_node, "modelNumber");
        this.model_url = this.getOptionalField(device_node, "modelURL");
        this.presentation_url = this.getOptionalField(device_node, "presentationURL");
        if (this.friendly_name == null) {
            String[] bits = new String[]{this.manufacturer, this.model_description, this.model_number};
            this.friendly_name = "";
            for (String bit : bits) {
                if (bit == null) continue;
                this.friendly_name = this.friendly_name + (this.friendly_name.length() == 0 ? "" : "/") + bit;
            }
            if (this.friendly_name.length() == 0) {
                this.friendly_name = "UPnP Device";
            }
        }
        boolean interested = this.device_type.equalsIgnoreCase("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        this.root_device.getUPnP().log(indent + this.friendly_name + (interested ? " *" : ""));
        SimpleXMLParserDocumentNode service_list = device_node.getChild("ServiceList");
        if (service_list != null) {
            SimpleXMLParserDocumentNode[] service_nodes = service_list.getChildren();
            for (int i = 0; i < service_nodes.length; ++i) {
                this.services.add(new UPnPServiceImpl(this, indent + "  ", service_nodes[i]));
            }
        }
        if ((dev_list = device_node.getChild("DeviceList")) != null) {
            SimpleXMLParserDocumentNode[] device_nodes = dev_list.getChildren();
            for (int i = 0; i < device_nodes.length; ++i) {
                this.devices.add(new UPnPDeviceImpl(this.root_device, indent + "  ", device_nodes[i]));
            }
        }
        if ((icon_list = device_node.getChild("iconList")) != null) {
            SimpleXMLParserDocumentNode[] children;
            for (SimpleXMLParserDocumentNode child : children = icon_list.getChildren()) {
                String oUrl;
                if (!"icon".equalsIgnoreCase(child.getName()) || (oUrl = this.getOptionalField(child, "url")) == null) continue;
                int width = -1;
                int height = -1;
                String oWidth = this.getOptionalField(child, "width");
                String oHeight = this.getOptionalField(child, "height");
                try {
                    width = Integer.parseInt(oWidth);
                    height = Integer.parseInt(oHeight);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                this.images.add(new UPnPDeviceImageImpl(width, height, oUrl, this.getOptionalField(child, "mime")));
            }
        }
    }

    public String getAbsoluteURL(String url) {
        return this.root_device.getAbsoluteURL(url);
    }

    public InetAddress getLocalAddress() {
        return this.root_device.getLocalAddress();
    }

    public synchronized void clearRelativeBaseURL() {
        this.root_device.clearRelativeBaseURL();
    }

    public synchronized void restoreRelativeBaseURL() {
        this.root_device.restoreRelativeBaseURL();
    }

    public UPnPImpl getUPnP() {
        return (UPnPImpl)this.root_device.getUPnP();
    }

    public UPnPRootDeviceImpl getRootDevice() {
        return this.root_device;
    }

    public String getDeviceType() {
        return this.device_type;
    }

    public String getFriendlyName() {
        return this.friendly_name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String getManufacturerURL() {
        return this.manufacturer_url;
    }

    public String getModelDescription() {
        return this.model_description;
    }

    public String getModelName() {
        return this.model_name;
    }

    public String getModelNumber() {
        return this.model_number;
    }

    public String getModelURL() {
        return this.model_url;
    }

    public String getPresentation() {
        return this.presentation_url == null ? null : this.getAbsoluteURL(this.presentation_url);
    }

    public UPnPDevice[] getSubDevices() {
        UPnPDevice[] res = new UPnPDevice[this.devices.size()];
        this.devices.toArray(res);
        return res;
    }

    public UPnPService[] getServices() {
        UPnPService[] res = new UPnPService[this.services.size()];
        this.services.toArray(res);
        return res;
    }

    public UPnPDeviceImage[] getImages() {
        return this.images.toArray(new UPnPDeviceImage[0]);
    }

    protected String getOptionalField(SimpleXMLParserDocumentNode node, String name) {
        SimpleXMLParserDocumentNode child = node.getChild(name);
        if (child == null) {
            return null;
        }
        return child.getValue().trim();
    }

    protected String getMandatoryField(SimpleXMLParserDocumentNode node, String name) {
        SimpleXMLParserDocumentNode child = node.getChild(name);
        if (child == null) {
            this.root_device.getUPnP().log("Mandatory field '" + name + "' is missing");
            return "<missing field '" + name + "'>";
        }
        return child.getValue().trim();
    }
}

