/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;
import org.gudy.azureus2.core3.internat.LocaleUtil;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerFactory;

public class SystemProperties {
    private static final LogIDs LOGID = LogIDs.CORE;
    public static final String SYS_PROP_CONFIG_OVERRIDE = "azureus.config.path";
    public static final String SEP = System.getProperty("file.separator");
    public static final String AZ_APP_ID = "az";
    public static String APPLICATION_NAME = "Azureus";
    private static String APPLICATION_ID = "az";
    private static String APPLICATION_VERSION = "5.5.0.1_B18";
    private static String APPLICATION_ENTRY_POINT = "org.gudy.azureus2.ui.swt.Main";
    private static final String WIN_DEFAULT = "Application Data";
    private static final String OSX_DEFAULT = "Library" + SEP + "Application Support";
    private static final boolean PORTABLE = System.getProperty("azureus.portable.root", "").length() > 0;
    private static String user_path;
    private static String app_path;

    public static void determineApplicationName() {
        String explicit_name = System.getProperty("azureus.app.name", null);
        if (explicit_name != null && (explicit_name = explicit_name.trim()).length() > 0) {
            SystemProperties.setApplicationName(explicit_name);
            return;
        }
        if (Constants.isOSX && !System.getProperty("azureus.infer.app.name", "true").equals("false")) {
            String classpath = System.getProperty("java.class.path");
            if (classpath == null) {
                System.out.println("SystemProperties: determineApplicationName - class path is null");
            } else {
                int dot_pos = classpath.indexOf(".app/Contents");
                if (dot_pos == -1) {
                    System.out.println("SystemProperties: determineApplicationName -  can't determine application name from " + classpath);
                } else {
                    int start_pos;
                    for (start_pos = dot_pos; start_pos >= 0 && classpath.charAt(start_pos) != '/'; --start_pos) {
                    }
                    String app_name = classpath.substring(start_pos + 1, dot_pos);
                    SystemProperties.setApplicationName(app_name);
                }
            }
        }
    }

    public static void setApplicationName(String name) {
        if (name != null && name.trim().length() > 0) {
            name = name.trim();
            if (user_path != null && !name.equals(APPLICATION_NAME)) {
                System.out.println("**** SystemProperties::setApplicationName called too late! ****");
            }
            APPLICATION_NAME = name;
        }
    }

    public static void setApplicationIdentifier(String application_id) {
        if (application_id != null && application_id.trim().length() > 0) {
            APPLICATION_ID = application_id.trim();
        }
    }

    public static void setApplicationEntryPoint(String entry_point) {
        if (entry_point != null && entry_point.trim().length() > 0) {
            APPLICATION_ENTRY_POINT = entry_point.trim();
        }
    }

    public static String getApplicationName() {
        return APPLICATION_NAME;
    }

    public static void setApplicationVersion(String v) {
        APPLICATION_VERSION = v;
    }

    public static String getApplicationVersion() {
        return APPLICATION_VERSION;
    }

    public static String getApplicationIdentifier() {
        return APPLICATION_ID;
    }

    public static String getApplicationEntryPoint() {
        return APPLICATION_ENTRY_POINT;
    }

    public static void setUserPath(String _path) {
        user_path = _path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getUserPath() {
        File dir;
        String temp_user_path;
        block25: {
            block24: {
                if (user_path != null) {
                    return user_path;
                }
                temp_user_path = System.getProperty(SYS_PROP_CONFIG_OVERRIDE);
                try {
                    File dir2;
                    if (temp_user_path == null) break block24;
                    if (!temp_user_path.endsWith(SEP)) {
                        temp_user_path = temp_user_path + SEP;
                    }
                    if (!(dir2 = new File(temp_user_path)).exists()) {
                        FileUtil.mkdirs(dir2);
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Custom): user_path = " + temp_user_path));
                    }
                    String string = temp_user_path;
                    Object var4_6 = null;
                    user_path = temp_user_path;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    user_path = temp_user_path;
                    throw throwable;
                }
            }
            try {
                PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
                File loc = platformManager.getLocation(1L);
                if (loc != null) {
                    temp_user_path = loc.getPath() + SEP;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath: user_path = " + temp_user_path));
                    }
                }
            }
            catch (Throwable e) {
                if (!Logger.isEnabled()) break block25;
                Logger.log(new LogEvent(LOGID, "Unable to retrieve user config path from the platform manager. Make sure aereg.dll is present."));
            }
        }
        if (temp_user_path == null) {
            String userhome = System.getProperty("user.home");
            if (Constants.isWindows) {
                temp_user_path = SystemProperties.getEnvironmentalVariable("APPDATA");
                if (temp_user_path != null && temp_user_path.length() > 0) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Using user config path from APPDATA env var instead: " + temp_user_path));
                    }
                } else {
                    temp_user_path = userhome + SEP + WIN_DEFAULT;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, "Using user config path from java user.home var instead: " + temp_user_path));
                    }
                }
                temp_user_path = temp_user_path + SEP + APPLICATION_NAME + SEP;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Win): user_path = " + temp_user_path));
                }
            } else if (Constants.isOSX) {
                temp_user_path = userhome + SEP + OSX_DEFAULT + SEP + APPLICATION_NAME + SEP;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Mac): user_path = " + temp_user_path));
                }
            } else {
                temp_user_path = userhome + SEP + "." + APPLICATION_NAME.toLowerCase() + SEP;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getUserPath(Unix): user_path = " + temp_user_path));
                }
            }
        }
        if (!(dir = new File(temp_user_path)).exists()) {
            FileUtil.mkdirs(dir);
        }
        String string = temp_user_path;
        Object var4_7 = null;
        user_path = temp_user_path;
        return string;
    }

    public static String getApplicationPath() {
        String appName;
        if (app_path != null) {
            return app_path;
        }
        String temp_app_path = System.getProperty("azureus.install.path", System.getProperty("user.dir"));
        if (!temp_app_path.endsWith(SEP)) {
            temp_app_path = temp_app_path + SEP;
        }
        if (Constants.isOSX && temp_app_path.endsWith(appName = SystemProperties.getApplicationName() + ".app/")) {
            temp_app_path = temp_app_path.substring(0, temp_app_path.length() - appName.length());
        }
        app_path = temp_app_path;
        return app_path;
    }

    public static boolean isJavaWebStartInstance() {
        try {
            String java_ws_prop = System.getProperty("azureus.javaws");
            return java_ws_prop != null && java_ws_prop.equals("true");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static String getEnvironmentalVariable(String _var) {
        Properties envVars;
        block8: {
            if (Constants.isWindows9598ME) {
                return "";
            }
            String res = System.getenv(_var);
            if (res != null) {
                return res;
            }
            envVars = new Properties();
            BufferedReader br = null;
            try {
                String line;
                Process p = null;
                Runtime r = Runtime.getRuntime();
                p = Constants.isWindows ? r.exec(new String[]{"cmd.exe", "/c", "set"}) : r.exec("env");
                String system_encoding = LocaleUtil.getSingleton().getSystemEncoding();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "SystemProperties::getEnvironmentalVariable - " + _var + ", system encoding = " + system_encoding));
                }
                br = new BufferedReader(new InputStreamReader(p.getInputStream(), system_encoding), 8192);
                while ((line = br.readLine()) != null) {
                    int idx = line.indexOf(61);
                    if (idx < 0) continue;
                    String key = line.substring(0, idx);
                    String value = line.substring(idx + 1);
                    envVars.setProperty(key, value);
                }
                br.close();
            }
            catch (Throwable t) {
                if (br == null) break block8;
                try {
                    br.close();
                }
                catch (Exception ingore) {
                    // empty catch block
                }
            }
        }
        return envVars.getProperty(_var, "");
    }

    public static String getDocPath() {
        String explicit_dir = System.getProperty("azureus.doc.path", null);
        if (explicit_dir != null) {
            File temp = new File(explicit_dir);
            if (!temp.exists()) {
                if (!temp.mkdirs()) {
                    System.err.println("Failed to create document dir: " + temp);
                }
            } else if (!temp.isDirectory() || !temp.canWrite()) {
                System.err.println("Document dir is not a directory or not writable: " + temp);
            }
            return temp.getAbsolutePath();
        }
        if (PORTABLE) {
            return SystemProperties.getUserPath();
        }
        File fDocPath = null;
        try {
            PlatformManager platformManager = PlatformManagerFactory.getPlatformManager();
            fDocPath = platformManager.getLocation(3L);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (fDocPath == null) {
            System.err.println("This is BAD - fix me!");
            new Throwable().printStackTrace();
            fDocPath = new File(SystemProperties.getUserPath(), "Documents");
        }
        return fDocPath.getAbsolutePath();
    }

    public static String getAzureusJarPath() {
        String str = SystemProperties.getApplicationPath();
        if (Constants.isOSX) {
            str = str + SystemProperties.getApplicationName() + ".app/Contents/Resources/Java/";
        }
        return str + "Azureus2.jar";
    }
}

