/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.plugins;

import java.util.List;
import java.util.Properties;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManagerDefaults;
import org.gudy.azureus2.plugins.installer.PluginInstaller;
import org.gudy.azureus2.pluginsimpl.local.PluginManagerDefaultsImpl;
import org.gudy.azureus2.pluginsimpl.local.PluginManagerImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PluginManager {
    public static final int UI_NONE = 0;
    public static final int UI_SWT = 1;
    public static final String PR_MULTI_INSTANCE = "MULTI_INSTANCE";
    public static final String PR_USER_DIRECTORY = "USER_DIR";
    public static final String PR_APP_DIRECTORY = "APP_DIR";
    public static final String PR_DOC_DIRECTORY = "DOC_DIR";
    public static final String PR_DISABLE_NATIVE_SUPPORT = "DISABLE_NATIVE";

    public static PluginManagerDefaults getDefaults() {
        return PluginManagerDefaultsImpl.getSingleton();
    }

    public static PluginManager startAzureus(int ui_type, Properties properties) {
        return PluginManagerImpl.startAzureus(ui_type, properties);
    }

    public static void stopAzureus() throws PluginException {
        PluginManagerImpl.stopAzureus();
    }

    public static void restartAzureus() throws PluginException {
        PluginManagerImpl.restartAzureus();
    }

    public static void registerPlugin(Class plugin_class) {
        PluginManagerImpl.registerPlugin(plugin_class);
    }

    public static void registerPlugin(Plugin plugin, String id) {
        PluginManagerImpl.registerPlugin(plugin, id);
    }

    public abstract PluginInterface getPluginInterfaceByID(String var1, boolean var2);

    public abstract PluginInterface getPluginInterfaceByClass(String var1, boolean var2);

    public abstract PluginInterface getPluginInterfaceByClass(Class var1, boolean var2);

    public abstract PluginInterface[] getPluginInterfaces();

    public abstract PluginInterface getDefaultPluginInterface();

    public abstract PluginInterface[] getPlugins();

    public abstract PluginInterface[] getPlugins(boolean var1);

    public abstract void firePluginEvent(int var1);

    public abstract PluginInstaller getPluginInstaller();

    public final void refreshPluginList() {
        this.refreshPluginList(true);
    }

    public abstract void refreshPluginList(boolean var1);

    public abstract boolean isSilentRestartEnabled();

    public abstract boolean isInitialized();

    public abstract PluginInterface getPluginInterfaceByID(String var1);

    public abstract PluginInterface getPluginInterfaceByClass(String var1);

    public abstract PluginInterface getPluginInterfaceByClass(Class var1);

    public abstract List<PluginInterface> getPluginsWithMethod(String var1, Class<?>[] var2);
}

