/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.StringListImpl;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.ExclusiveSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionFile
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "files";
    }

    public void configSectionSave() {
    }

    public int maxUserMode() {
        return 2;
    }

    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    public Composite configSectionCreate(final Composite parent) {
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        ArrayList<String> allConfigIDs = new ArrayList<String>();
        Composite gFile = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        gFile.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        final Group gDefaultDir = new Group(gFile, 0);
        Messages.setLanguageText((Widget)gDefaultDir, "ConfigView.section.file.defaultdir.section");
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 2;
        gDefaultDir.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gDefaultDir.setLayoutData((Object)gridData);
        String sCurConfigID = "Default save path";
        allConfigIDs.add(sCurConfigID);
        Label lblDefaultDir = new Label((Composite)gDefaultDir, 0);
        Messages.setLanguageText((Widget)lblDefaultDir, "ConfigView.section.file.defaultdir.ask");
        lblDefaultDir.setLayoutData((Object)new GridData());
        gridData = new GridData(768);
        final StringParameter pathParameter = new StringParameter((Composite)gDefaultDir, sCurConfigID);
        pathParameter.setLayoutData(gridData);
        Button browse = new Button((Composite)gDefaultDir, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setMessage(MessageText.getString("ConfigView.dialog.choosedefaultsavepath"));
                dialog.setText(MessageText.getString("ConfigView.section.file.defaultdir.ask"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        sCurConfigID = "ui.addtorrent.openoptions";
        allConfigIDs.add(sCurConfigID);
        Composite cOpenOptions = new Composite((Composite)gDefaultDir, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        cOpenOptions.setLayoutData((Object)gridData);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginRight = 0;
        rowLayout.marginLeft = 0;
        rowLayout.marginBottom = 0;
        rowLayout.center = true;
        cOpenOptions.setLayout((Layout)rowLayout);
        Label label = new Label(cOpenOptions, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.file.showopentorrentoptions");
        String[] openValues = new String[]{"never", "always", "many"};
        String[] openLabels = new String[]{MessageText.getString("OpenTorrentOptions.show.never"), MessageText.getString("OpenTorrentOptions.show.always"), MessageText.getString("OpenTorrentOptions.show.many")};
        new StringListParameter(cOpenOptions, sCurConfigID, openLabels, openValues);
        label = new Label(cOpenOptions, 0);
        label.setText("    ");
        sCurConfigID = "ui.addtorrent.openoptions.sep";
        new BooleanParameter(cOpenOptions, sCurConfigID, "ConfigView.section.file.showopentorrentoptions.sep");
        if (userMode > 0) {
            sCurConfigID = "DefaultDir.AutoSave.AutoRename";
            allConfigIDs.add(sCurConfigID);
            BooleanParameter autoSaveAutoRename = new BooleanParameter((Composite)gDefaultDir, sCurConfigID, "ConfigView.section.file.defaultdir.autorename");
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            autoSaveAutoRename.setLayoutData(gridData);
            sCurConfigID = "DefaultDir.BestGuess";
            allConfigIDs.add(sCurConfigID);
            final BooleanParameter bestGuess = new BooleanParameter((Composite)gDefaultDir, sCurConfigID, "ConfigView.section.file.defaultdir.bestguess");
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            bestGuess.setLayoutData(gridData);
            sCurConfigID = "DefaultDir.BestGuess.Default";
            allConfigIDs.add(sCurConfigID);
            final Label lblBestGuessDefaultDir = new Label((Composite)gDefaultDir, 0);
            Messages.setLanguageText((Widget)lblBestGuessDefaultDir, "ConfigView.section.file.bgdefaultdir.ask");
            gridData = new GridData();
            gridData.horizontalIndent = 25;
            lblBestGuessDefaultDir.setLayoutData((Object)gridData);
            gridData = new GridData(768);
            final StringParameter bestGuessPathParameter = new StringParameter((Composite)gDefaultDir, sCurConfigID);
            bestGuessPathParameter.setLayoutData(gridData);
            final Button bestGuessBrowse = new Button((Composite)gDefaultDir, 8);
            bestGuessBrowse.setImage(imgOpenFolder);
            bestGuessBrowse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            bestGuessBrowse.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                    dialog.setFilterPath(pathParameter.getValue());
                    dialog.setMessage(MessageText.getString("ConfigView.dialog.choosedefaultsavepath"));
                    dialog.setText(MessageText.getString("ConfigView.section.file.defaultdir.ask"));
                    String path = dialog.open();
                    if (path != null) {
                        bestGuessPathParameter.setValue(path);
                    }
                }
            });
            COConfigurationManager.addAndFireParameterListener("Default save path", new ParameterListener(){

                public void parameterChanged(String parameterName) {
                    if (gDefaultDir.isDisposed()) {
                        COConfigurationManager.removeParameterListener(parameterName, this);
                    } else {
                        String dsp = COConfigurationManager.getStringParameter(parameterName);
                        boolean enable = dsp == null || dsp.trim().length() == 0;
                        bestGuess.setEnabled(enable);
                        lblBestGuessDefaultDir.setEnabled(enable);
                        bestGuessPathParameter.setEnabled(enable);
                        bestGuessBrowse.setEnabled(enable);
                    }
                }
            });
            Composite cHistory = new Composite((Composite)gDefaultDir, 0);
            layout = new GridLayout();
            layout.numColumns = 6;
            cHistory.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 3;
            cHistory.setLayoutData((Object)gridData);
            sCurConfigID = "DefaultDir.AutoUpdate";
            allConfigIDs.add(sCurConfigID);
            BooleanParameter autoUpdateSaveDir = new BooleanParameter(cHistory, sCurConfigID, "ConfigView.section.file.defaultdir.lastused");
            Label padLabel = new Label(cHistory, 0);
            gridData = new GridData(768);
            padLabel.setLayoutData((Object)gridData);
            sCurConfigID = "saveTo_list.max_entries";
            allConfigIDs.add(sCurConfigID);
            Label historyMax = new Label(cHistory, 0);
            Messages.setLanguageText((Widget)historyMax, "ConfigView.label.save_list.max_entries");
            IntParameter paramhistoryMax = new IntParameter(cHistory, sCurConfigID);
            Label historyReset = new Label(cHistory, 0);
            Messages.setLanguageText((Widget)historyReset, "ConfigView.label.save_list.clear");
            final Button clear_history_button = new Button(cHistory, 8);
            Messages.setLanguageText((Widget)clear_history_button, "Button.clear");
            clear_history_button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    COConfigurationManager.setParameter("saveTo_list", new StringListImpl());
                    clear_history_button.setEnabled(false);
                }
            });
            StringList dirList = COConfigurationManager.getStringListParameter("saveTo_list");
            clear_history_button.setEnabled(dirList.size() > 0);
        }
        new Label(gFile, 0);
        sCurConfigID = "XFS Allocation";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0 && !Constants.isWindows) {
            BooleanParameter xfsAllocation = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.xfs.allocation");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            xfsAllocation.setLayoutData(gridData);
        }
        BooleanParameter zeroNew = null;
        sCurConfigID = "Zero New";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            zeroNew = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.zeronewfiles");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            zeroNew.setLayoutData(gridData);
        }
        BooleanParameter pieceReorder = null;
        sCurConfigID = "Enable reorder storage mode";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            pieceReorder = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.piecereorder");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            pieceReorder.setLayoutData(gridData);
            Button[] btnReorder = new Button[]{(Button)pieceReorder.getControl()};
            zeroNew.setAdditionalActionPerformer(new ExclusiveSelectionActionPerformer(btnReorder));
            Button[] btnZeroNew = new Button[]{(Button)zeroNew.getControl()};
            pieceReorder.setAdditionalActionPerformer(new ExclusiveSelectionActionPerformer(btnZeroNew));
        }
        sCurConfigID = "Reorder storage mode min MB";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            Label lblMinMB = new Label(gFile, 0);
            Messages.setLanguageText((Widget)lblMinMB, "ConfigView.label.piecereorderminmb");
            gridData = new GridData();
            gridData.horizontalIndent = 25;
            lblMinMB.setLayoutData((Object)gridData);
            IntParameter minMB = new IntParameter(gFile, sCurConfigID);
            gridData = new GridData();
            minMB.setLayoutData(gridData);
            pieceReorder.setAdditionalActionPerformer(new ChangeSelectionActionPerformer((Control)lblMinMB));
            pieceReorder.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(minMB));
        }
        sCurConfigID = "Enable incremental file creation";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter incremental = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.incrementalfile");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            incremental.setLayoutData(gridData);
            Button[] btnIncremental = new Button[]{(Button)incremental.getControl()};
            zeroNew.setAdditionalActionPerformer(new ExclusiveSelectionActionPerformer(btnIncremental));
            Button[] btnZeroNew = new Button[]{(Button)zeroNew.getControl()};
            incremental.setAdditionalActionPerformer(new ExclusiveSelectionActionPerformer(btnZeroNew));
        }
        sCurConfigID = "File.truncate.if.too.large";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter truncateLarge = new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.truncate.too.large");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            truncateLarge.setLayoutData(gridData);
        }
        sCurConfigID = "Check Pieces on Completion";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter checkOnComp = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.checkOncompletion");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            checkOnComp.setLayoutData(gridData);
        }
        sCurConfigID = "Seeding Piece Check Recheck Enable";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 0) {
            BooleanParameter checkOnSeeding = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.checkOnSeeding");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            checkOnSeeding.setLayoutData(gridData);
        }
        sCurConfigID = "File.strict.locking";
        allConfigIDs.add(sCurConfigID);
        if (userMode > 1) {
            BooleanParameter strictLocking = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.strictfilelocking");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            strictLocking.setLayoutData(gridData);
        }
        if (userMode == 0) {
            allConfigIDs.add("Use Resume");
            sCurConfigID = "Save Resume Interval";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "On Resume Recheck All";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "File.save.peers.enable";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "File.save.peers.max";
            allConfigIDs.add(sCurConfigID);
        } else {
            sCurConfigID = "Use Resume";
            allConfigIDs.add(sCurConfigID);
            final BooleanParameter bpUseResume = new BooleanParameter(gFile, sCurConfigID, "ConfigView.label.usefastresume");
            bpUseResume.setLayoutData(new GridData(2));
            Composite cResumeGroup = new Composite(gFile, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 4;
            layout.numColumns = 3;
            cResumeGroup.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalIndent = 25;
            gridData.horizontalSpan = 2;
            cResumeGroup.setLayoutData((Object)gridData);
            sCurConfigID = "Save Resume Interval";
            allConfigIDs.add(sCurConfigID);
            Label lblSaveResumeInterval = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblSaveResumeInterval, "ConfigView.label.saveresumeinterval");
            IntParameter paramSaveInterval = new IntParameter(cResumeGroup, sCurConfigID);
            gridData = new GridData();
            paramSaveInterval.setLayoutData(gridData);
            Label lblMinutes = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblMinutes, "ConfigView.text.minutes");
            sCurConfigID = "On Resume Recheck All";
            allConfigIDs.add(sCurConfigID);
            BooleanParameter recheck_all = new BooleanParameter(cResumeGroup, sCurConfigID, "ConfigView.section.file.resume.recheck.all");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            recheck_all.setLayoutData(gridData);
            sCurConfigID = "File.save.peers.enable";
            allConfigIDs.add(sCurConfigID);
            final BooleanParameter save_peers = new BooleanParameter(cResumeGroup, sCurConfigID, "ConfigView.section.file.save.peers.enable");
            gridData = new GridData();
            gridData.horizontalSpan = 3;
            save_peers.setLayoutData(gridData);
            sCurConfigID = "File.save.peers.max";
            allConfigIDs.add(sCurConfigID);
            final Label lblSavePeersMax = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblSavePeersMax, "ConfigView.section.file.save.peers.max");
            final IntParameter savePeersMax = new IntParameter(cResumeGroup, sCurConfigID);
            gridData = new GridData();
            savePeersMax.setLayoutData(gridData);
            final Label lblPerTorrent = new Label(cResumeGroup, 0);
            Messages.setLanguageText((Widget)lblPerTorrent, "ConfigView.section.file.save.peers.pertorrent");
            Control[] controls = new Control[]{cResumeGroup};
            GenericActionPerformer f_enabler = new GenericActionPerformer(controls){

                public void performAction() {
                    this.controlsSetEnabled(this.controls, bpUseResume.isSelected());
                    if (bpUseResume.isSelected()) {
                        lblSavePeersMax.setEnabled(save_peers.isSelected());
                        savePeersMax.getControl().setEnabled(save_peers.isSelected());
                        lblPerTorrent.setEnabled(save_peers.isSelected());
                    }
                }
            };
            bpUseResume.setAdditionalActionPerformer(f_enabler);
            save_peers.setAdditionalActionPerformer(f_enabler);
        }
        if (userMode > 0) {
            sCurConfigID = "priorityExtensions";
            allConfigIDs.add(sCurConfigID);
            label = new Label(gFile, 64);
            gridData = new GridData();
            gridData.widthHint = 180;
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "ConfigView.label.priorityExtensions");
            Composite cExtensions = new Composite(gFile, 0);
            gridData = new GridData(768);
            cExtensions.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 3;
            cExtensions.setLayout((Layout)layout);
            gridData = new GridData(768);
            new StringParameter(cExtensions, sCurConfigID).setLayoutData(gridData);
            sCurConfigID = "priorityExtensionsIgnoreCase";
            allConfigIDs.add(sCurConfigID);
            new BooleanParameter(cExtensions, sCurConfigID, "ConfigView.label.ignoreCase");
        } else {
            sCurConfigID = "priorityExtensions";
            allConfigIDs.add(sCurConfigID);
            sCurConfigID = "priorityExtensionsIgnoreCase";
            allConfigIDs.add(sCurConfigID);
        }
        sCurConfigID = "quick.view.exts";
        allConfigIDs.add(sCurConfigID);
        label = new Label(gFile, 64);
        gridData = new GridData();
        gridData.widthHint = 180;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "ConfigView.label.quickviewexts");
        Composite cQuickView = new Composite(gFile, 0);
        gridData = new GridData(768);
        cQuickView.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        cQuickView.setLayout((Layout)layout);
        gridData = new GridData(768);
        new StringParameter(cQuickView, sCurConfigID).setLayoutData(gridData);
        label = new Label(cQuickView, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.quickviewmaxkb");
        sCurConfigID = "quick.view.maxkb";
        allConfigIDs.add(sCurConfigID);
        IntParameter qvmax = new IntParameter(cQuickView, sCurConfigID, 1, 9999);
        if (userMode > 0) {
            sCurConfigID = "Rename Incomplete Files";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            BooleanParameter rename_incomplete = new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.rename.incomplete");
            rename_incomplete.setLayoutData(gridData);
            sCurConfigID = "Rename Incomplete Files Extension";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData(768);
            StringParameter rename_incomplete_ext = new StringParameter(gFile, sCurConfigID);
            rename_incomplete_ext.setLayoutData(gridData);
            ChangeSelectionActionPerformer incompFileAP = new ChangeSelectionActionPerformer(rename_incomplete_ext.getControls(), false);
            rename_incomplete.setAdditionalActionPerformer(incompFileAP);
            sCurConfigID = "Enable Subfolder for DND Files";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData();
            gridData.horizontalSpan = 1;
            BooleanParameter enable_subfolder = new BooleanParameter(gFile, sCurConfigID, "ConfigView.section.file.subfolder.dnd");
            rename_incomplete.setLayoutData(gridData);
            sCurConfigID = "Subfolder for DND Files";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData(768);
            StringParameter subfolder_name = new StringParameter(gFile, sCurConfigID);
            subfolder_name.setLayoutData(gridData);
            ChangeSelectionActionPerformer subfolderAP = new ChangeSelectionActionPerformer(subfolder_name.getControls(), false);
            enable_subfolder.setAdditionalActionPerformer(subfolderAP);
            Label lIgnoreFiles = new Label(gFile, 0);
            Messages.setLanguageText((Widget)lIgnoreFiles, "ConfigView.section.file.torrent.ignorefiles");
            gridData = new GridData(768);
            new StringParameter(gFile, "File.Torrent.IgnoreFiles", ".DS_Store;Thumbs.db;desktop.ini").setLayoutData(gridData);
        }
        Group gDeletion = new Group(gFile, 0);
        Messages.setLanguageText((Widget)gDeletion, "ConfigView.section.file.deletion.section");
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 5;
        gDeletion.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gDeletion.setLayoutData((Object)gridData);
        if (userMode > 0) {
            Composite c = new Composite((Composite)gDeletion, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            c.setLayoutData((Object)gridData);
            sCurConfigID = "tb.confirm.delete.content";
            label = new Label(c, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.file.tb.delete");
            int[] values = new int[]{0, 1, 2};
            String[] labels = new String[]{MessageText.getString("ConfigView.tb.delete.ask"), MessageText.getString("ConfigView.tb.delete.content"), MessageText.getString("ConfigView.tb.delete.torrent")};
            new IntListParameter(c, sCurConfigID, labels, values);
            sCurConfigID = "def.deletetorrent";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            new BooleanParameter((Composite)gDeletion, sCurConfigID, "ConfigView.section.file.delete.torrent").setLayoutData(gridData);
        }
        try {
            PlatformManager platform = PlatformManagerFactory.getPlatformManager();
            if (platform.hasCapability(PlatformManagerCapabilities.RecoverableFileDelete)) {
                sCurConfigID = "Move Deleted Data To Recycle Bin";
                allConfigIDs.add(sCurConfigID);
                gridData = new GridData();
                gridData.horizontalSpan = 2;
                new BooleanParameter((Composite)gDeletion, sCurConfigID, "ConfigView.section.file.nativedelete").setLayoutData(gridData);
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (userMode > 0) {
            sCurConfigID = "File.delete.include_files_outside_save_dir";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            new BooleanParameter((Composite)gDeletion, sCurConfigID, "ConfigView.section.file.delete.include_files_outside_save_dir").setLayoutData(gridData);
            sCurConfigID = "Delete Partial Files On Library Removal";
            allConfigIDs.add(sCurConfigID);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            new BooleanParameter((Composite)gDeletion, sCurConfigID, "delete.partial.files").setLayoutData(gridData);
        }
        if (userMode > 0) {
            Group gConfigSettings = new Group(gFile, 0);
            Messages.setLanguageText((Widget)gConfigSettings, "ConfigView.section.file.config.section");
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 5;
            gConfigSettings.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            gConfigSettings.setLayoutData((Object)gridData);
            Label config_label = new Label((Composite)gConfigSettings, 0);
            Messages.setLanguageText((Widget)config_label, "ConfigView.section.file.config.currentdir");
            config_label.setLayoutData((Object)new GridData());
            Label config_link = new Label((Composite)gConfigSettings, 0);
            config_link.setText(SystemProperties.getUserPath());
            config_link.setLayoutData((Object)new GridData());
            LinkLabel.makeLinkedLabel(config_link, SystemProperties.getUserPath());
            sCurConfigID = "Use Config File Backups";
            allConfigIDs.add(sCurConfigID);
            BooleanParameter backupConfig = new BooleanParameter((Composite)gConfigSettings, sCurConfigID, "ConfigView.label.backupconfigfiles");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            backupConfig.setLayoutData(gridData);
        }
        return gFile;
    }
}

