/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.subs.impl;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.subs.SubscriptionResult;
import com.aelitis.azureus.core.subs.impl.SubscriptionHistoryImpl;
import com.aelitis.azureus.util.JSONUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SHA1Simple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubscriptionResultImpl
implements SubscriptionResult {
    private final SubscriptionHistoryImpl history;
    private byte[] key1;
    private byte[] key2;
    private boolean read;
    private boolean deleted;
    private String result_json;

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, Result result) {
        this.history = _history;
        Map map = result.toJSONMap();
        this.result_json = JSONUtils.encodeToJSON(map);
        this.read = false;
        String key1_str = result.getEngine().getId() + ":" + result.getName();
        try {
            byte[] sha1 = new SHA1Simple().calculateHash(key1_str.getBytes("UTF-8"));
            this.key1 = new byte[10];
            System.arraycopy(sha1, 0, this.key1, 0, 10);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        String uid = result.getUID();
        if (uid != null && uid.length() > 0) {
            String key2_str = result.getEngine().getId() + ":" + uid;
            try {
                byte[] sha1 = new SHA1Simple().calculateHash(key2_str.getBytes("UTF-8"));
                this.key2 = new byte[10];
                System.arraycopy(sha1, 0, this.key2, 0, 10);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected SubscriptionResultImpl(SubscriptionHistoryImpl _history, Map map) {
        this.history = _history;
        this.key1 = (byte[])map.get("key");
        this.key2 = (byte[])map.get("key2");
        this.read = ((Long)map.get("read")).intValue() == 1;
        Long l_deleted = (Long)map.get("deleted");
        if (l_deleted != null) {
            this.deleted = true;
        } else {
            try {
                this.result_json = new String((byte[])map.get("result_json"), "UTF-8");
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected boolean updateFrom(SubscriptionResultImpl other) {
        if (this.deleted) {
            return false;
        }
        if (this.getJSON().equals(other.getJSON())) {
            return false;
        }
        this.key2 = other.getKey2();
        this.result_json = other.getJSON();
        return true;
    }

    @Override
    public String getID() {
        return Base32.encode(this.key1);
    }

    protected byte[] getKey1() {
        return this.key1;
    }

    protected byte[] getKey2() {
        return this.key2;
    }

    @Override
    public boolean getRead() {
        return this.read;
    }

    @Override
    public void setRead(boolean _read) {
        if (this.read != _read) {
            this.read = _read;
            this.history.updateResult(this);
        }
    }

    protected void setReadInternal(boolean _read) {
        this.read = _read;
    }

    @Override
    public void delete() {
        if (!this.deleted) {
            this.deleted = true;
            this.history.updateResult(this);
        }
    }

    protected void deleteInternal() {
        this.deleted = true;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    protected Map toBEncodedMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", this.key1);
        if (this.key2 != null) {
            map.put("key2", this.key2);
        }
        map.put("read", new Long(this.read ? 1L : 0L));
        if (this.deleted) {
            map.put("deleted", new Long(1L));
        } else {
            try {
                map.put("result_json", this.result_json.getBytes("UTF-8"));
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return map;
    }

    @Override
    public Map toJSONMap() {
        Map map = JSONUtils.decodeJSON(this.result_json);
        map.put("subs_is_read", new Boolean(this.read));
        map.put("subs_id", this.getID());
        Result.adjustRelativeTerms(map);
        String size = (String)map.get("l");
        if (size != null) {
            size = DisplayFormatters.trimDigits(size, 3);
            map.put("l", size);
        }
        return map;
    }

    private String getJSON() {
        return this.result_json;
    }

    @Override
    public String getDownloadLink() {
        Map map = this.toJSONMap();
        String link = (String)map.get("dbl");
        if (link == null) {
            link = (String)map.get("dl");
        }
        return link;
    }

    @Override
    public String getPlayLink() {
        return (String)this.toJSONMap().get("pl");
    }

    public String getAssetHash() {
        return (String)this.toJSONMap().get("h");
    }

    @Override
    public Map<Integer, Object> toPropertyMap() {
        String rank;
        String peers;
        String seeds;
        String hash;
        String cdp_link;
        String link;
        String size;
        Map map = this.toJSONMap();
        HashMap<Integer, Object> result = new HashMap<Integer, Object>();
        String title = (String)map.get("n");
        result.put(20, this.getID());
        result.put(1, title);
        String pub_date = (String)map.get("ts");
        if (pub_date != null) {
            result.put(2, new Date(Long.parseLong(pub_date)));
        }
        if ((size = (String)map.get("lb")) != null) {
            result.put(3, Long.parseLong(size));
        }
        if ((link = (String)map.get("dbl")) == null) {
            link = (String)map.get("dl");
        }
        if (link != null) {
            result.put(12, link);
        }
        if ((cdp_link = (String)map.get("cdp")) != null) {
            result.put(11, cdp_link);
        }
        if ((hash = (String)map.get("h")) != null) {
            result.put(21, Base32.decode(hash));
        }
        if ((seeds = (String)map.get("s")) != null) {
            result.put(5, Long.parseLong(seeds));
        }
        if ((peers = (String)map.get("p")) != null) {
            result.put(4, Long.parseLong(peers));
        }
        if ((rank = (String)map.get("r")) != null) {
            result.put(17, (long)(100.0f * Float.parseFloat(rank)));
        }
        return result;
    }
}

