/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.feature;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener;
import com.aelitis.azureus.ui.mdi.MdiEntryDropListener;
import com.aelitis.azureus.ui.mdi.MdiEntryLoadedListener;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImageListener;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.feature.FeatureManagerUIListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText_UrlClickedListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectTextbox;
import com.aelitis.azureus.ui.swt.views.skin.SBC_PlusFTUX;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBox;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import com.aelitis.azureus.util.ConstantsVuze;
import com.aelitis.azureus.util.FeatureUtils;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.shells.GCStringPrinter;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class FeatureManagerUI {
    private static final Integer BUTTON_UPGRADE = 4096;
    public static boolean enabled = !Constants.isUnix || System.getProperty("fm.ui", "0").equals("1");
    private static FeatureManager featman;
    private static VuzeMessageBox validatingBox;
    private static VuzeMessageBox entryWindow;
    private static FeatureManagerUIListener fml;

    public static void registerWithFeatureManager() {
        if (!enabled) {
            return;
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                FeatureManager.Licence[] licences;
                PluginInterface pi = core.getPluginManager().getDefaultPluginInterface();
                featman = pi.getUtilities().getFeatureManager();
                fml = new FeatureManagerUIListener(featman);
                featman.addListener(fml);
                for (FeatureManager.Licence licence : licences = featman.getLicences()) {
                    fml.licenceAdded(licence);
                }
                UIManager ui_manager = pi.getUIManager();
                ui_manager.addUIListener(new UIManagerListener(){

                    public void UIDetached(UIInstance instance) {
                    }

                    public void UIAttached(UIInstance instance) {
                        if (!(instance instanceof UISWTInstance)) {
                            return;
                        }
                        if (!Utils.isAZ2UI()) {
                            FeatureManagerUI.addFreeBurnUI();
                        }
                    }
                });
            }
        });
    }

    private static void addFreeBurnUI() {
        final MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        mdi.registerEntry("Plus", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                String title = FeatureUtils.hasFullLicence() ? "{mdi.entry.plus.full}" : "{mdi.entry.plus.free}";
                String placeBelow = mdi.getEntry("Welcome") == null ? "" : "Welcome";
                MdiEntry entry = mdi.createEntryFromSkinRef("header.vuze", "Plus", "main.area.plus", title, null, null, true, placeBelow);
                entry.setImageLeftID("image.sidebar.plus");
                return entry;
            }
        });
        MdiEntry existingEntry = mdi.getEntry("header.dvd");
        if (existingEntry != null) {
            return;
        }
        mdi.registerEntry("BurnInfo", new MdiEntryCreationListener(){

            public MdiEntry createMDiEntry(String id) {
                MdiEntry entryAbout = mdi.createEntryFromSkinRef("header.dvd", "BurnInfo", "main.burn.ftux", "{mdi.entry.about.dvdburn}", null, null, false, null);
                entryAbout.setImageLeftID("image.sidebar.dvdburn");
                entryAbout.setExpanded(true);
                entryAbout.addListener(new MdiEntryDropListener(){

                    public boolean mdiEntryDrop(MdiEntry entry, Object droppedObject) {
                        FeatureManagerUI.openTrialAskWindow();
                        return true;
                    }
                });
                MenuManager menuManager = PluginInitializer.getDefaultInterface().getUIManager().getMenuManager();
                MenuItem menuHide = menuManager.addMenuItem("Sidebar.BurnInfo", "popup.error.hide");
                menuHide.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        mdi.closeEntry("BurnInfo");
                    }
                });
                return entryAbout;
            }
        });
        mdi.addListener(new MdiEntryLoadedListener(){

            public void mdiEntryLoaded(MdiEntry entry) {
                if (!entry.getId().equals("header.dvd")) {
                    return;
                }
                MdiEntryVitalityImage addSub = entry.addVitalityImage("image.sidebar.subs.add");
                addSub.addListener(new MdiEntryVitalityImageListener(){

                    public void mdiEntryVitalityImage_clicked(int x, int y) {
                        FeatureManagerUI.openTrialAskWindow();
                    }
                });
            }
        });
        if (ConfigurationChecker.isNewVersion() && !ConfigurationChecker.isNewInstall() && !FeatureUtils.hasFullLicence()) {
            SBC_PlusFTUX.setSourceRef("startup");
            mdi.showEntryByID("Plus");
        }
    }

    public static void openTrialAskWindow() {
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("dlg.try.trial.title"), MessageText.getString("dlg.try.trial.text"), new String[]{MessageText.getString("Button.turnon"), MessageText.getString("Button.cancel")}, 0);
        box.setButtonVals(new Integer[]{32, 256});
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        box.setIconResource("image.burn.dlg.header");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                String id;
                SWTSkinObject so;
                SWTSkin skin = soExtra.getSkin();
                SWTSkinObjectText soLink = (SWTSkinObjectText)skin.getSkinObject("link", so = skin.createSkinObject(id = "dlg.register.trialask", id, soExtra));
                if (soLink != null) {
                    soLink.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                        public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                            String url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL("plus_tos.start", true);
                            Utils.launch(url);
                            return true;
                        }
                    });
                }
            }
        });
        box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == 32) {
                    SimpleTimer.addEvent("createTrial", SystemTime.getCurrentTime(), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            FeatureManagerUI.createTrial();
                        }
                    });
                }
            }
        });
    }

    public static void createTrial() {
        try {
            FeatureManager.Licence[] trial = featman.createLicences(new String[]{"dvdburn_trial"});
        }
        catch (Throwable e) {
            String s = "Creating Trial: " + Debug.getNestedExceptionMessage(e);
            new MessageBoxShell("Trial Error", s).open(null);
            Logger.log(new LogAlert(true, s, e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openLicenceEntryWindow(final boolean trytwo, final String prefillWith) {
        Class<FeatureManagerUI> clazz = FeatureManagerUI.class;
        synchronized (FeatureManagerUI.class) {
            if (!enabled) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (entryWindow != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            try {
                String tryNo = trytwo ? "2" : "1";
                final SWTSkinObjectTextbox[] key = new SWTSkinObjectTextbox[1];
                entryWindow = new VuzeMessageBox(MessageText.getString("dlg.auth.title"), MessageText.getString("dlg.auth.enter.line.try." + tryNo), new String[]{MessageText.getString("Button.agree"), MessageText.getString("Button.cancel")}, 0);
                entryWindow.setButtonVals(new Integer[]{32, 256});
                entryWindow.setSubTitle(MessageText.getString("dlg.auth.enter.subtitle.try." + tryNo));
                entryWindow.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
                entryWindow.setIconResource("image.vp");
                if (trytwo) {
                    entryWindow.setTextIconResource("image.warn.big");
                }
                entryWindow.setListener(new VuzeMessageBoxListener(){

                    public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                        SWTSkin skin = soExtra.getSkin();
                        skin.createSkinObject("dlg.register", "dlg.register", soExtra);
                        SWTSkinObjectText link = (SWTSkinObjectText)skin.getSkinObject("register-link", soExtra);
                        link.setText(MessageText.getString(trytwo ? "dlg.auth.enter.link.try.2" : "dlg.auth.enter.link.try.1"));
                        link.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                            public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                                if (trytwo) {
                                    String url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL("upgrade.start", true);
                                    Utils.launch(url);
                                } else {
                                    SBC_PlusFTUX.setSourceRef("dlg-activation");
                                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                                    mdi.showEntryByID("Plus");
                                    entryWindow.close(-2);
                                }
                                return true;
                            }
                        });
                        SWTSkinObjectText linkTOS = (SWTSkinObjectText)skin.getSkinObject("tos-link", soExtra);
                        if (linkTOS != null) {
                            linkTOS.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                                public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                                    String url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL("plus_tos.start", true);
                                    Utils.launch(url);
                                    return true;
                                }
                            });
                        }
                        key[0] = (SWTSkinObjectTextbox)skin.getSkinObject("key", soExtra);
                        if (key[0] != null) {
                            FeatureUtils.licenceDetails details;
                            if (prefillWith != null) {
                                key[0].setText(prefillWith);
                            } else if (!trytwo && (details = FeatureUtils.getFullFeatureDetails()) != null && details.licence.getState() != 3) {
                                SWTSkinObjectText soExpirey;
                                key[0].setText(details.licence.getKey());
                                if (key[0].getControl() instanceof Text) {
                                    ((Text)key[0].getControl()).selectAll();
                                }
                                if ((soExpirey = (SWTSkinObjectText)skin.getSkinObject("register-expirey")) != null) {
                                    key[0].getControl().addListener(24, new Listener(){

                                        public void handleEvent(Event event2) {
                                            soExpirey.setText("");
                                        }
                                    });
                                    int state = details.licence.getState();
                                    if (state == 4) {
                                        soExpirey.setText(MessageText.getString("dlg.auth.enter.cancelled"));
                                    } else if (state == 5) {
                                        soExpirey.setText(MessageText.getString("dlg.auth.enter.revoked"));
                                    } else if (state == 6) {
                                        soExpirey.setText(MessageText.getString("dlg.auth.enter.denied"));
                                    } else {
                                        long now = SystemTime.getCurrentTime();
                                        if (details.expiry < now && details.displayedExpiry > now) {
                                            soExpirey.setText(MessageText.getString("plus.notificaiton.OfflineExpiredEntry"));
                                        } else {
                                            soExpirey.setText(MessageText.getString("dlg.auth.enter.expiry", new String[]{DisplayFormatters.formatCustomDateOnly(details.displayedExpiry)}));
                                        }
                                    }
                                }
                            }
                        }
                    }
                });
                entryWindow.open(new UserPrompterResultListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void prompterClosed(int result) {
                        Class<FeatureManagerUI> clazz = FeatureManagerUI.class;
                        synchronized (FeatureManagerUI.class) {
                            entryWindow = null;
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            if (result == 32) {
                                try {
                                    FeatureManager.Licence licence = featman.addLicence(key[0].getText());
                                    int initialState = licence.getState();
                                    if (initialState == 2) {
                                        if (!licence.isFullyInstalled()) {
                                            fml.licenceAdded(licence);
                                        } else {
                                            FeatureManagerUI.openLicenceSuccessWindow();
                                        }
                                    } else if (initialState == 1) {
                                        fml.licenceAdded(licence);
                                    } else if (initialState == 3) {
                                        FeatureManagerUI.openLicenceFailedWindow(initialState, key[0].getText());
                                    } else if (initialState == 6) {
                                        FeatureManagerUI.openLicenceActivationDeniedWindow(licence);
                                    } else if (initialState == 4) {
                                        FeatureManagerUI.openLicenceCancelledWindow(licence);
                                    } else if (initialState == 5) {
                                        FeatureManagerUI.openLicenceRevokedWindow(licence);
                                    }
                                }
                                catch (Throwable e) {
                                    String s = Debug.getNestedExceptionMessage(e);
                                    MessageBoxShell mb = new MessageBoxShell(33, "Licence Addition Error", s);
                                    mb.open();
                                    Logger.log(new LogAlert(true, 3, "Adding Licence", e));
                                }
                            }
                            return;
                        }
                    }
                });
            }
            catch (Exception e) {
                entryWindow = null;
            }
            return;
        }
    }

    public static void openLicenceSuccessWindow() {
        if (!enabled) {
            return;
        }
        if (FeatureUtils.hasFullLicence()) {
            FeatureManagerUI.openFullLicenceSuccessWindow();
        } else {
            FeatureManagerUI.openTrialLicenceSuccessWindow();
        }
    }

    private static void openTrialLicenceSuccessWindow() {
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("dlg.auth.trial.success.subtitle"), MessageText.getString("dlg.auth.trial.success.line1"), new String[]{MessageText.getString("Button.goLibrary")}, 0);
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        box.setIconResource("image.burn.dlg.header");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                skin.createSkinObject("dlg.register.trial.success", "dlg.register.trial.success", soExtra);
            }
        });
        box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == 0) {
                    SBC_PlusFTUX.setSourceRef("dlg-trial-installed");
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    mdi.showEntryByID("Library");
                }
            }
        });
    }

    private static void openFullLicenceSuccessWindow() {
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("dlg.auth.title"), MessageText.getString("dlg.auth.success.line1"), new String[]{MessageText.getString("Button.getstarted")}, 0);
        box.setSubTitle(MessageText.getString("dlg.auth.success.subtitle"));
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        box.setIconResource("image.vp");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                skin.createSkinObject("dlg.register.success", "dlg.register.success", soExtra);
            }
        });
        box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == 0) {
                    SBC_PlusFTUX.setSourceRef("dlg-plus-installed");
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    mdi.showEntryByID("Plus");
                }
            }
        });
    }

    public static void openLicenceRevokedWindow(final FeatureManager.Licence licence) {
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("dlg.auth.revoked"), MessageText.getString("dlg.auth.revoked.line1"), new String[]{MessageText.getString("Button.close")}, 0);
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        box.setIconResource("image.vp");
        box.setTextIconResource("image.warn.big");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkinObject so;
                SWTSkin skin = soExtra.getSkin();
                SWTSkinObjectText soLink = (SWTSkinObjectText)skin.getSkinObject("link", so = skin.createSkinObject("dlg.register.revoked", "dlg.register.revoked", soExtra));
                if (soLink != null) {
                    soLink.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                        public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                            String url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL("licence_revoked.start?key=" + UrlUtils.encode(licence.getKey()), true);
                            Utils.launch(url);
                            return true;
                        }
                    });
                }
            }
        });
        box.open(null);
    }

    public static void openLicenceActivationDeniedWindow(final FeatureManager.Licence licence) {
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("dlg.auth.denied"), MessageText.getString("dlg.auth.denied.line1"), new String[]{MessageText.getString("Button.close")}, 0);
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        box.setIconResource("image.vp");
        box.setTextIconResource("image.warn.big");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkinObject so;
                SWTSkin skin = soExtra.getSkin();
                SWTSkinObjectText soLink = (SWTSkinObjectText)skin.getSkinObject("link", so = skin.createSkinObject("dlg.register.denied", "dlg.register.denied", soExtra));
                if (soLink != null) {
                    soLink.addUrlClickedListener(new SWTSkinObjectText_UrlClickedListener(){

                        public boolean urlClicked(GCStringPrinter.URLInfo urlInfo) {
                            String url = ConstantsVuze.getDefaultContentNetwork().getExternalSiteRelativeURL("licence_denied.start?key=" + UrlUtils.encode(licence.getKey()), true);
                            Utils.launch(url);
                            return true;
                        }
                    });
                }
            }
        });
        box.open(null);
    }

    public static void openLicenceCancelledWindow(FeatureManager.Licence licence) {
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString("dlg.auth.cancelled"), MessageText.getString("dlg.auth.cancelled.line1"), new String[]{MessageText.getString("Button.close")}, 0);
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
        box.setIconResource("image.vp");
        box.setTextIconResource("image.warn.big");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                SWTSkinObject so = skin.createSkinObject("dlg.register.cancelled", "dlg.register.cancelled", soExtra);
            }
        });
        box.open(null);
    }

    protected static void openLicenceFailedWindow(int licenceState, String code) {
        FeatureManagerUI.openLicenceEntryWindow(true, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void openLicenceValidatingWindow() {
        Class<FeatureManagerUI> clazz = FeatureManagerUI.class;
        synchronized (FeatureManagerUI.class) {
            if (!enabled || validatingBox != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            validatingBox = new VuzeMessageBox(MessageText.getString("dlg.auth.validating.subtitle"), null, null, 0);
            validatingBox.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_register");
            validatingBox.setIconResource("image.vp");
            validatingBox.setListener(new VuzeMessageBoxListener(){

                public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                    SWTSkin skin = soExtra.getSkin();
                    skin.createSkinObject("dlg.register.validating", "dlg.register.validating", soExtra);
                }
            });
            validatingBox.open(new UserPrompterResultListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void prompterClosed(int result) {
                    Class<FeatureManagerUI> clazz = FeatureManagerUI.class;
                    synchronized (FeatureManagerUI.class) {
                        validatingBox = null;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeLicenceValidatingWindow() {
        Class<FeatureManagerUI> clazz = FeatureManagerUI.class;
        synchronized (FeatureManagerUI.class) {
            if (validatingBox != null) {
                validatingBox.close(0);
                validatingBox = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void openStreamPlusWindow(final String referal) {
        String buttonID;
        String msgidPrefix;
        long plusExpiryTimeStamp = FeatureUtils.getPlusExpiryTimeStamp();
        if (plusExpiryTimeStamp <= 0L || plusExpiryTimeStamp >= SystemTime.getCurrentTime()) {
            msgidPrefix = "dlg.stream.plus.";
            buttonID = "Button.upgrade";
        } else {
            buttonID = "Button.renew";
            msgidPrefix = "dlg.stream.plus.renew.";
            if (!MessageText.keyExistsForDefaultLocale(msgidPrefix + "text")) {
                msgidPrefix = "dlg.stream.plus.";
            }
        }
        final String f_msgidPrefix = msgidPrefix;
        VuzeMessageBox box = new VuzeMessageBox(MessageText.getString(msgidPrefix + "title"), MessageText.getString(msgidPrefix + "text"), new String[]{MessageText.getString(buttonID), MessageText.getString("Button.cancel")}, 0);
        box.setButtonVals(new Integer[]{BUTTON_UPGRADE, 256});
        box.setSubTitle(MessageText.getString(msgidPrefix + "subtitle"));
        box.addResourceBundle(FeatureManagerUI.class, "com/aelitis/azureus/ui/skin/", "skin3_dlg_streamplus");
        box.setIconResource("image.header.streamplus");
        box.setListener(new VuzeMessageBoxListener(){

            public void shellReady(Shell shell, SWTSkinObjectContainer soExtra) {
                SWTSkin skin = soExtra.getSkin();
                skin.createSkinObject("dlg.stream.plus", "dlg.stream.plus", soExtra);
                SWTSkinObject soSubText = skin.getSkinObject("trial-info", soExtra);
                if (soSubText instanceof SWTSkinObjectText) {
                    ((SWTSkinObjectText)soSubText).setTextID(f_msgidPrefix + "subtext");
                }
            }
        });
        box.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == BUTTON_UPGRADE) {
                    SBC_PlusFTUX.setSourceRef("dlg-stream" + (referal == null ? "" : "-" + referal));
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    mdi.showEntryByID("Plus");
                }
            }
        });
    }

    public static String appendFeatureManagerURLParams(String url) {
        long remainingUses = FeatureUtils.getRemaining();
        long plusExpiryTimeStamp = FeatureUtils.getPlusExpiryDisplayTimeStamp();
        String plusRenewalCode = FeatureUtils.getPlusRenewalCode();
        String newURL = url + (url.contains("?") ? "&" : "?");
        newURL = newURL + "mode=" + FeatureUtils.getMode();
        if (plusExpiryTimeStamp != 0L) {
            newURL = newURL + "&remaining_plus=" + (plusExpiryTimeStamp - SystemTime.getCurrentTime());
        }
        newURL = newURL + "&remaining=" + remainingUses;
        if (plusRenewalCode != null) {
            newURL = newURL + "&renewal_code=" + plusRenewalCode;
        }
        return newURL;
    }

    public static long getPlusExpiryTimeStamp() {
        return FeatureUtils.getPlusExpiryTimeStamp();
    }
}

