/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl.transport;

import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.IncomingMessageQueue;
import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import com.aelitis.azureus.core.networkmanager.NetworkConnection;
import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.OutgoingMessageQueue;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.udp.UDPNetworkManager;
import com.aelitis.azureus.core.peermanager.messaging.Message;
import com.aelitis.azureus.core.peermanager.messaging.MessageManager;
import com.aelitis.azureus.core.peermanager.messaging.MessageStreamEncoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZBadPiece;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHandshake;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZHave;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZMetaData;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZPeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZRequestHint;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStatReply;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStatRequest;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZStylePeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.azureus.AZUTMetaData;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTAllowedFast;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTBitfield;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTCancel;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTChoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTDHTPort;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHave;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHaveAll;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTHaveNone;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTInterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTKeepAlive;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRawMessage;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRejectRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTRequest;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTSuggestPiece;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUnchoke;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.BTUninterested;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTHandshake;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessageDecoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.LTMessageEncoder;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.UTMetaData;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.UTPeerExchange;
import com.aelitis.azureus.core.peermanager.messaging.bittorrent.ltep.UTUploadOnly;
import com.aelitis.azureus.core.peermanager.peerdb.PeerExchangerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItem;
import com.aelitis.azureus.core.peermanager.peerdb.PeerItemFactory;
import com.aelitis.azureus.core.peermanager.piecepicker.PiecePicker;
import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.core.peermanager.utils.AZPeerIdentityManager;
import com.aelitis.azureus.core.peermanager.utils.ClientIdentifier;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTHaveMessageAggregator;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandler;
import com.aelitis.azureus.core.peermanager.utils.OutgoingBTPieceMessageHandlerAdapter;
import com.aelitis.azureus.core.peermanager.utils.PeerClassifier;
import com.aelitis.azureus.core.peermanager.utils.PeerMessageLimiter;
import com.aelitis.azureus.core.tag.TaggableResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerListener;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerControl;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransportFactory;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.peer.util.PeerIdentityManager;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunStateHandler;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IPToHostNameResolver;
import org.gudy.azureus2.core3.util.IPToHostNameResolverListener;
import org.gudy.azureus2.core3.util.IPToHostNameResolverRequest;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.dht.mainline.MainlineDHTProvider;
import org.gudy.azureus2.plugins.network.Connection;
import org.gudy.azureus2.plugins.peers.Peer;
import org.gudy.azureus2.pluginsimpl.local.network.ConnectionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PEPeerTransportProtocol
extends LogRelation
implements PEPeerTransport {
    protected static final LogIDs LOGID = LogIDs.PEER;
    private volatile int _lastPiece = -1;
    protected final PEPeerControl manager;
    protected final DiskManager diskManager;
    protected final PiecePicker piecePicker;
    protected final int nbPieces;
    private final String peer_source;
    private byte[] peer_id;
    private final String ip;
    protected String ip_resolved;
    private IPToHostNameResolverRequest ip_resolver_request;
    private int port;
    private PeerItem peer_item_identity;
    private int tcp_listen_port = 0;
    private int udp_listen_port = 0;
    private int udp_non_data_port = 0;
    private InetAddress alternativeAddress;
    private byte crypto_level;
    protected PEPeerStats peer_stats;
    private final ArrayList requested = new ArrayList();
    private final AEMonitor requested_mon = new AEMonitor("PEPeerTransportProtocol:Req");
    private Map data;
    private long lastNeededUndonePieceChange;
    private boolean really_choked_by_other_peer = true;
    private boolean effectively_choked_by_other_peer = true;
    private long effectively_unchoked_time = -1L;
    protected boolean choking_other_peer = true;
    private boolean interested_in_other_peer = false;
    private boolean other_peer_interested_in_me = false;
    private long snubbed = 0L;
    private volatile BitFlags peerHavePieces = null;
    private volatile boolean availabilityAdded = false;
    private volatile boolean received_bitfield;
    private int[] piece_priority_offsets;
    private boolean handshake_sent;
    private boolean seeding = false;
    private static final byte RELATIVE_SEEDING_NONE = 0;
    private static final byte RELATIVE_SEEDING_UPLOAD_ONLY_INDICATED = 1;
    private static final byte RELATIVE_SEEDING_UPLOAD_ONLY_SEED = 2;
    private byte relativeSeeding = 0;
    private final boolean incoming;
    protected volatile boolean closing = false;
    private volatile int current_peer_state;
    private final NetworkConnection connection;
    private OutgoingBTPieceMessageHandler outgoing_piece_message_handler;
    private OutgoingBTHaveMessageAggregator outgoing_have_message_aggregator;
    private Connection plugin_connection;
    private boolean identityAdded = false;
    protected int connection_state = 0;
    private String client = "";
    private String client_peer_id = "";
    private String client_handshake = "";
    private String client_handshake_version = "";
    private int uniquePiece = -1;
    private int[] reserved_pieces = null;
    private int spreadTimeHint = 0;
    protected long last_message_sent_time = 0L;
    protected long last_message_received_time = 0L;
    protected long last_data_message_received_time = -1L;
    protected long last_good_data_time = -1L;
    protected long last_data_message_sent_time = -1L;
    private long connection_established_time = 0L;
    private int consecutive_no_request_count;
    private int messaging_mode = 1;
    private Message[] supported_messages = null;
    private byte other_peer_bitfield_version = 1;
    private byte other_peer_cancel_version = 1;
    private byte other_peer_choke_version = 1;
    private byte other_peer_handshake_version = 1;
    private byte other_peer_bt_have_version = 1;
    private byte other_peer_az_have_version = 1;
    private byte other_peer_interested_version = 1;
    private byte other_peer_keep_alive_version = 1;
    private byte other_peer_pex_version = 1;
    private byte other_peer_piece_version = 1;
    private byte other_peer_unchoke_version = 1;
    private byte other_peer_uninterested_version = 1;
    private byte other_peer_request_version = 1;
    private byte other_peer_suggest_piece_version = 1;
    private byte other_peer_have_all_version = 1;
    private byte other_peer_have_none_version = 1;
    private byte other_peer_reject_request_version = 1;
    private byte other_peer_allowed_fast_version = 1;
    private byte other_peer_bt_lt_ext_version = 1;
    private byte other_peer_az_request_hint_version = 1;
    private byte other_peer_az_bad_piece_version = 1;
    private byte other_peer_az_stats_request_version = 1;
    private byte other_peer_az_stats_reply_version = 1;
    private byte other_peer_az_metadata_version = 1;
    private static final boolean DEBUG_FAST = false;
    private boolean ut_pex_enabled = false;
    private boolean fast_extension_enabled = false;
    private boolean ml_dht_enabled = false;
    private static final int ALLOWED_FAST_PIECE_OFFERED_NUM = 10;
    private static final int ALLOWED_FAST_OTHER_PEER_PIECE_MAX = 10;
    private static final Object KEY_ALLOWED_FAST_RECEIVED = new Object();
    private static final Object KEY_ALLOWED_FAST_SENT = new Object();
    private final AEMonitor closing_mon = new AEMonitor("PEPeerTransportProtocol:closing");
    private final AEMonitor general_mon = new AEMonitor("PEPeerTransportProtocol:data");
    private byte[] handshake_reserved_bytes = null;
    private LinkedHashMap recent_outgoing_requests;
    private AEMonitor recent_outgoing_requests_mon;
    private boolean has_received_initial_pex = false;
    private static final boolean SHOW_DISCARD_RATE_STATS;
    private static int requests_discarded;
    private static int requests_discarded_endgame;
    private static int requests_recovered;
    private static int requests_completed;
    private static final int REQUEST_HINT_MAX_LIFE = 150000;
    private int[] request_hint;
    private List peer_listeners_cow;
    private final AEMonitor peer_listeners_mon = new AEMonitor("PEPeerTransportProtocol:PL");
    protected static boolean ENABLE_LAZY_BITFIELD;
    private boolean priority_connection;
    private int upload_priority_auto;
    private static final DisconnectedTransportQueue recentlyDisconnected;
    private static boolean fast_unchoke_new_peers;
    private static final Random rnd;
    private static final byte[] sessionSecret;
    private static boolean enable_upload_bias;
    private HashWrapper peerSessionID;
    private HashWrapper mySessionID;
    private boolean allowReconnect;
    private Set<Object> upload_disabled_set;
    private Set<Object> download_disabled_set;
    private boolean is_upload_disabled;
    private boolean is_download_disabled;
    private boolean is_optimistic_unchoke = false;
    private PeerExchangerItem peer_exchange_item = null;
    private boolean peer_exchange_supported = false;
    protected PeerMessageLimiter message_limiter;
    private boolean request_hint_supported;
    private boolean bad_piece_supported;
    private boolean stats_request_supported;
    private boolean stats_reply_supported;
    private boolean az_metadata_supported;
    private boolean have_aggregation_disabled;
    private volatile boolean manual_lazy_bitfield_control;
    private volatile int[] manual_lazy_haves;
    private final boolean is_metadata_download;

    public PEPeerTransportProtocol(PEPeerControl _manager, String _peer_source, NetworkConnection _connection, Map _initial_user_data) {
        this.manager = _manager;
        this.peer_source = _peer_source;
        this.connection = _connection;
        this.data = _initial_user_data;
        this.incoming = true;
        this.is_metadata_download = this.manager.isMetadataDownload();
        this.diskManager = this.manager.getDiskManager();
        this.piecePicker = this.manager.getPiecePicker();
        this.nbPieces = this.diskManager.getNbPieces();
        InetSocketAddress notional_address = _connection.getEndpoint().getNotionalAddress();
        this.ip = AddressUtils.getHostAddress(notional_address);
        this.port = notional_address.getPort();
        this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.port, PeerItem.convertSourceID(_peer_source), (byte)0, 0, (byte)1, 0);
        this.plugin_connection = new ConnectionImpl(this.connection, this.incoming);
        this.peer_stats = this.manager.createPeerStats(this);
        this.changePeerState(10);
    }

    @Override
    public void start() {
        if (this.incoming) {
            this.connection.connect(3, new NetworkConnection.ConnectionListener(){

                public final int connectStarted(int ct) {
                    PEPeerTransportProtocol.this.connection_state = 1;
                    return ct;
                }

                public final void connectSuccess(ByteBuffer remaining_initial_data) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(PEPeerTransportProtocol.this, LOGID, "In: Established incoming connection"));
                    }
                    PEPeerTransportProtocol.this.generateSessionId();
                    PEPeerTransportProtocol.this.initializeConnection();
                    PEPeerTransportProtocol.this.sendBTHandshake();
                }

                public final void connectFailure(Throwable failure_msg) {
                    Debug.out("ERROR: incoming connect failure: ", failure_msg);
                    PEPeerTransportProtocol.this.closeConnectionInternally("ERROR: incoming connect failure [" + PEPeerTransportProtocol.this + "] : " + failure_msg.getMessage(), true, true);
                }

                public final void exceptionThrown(Throwable error) {
                    if (error.getMessage() == null) {
                        Debug.out(error);
                    }
                    PEPeerTransportProtocol.this.closeConnectionInternally("connection exception: " + error.getMessage(), false, true);
                }

                public Object getConnectionProperty(String property_name) {
                    return null;
                }

                public String getDescription() {
                    return PEPeerTransportProtocol.this.getString();
                }
            });
        }
    }

    public PEPeerTransportProtocol(PEPeerControl _manager, String _peer_source, String _ip, int _tcp_port, int _udp_port, boolean _use_tcp, boolean _require_crypto_handshake, byte _crypto_level, Map _initial_user_data) {
        ProtocolEndpoint pe1;
        InetSocketAddress endpoint_address;
        boolean public_net;
        Boolean pc;
        this.manager = _manager;
        this.is_metadata_download = this.manager.isMetadataDownload();
        this.diskManager = this.manager.getDiskManager();
        this.piecePicker = this.manager.getPiecePicker();
        this.nbPieces = this.diskManager.getNbPieces();
        this.lastNeededUndonePieceChange = Long.MIN_VALUE;
        this.peer_source = _peer_source;
        this.ip = _ip;
        this.port = _tcp_port;
        this.tcp_listen_port = _tcp_port;
        this.udp_listen_port = _udp_port;
        this.crypto_level = _crypto_level;
        this.data = _initial_user_data;
        if (this.data != null && (pc = (Boolean)this.data.get(Peer.PR_PRIORITY_CONNECTION)) != null && pc.booleanValue()) {
            this.setPriorityConnection(true);
        }
        this.udp_non_data_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(_peer_source), (byte)0, _udp_port, this.crypto_level, 0);
        this.incoming = false;
        this.peer_stats = this.manager.createPeerStats(this);
        if (this.port < 0 || this.port > 65535) {
            this.closeConnectionInternally("given remote port is invalid: " + this.port);
            this.connection = null;
            return;
        }
        boolean use_crypto = _require_crypto_handshake || NetworkManager.getCryptoRequired(this.manager.getAdapter().getCryptoLevel());
        boolean lan_local = this.isLANLocal();
        boolean bl = public_net = this.peer_item_identity.getNetwork() == "Public";
        if (lan_local || !public_net) {
            use_crypto = false;
        }
        ProtocolEndpoint pe2 = null;
        if (_use_tcp) {
            boolean utp_available = ProtocolEndpointFactory.isHandlerRegistered(3);
            boolean socks_active = NetworkAdmin.getSingleton().isSocksActive();
            endpoint_address = public_net ? new InetSocketAddress(this.ip, this.tcp_listen_port) : InetSocketAddress.createUnresolved(this.ip, this.tcp_listen_port);
            if (lan_local || !utp_available || !public_net) {
                pe1 = ProtocolEndpointFactory.createEndpoint(1, endpoint_address);
            } else if (AERunStateHandler.isUDPNetworkOnly() && !socks_active) {
                pe1 = ProtocolEndpointFactory.createEndpoint(3, endpoint_address);
            } else {
                pe1 = ProtocolEndpointFactory.createEndpoint(1, endpoint_address);
                if (!socks_active && RandomUtils.nextInt(2) == 1) {
                    pe2 = ProtocolEndpointFactory.createEndpoint(3, endpoint_address);
                }
            }
        } else {
            endpoint_address = public_net ? new InetSocketAddress(this.ip, this.udp_listen_port) : InetSocketAddress.createUnresolved(this.ip, this.udp_listen_port);
            pe1 = ProtocolEndpointFactory.createEndpoint(2, endpoint_address);
        }
        ConnectionEndpoint connection_endpoint = new ConnectionEndpoint(endpoint_address);
        connection_endpoint.addProtocol(pe1);
        if (pe2 != null) {
            connection_endpoint.addProtocol(pe2);
        }
        this.connection = NetworkManager.getSingleton().createConnection(connection_endpoint, new BTMessageEncoder(), new BTMessageDecoder(), use_crypto, !_require_crypto_handshake, this.manager.getSecrets(_crypto_level));
        this.plugin_connection = new ConnectionImpl(this.connection, this.incoming);
        this.changePeerState(10);
        ByteBuffer initial_outbound_data = null;
        if (use_crypto) {
            int i;
            BTHandshake handshake = new BTHandshake(this.manager.getHash(), this.manager.getPeerId(), this.manager.isExtendedMessagingEnabled(), this.other_peer_handshake_version);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "Sending encrypted handshake with reserved bytes: " + ByteFormatter.nicePrint(handshake.getReserved(), false)));
            }
            DirectByteBuffer[] ddbs = handshake.getRawData();
            int handshake_len = 0;
            for (i = 0; i < ddbs.length; ++i) {
                handshake_len += ddbs[i].remaining((byte)9);
            }
            initial_outbound_data = ByteBuffer.allocate(handshake_len);
            for (i = 0; i < ddbs.length; ++i) {
                DirectByteBuffer ddb = ddbs[i];
                initial_outbound_data.put(ddb.getBuffer((byte)9));
                ddb.returnToPool();
            }
            initial_outbound_data.flip();
            this.handshake_sent = true;
        }
        int priority = this.manager.isSeeding() ? 4 : (this.manager.isRTA() ? (PeerClassifier.isAzureusIP(this.ip) ? 0 : 1) : (PeerClassifier.isAzureusIP(this.ip) ? 1 : 3));
        if (this.peer_source == "Plugin" && priority > 2) {
            priority = 2;
        }
        this.connection.connect(initial_outbound_data, priority, new NetworkConnection.ConnectionListener(){
            private boolean connect_ok;

            public final int connectStarted(int default_connect_timeout) {
                PEPeerTransportProtocol.this.connection_state = 1;
                if (default_connect_timeout <= 0) {
                    return default_connect_timeout;
                }
                return PEPeerTransportProtocol.this.manager.getConnectTimeout(default_connect_timeout);
            }

            public final void connectSuccess(ByteBuffer remaining_initial_data) {
                this.connect_ok = true;
                if (PEPeerTransportProtocol.this.closing) {
                    return;
                }
                PEPeerTransportProtocol.this.generateSessionId();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LOGID, "Out: Established outgoing connection"));
                }
                PEPeerTransportProtocol.this.initializeConnection();
                if (remaining_initial_data != null && remaining_initial_data.remaining() > 0) {
                    PEPeerTransportProtocol.this.connection.getOutgoingMessageQueue().addMessage(new BTRawMessage(new DirectByteBuffer(remaining_initial_data)), false);
                }
                PEPeerTransportProtocol.this.sendBTHandshake();
            }

            public final void connectFailure(Throwable failure_msg) {
                PEPeerTransportProtocol.this.closeConnectionInternally("failed to establish outgoing connection: " + failure_msg.getMessage(), true, true);
            }

            public final void exceptionThrown(Throwable error) {
                if (error.getMessage() == null) {
                    Debug.out("error.getMessage() == null", error);
                }
                PEPeerTransportProtocol.this.closeConnectionInternally("connection exception: " + error.getMessage(), !this.connect_ok, true);
            }

            public Object getConnectionProperty(String property_name) {
                if (property_name == "peer_networks") {
                    return PEPeerTransportProtocol.this.manager.getAdapter().getEnabledNetworks();
                }
                return null;
            }

            public String getDescription() {
                return PEPeerTransportProtocol.this.getString();
            }
        });
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Out: Creating outgoing connection"));
        }
    }

    protected void initializeConnection() {
        if (this.closing) {
            return;
        }
        this.recent_outgoing_requests = new LinkedHashMap(16, 0.75f, true){

            public final boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 16;
            }
        };
        this.recent_outgoing_requests_mon = new AEMonitor("PEPeerTransportProtocol:ROR");
        this.message_limiter = new PeerMessageLimiter();
        this.outgoing_have_message_aggregator = new OutgoingBTHaveMessageAggregator(this.connection.getOutgoingMessageQueue(), this.other_peer_bt_have_version, this.other_peer_az_have_version);
        this.connection_established_time = SystemTime.getCurrentTime();
        this.connection_state = 2;
        this.changePeerState(20);
        this.registerForMessageHandling();
    }

    @Override
    public String getPeerSource() {
        return this.peer_source;
    }

    protected void closeConnectionInternally(String reason, boolean connect_failed, boolean network_failure) {
        this.performClose(reason, connect_failed, false, network_failure);
    }

    protected void closeConnectionInternally(String reason) {
        this.performClose(reason, false, false, false);
    }

    @Override
    public void closeConnection(String reason) {
        this.performClose(reason, false, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performClose(String reason, boolean connect_failed, boolean externally_closed, boolean network_failure) {
        try {
            this.closing_mon.enter();
            if (this.closing) {
                Object var6_5 = null;
                this.closing_mon.exit();
                return;
            }
            this.closing = true;
            this.interested_in_other_peer = false;
            this.lastNeededUndonePieceChange = Long.MAX_VALUE;
            if (this.isSnubbed()) {
                this.manager.decNbPeersSnubbed();
            }
            if (this.identityAdded) {
                if (this.peer_id != null) {
                    PeerIdentityManager.removeIdentity(this.manager.getPeerIdentityDataID(), this.peer_id, this.getPort());
                } else {
                    Debug.out("PeerIdentity added but peer_id == null !!!");
                }
                this.identityAdded = false;
            }
            this.changePeerState(40);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.closing_mon.exit();
            throw throwable;
        }
        Object var6_6 = null;
        this.closing_mon.exit();
        this.cancelRequests();
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.destroy();
        }
        if (this.peer_exchange_item != null) {
            this.peer_exchange_item.destroy();
        }
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.destroy();
        }
        if (this.connection != null) {
            this.connection.close(reason);
        }
        if (this.ip_resolver_request != null) {
            this.ip_resolver_request.cancel();
        }
        this.removeAvailability();
        this.changePeerState(50);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Peer connection closed: " + reason));
        }
        if (!externally_closed) {
            this.manager.peerConnectionClosed(this, connect_failed, network_failure);
        }
        this.setPriorityConnection(false);
        this.outgoing_have_message_aggregator = null;
        this.peer_exchange_item = null;
        this.outgoing_piece_message_handler = null;
        this.plugin_connection = null;
        if (this.peer_stats.getTotalDataBytesReceived() > 0L || this.peer_stats.getTotalDataBytesSent() > 0L || SystemTime.getCurrentTime() - this.connection_established_time > 30000L) {
            recentlyDisconnected.put(this.mySessionID, this);
        }
    }

    @Override
    public PEPeerTransport reconnect(boolean tryUDP, boolean tryIPv6) {
        boolean use_tcp;
        boolean bl = use_tcp = this.isTCP() && (!tryUDP || this.getUDPListenPort() <= 0);
        if (use_tcp && this.getTCPListenPort() > 0 || !use_tcp && this.getUDPListenPort() > 0) {
            boolean use_crypto = this.getPeerItemIdentity().getHandshakeType() == 1;
            PEPeerTransport new_conn = PEPeerTransportFactory.createTransport(this.manager, this.getPeerSource(), tryIPv6 && this.alternativeAddress != null ? this.alternativeAddress.getHostAddress() : this.getIp(), this.getTCPListenPort(), this.getUDPListenPort(), use_tcp, use_crypto, this.crypto_level, null);
            Logger.log(new LogEvent(new Object[]{this, new_conn}, LOGID, "attempting to reconnect, creating new connection"));
            if (new_conn instanceof PEPeerTransportProtocol) {
                PEPeerTransportProtocol pt = (PEPeerTransportProtocol)new_conn;
                pt.checkForReconnect(this.mySessionID);
                pt.alternativeAddress = this.alternativeAddress;
            }
            this.manager.addPeer(new_conn);
            return new_conn;
        }
        return null;
    }

    @Override
    public boolean isSafeForReconnect() {
        return this.allowReconnect;
    }

    private void checkForReconnect(HashWrapper oldID) {
        PEPeerTransportProtocol oldTransport = recentlyDisconnected.remove(oldID);
        if (oldTransport != null) {
            Logger.log(new LogEvent((Object)this, LOGID, 0, "reassociating stats from " + oldTransport + " with this connection"));
            this.peerSessionID = oldTransport.peerSessionID;
            this.peer_stats = oldTransport.peer_stats;
            this.peer_stats.setPeer(this);
            this.setSnubbed(oldTransport.isSnubbed());
            this.snubbed = oldTransport.snubbed;
            this.last_good_data_time = oldTransport.last_good_data_time;
        }
    }

    private void generateSessionId() {
        SHA1Hasher sha1 = new SHA1Hasher();
        sha1.update(sessionSecret);
        sha1.update(this.manager.getHash());
        sha1.update(this.getIp().getBytes());
        this.mySessionID = sha1.getHash();
        this.checkForReconnect(this.mySessionID);
    }

    private void addAvailability() {
        List peer_listeners_ref;
        if (!this.availabilityAdded && !this.closing && this.peerHavePieces != null && this.current_peer_state == 30 && (peer_listeners_ref = this.peer_listeners_cow) != null) {
            for (int i = 0; i < peer_listeners_ref.size(); ++i) {
                PEPeerListener peerListener = (PEPeerListener)peer_listeners_ref.get(i);
                peerListener.addAvailability(this, this.peerHavePieces);
            }
            this.availabilityAdded = true;
        }
    }

    private void removeAvailability() {
        if (this.availabilityAdded && this.peerHavePieces != null) {
            List peer_listeners_ref = this.peer_listeners_cow;
            if (peer_listeners_ref != null) {
                for (int i = 0; i < peer_listeners_ref.size(); ++i) {
                    PEPeerListener peerListener = (PEPeerListener)peer_listeners_ref.get(i);
                    peerListener.removeAvailability(this, this.peerHavePieces);
                }
            }
            this.availabilityAdded = false;
        }
        this.peerHavePieces = null;
    }

    protected void sendBTHandshake() {
        if (!this.handshake_sent) {
            BTHandshake handshake = new BTHandshake(this.manager.getHash(), this.manager.getPeerId(), this.manager.isExtendedMessagingEnabled(), this.other_peer_handshake_version);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "Sending handshake with reserved bytes: " + ByteFormatter.nicePrint(handshake.getReserved(), false)));
            }
            if (Constants.isCVSVersion()) {
                boolean supports_ltep;
                byte[] reserved = handshake.getReserved();
                boolean supports_azmp = (reserved[0] & 0x80) == 128;
                boolean bl = supports_ltep = (reserved[5] & 0x10) == 16;
                if (supports_ltep && !supports_azmp) {
                    Logger.log(new LogAlert((Object)this, false, 3, "AZMP support has failed in Azureus, please report this in the <a href=\"http://forum.vuze.com/forum.jspa?forumID=124\">bug report forum</a>.\nDebug data: " + ByteFormatter.nicePrint(reserved)));
                }
            }
            this.connection.getOutgoingMessageQueue().addMessage(handshake, false);
        }
    }

    private void sendLTHandshake() {
        int metainfo_size;
        String client_name = "Vuze 5.5.0.1_B19";
        int localTcpPort = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
        String tcpPortOverride = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        try {
            localTcpPort = Integer.parseInt(tcpPortOverride);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean require_crypto = NetworkManager.getCryptoRequired(this.manager.getAdapter().getCryptoLevel());
        HashMap<String, Object> data_dict = new HashMap<String, Object>();
        data_dict.put("v", client_name);
        data_dict.put("p", new Integer(localTcpPort));
        data_dict.put("e", new Long(require_crypto ? 1L : 0L));
        boolean upload_only = this.manager.isSeeding() && !ENABLE_LAZY_BITFIELD && !this.manual_lazy_bitfield_control && !this.manager.isSuperSeedMode();
        data_dict.put("upload_only", new Long(upload_only ? 1L : 0L));
        if (this.manager.isPrivateTorrent()) {
            metainfo_size = 0;
        } else {
            int n = metainfo_size = this.is_metadata_download ? 0 : this.manager.getTorrentInfoDictSize();
        }
        if (metainfo_size > 0) {
            data_dict.put("metadata_size", new Integer(metainfo_size));
        }
        NetworkAdmin na = NetworkAdmin.getSingleton();
        if (this.peer_item_identity.getNetwork() == "Public" && !na.isSocksActive()) {
            InetAddress defaultV6;
            InetAddress inetAddress = defaultV6 = na.hasIPV6Potential(true) ? na.getDefaultPublicAddressV6() : null;
            if (defaultV6 != null) {
                data_dict.put("ipv6", defaultV6.getAddress());
            }
        }
        LTHandshake lt_handshake = new LTHandshake(data_dict, this.other_peer_bt_lt_ext_version);
        lt_handshake.addDefaultExtensionMappings(true, this.is_metadata_download || metainfo_size > 0, true);
        this.connection.getOutgoingMessageQueue().addMessage(lt_handshake, false);
    }

    private void sendAZHandshake() {
        Message[] avail_msgs = MessageManager.getSingleton().getRegisteredMessages();
        String[] avail_ids = new String[avail_msgs.length];
        byte[] avail_vers = new byte[avail_msgs.length];
        for (int i = 0; i < avail_msgs.length; ++i) {
            avail_ids[i] = avail_msgs[i].getID();
            avail_vers[i] = avail_msgs[i].getVersion();
        }
        int local_tcp_port = TCPNetworkManager.getSingleton().getTCPListeningPortNumber();
        int local_udp_port = UDPNetworkManager.getSingleton().getUDPListeningPortNumber();
        int local_udp2_port = UDPNetworkManager.getSingleton().getUDPNonDataListeningPortNumber();
        String tcpPortOverride = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
        try {
            local_tcp_port = Integer.parseInt(tcpPortOverride);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean require_crypto = NetworkManager.getCryptoRequired(this.manager.getAdapter().getCryptoLevel());
        if (this.peerSessionID != null) {
            Logger.log(new LogEvent((Object)this, LOGID, 0, "notifying peer of reconnect attempt"));
        }
        InetAddress defaultV6 = null;
        NetworkAdmin na = NetworkAdmin.getSingleton();
        if (this.peer_item_identity.getNetwork() == "Public" && !na.isSocksActive()) {
            defaultV6 = na.hasIPV6Potential(true) ? na.getDefaultPublicAddressV6() : null;
        }
        String peer_name = "Vuze";
        if (this.peer_id[0] == 45 && this.peer_id[1] == 65 && this.peer_id[2] == 90 && this.peer_id[7] == 45) {
            try {
                int version = Integer.parseInt(new String(this.peer_id, 3, 4));
                if (version < 4813) {
                    peer_name = "Azureus";
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        AZHandshake az_handshake = new AZHandshake(AZPeerIdentityManager.getAZPeerIdentity(), this.mySessionID, this.peerSessionID, peer_name, "5.5.0.1_B19", local_tcp_port, local_udp_port, local_udp2_port, defaultV6, this.manager.isPrivateTorrent() ? 0 : (this.is_metadata_download ? 0 : this.manager.getTorrentInfoDictSize()), avail_ids, avail_vers, require_crypto ? 1 : 0, this.other_peer_handshake_version, this.manager.isSeeding() && !ENABLE_LAZY_BITFIELD && !this.manual_lazy_bitfield_control);
        this.connection.getOutgoingMessageQueue().addMessage(az_handshake, false);
    }

    @Override
    public int getPeerState() {
        return this.current_peer_state;
    }

    @Override
    public boolean isDownloadPossible() {
        if (!this.closing && !this.effectively_choked_by_other_peer) {
            if (this.lastNeededUndonePieceChange < this.piecePicker.getNeededUndonePieceChange()) {
                this.checkInterested();
                this.lastNeededUndonePieceChange = this.piecePicker.getNeededUndonePieceChange();
            }
            if (this.interested_in_other_peer && this.current_peer_state == 30) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getPercentDoneInThousandNotation() {
        long total_done = this.getBytesDownloaded();
        return (int)(total_done * 1000L / this.diskManager.getTotalLength());
    }

    @Override
    public boolean transferAvailable() {
        return !this.effectively_choked_by_other_peer && this.interested_in_other_peer;
    }

    private void printRequestStats() {
        if (SHOW_DISCARD_RATE_STATS) {
            float discard_perc = (float)requests_discarded * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded) * 1.0f);
            float discard_perc_end = (float)requests_discarded_endgame * 100.0f / ((float)(requests_completed + requests_recovered + requests_discarded_endgame) * 1.0f);
            float recover_perc = (float)requests_recovered * 100.0f / ((float)(requests_recovered + requests_discarded) * 1.0f);
            System.out.println("c=" + requests_completed + " d=" + requests_discarded + " de=" + requests_discarded_endgame + " r=" + requests_recovered + " dp=" + discard_perc + "% dpe=" + discard_perc_end + "% rp=" + recover_perc + "%");
        }
    }

    private void checkSeed() {
        if (this.peerHavePieces != null && this.nbPieces > 0) {
            this.setSeed(this.peerHavePieces.nbSet == this.nbPieces);
        } else {
            this.setSeed(false);
        }
        if (this.manager.isSeeding() && this.isSeed()) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 2);
        } else if (this.manager.isSeeding() && (this.relativeSeeding & 1) != 0) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 2);
        } else if (this.peerHavePieces != null && this.nbPieces > 0) {
            int piecesDone = this.manager.getPiecePicker().getNbPiecesDone();
            DiskManagerPiece[] dmPieces = this.diskManager.getPieces();
            boolean couldBeSeed = true;
            if (!this.manager.isSeeding() && (this.relativeSeeding & 1) != 0) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end && (couldBeSeed &= !this.peerHavePieces.flags[i] || dmPieces[i].isDone() || !dmPieces[i].isNeeded()); ++i) {
                }
            } else if (this.manager.isSeeding() && piecesDone <= this.peerHavePieces.nbSet) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end && (couldBeSeed &= !dmPieces[i].isDone() || this.peerHavePieces.flags[i]); ++i) {
                }
            } else {
                couldBeSeed = false;
            }
            this.relativeSeeding = couldBeSeed ? (byte)(this.relativeSeeding | 2) : (byte)(this.relativeSeeding & 0xFFFFFFFD);
        } else {
            this.relativeSeeding = (byte)(this.relativeSeeding & 0xFFFFFFFD);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DiskManagerReadRequest request(int pieceNumber, int pieceOffset, int pieceLength, boolean return_duplicates) {
        DiskManagerReadRequest request2 = this.manager.createDiskManagerRequest(pieceNumber, pieceOffset, pieceLength);
        if (this.current_peer_state != 30) {
            this.manager.requestCanceled(request2);
            return null;
        }
        boolean added = false;
        try {
            this.requested_mon.enter();
            if (!this.requested.contains(request2)) {
                this.requested.add(request2);
                added = true;
            }
            Object var8_7 = null;
            this.requested_mon.exit();
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.requested_mon.exit();
            throw throwable;
        }
        if (added) {
            if (this.is_metadata_download) {
                if (this.az_metadata_supported) {
                    this.connection.getOutgoingMessageQueue().addMessage(new AZMetaData(pieceNumber, this.other_peer_request_version), false);
                } else {
                    this.connection.getOutgoingMessageQueue().addMessage(new UTMetaData(pieceNumber, this.other_peer_request_version), false);
                }
            } else {
                this.connection.getOutgoingMessageQueue().addMessage(new BTRequest(pieceNumber, pieceOffset, pieceLength, this.other_peer_request_version), false);
            }
            this._lastPiece = pieceNumber;
            try {
                this.recent_outgoing_requests_mon.enter();
                this.recent_outgoing_requests.put(request2, null);
                Object var10_10 = null;
                this.recent_outgoing_requests_mon.exit();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                this.recent_outgoing_requests_mon.exit();
                throw throwable;
            }
            return request2;
        }
        if (return_duplicates) {
            return request2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRequestIndex(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            int n = this.requested.indexOf(request2);
            Object var4_3 = null;
            this.requested_mon.exit();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void sendCancel(DiskManagerReadRequest request2) {
        if (this.current_peer_state != 30) {
            return;
        }
        if (this.hasBeenRequested(request2)) {
            this.removeRequest(request2);
            this.connection.getOutgoingMessageQueue().addMessage(new BTCancel(request2.getPieceNumber(), request2.getOffset(), request2.getLength(), this.other_peer_cancel_version), false);
        }
    }

    private void sendHaveNone() {
        this.connection.getOutgoingMessageQueue().addMessage(new BTHaveNone(this.other_peer_have_none_version), false);
    }

    @Override
    public void sendHave(int pieceNumber) {
        if (this.current_peer_state != 30 || pieceNumber == this.manager.getHiddenPiece()) {
            return;
        }
        boolean force = !this.other_peer_interested_in_me && this.peerHavePieces != null && !this.peerHavePieces.flags[pieceNumber];
        this.outgoing_have_message_aggregator.queueHaveMessage(pieceNumber, force || this.have_aggregation_disabled);
        this.checkInterested();
    }

    @Override
    public void sendChoke() {
        if (this.current_peer_state != 30) {
            return;
        }
        this.connection.getOutgoingMessageQueue().addMessage(new BTChoke(this.other_peer_choke_version), false);
        this.choking_other_peer = true;
        this.is_optimistic_unchoke = false;
        this.destroyPieceMessageHandler();
    }

    @Override
    public void sendUnChoke() {
        if (this.current_peer_state != 30) {
            return;
        }
        this.createPieceMessageHandler();
        this.choking_other_peer = false;
        this.connection.getOutgoingMessageQueue().addMessage(new BTUnchoke(this.other_peer_unchoke_version), false);
    }

    private void createPieceMessageHandler() {
        if (this.outgoing_piece_message_handler == null) {
            this.outgoing_piece_message_handler = new OutgoingBTPieceMessageHandler(this, this.connection.getOutgoingMessageQueue(), new OutgoingBTPieceMessageHandlerAdapter(){

                public void diskRequestCompleted(long bytes) {
                    PEPeerTransportProtocol.this.peer_stats.diskReadComplete(bytes);
                }
            }, this.other_peer_piece_version);
        }
    }

    private void destroyPieceMessageHandler() {
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.removeAllPieceRequests();
            this.outgoing_piece_message_handler.destroy();
            this.outgoing_piece_message_handler = null;
        }
    }

    private void sendKeepAlive() {
        if (this.current_peer_state != 30) {
            return;
        }
        if (this.outgoing_have_message_aggregator.hasPending()) {
            this.outgoing_have_message_aggregator.forceSendOfPending();
        } else {
            this.connection.getOutgoingMessageQueue().addMessage(new BTKeepAlive(this.other_peer_keep_alive_version), false);
        }
    }

    private void sendMainlineDHTPort() {
        if (!this.ml_dht_enabled) {
            return;
        }
        MainlineDHTProvider provider2 = PEPeerTransportProtocol.getDHTProvider();
        if (provider2 == null) {
            return;
        }
        BTDHTPort message = new BTDHTPort(provider2.getDHTPort());
        this.connection.getOutgoingMessageQueue().addMessage(message, false);
    }

    @Override
    public void checkInterested() {
        boolean is_interesting;
        if (this.closing || this.peerHavePieces == null || this.peerHavePieces.nbSet == 0) {
            return;
        }
        boolean bl = is_interesting = !this.is_download_disabled;
        if (is_interesting && this.piecePicker.hasDownloadablePiece()) {
            if (!this.isSeed() && !this.isRelativeSeed()) {
                for (int i = this.peerHavePieces.start; i <= this.peerHavePieces.end; ++i) {
                    if (!this.peerHavePieces.flags[i] || !this.diskManager.isInteresting(i)) continue;
                    is_interesting = true;
                    break;
                }
            } else {
                is_interesting = true;
            }
        }
        if (is_interesting && !this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(this.other_peer_interested_version), false);
        } else if (!is_interesting && this.interested_in_other_peer) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTUninterested(this.other_peer_uninterested_version), false);
        }
        this.interested_in_other_peer = is_interesting;
    }

    private void sendBitField() {
        int i;
        if (this.closing) {
            return;
        }
        if (this.manager.isSuperSeedMode()) {
            this.sendHaveNone();
            return;
        }
        if (this.is_metadata_download) {
            return;
        }
        DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)12, (this.nbPieces + 7) / 8);
        DiskManagerPiece[] pieces = this.diskManager.getPieces();
        int num_pieces = pieces.length;
        HashSet<MutableInteger> lazies = null;
        int[] lazy_haves = null;
        if (ENABLE_LAZY_BITFIELD || this.manual_lazy_bitfield_control) {
            int last_byte_entry;
            int bits_in_first_byte = Math.min(num_pieces, 8);
            int last_byte_start_bit = num_pieces / 8 * 8;
            int bits_in_last_byte = num_pieces - last_byte_start_bit;
            if (bits_in_last_byte == 0) {
                bits_in_last_byte = 8;
                last_byte_start_bit -= 8;
            }
            lazies = new HashSet<MutableInteger>();
            int first_byte_entry = rnd.nextInt(bits_in_first_byte);
            if (pieces[first_byte_entry].isDone()) {
                lazies.add(new MutableInteger(first_byte_entry));
            }
            if (pieces[last_byte_entry = last_byte_start_bit + rnd.nextInt(bits_in_last_byte)].isDone()) {
                lazies.add(new MutableInteger(last_byte_entry));
            }
            int other_lazies = rnd.nextInt(16) + 4;
            for (int i2 = 0; i2 < other_lazies; ++i2) {
                int random_entry = rnd.nextInt(num_pieces);
                if (!pieces[random_entry].isDone()) continue;
                lazies.add(new MutableInteger(random_entry));
            }
            int num_lazy = lazies.size();
            if (num_lazy == 0) {
                lazies = null;
            } else {
                int i3;
                lazy_haves = new int[num_lazy];
                Iterator it = lazies.iterator();
                for (i3 = 0; i3 < num_lazy; ++i3) {
                    int lazy_have;
                    lazy_haves[i3] = lazy_have = ((MutableInteger)it.next()).getValue();
                }
                if (num_lazy > 1) {
                    for (i3 = 0; i3 < num_lazy; ++i3) {
                        int swap = rnd.nextInt(num_lazy);
                        if (swap == i3) continue;
                        int temp = lazy_haves[swap];
                        lazy_haves[swap] = lazy_haves[i3];
                        lazy_haves[i3] = temp;
                    }
                }
            }
        }
        int bToSend = 0;
        MutableInteger mi = new MutableInteger(0);
        int hidden_piece = this.manager.getHiddenPiece();
        for (i = 0; i < num_pieces; ++i) {
            if (i % 8 == 0) {
                bToSend = 0;
            }
            bToSend <<= 1;
            if (pieces[i].isDone() && i != hidden_piece) {
                if (lazies != null) {
                    mi.setValue(i);
                    if (!lazies.contains(mi)) {
                        ++bToSend;
                    }
                } else {
                    ++bToSend;
                }
            }
            if (i % 8 != 7) continue;
            buffer.put((byte)6, (byte)bToSend);
        }
        if (i % 8 != 0) {
            buffer.put((byte)6, (byte)(bToSend <<= 8 - i % 8));
        }
        buffer.flip((byte)6);
        this.connection.getOutgoingMessageQueue().addMessage(new BTBitfield(buffer, this.other_peer_bitfield_version), false);
        if (lazy_haves != null) {
            if (this.manual_lazy_bitfield_control) {
                this.manual_lazy_haves = lazy_haves;
            } else {
                this.sendLazyHaves(lazy_haves, false);
            }
        }
    }

    protected void sendLazyHaves(final int[] lazy_haves, boolean immediate) {
        if (immediate) {
            if (this.current_peer_state == 30) {
                for (int lazy_have : lazy_haves) {
                    this.connection.getOutgoingMessageQueue().addMessage(new BTHave(lazy_have, this.other_peer_bt_have_version), false);
                }
            }
        } else {
            SimpleTimer.addEvent("LazyHaveSender", SystemTime.getCurrentTime() + 1000L + (long)rnd.nextInt(2000), new TimerEventPerformer(){
                int next_have = 0;

                public void perform(TimerEvent event2) {
                    if (PEPeerTransportProtocol.this.current_peer_state == 30) {
                        int lazy_have = lazy_haves[this.next_have++];
                        PEPeerTransportProtocol.this.connection.getOutgoingMessageQueue().addMessage(new BTHave(lazy_have, PEPeerTransportProtocol.this.other_peer_bt_have_version), false);
                        if (this.next_have < lazy_haves.length && PEPeerTransportProtocol.this.current_peer_state == 30) {
                            SimpleTimer.addEvent("LazyHaveSender", SystemTime.getCurrentTime() + (long)rnd.nextInt(2000), this);
                        }
                    }
                }
            });
        }
    }

    @Override
    public byte[] getId() {
        return this.peer_id;
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public InetAddress getAlternativeIPv6() {
        return this.alternativeAddress;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getTCPListenPort() {
        return this.tcp_listen_port;
    }

    @Override
    public int getUDPListenPort() {
        return this.udp_listen_port;
    }

    @Override
    public int getUDPNonDataListenPort() {
        return this.udp_non_data_port;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public boolean isIncoming() {
        return this.incoming;
    }

    @Override
    public boolean isOptimisticUnchoke() {
        return this.is_optimistic_unchoke && !this.isChokedByMe();
    }

    @Override
    public void setOptimisticUnchoke(boolean is_optimistic) {
        this.is_optimistic_unchoke = is_optimistic;
    }

    @Override
    public PEPeerControl getControl() {
        return this.manager;
    }

    @Override
    public PEPeerManager getManager() {
        return this.manager;
    }

    @Override
    public PEPeerStats getStats() {
        return this.peer_stats;
    }

    @Override
    public int[] getPriorityOffsets() {
        return this.piece_priority_offsets;
    }

    @Override
    public boolean requestAllocationStarts(int[] base_priorities) {
        return false;
    }

    @Override
    public void requestAllocationComplete() {
    }

    @Override
    public BitFlags getAvailable() {
        return this.peerHavePieces;
    }

    @Override
    public boolean isPieceAvailable(int pieceNumber) {
        if (this.peerHavePieces != null) {
            return this.peerHavePieces.flags[pieceNumber];
        }
        return false;
    }

    @Override
    public boolean isChokingMe() {
        return this.effectively_choked_by_other_peer;
    }

    @Override
    public boolean isUnchokeOverride() {
        return this.really_choked_by_other_peer && !this.effectively_choked_by_other_peer;
    }

    @Override
    public boolean isChokedByMe() {
        return this.choking_other_peer;
    }

    @Override
    public boolean isInteresting() {
        return this.interested_in_other_peer;
    }

    @Override
    public boolean isInterested() {
        return this.other_peer_interested_in_me;
    }

    @Override
    public boolean isSeed() {
        return this.seeding;
    }

    @Override
    public boolean isRelativeSeed() {
        return (this.relativeSeeding & 2) != 0;
    }

    private void setSeed(boolean s) {
        if (this.seeding != s) {
            this.seeding = s;
            PeerExchangerItem pex_item = this.peer_exchange_item;
            if (pex_item != null && s) {
                pex_item.seedStatusChanged();
            }
        }
    }

    @Override
    public boolean isSnubbed() {
        return this.snubbed != 0L;
    }

    @Override
    public long getSnubbedTime() {
        if (this.snubbed == 0L) {
            return 0L;
        }
        long now = SystemTime.getCurrentTime();
        if (now < this.snubbed) {
            this.snubbed = now - 26L;
        }
        return now - this.snubbed;
    }

    @Override
    public void setSnubbed(boolean b) {
        if (!this.closing) {
            long now = SystemTime.getCurrentTime();
            if (!b) {
                if (this.snubbed != 0L) {
                    this.snubbed = 0L;
                    this.manager.decNbPeersSnubbed();
                }
            } else if (this.snubbed == 0L) {
                this.snubbed = now;
                this.manager.incNbPeersSnubbed();
            }
        }
    }

    @Override
    public void setUploadHint(int spreadTime) {
        this.spreadTimeHint = spreadTime;
    }

    @Override
    public int getUploadHint() {
        return this.spreadTimeHint;
    }

    @Override
    public void setUniqueAnnounce(int _uniquePiece) {
        this.uniquePiece = _uniquePiece;
    }

    @Override
    public int getUniqueAnnounce() {
        return this.uniquePiece;
    }

    @Override
    public Object getData(String key) {
        return this.getUserData(key);
    }

    @Override
    public void setData(String key, Object value) {
        this.setUserData(key, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getUserData(Object key) {
        block3: {
            try {
                this.general_mon.enter();
                if (this.data != null) break block3;
                Object var2_2 = null;
                Object var4_4 = null;
                this.general_mon.exit();
                return var2_2;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.general_mon.exit();
                throw throwable;
            }
        }
        Object v = this.data.get(key);
        Object var4_5 = null;
        this.general_mon.exit();
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUserData(Object key, Object value) {
        try {
            this.general_mon.enter();
            if (this.data == null) {
                this.data = new LightHashMap();
            }
            if (value == null) {
                if (this.data.containsKey(key)) {
                    this.data.remove(key);
                    if (this.data.size() == 0) {
                        this.data = null;
                    }
                }
            } else {
                this.data.put(key, value);
            }
            Object var4_3 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    @Override
    public String getIPHostName() {
        if (this.ip_resolved == null) {
            this.ip_resolved = this.ip;
            this.ip_resolver_request = IPToHostNameResolver.addResolverRequest(this.ip_resolved, new IPToHostNameResolverListener(){

                public final void IPResolutionComplete(String res, boolean ok) {
                    PEPeerTransportProtocol.this.ip_resolved = res;
                }
            });
        }
        return this.ip_resolved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRequests() {
        if (!this.closing) {
            Message[] type = new Message[]{new BTRequest(-1, -1, -1, this.other_peer_request_version)};
            this.connection.getOutgoingMessageQueue().removeMessagesOfType(type, false);
        }
        if (this.requested != null && this.requested.size() > 0) {
            try {
                long timeSinceGoodData;
                this.requested_mon.enter();
                if (!(this.closing || (timeSinceGoodData = this.getTimeSinceGoodDataReceived()) != -1L && timeSinceGoodData <= 60000L)) {
                    this.setSnubbed(true);
                }
                for (int i = this.requested.size() - 1; i >= 0; --i) {
                    DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.remove(i);
                    this.manager.requestCanceled(request2);
                }
                Object var4_5 = null;
                this.requested_mon.exit();
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.requested_mon.exit();
                throw throwable;
            }
        }
    }

    @Override
    public int getMaxNbRequests() {
        return -1;
    }

    @Override
    public int getNbRequests() {
        return this.requested.size();
    }

    @Override
    public List getExpiredRequests() {
        ArrayList<DiskManagerReadRequest> result = null;
        try {
            for (int i = this.requested.size() - 1; i >= 0; --i) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.get(i);
                if (!request2.isExpired()) continue;
                if (result == null) {
                    result = new ArrayList<DiskManagerReadRequest>();
                }
                result.add(request2);
            }
            return result;
        }
        catch (Throwable e) {
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasBeenRequested(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            boolean bl = this.requested.contains(request2);
            Object var4_3 = null;
            this.requested_mon.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeRequest(DiskManagerReadRequest request2) {
        try {
            this.requested_mon.enter();
            this.requested.remove(request2);
            Object var3_2 = null;
            this.requested_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.requested_mon.exit();
            throw throwable;
        }
        BTRequest msg = new BTRequest(request2.getPieceNumber(), request2.getOffset(), request2.getLength(), this.other_peer_request_version);
        this.connection.getOutgoingMessageQueue().removeMessage(msg, false);
        msg.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetRequestsTime(long now) {
        try {
            this.requested_mon.enter();
            int requestedSize = this.requested.size();
            for (int i = 0; i < requestedSize; ++i) {
                DiskManagerReadRequest request2 = (DiskManagerReadRequest)this.requested.get(i);
                if (request2 == null) continue;
                request2.resetTime(now);
            }
            Object var7_5 = null;
            this.requested_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    public String toString() {
        return (this.isIncoming() ? "R: " : "L: ") + this.ip + ":" + this.port + (this.isTCP() ? " [" : "(UDP) [") + this.client + "]";
    }

    public String getString() {
        return this.toString();
    }

    @Override
    public void doKeepAliveCheck() {
        long now = SystemTime.getCurrentTime();
        long wait_time = now - this.last_message_sent_time;
        if (this.last_message_sent_time == 0L || wait_time < 0L) {
            this.last_message_sent_time = now;
            return;
        }
        if (wait_time > 120000L) {
            this.sendKeepAlive();
            this.last_message_sent_time = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAutoUploadPriority(Object key, boolean inc) {
        try {
            boolean key_exists;
            this.general_mon.enter();
            boolean bl = key_exists = this.getUserData(key) != null;
            if (inc && !key_exists) {
                ++this.upload_priority_auto;
                this.setUserData(key, "");
            } else if (!inc && key_exists) {
                --this.upload_priority_auto;
                this.setUserData(key, null);
            }
            Object var5_4 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    @Override
    public boolean doTimeoutChecks() {
        if (this.connection != null) {
            this.connection.getOutgoingMessageQueue().setPriorityBoost(this.upload_priority_auto > 0 || this.manager.getUploadPriority() > 0 || enable_upload_bias && !this.manager.isSeeding());
        }
        if (this.fast_extension_enabled) {
            this.checkAllowedFast();
        }
        long now = SystemTime.getCurrentTime();
        if (this.connection_state == 4) {
            if (this.last_message_received_time > now) {
                this.last_message_received_time = now;
            }
            if (this.last_data_message_received_time > now) {
                this.last_data_message_received_time = now;
            }
            if (now - this.last_message_received_time > 300000L && now - this.last_data_message_received_time > 300000L) {
                this.closeConnectionInternally("timed out while waiting for messages", false, true);
                return true;
            }
        } else if (this.connection_state == 2) {
            if (this.connection_established_time > now) {
                this.connection_established_time = now;
            } else if (now - this.connection_established_time > 180000L) {
                this.closeConnectionInternally("timed out while waiting for handshake");
                return true;
            }
        }
        return false;
    }

    @Override
    public void doPerformanceTuningCheck() {
        Transport transport = this.connection.getTransport();
        if (transport != null && this.peer_stats != null && this.outgoing_piece_message_handler != null) {
            long send_rate = this.peer_stats.getDataSendRate() + this.peer_stats.getProtocolSendRate();
            if (send_rate >= 3125000L) {
                transport.setTransportMode(2);
                this.outgoing_piece_message_handler.setRequestReadAhead(256);
            } else if (send_rate >= 1250000L) {
                transport.setTransportMode(2);
                this.outgoing_piece_message_handler.setRequestReadAhead(128);
            } else if (send_rate >= 125000L) {
                if (transport.getTransportMode() < 1) {
                    transport.setTransportMode(1);
                }
                this.outgoing_piece_message_handler.setRequestReadAhead(32);
            } else if (send_rate >= 62500L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(16);
            } else if (send_rate >= 31250L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(8);
            } else if (send_rate >= 12500L) {
                this.outgoing_piece_message_handler.setRequestReadAhead(4);
            } else {
                this.outgoing_piece_message_handler.setRequestReadAhead(2);
            }
            long receive_rate = this.peer_stats.getDataReceiveRate() + this.peer_stats.getProtocolReceiveRate();
            if (receive_rate >= 1250000L) {
                transport.setTransportMode(2);
            } else if (receive_rate >= 125000L && transport.getTransportMode() < 1) {
                transport.setTransportMode(1);
            }
        }
    }

    @Override
    public int getConnectionState() {
        return this.connection_state;
    }

    @Override
    public long getTimeSinceLastDataMessageReceived() {
        if (this.last_data_message_received_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        if (this.last_data_message_received_time > now) {
            this.last_data_message_received_time = now;
        }
        return now - this.last_data_message_received_time;
    }

    @Override
    public long getTimeSinceGoodDataReceived() {
        if (this.last_good_data_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        if (this.last_good_data_time > now) {
            this.last_good_data_time = now;
        }
        return now - this.last_good_data_time;
    }

    @Override
    public long getTimeSinceLastDataMessageSent() {
        if (this.last_data_message_sent_time == -1L) {
            return -1L;
        }
        long now = SystemTime.getCurrentTime();
        if (this.last_data_message_sent_time > now) {
            this.last_data_message_sent_time = now;
        }
        return now - this.last_data_message_sent_time;
    }

    @Override
    public long getTimeSinceConnectionEstablished() {
        if (this.connection_established_time == 0L) {
            return 0L;
        }
        long now = SystemTime.getCurrentTime();
        if (this.connection_established_time > now) {
            this.connection_established_time = now;
        }
        return now - this.connection_established_time;
    }

    @Override
    public int getConsecutiveNoRequestCount() {
        return this.consecutive_no_request_count;
    }

    @Override
    public void setConsecutiveNoRequestCount(int num) {
        this.consecutive_no_request_count = num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void decodeBTHandshake(BTHandshake handshake) {
        block28: {
            block27: {
                String msg;
                boolean same_allowed;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Received handshake with reserved bytes: " + ByteFormatter.nicePrint(handshake.getReserved(), false)));
                }
                PeerIdentityDataID my_peer_data_id = this.manager.getPeerIdentityDataID();
                if (this.getConnectionState() == 4) {
                    handshake.destroy();
                    this.closeConnectionInternally("peer sent another handshake after the initial connect");
                }
                if (!Arrays.equals(this.manager.getHash(), handshake.getDataHash())) {
                    this.closeConnectionInternally("handshake has wrong infohash");
                    handshake.destroy();
                    return;
                }
                this.peer_id = handshake.getPeerId();
                this.client_peer_id = this.client = StringInterner.intern(PeerClassifier.getClientDescription(this.peer_id));
                if (!PeerClassifier.isClientTypeAllowed(this.client)) {
                    this.closeConnectionInternally(this.client + " client type not allowed to connect, banned");
                    handshake.destroy();
                    return;
                }
                if (Arrays.equals(this.manager.getPeerId(), this.peer_id)) {
                    this.manager.peerVerifiedAsSelf(this);
                    this.closeConnectionInternally("given peer id matches myself");
                    handshake.destroy();
                    return;
                }
                boolean sameIdentity = PeerIdentityManager.containsIdentity(my_peer_data_id, this.peer_id, this.getPort());
                boolean sameIP = false;
                boolean bl = same_allowed = COConfigurationManager.getBooleanParameter("Allow Same IP Peers") || this.ip.equals("127.0.0.1");
                if (!same_allowed && PeerIdentityManager.containsIPAddress(my_peer_data_id, this.ip)) {
                    sameIP = true;
                }
                if (sameIdentity) {
                    PEPeerTransport existing;
                    boolean close = true;
                    if (this.connection.isLANLocal() && (existing = this.manager.getTransportFromIdentity(this.peer_id)) != null) {
                        String existing_ip = existing.getIp();
                        if (!existing.isLANLocal() || existing_ip.endsWith(".1") && !existing_ip.equals(this.ip)) {
                            Debug.outNoStack("Dropping existing non-lanlocal peer connection [" + existing + "] in favour of [" + this + "]");
                            this.manager.removePeer(existing);
                            close = false;
                        }
                    }
                    if (close) {
                        if (Constants.IS_CVS_VERSION) {
                            try {
                                List<PEPeer> peers = this.manager.getPeers();
                                String dup_str = "?";
                                boolean dup_ip = false;
                                for (PEPeer p : peers) {
                                    byte[] id;
                                    if (p == this || !Arrays.equals(id = p.getId(), this.peer_id)) continue;
                                    dup_ip = p.getIp().equals(this.getIp());
                                    dup_str = p.getClient() + "/" + p.getClientNameFromExtensionHandshake() + "/" + p.getIp() + "/" + p.getPort();
                                    break;
                                }
                                String my_str = this.getClient() + "/" + this.getIp() + "/" + this.getPort();
                                if (!dup_ip) {
                                    Debug.outNoStack("Duplicate peer id detected: id=" + ByteFormatter.encodeString(this.peer_id) + ": this=" + my_str + ",other=" + dup_str);
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                        }
                        this.closeConnectionInternally("peer matches already-connected peer id");
                        handshake.destroy();
                        return;
                    }
                }
                if (sameIP) {
                    this.closeConnectionInternally("peer matches already-connected IP address, duplicate connections not allowed");
                    handshake.destroy();
                    return;
                }
                int maxAllowed = this.manager.getMaxNewConnectionsAllowed();
                if (maxAllowed == 0 && !this.manager.doOptimisticDisconnect(this.isLANLocal(), this.isPriorityConnection())) {
                    msg = "too many existing peer connections [p" + PeerIdentityManager.getIdentityCount(my_peer_data_id) + "/g" + PeerIdentityManager.getTotalIdentityCount() + ", pmx" + PeerUtils.MAX_CONNECTIONS_PER_TORRENT + "/gmx" + PeerUtils.MAX_CONNECTIONS_TOTAL + "/dmx" + this.manager.getMaxConnections() + "]";
                    this.closeConnectionInternally(msg);
                    handshake.destroy();
                    return;
                }
                try {
                    this.closing_mon.enter();
                    if (this.closing) {
                        msg = "connection already closing";
                        this.closeConnectionInternally("connection already closing");
                        handshake.destroy();
                        Object var14_15 = null;
                        this.closing_mon.exit();
                        return;
                    }
                    if (!PeerIdentityManager.addIdentity(my_peer_data_id, this.peer_id, this.getPort(), this.ip)) {
                        this.closeConnectionInternally("peer matches already-connected peer id");
                        handshake.destroy();
                        break block27;
                    }
                    this.identityAdded = true;
                    break block28;
                }
                catch (Throwable throwable) {
                    Object var14_18 = null;
                    this.closing_mon.exit();
                    throw throwable;
                }
            }
            Object var14_16 = null;
            this.closing_mon.exit();
            return;
        }
        Object var14_17 = null;
        this.closing_mon.exit();
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "In: has sent their handshake"));
        }
        this.handshake_reserved_bytes = handshake.getReserved();
        this.ml_dht_enabled = (this.handshake_reserved_bytes[7] & 1) == 1;
        this.fast_extension_enabled = this.manager.getUploadRateLimitBytesPerSecond() == 0 && (this.handshake_reserved_bytes[7] & 4) != 0;
        this.messaging_mode = this.decideExtensionProtocol(handshake);
        if (this.messaging_mode == 2) {
            if (Logger.isEnabled() && this.client.indexOf("Azureus") == -1) {
                Logger.log(new LogEvent(this, LOGID, "Handshake claims extended AZ messaging support... enabling AZ mode."));
            }
            this.ml_dht_enabled = false;
            Transport transport = this.connection.getTransport();
            int padding_mode = transport.isEncrypted() ? (transport.isTCP() ? 1 : 2) : 0;
            this.connection.getIncomingMessageQueue().setDecoder(new AZMessageDecoder());
            this.connection.getOutgoingMessageQueue().setEncoder(new AZMessageEncoder(padding_mode));
            this.sendAZHandshake();
            handshake.destroy();
            return;
        }
        if (this.messaging_mode != 3) {
            this.client = ClientIdentifier.identifyBTOnly(this.client_peer_id, this.handshake_reserved_bytes);
            this.connection.getIncomingMessageQueue().getDecoder().resumeDecoding();
            this.initPostConnection(handshake);
            return;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Enabling LT extension protocol support..."));
        }
        this.connection.getIncomingMessageQueue().setDecoder(new LTMessageDecoder());
        this.connection.getOutgoingMessageQueue().setEncoder(new LTMessageEncoder(this));
        this.generateSessionId();
        if (!this.is_metadata_download) {
            this.initPostConnection(handshake);
        }
        this.sendLTHandshake();
    }

    private int decideExtensionProtocol(BTHandshake handshake) {
        boolean use_azmp;
        boolean supports_ltep;
        boolean supports_azmp = (handshake.getReserved()[0] & 0x80) == 128;
        boolean bl = supports_ltep = (handshake.getReserved()[5] & 0x10) == 16;
        if (!supports_azmp) {
            if (supports_ltep) {
                if (!this.manager.isExtendedMessagingEnabled()) {
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(this, LOGID, "Ignoring peer's LT extension protocol support, as disabled for this download."));
                    }
                    return 1;
                }
                return 3;
            }
            return 1;
        }
        if (!supports_ltep) {
            if (!this.manager.isExtendedMessagingEnabled()) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Ignoring peer's extended AZ messaging support, as disabled for this download."));
                }
                return 1;
            }
            if (this.client.indexOf("Plus!") != -1) {
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this, LOGID, "Handshake mistakingly indicates extended AZ messaging support...ignoring."));
                }
                return 1;
            }
            return 2;
        }
        boolean enp_major_bit = (handshake.getReserved()[5] & 2) == 2;
        boolean enp_minor_bit = (handshake.getReserved()[5] & 1) == 1;
        String their_ext_preference = (enp_major_bit == enp_minor_bit ? "Force " : "Prefer ") + (enp_major_bit ? "AZMP" : "LTEP");
        String our_ext_preference = "Force AZMP";
        boolean we_decide = use_azmp = enp_major_bit || enp_minor_bit;
        if (Logger.isEnabled()) {
            String msg = "Peer supports both AZMP and LTEP: ";
            msg = msg + "\"" + our_ext_preference + "\"" + (we_decide ? ">" : "<") + (our_ext_preference.equals(their_ext_preference) ? "= " : " ");
            msg = msg + "\"" + their_ext_preference + "\" - using " + (use_azmp ? "AZMP" : "LTEP");
            Logger.log(new LogEvent(this, LOGID, msg));
        }
        return use_azmp ? 2 : 3;
    }

    protected void decodeLTHandshake(LTHandshake handshake) {
        String lt_handshake_name = handshake.getClientName();
        if (lt_handshake_name != null) {
            this.client_handshake = StringInterner.intern(lt_handshake_name);
            this.client = StringInterner.intern(ClientIdentifier.identifyLTEP(this.client_peer_id, this.client_handshake, this.peer_id));
        }
        if (handshake.getTCPListeningPort() > 0) {
            Boolean crypto_requested = handshake.isCryptoRequested();
            byte handshake_type = crypto_requested != null && crypto_requested != false ? (byte)1 : 0;
            this.tcp_listen_port = handshake.getTCPListeningPort();
            this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(this.peer_source), handshake_type, this.udp_listen_port, this.crypto_level, 0);
        }
        if (handshake.isUploadOnly()) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 1);
            this.checkSeed();
        }
        if (AddressUtils.isGlobalAddressV6(handshake.getIPv6())) {
            this.alternativeAddress = handshake.getIPv6();
        }
        LTMessageEncoder encoder = (LTMessageEncoder)this.connection.getOutgoingMessageQueue().getEncoder();
        encoder.updateSupportedExtensions(handshake.getExtensionMapping());
        this.ut_pex_enabled = encoder.supportsUTPEX();
        if (this.is_metadata_download) {
            int mds;
            if (encoder.supportsUTMetaData() && (mds = handshake.getMetadataSize()) > 0) {
                this.spoofMDAvailability(mds);
            }
            if (this.current_peer_state != 30) {
                this.initPostConnection(null);
            }
        }
        this.doPostHandshakeProcessing();
        handshake.destroy();
    }

    protected void decodeAZHandshake(AZHandshake handshake) {
        int mds;
        if (this.getConnectionState() == 4) {
            handshake.destroy();
            this.closeConnectionInternally("peer sent another az-handshake after the intial connect");
        }
        this.client_handshake = StringInterner.intern(handshake.getClient());
        this.client_handshake_version = StringInterner.intern(handshake.getClientVersion());
        this.client = StringInterner.intern(ClientIdentifier.identifyAZMP(this.client_peer_id, this.client_handshake, this.client_handshake_version, this.peer_id));
        if (handshake.getTCPListenPort() > 0) {
            this.tcp_listen_port = handshake.getTCPListenPort();
            this.udp_listen_port = handshake.getUDPListenPort();
            this.udp_non_data_port = handshake.getUDPNonDataListenPort();
            byte type = handshake.getHandshakeType() == 1 ? (byte)1 : 0;
            this.peer_item_identity = PeerItemFactory.createPeerItem(this.ip, this.tcp_listen_port, PeerItem.convertSourceID(this.peer_source), type, this.udp_listen_port, this.crypto_level, 0);
        }
        if (AddressUtils.isGlobalAddressV6(handshake.getIPv6())) {
            this.alternativeAddress = handshake.getIPv6();
        }
        if (handshake.getReconnectSessionID() != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 0, "received reconnect request ID: " + handshake.getReconnectSessionID().toBase32String()));
            }
            this.checkForReconnect(handshake.getReconnectSessionID());
        }
        if (handshake.getRemoteSessionID() != null) {
            this.peerSessionID = handshake.getRemoteSessionID();
        }
        if (handshake.isUploadOnly()) {
            this.relativeSeeding = (byte)(this.relativeSeeding | 1);
            this.checkSeed();
        }
        String[] supported_message_ids = handshake.getMessageIDs();
        byte[] supported_message_versions = handshake.getMessageVersions();
        ArrayList<Message> messages = new ArrayList<Message>();
        for (int i = 0; i < handshake.getMessageIDs().length; ++i) {
            Message msg = MessageManager.getSingleton().lookupMessage(supported_message_ids[i]);
            if (msg == null) continue;
            messages.add(msg);
            String id = msg.getID();
            byte supported_version = supported_message_versions[i];
            if (id == "BT_BITFIELD") {
                this.other_peer_bitfield_version = supported_version;
                continue;
            }
            if (id == "BT_CANCEL") {
                this.other_peer_cancel_version = supported_version;
                continue;
            }
            if (id == "BT_CHOKE") {
                this.other_peer_choke_version = supported_version;
                continue;
            }
            if (id == "BT_HANDSHAKE") {
                this.other_peer_handshake_version = supported_version;
                continue;
            }
            if (id == "BT_HAVE") {
                this.other_peer_bt_have_version = supported_version;
                continue;
            }
            if (id == "BT_INTERESTED") {
                this.other_peer_interested_version = supported_version;
                continue;
            }
            if (id == "BT_KEEP_ALIVE") {
                this.other_peer_keep_alive_version = supported_version;
                continue;
            }
            if (id == "BT_PIECE") {
                this.other_peer_piece_version = supported_version;
                continue;
            }
            if (id == "BT_UNCHOKE") {
                this.other_peer_unchoke_version = supported_version;
                continue;
            }
            if (id == "BT_UNINTERESTED") {
                this.other_peer_uninterested_version = supported_version;
                continue;
            }
            if (id == "BT_REQUEST") {
                this.other_peer_request_version = supported_version;
                continue;
            }
            if (id == "BT_SUGGEST_PIECE") {
                this.other_peer_suggest_piece_version = supported_version;
                continue;
            }
            if (id == "BT_HAVE_ALL") {
                this.other_peer_have_all_version = supported_version;
                continue;
            }
            if (id == "BT_HAVE_NONE") {
                this.other_peer_have_none_version = supported_version;
                continue;
            }
            if (id == "BT_REJECT_REQUEST") {
                this.other_peer_reject_request_version = supported_version;
                continue;
            }
            if (id == "BT_ALLOWED_FAST") {
                this.other_peer_allowed_fast_version = supported_version;
                continue;
            }
            if (id == "AZ_PEER_EXCHANGE") {
                this.other_peer_pex_version = supported_version;
                continue;
            }
            if (id == "AZ_REQUEST_HINT") {
                this.other_peer_az_request_hint_version = supported_version;
                continue;
            }
            if (id == "AZ_HAVE") {
                this.other_peer_az_have_version = supported_version;
                continue;
            }
            if (id == "AZ_BAD_PIECE") {
                this.other_peer_az_bad_piece_version = supported_version;
                continue;
            }
            if (id == "AZ_STAT_REQ") {
                this.other_peer_az_stats_request_version = supported_version;
                continue;
            }
            if (id == "AZ_STAT_REP") {
                this.other_peer_az_stats_reply_version = supported_version;
                continue;
            }
            if (id == "AZ_METADATA") {
                this.other_peer_az_metadata_version = supported_version;
                continue;
            }
            if (id != "BT_DHT_PORT") continue;
            this.ml_dht_enabled = true;
        }
        if (this.is_metadata_download && (mds = handshake.getMetadataSize()) > 0) {
            this.manager.setTorrentInfoDictSize(mds);
        }
        this.supported_messages = messages.toArray(new Message[messages.size()]);
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.setPieceVersion(this.other_peer_piece_version);
        }
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.setHaveVersion(this.other_peer_bt_have_version, this.other_peer_az_have_version);
        }
        this.initPostConnection(handshake);
    }

    private void spoofMDAvailability(int mds) {
        int md_pieces = (mds + 16384 - 1) / 16384;
        this.manager.setTorrentInfoDictSize(mds);
        BitFlags tempHavePieces = new BitFlags(this.nbPieces);
        for (int i = 0; i < md_pieces; ++i) {
            tempHavePieces.set(i);
        }
        this.peerHavePieces = tempHavePieces;
        this.addAvailability();
        this.really_choked_by_other_peer = false;
        this.calculatePiecePriorities();
    }

    private void initPostConnection(Message handshake) {
        this.changePeerState(30);
        this.connection_state = 4;
        this.sendBitField();
        if (handshake != null) {
            handshake.destroy();
        }
        this.addAvailability();
        this.sendMainlineDHTPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeHaveAll(BTHaveAll have_all) {
        have_all.destroy();
        this.received_bitfield = true;
        if (this.is_metadata_download) {
            return;
        }
        try {
            this.closing_mon.enter();
            if (!this.closing) {
                BitFlags tempHavePieces;
                if (this.peerHavePieces == null) {
                    tempHavePieces = new BitFlags(this.nbPieces);
                } else {
                    tempHavePieces = this.peerHavePieces;
                    this.removeAvailability();
                }
                tempHavePieces.setAll();
                for (int i = 0; i < this.nbPieces; ++i) {
                    this.manager.updateSuperSeedPiece(this, i);
                }
                this.peerHavePieces = tempHavePieces;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
            }
            Object var5_4 = null;
            this.closing_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.closing_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeHaveNone(BTHaveNone have_none) {
        have_none.destroy();
        this.received_bitfield = true;
        if (this.is_metadata_download) {
            return;
        }
        try {
            this.closing_mon.enter();
            if (!this.closing) {
                BitFlags tempHavePieces;
                if (this.peerHavePieces == null) {
                    tempHavePieces = new BitFlags(this.nbPieces);
                } else {
                    tempHavePieces = this.peerHavePieces;
                    this.removeAvailability();
                }
                tempHavePieces.clear();
                this.peerHavePieces = tempHavePieces;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
                this.checkFast(tempHavePieces);
            }
            Object var4_3 = null;
            this.closing_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.closing_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeBitfield(BTBitfield bitfield) {
        this.received_bitfield = true;
        if (this.is_metadata_download) {
            bitfield.destroy();
            return;
        }
        DirectByteBuffer field = bitfield.getBitfield();
        byte[] dataf = new byte[(this.nbPieces + 7) / 8];
        if (field.remaining((byte)9) < dataf.length) {
            String error = this.toString() + " has sent invalid Bitfield: too short [" + field.remaining((byte)9) + "<" + dataf.length + "]";
            Debug.out(error);
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, error));
            }
            bitfield.destroy();
            return;
        }
        field.get((byte)9, dataf);
        try {
            this.closing_mon.enter();
            if (this.closing) {
                bitfield.destroy();
            } else {
                BitFlags tempHavePieces;
                if (this.peerHavePieces == null) {
                    tempHavePieces = new BitFlags(this.nbPieces);
                } else {
                    tempHavePieces = this.peerHavePieces;
                    this.removeAvailability();
                }
                for (int i = 0; i < this.nbPieces; ++i) {
                    int index = i / 8;
                    byte bData = dataf[index];
                    int bit = 7 - i % 8;
                    byte b = (byte)(bData >> bit);
                    if ((b & 1) != 1) continue;
                    tempHavePieces.set(i);
                    this.manager.updateSuperSeedPiece(this, i);
                }
                bitfield.destroy();
                this.peerHavePieces = tempHavePieces;
                this.addAvailability();
                this.checkSeed();
                this.checkInterested();
                this.checkFast(tempHavePieces);
            }
            Object var11_11 = null;
            this.closing_mon.exit();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            this.closing_mon.exit();
            throw throwable;
        }
    }

    @Override
    public void setSuspendedLazyBitFieldEnabled(boolean enable) {
        this.manual_lazy_bitfield_control = enable;
        if (!enable) {
            int[] pending = this.manual_lazy_haves;
            this.manual_lazy_haves = null;
            if (pending != null) {
                this.sendLazyHaves(pending, true);
            }
        }
    }

    protected void decodeMainlineDHTPort(BTDHTPort port) {
        int i_port = port.getDHTPort();
        port.destroy();
        if (!this.ml_dht_enabled) {
            return;
        }
        MainlineDHTProvider provider2 = PEPeerTransportProtocol.getDHTProvider();
        if (provider2 == null) {
            return;
        }
        if (AENetworkClassifier.categoriseAddress(this.getIp()) == "Public") {
            try {
                provider2.notifyOfIncomingPort(this.getIp(), i_port);
            }
            catch (Throwable t) {
                Debug.printStackTrace(t);
            }
        }
    }

    protected void decodeChoke(BTChoke choke) {
        choke.destroy();
        if (this.is_metadata_download) {
            return;
        }
        if (!this.really_choked_by_other_peer) {
            this.really_choked_by_other_peer = true;
            this.calculatePiecePriorities();
            this.cancelRequests();
        }
    }

    protected void decodeUnchoke(BTUnchoke unchoke) {
        unchoke.destroy();
        if (this.is_metadata_download) {
            return;
        }
        if (this.really_choked_by_other_peer) {
            this.really_choked_by_other_peer = false;
            this.calculatePiecePriorities();
        }
    }

    protected void decodeInterested(BTInterested interested) {
        interested.destroy();
        boolean bl = this.other_peer_interested_in_me = !this.isSeed() && !this.isRelativeSeed();
        if (this.other_peer_interested_in_me && !this.is_upload_disabled && fast_unchoke_new_peers && this.isChokedByMe() && this.getData("fast_unchoke_done") == null) {
            this.setData("fast_unchoke_done", "");
            this.sendUnChoke();
        }
    }

    protected void decodeUninterested(BTUninterested uninterested) {
        uninterested.destroy();
        this.other_peer_interested_in_me = false;
        if (this.outgoing_have_message_aggregator != null) {
            this.outgoing_have_message_aggregator.forceSendOfPending();
        }
    }

    protected void decodeHave(BTHave have) {
        int pieceNumber = have.getPieceNumber();
        have.destroy();
        if (this.is_metadata_download) {
            return;
        }
        if (pieceNumber >= this.nbPieces || pieceNumber < 0) {
            this.closeConnectionInternally("invalid pieceNumber: " + pieceNumber);
            return;
        }
        if (this.closing) {
            return;
        }
        if (this.peerHavePieces == null) {
            this.peerHavePieces = new BitFlags(this.nbPieces);
        }
        if (!this.peerHavePieces.flags[pieceNumber]) {
            if (!this.interested_in_other_peer && this.diskManager.isInteresting(pieceNumber) && !this.is_download_disabled) {
                this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(this.other_peer_interested_version), false);
                this.interested_in_other_peer = true;
            }
            this.peerHavePieces.set(pieceNumber);
            int pieceLength = this.manager.getPieceLength(pieceNumber);
            this.manager.havePiece(pieceNumber, pieceLength, this);
            this.checkSeed();
            if (this.other_peer_interested_in_me && (this.isSeed() || this.isRelativeSeed())) {
                this.other_peer_interested_in_me = false;
            }
            this.peer_stats.hasNewPiece(pieceLength);
        }
    }

    protected void decodeAZHave(AZHave have) {
        int[] pieceNumbers = have.getPieceNumbers();
        have.destroy();
        if (this.closing) {
            return;
        }
        if (this.peerHavePieces == null) {
            this.peerHavePieces = new BitFlags(this.nbPieces);
        }
        boolean send_interested = false;
        boolean new_have = false;
        for (int i = 0; i < pieceNumbers.length; ++i) {
            int pieceNumber = pieceNumbers[i];
            if (pieceNumber >= this.nbPieces || pieceNumber < 0) {
                this.closeConnectionInternally("invalid pieceNumber: " + pieceNumber);
                return;
            }
            if (this.peerHavePieces.flags[pieceNumber]) continue;
            new_have = true;
            if (!send_interested && !this.interested_in_other_peer && !this.is_download_disabled && this.diskManager.isInteresting(pieceNumber)) {
                send_interested = true;
            }
            this.peerHavePieces.set(pieceNumber);
            int pieceLength = this.manager.getPieceLength(pieceNumber);
            this.manager.havePiece(pieceNumber, pieceLength, this);
            this.peer_stats.hasNewPiece(pieceLength);
        }
        if (new_have) {
            this.checkSeed();
            if (this.other_peer_interested_in_me && (this.isSeed() || this.isRelativeSeed())) {
                this.other_peer_interested_in_me = false;
            }
        }
        if (send_interested) {
            this.connection.getOutgoingMessageQueue().addMessage(new BTInterested(this.other_peer_interested_version), false);
            this.interested_in_other_peer = true;
        }
    }

    protected long getBytesDownloaded() {
        if (this.peerHavePieces == null || this.peerHavePieces.flags.length == 0) {
            return 0L;
        }
        long total_done = this.peerHavePieces.flags[this.nbPieces - 1] ? (long)(this.peerHavePieces.nbSet - 1) * (long)this.diskManager.getPieceLength() + (long)this.diskManager.getPieceLength(this.nbPieces - 1) : (long)this.peerHavePieces.nbSet * (long)this.diskManager.getPieceLength();
        return Math.min(total_done, this.diskManager.getTotalLength());
    }

    @Override
    public long getBytesRemaining() {
        return this.diskManager.getTotalLength() - this.getBytesDownloaded();
    }

    @Override
    public void sendBadPiece(int piece_number) {
        if (this.bad_piece_supported) {
            AZBadPiece bp = new AZBadPiece(piece_number, this.other_peer_az_bad_piece_version);
            this.connection.getOutgoingMessageQueue().addMessage(bp, false);
        }
    }

    protected void decodeAZBadPiece(AZBadPiece bad_piece) {
        int piece_number = bad_piece.getPieceNumber();
        bad_piece.destroy();
        this.manager.badPieceReported(this, piece_number);
    }

    @Override
    public void sendStatsRequest(Map request2) {
        if (this.stats_request_supported) {
            AZStatRequest sr = new AZStatRequest(request2, this.other_peer_az_stats_request_version);
            this.connection.getOutgoingMessageQueue().addMessage(sr, false);
        }
    }

    protected void decodeAZStatsRequest(AZStatRequest request2) {
        Map req = request2.getRequest();
        request2.destroy();
        this.manager.statsRequest(this, req);
    }

    @Override
    public void sendStatsReply(Map reply) {
        if (this.stats_reply_supported) {
            AZStatReply sr = new AZStatReply(reply, this.other_peer_az_stats_reply_version);
            this.connection.getOutgoingMessageQueue().addMessage(sr, false);
        }
    }

    protected void decodeAZStatsReply(AZStatReply reply) {
        Map rep = reply.getReply();
        reply.destroy();
        this.manager.statsReply(this, rep);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeRequest(BTRequest request2) {
        boolean request_ok;
        int number = request2.getPieceNumber();
        int offset = request2.getPieceOffset();
        int length = request2.getLength();
        request2.destroy();
        if (!this.manager.validateReadRequest(this, number, offset, length)) {
            this.closeConnectionInternally("request for piece #" + number + ":" + offset + "->" + (offset + length - 1) + " is an invalid request");
            return;
        }
        if (this.manager.getHiddenPiece() == number) {
            this.closeConnectionInternally("request for piece #" + number + " is invalid as piece is hidden");
            return;
        }
        boolean bl = request_ok = !this.is_upload_disabled;
        if (request_ok) {
            if (this.choking_other_peer) {
                try {
                    this.general_mon.enter();
                    int[][] pieces = (int[][])this.getUserData(KEY_ALLOWED_FAST_SENT);
                    if (pieces != null) {
                        for (int i = 0; i < pieces.length; ++i) {
                            if (pieces[i][0] != number) continue;
                            if (pieces[i][1] >= length) {
                                int[] nArray = pieces[i];
                                nArray[1] = nArray[1] - length;
                                request_ok = true;
                                this.createPieceMessageHandler();
                                break;
                            }
                            this.manager.reportBadFastExtensionUse(this);
                        }
                    }
                    Object var9_8 = null;
                    this.general_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    this.general_mon.exit();
                    throw throwable;
                }
            } else {
                request_ok = true;
            }
        }
        if (request_ok) {
            if (this.outgoing_piece_message_handler == null || !this.outgoing_piece_message_handler.addPieceRequest(number, offset, length)) {
                this.sendRejectRequest(number, offset, length);
            }
            this.allowReconnect = true;
        } else {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "decodeRequest(): peer request for piece #" + number + ":" + offset + "->" + (offset + length - 1) + " ignored as peer is currently choked."));
            }
            this.sendRejectRequest(number, offset, length);
        }
    }

    @Override
    public void sendRejectRequest(DiskManagerReadRequest request2) {
        this.sendRejectRequest(request2.getPieceNumber(), request2.getOffset(), request2.getLength());
    }

    private void sendRejectRequest(int number, int offset, int length) {
        if (this.fast_extension_enabled && !this.closing) {
            BTRejectRequest reject = new BTRejectRequest(number, offset, length, this.other_peer_reject_request_version);
            this.connection.getOutgoingMessageQueue().addMessage(reject, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodePiece(BTPiece piece) {
        final int pieceNumber = piece.getPieceNumber();
        final int offset = piece.getPieceOffset();
        DirectByteBuffer payload = piece.getPieceData();
        final int length = payload.remaining((byte)9);
        Object error_msg = new Object(){

            public final String toString() {
                return "decodePiece(): Peer has sent piece #" + pieceNumber + ":" + offset + "->" + (offset + length - 1) + ", ";
            }
        };
        if (!this.manager.validatePieceReply(this, pieceNumber, offset, payload)) {
            this.peer_stats.bytesDiscarded(length);
            this.manager.discarded(this, length);
            ++requests_discarded;
            this.printRequestStats();
            piece.destroy();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LOGID, 3, error_msg + "but piece block discarded as invalid."));
            }
            return;
        }
        DiskManagerReadRequest request2 = this.manager.createDiskManagerRequest(pieceNumber, offset, length);
        boolean piece_error = true;
        if (this.hasBeenRequested(request2)) {
            this.removeRequest(request2);
            long now = SystemTime.getCurrentTime();
            this.resetRequestsTime(now);
            if (this.manager.isWritten(pieceNumber, offset)) {
                this.peer_stats.bytesDiscarded(length);
                this.manager.discarded(this, length);
                if (this.manager.isInEndGameMode()) {
                    if (this.last_good_data_time != -1L && now - this.last_good_data_time <= 60000L) {
                        this.setSnubbed(false);
                    }
                    this.last_good_data_time = now;
                    ++requests_discarded_endgame;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 0, error_msg + "but piece block ignored as already written in end-game mode."));
                    }
                } else {
                    if (!this.isSnubbed()) {
                        this.last_good_data_time = now;
                    }
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 1, error_msg + "but piece block discarded as already written."));
                    }
                    ++requests_discarded;
                }
                this.printRequestStats();
            } else {
                this.manager.writeBlock(pieceNumber, offset, payload, this, false);
                if (this.last_good_data_time != -1L && now - this.last_good_data_time <= 60000L) {
                    this.setSnubbed(false);
                }
                this.last_good_data_time = now;
                ++requests_completed;
                piece_error = false;
            }
        } else if (!this.manager.isWritten(pieceNumber, offset)) {
            boolean ever_requested;
            try {
                this.recent_outgoing_requests_mon.enter();
                ever_requested = this.recent_outgoing_requests.containsKey(request2);
                Object var12_11 = null;
                this.recent_outgoing_requests_mon.exit();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.recent_outgoing_requests_mon.exit();
                throw throwable;
            }
            if (ever_requested) {
                this.manager.writeBlock(pieceNumber, offset, payload, this, true);
                long now = SystemTime.getCurrentTime();
                if (this.last_good_data_time != -1L && now - this.last_good_data_time <= 60000L) {
                    this.setSnubbed(false);
                }
                this.resetRequestsTime(now);
                this.last_good_data_time = now;
                ++requests_recovered;
                this.printRequestStats();
                piece_error = false;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 0, error_msg + "expired piece block data recovered as useful."));
                }
            } else {
                System.out.println("[" + this.client + "]" + error_msg + "but expired piece block discarded as never requested.");
                this.peer_stats.bytesDiscarded(length);
                this.manager.discarded(this, length);
                ++requests_discarded;
                this.printRequestStats();
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 3, error_msg + "but expired piece block discarded as never requested."));
                }
            }
        } else {
            this.peer_stats.bytesDiscarded(length);
            this.manager.discarded(this, length);
            ++requests_discarded;
            this.printRequestStats();
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)this, LogIDs.PIECES, 1, error_msg + "but expired piece block discarded as already written."));
            }
        }
        if (piece_error) {
            piece.destroy();
        } else {
            this.allowReconnect = true;
        }
    }

    protected void decodeCancel(BTCancel cancel) {
        int number = cancel.getPieceNumber();
        int offset = cancel.getPieceOffset();
        int length = cancel.getLength();
        cancel.destroy();
        if (this.outgoing_piece_message_handler != null) {
            this.outgoing_piece_message_handler.removePieceRequest(number, offset, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeRejectRequest(BTRejectRequest reject) {
        int number = reject.getPieceNumber();
        int offset = reject.getPieceOffset();
        int length = reject.getLength();
        reject.destroy();
        DiskManagerReadRequest request2 = this.manager.createDiskManagerRequest(number, offset, length);
        if (this.hasBeenRequested(request2)) {
            this.removeRequest(request2);
            this.manager.requestCanceled(request2);
            try {
                int[] priorities;
                this.general_mon.enter();
                List pieces = (List)this.getUserData(KEY_ALLOWED_FAST_RECEIVED);
                if (pieces != null) {
                    pieces.remove(new Integer(number));
                    if (pieces.size() == 0) {
                        this.setUserData(KEY_ALLOWED_FAST_RECEIVED, null);
                    }
                }
                if ((priorities = this.piece_priority_offsets) != null) {
                    priorities[number] = Integer.MIN_VALUE;
                }
                this.calculatePiecePriorities();
                Object var9_8 = null;
                this.general_mon.exit();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.general_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeAllowedFast(BTAllowedFast allowed) {
        int piece = allowed.getPieceNumber();
        allowed.destroy();
        if (this.piecePicker.getNbPiecesDone() > 10) {
            return;
        }
        try {
            Integer i;
            this.general_mon.enter();
            ArrayList<Integer> pieces = (ArrayList<Integer>)this.getUserData(KEY_ALLOWED_FAST_RECEIVED);
            if (pieces == null) {
                pieces = new ArrayList<Integer>(10);
                this.setUserData(KEY_ALLOWED_FAST_RECEIVED, pieces);
            }
            if (pieces.size() < 20 && !pieces.contains(i = new Integer(piece)) && i >= 0 && i < this.nbPieces) {
                pieces.add(i);
                this.calculatePiecePriorities();
            }
            Object var6_5 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    private void sendAllowFast(int number) {
        if (this.fast_extension_enabled) {
            BTAllowedFast af = new BTAllowedFast(number, this.other_peer_allowed_fast_version);
            this.connection.getOutgoingMessageQueue().addMessage(af, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculatePiecePriorities() {
        try {
            this.general_mon.enter();
            if (this.really_choked_by_other_peer) {
                List pieces = (List)this.getUserData(KEY_ALLOWED_FAST_RECEIVED);
                if (pieces == null) {
                    this.effectively_choked_by_other_peer = true;
                    this.piece_priority_offsets = null;
                } else {
                    int[] priorities = this.piece_priority_offsets;
                    if (priorities == null) {
                        priorities = new int[this.nbPieces];
                        Arrays.fill(priorities, Integer.MIN_VALUE);
                    }
                    Iterator i$ = pieces.iterator();
                    while (i$.hasNext()) {
                        int i = (Integer)i$.next();
                        priorities[i] = 0;
                    }
                    this.piece_priority_offsets = priorities;
                    if (this.effectively_choked_by_other_peer) {
                        this.effectively_choked_by_other_peer = false;
                        this.effectively_unchoked_time = SystemTime.getMonotonousTime();
                    }
                }
            } else {
                if (this.effectively_choked_by_other_peer) {
                    this.effectively_choked_by_other_peer = false;
                    this.effectively_unchoked_time = SystemTime.getMonotonousTime();
                }
                this.piece_priority_offsets = null;
            }
            Object var6_5 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFast(BitFlags flags) {
        if (this.fast_extension_enabled && !this.is_upload_disabled && !this.isSeed() && !this.isRelativeSeed() && PeerClassifier.fullySupportsFE(this.client_peer_id)) {
            int[][] pieces;
            if (flags.nbSet >= 10) {
                return;
            }
            if (!this.manager.isFastExtensionPermitted(this)) {
                return;
            }
            try {
                this.general_mon.enter();
                pieces = (int[][])this.getUserData(KEY_ALLOWED_FAST_SENT);
                if (pieces == null) {
                    List<Integer> l_pieces = this.generateFastSet(10);
                    pieces = new int[l_pieces.size()][2];
                    int piece_size = this.diskManager.getPieceLength();
                    for (int i = 0; i < l_pieces.size(); ++i) {
                        int piece_number = l_pieces.get(i);
                        pieces[i] = new int[]{piece_number, piece_size * 2};
                    }
                    this.setUserData(KEY_ALLOWED_FAST_SENT, pieces);
                }
                Object var8_8 = null;
                this.general_mon.exit();
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.general_mon.exit();
                throw throwable;
            }
            for (int i = 0; i < pieces.length; ++i) {
                int piece_number = pieces[i][0];
                if (flags.flags[piece_number]) continue;
                this.sendAllowFast(piece_number);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllowedFast() {
        try {
            int[][] pieces;
            BitFlags flags;
            List pieces2;
            this.general_mon.enter();
            if (this.piecePicker.getNbPiecesDone() > 10 && (pieces2 = (List)this.getUserData(KEY_ALLOWED_FAST_RECEIVED)) != null) {
                this.setUserData(KEY_ALLOWED_FAST_RECEIVED, null);
                this.calculatePiecePriorities();
            }
            if ((flags = this.peerHavePieces) != null && flags.nbSet >= 10 && (pieces = (int[][])this.getUserData(KEY_ALLOWED_FAST_SENT)) != null) {
                this.setUserData(KEY_ALLOWED_FAST_SENT, null);
            }
            Object var4_3 = null;
            this.general_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.general_mon.exit();
            throw throwable;
        }
    }

    private void registerForMessageHandling() {
        this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

            public final boolean messageReceived(Message message) {
                String message_id;
                long now;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LogIDs.NET, "Received [" + message.getDescription() + "] message"));
                }
                PEPeerTransportProtocol.this.last_message_received_time = now = SystemTime.getCurrentTime();
                if (message.getType() == 1) {
                    PEPeerTransportProtocol.this.last_data_message_received_time = now;
                }
                if ((message_id = message.getID()).equals("BT_PIECE")) {
                    PEPeerTransportProtocol.this.decodePiece((BTPiece)message);
                    return true;
                }
                if (PEPeerTransportProtocol.this.closing) {
                    message.destroy();
                    return true;
                }
                if (message_id.equals("BT_KEEP_ALIVE")) {
                    message.destroy();
                    if (!PEPeerTransportProtocol.this.message_limiter.countIncomingMessage(message.getID(), 6, 60000)) {
                        System.out.println(PEPeerTransportProtocol.this.manager.getDisplayName() + ": Incoming keep-alive message flood detected, dropping spamming peer connection." + PEPeerTransportProtocol.this);
                        PEPeerTransportProtocol.this.closeConnectionInternally("Incoming keep-alive message flood detected, dropping spamming peer connection.");
                    }
                    return true;
                }
                if (message_id.equals("BT_HANDSHAKE")) {
                    PEPeerTransportProtocol.this.decodeBTHandshake((BTHandshake)message);
                    return true;
                }
                if (message_id.equals("AZ_HANDSHAKE")) {
                    PEPeerTransportProtocol.this.decodeAZHandshake((AZHandshake)message);
                    return true;
                }
                if (message_id.equals("lt_handshake")) {
                    PEPeerTransportProtocol.this.decodeLTHandshake((LTHandshake)message);
                    return true;
                }
                if (message_id.equals("BT_BITFIELD")) {
                    PEPeerTransportProtocol.this.decodeBitfield((BTBitfield)message);
                    return true;
                }
                if (message_id.equals("BT_CHOKE")) {
                    PEPeerTransportProtocol.this.decodeChoke((BTChoke)message);
                    if (PEPeerTransportProtocol.this.choking_other_peer) {
                        PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(false, PEPeerTransportProtocol.this.manager.getPartitionID());
                    }
                    return true;
                }
                if (message_id.equals("BT_UNCHOKE")) {
                    PEPeerTransportProtocol.this.decodeUnchoke((BTUnchoke)message);
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(true, PEPeerTransportProtocol.this.manager.getPartitionID());
                    return true;
                }
                if (message_id.equals("BT_INTERESTED")) {
                    PEPeerTransportProtocol.this.decodeInterested((BTInterested)message);
                    return true;
                }
                if (message_id.equals("BT_UNINTERESTED")) {
                    PEPeerTransportProtocol.this.decodeUninterested((BTUninterested)message);
                    return true;
                }
                if (message_id.equals("BT_HAVE")) {
                    PEPeerTransportProtocol.this.decodeHave((BTHave)message);
                    return true;
                }
                if (message_id.equals("BT_REQUEST")) {
                    PEPeerTransportProtocol.this.decodeRequest((BTRequest)message);
                    return true;
                }
                if (message_id.equals("BT_CANCEL")) {
                    PEPeerTransportProtocol.this.decodeCancel((BTCancel)message);
                    return true;
                }
                if (message_id.equals("BT_SUGGEST_PIECE")) {
                    PEPeerTransportProtocol.this.decodeSuggestPiece((BTSuggestPiece)message);
                    return true;
                }
                if (message_id.equals("BT_HAVE_ALL")) {
                    PEPeerTransportProtocol.this.decodeHaveAll((BTHaveAll)message);
                    return true;
                }
                if (message_id.equals("BT_HAVE_NONE")) {
                    PEPeerTransportProtocol.this.decodeHaveNone((BTHaveNone)message);
                    return true;
                }
                if (message_id.equals("BT_REJECT_REQUEST")) {
                    PEPeerTransportProtocol.this.decodeRejectRequest((BTRejectRequest)message);
                    return true;
                }
                if (message_id.equals("BT_ALLOWED_FAST")) {
                    PEPeerTransportProtocol.this.decodeAllowedFast((BTAllowedFast)message);
                    return true;
                }
                if (message_id.equals("BT_DHT_PORT")) {
                    PEPeerTransportProtocol.this.decodeMainlineDHTPort((BTDHTPort)message);
                    return true;
                }
                if (message_id.equals("AZ_PEER_EXCHANGE")) {
                    PEPeerTransportProtocol.this.decodePeerExchange((AZPeerExchange)message);
                    return true;
                }
                if (message_id.equals("ut_pex")) {
                    PEPeerTransportProtocol.this.decodePeerExchange((UTPeerExchange)message);
                    return true;
                }
                if (message instanceof AZStylePeerExchange) {
                    PEPeerTransportProtocol.this.decodePeerExchange((AZStylePeerExchange)message);
                    return true;
                }
                if (message_id.equals("AZ_REQUEST_HINT")) {
                    PEPeerTransportProtocol.this.decodeAZRequestHint((AZRequestHint)message);
                    return true;
                }
                if (message_id.equals("AZ_HAVE")) {
                    PEPeerTransportProtocol.this.decodeAZHave((AZHave)message);
                    return true;
                }
                if (message_id.equals("AZ_BAD_PIECE")) {
                    PEPeerTransportProtocol.this.decodeAZBadPiece((AZBadPiece)message);
                    return true;
                }
                if (message_id.equals("AZ_STAT_REQ")) {
                    PEPeerTransportProtocol.this.decodeAZStatsRequest((AZStatRequest)message);
                    return true;
                }
                if (message_id.equals("AZ_STAT_REP")) {
                    PEPeerTransportProtocol.this.decodeAZStatsReply((AZStatReply)message);
                    return true;
                }
                if (message_id.equals("ut_metadata")) {
                    PEPeerTransportProtocol.this.decodeMetaData((UTMetaData)message);
                    return true;
                }
                if (message_id.equals("AZ_METADATA")) {
                    PEPeerTransportProtocol.this.decodeMetaData((AZMetaData)message);
                    return true;
                }
                if (message_id.equals("upload_only")) {
                    PEPeerTransportProtocol.this.decodeUploadOnly((UTUploadOnly)message);
                    return true;
                }
                return false;
            }

            public final void protocolBytesReceived(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.protocolBytesReceived(byte_count);
                PEPeerTransportProtocol.this.manager.protocolBytesReceived(PEPeerTransportProtocol.this, byte_count);
            }

            public final void dataBytesReceived(int byte_count) {
                PEPeerTransportProtocol.this.last_data_message_received_time = SystemTime.getCurrentTime();
                PEPeerTransportProtocol.this.peer_stats.dataBytesReceived(byte_count);
                PEPeerTransportProtocol.this.manager.dataBytesReceived(PEPeerTransportProtocol.this, byte_count);
            }

            public boolean isPriority() {
                return false;
            }
        });
        this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

            public final boolean messageAdded(Message message) {
                return true;
            }

            public final void messageQueued(Message message) {
            }

            public final void messageRemoved(Message message) {
            }

            public final void messageSent(Message message) {
                long now;
                PEPeerTransportProtocol.this.last_message_sent_time = now = SystemTime.getCurrentTime();
                if (message.getType() == 1) {
                    PEPeerTransportProtocol.this.last_data_message_sent_time = now;
                }
                if (message.getID().equals("BT_UNCHOKE")) {
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(true, PEPeerTransportProtocol.this.manager.getPartitionID());
                } else if (message.getID().equals("BT_CHOKE") && PEPeerTransportProtocol.this.effectively_choked_by_other_peer) {
                    PEPeerTransportProtocol.this.connection.enableEnhancedMessageProcessing(false, PEPeerTransportProtocol.this.manager.getPartitionID());
                }
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(PEPeerTransportProtocol.this, LogIDs.NET, "Sent [" + message.getDescription() + "] message"));
                }
            }

            public final void protocolBytesSent(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.protocolBytesSent(byte_count);
                PEPeerTransportProtocol.this.manager.protocolBytesSent(PEPeerTransportProtocol.this, byte_count);
            }

            public final void dataBytesSent(int byte_count) {
                PEPeerTransportProtocol.this.peer_stats.dataBytesSent(byte_count);
                PEPeerTransportProtocol.this.manager.dataBytesSent(PEPeerTransportProtocol.this, byte_count);
            }

            public void flush() {
            }
        });
        this.connection.addRateLimiter(this.manager.getUploadLimitedRateGroup(), true);
        this.connection.addRateLimiter(this.manager.getDownloadLimitedRateGroup(), false);
        this.connection.startMessageProcessing();
    }

    @Override
    public void addRateLimiter(LimitedRateGroup limiter, boolean upload) {
        this.connection.addRateLimiter(limiter, upload);
    }

    @Override
    public LimitedRateGroup[] getRateLimiters(boolean upload) {
        return this.connection.getRateLimiters(upload);
    }

    @Override
    public void removeRateLimiter(LimitedRateGroup limiter, boolean upload) {
        this.connection.removeRateLimiter(limiter, upload);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUploadDisabled(Object key, boolean disabled) {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            if (this.upload_disabled_set == null) {
                if (disabled) {
                    this.upload_disabled_set = new HashSet<Object>();
                    this.upload_disabled_set.add(key);
                } else {
                    Debug.out("derp");
                }
            } else if (disabled) {
                if (!this.upload_disabled_set.add(key)) {
                    Debug.out("derp");
                }
            } else {
                if (!this.upload_disabled_set.remove(key)) {
                    Debug.out("derp");
                }
                if (this.upload_disabled_set.size() == 0) {
                    this.upload_disabled_set = null;
                }
            }
            this.is_upload_disabled = this.upload_disabled_set != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDownloadDisabled(Object key, boolean disabled) {
        boolean check = false;
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            if (this.download_disabled_set == null) {
                if (disabled) {
                    this.download_disabled_set = new HashSet<Object>();
                    this.download_disabled_set.add(key);
                } else {
                    Debug.out("derp");
                }
            } else if (disabled) {
                if (!this.download_disabled_set.add(key)) {
                    Debug.out("derp");
                }
            } else {
                if (!this.download_disabled_set.remove(key)) {
                    Debug.out("derp");
                }
                if (this.download_disabled_set.size() == 0) {
                    this.download_disabled_set = null;
                }
            }
            boolean old = this.is_download_disabled;
            this.is_download_disabled = this.download_disabled_set != null;
            check = old != this.is_download_disabled;
        }
        if (check) {
            this.checkInterested();
        }
    }

    @Override
    public boolean isUploadDisabled() {
        return this.is_upload_disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUploadDisabled(Object key) {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            if (this.upload_disabled_set == null) {
                return false;
            }
            return this.upload_disabled_set.contains(key);
        }
    }

    @Override
    public boolean isDownloadDisabled() {
        return this.is_download_disabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadDisabled(Object key) {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            if (this.download_disabled_set == null) {
                return false;
            }
            return this.download_disabled_set.contains(key);
        }
    }

    @Override
    public Connection getPluginConnection() {
        return this.plugin_connection;
    }

    @Override
    public Message[] getSupportedMessages() {
        return this.supported_messages;
    }

    @Override
    public boolean supportsMessaging() {
        return this.supported_messages != null;
    }

    @Override
    public int getMessagingMode() {
        return this.messaging_mode;
    }

    @Override
    public byte[] getHandshakeReservedBytes() {
        return this.handshake_reserved_bytes;
    }

    @Override
    public void setHaveAggregationEnabled(boolean enabled) {
        this.have_aggregation_disabled = !enabled;
    }

    @Override
    public boolean hasReceivedBitField() {
        return this.received_bitfield;
    }

    @Override
    public long getUnchokedForMillis() {
        long time = this.effectively_unchoked_time;
        if (this.effectively_choked_by_other_peer || time < 0L) {
            return -1L;
        }
        return SystemTime.getMonotonousTime() - time;
    }

    @Override
    public String getEncryption() {
        Transport transport = this.connection.getTransport();
        if (transport == null) {
            return "";
        }
        return transport.getEncryption(false);
    }

    @Override
    public String getProtocol() {
        Transport transport = this.connection.getTransport();
        if (transport == null) {
            return "";
        }
        return transport.getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(PEPeerListener listener) {
        try {
            this.peer_listeners_mon.enter();
            if (this.peer_listeners_cow == null) {
                this.peer_listeners_cow = new ArrayList();
            }
            ArrayList<PEPeerListener> new_listeners = new ArrayList<PEPeerListener>(this.peer_listeners_cow);
            new_listeners.add(listener);
            this.peer_listeners_cow = new_listeners;
            Object var4_3 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(PEPeerListener listener) {
        try {
            this.peer_listeners_mon.enter();
            if (this.peer_listeners_cow != null) {
                ArrayList new_listeners = new ArrayList(this.peer_listeners_cow);
                new_listeners.remove(listener);
                if (new_listeners.isEmpty()) {
                    new_listeners = null;
                }
                this.peer_listeners_cow = new_listeners;
            }
            Object var4_3 = null;
            this.peer_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.peer_listeners_mon.exit();
            throw throwable;
        }
    }

    private void changePeerState(int new_state) {
        List peer_listeners_ref;
        this.current_peer_state = new_state;
        if (this.current_peer_state == 30) {
            this.doPostHandshakeProcessing();
        }
        if ((peer_listeners_ref = this.peer_listeners_cow) != null) {
            for (int i = 0; i < peer_listeners_ref.size(); ++i) {
                PEPeerListener l = (PEPeerListener)peer_listeners_ref.get(i);
                l.stateChanged(this, this.current_peer_state);
            }
        }
    }

    private void doPostHandshakeProcessing() {
        int mds;
        if (this.manager.isPeerExchangeEnabled()) {
            PeerExchangerItem pex_item = this.peer_exchange_item;
            if (pex_item == null && this.canBePeerExchanged()) {
                pex_item = this.peer_exchange_item = this.manager.createPeerExchangeConnection(this);
            }
            if (pex_item != null) {
                if (this.ut_pex_enabled || this.peerSupportsMessageType("AZ_PEER_EXCHANGE")) {
                    this.peer_exchange_supported = true;
                    pex_item.enableStateMaintenance();
                } else {
                    MessageStreamEncoder encoder = this.connection.getOutgoingMessageQueue().getEncoder();
                    if (encoder instanceof LTMessageEncoder && ((LTMessageEncoder)encoder).hasCustomExtensionHandler(1)) {
                        this.peer_exchange_supported = true;
                        pex_item.enableStateMaintenance();
                    } else {
                        pex_item.disableStateMaintenance();
                    }
                }
            }
        }
        this.request_hint_supported = this.peerSupportsMessageType("AZ_REQUEST_HINT");
        this.bad_piece_supported = this.peerSupportsMessageType("AZ_BAD_PIECE");
        this.stats_request_supported = this.peerSupportsMessageType("AZ_STAT_REQ");
        this.stats_reply_supported = this.peerSupportsMessageType("AZ_STAT_REP");
        this.az_metadata_supported = this.peerSupportsMessageType("AZ_METADATA");
        if (this.is_metadata_download && this.az_metadata_supported && (mds = this.manager.getTorrentInfoDictSize()) > 0) {
            this.spoofMDAvailability(mds);
        }
    }

    private boolean canBePeerExchanged() {
        if (this.client_peer_id != null) {
            boolean ok = !this.client_peer_id.startsWith("CacheLogic");
            return ok;
        }
        Debug.out("No client peer id!");
        return false;
    }

    private boolean peerSupportsMessageType(String message_id) {
        if (this.supported_messages != null) {
            for (int i = 0; i < this.supported_messages.length; ++i) {
                if (!this.supported_messages[i].getID().equals(message_id)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void updatePeerExchange() {
        if (this.current_peer_state != 30) {
            return;
        }
        if (!this.peer_exchange_supported) {
            return;
        }
        PeerExchangerItem pex_item = this.peer_exchange_item;
        if (pex_item != null && this.manager.isPeerExchangeEnabled()) {
            if (this.peer_item_identity.getNetwork() == "Public") {
                PeerItem[] adds = pex_item.getNewlyAddedPeerConnections("Public");
                PeerItem[] drops = pex_item.getNewlyDroppedPeerConnections("Public");
                if (adds != null && adds.length > 0 || drops != null && drops.length > 0) {
                    if (this.ut_pex_enabled) {
                        this.connection.getOutgoingMessageQueue().addMessage(new UTPeerExchange(adds, drops, null, 0), false);
                    } else {
                        this.connection.getOutgoingMessageQueue().addMessage(new AZPeerExchange(this.manager.getHash(), adds, drops, this.other_peer_pex_version), false);
                    }
                }
            } else {
                MessageStreamEncoder encoder = this.connection.getOutgoingMessageQueue().getEncoder();
                if (encoder instanceof LTMessageEncoder) {
                    ((LTMessageEncoder)encoder).handleCustomExtension(1, new Object[]{pex_item});
                }
            }
        }
    }

    protected void decodePeerExchange(AZStylePeerExchange exchange) {
        PeerItem[] added = exchange instanceof UTPeerExchange ? ((UTPeerExchange)exchange).getAddedPeers(!this.manager.isSeeding() && !Constants.DOWNLOAD_SOURCES_PRETEND_COMPLETE) : exchange.getAddedPeers();
        PeerItem[] dropped = exchange.getDroppedPeers();
        int max_added = exchange.getMaxAllowedPeersPerVolley(!this.has_received_initial_pex, true);
        int max_dropped = exchange.getMaxAllowedPeersPerVolley(!this.has_received_initial_pex, false);
        exchange.destroy();
        if (!this.message_limiter.countIncomingMessage(exchange.getID(), 7, 120000)) {
            System.out.println(this.manager.getDisplayName() + ": Incoming PEX message flood detected, dropping spamming peer connection." + this);
            this.closeConnectionInternally("Incoming PEX message flood detected, dropping spamming peer connection.");
            return;
        }
        if (added != null && added.length > max_added || dropped != null && dropped.length > max_dropped) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this, LOGID, "Invalid PEX message received: too large, ignoring this exchange. (added=" + (added == null ? 0 : added.length) + ",dropped=" + (dropped == null ? 0 : dropped.length) + ")"));
            }
            added = null;
            dropped = null;
        }
        this.has_received_initial_pex = true;
        PeerExchangerItem pex_item = this.peer_exchange_item;
        if (this.peer_exchange_supported && pex_item != null && this.manager.isPeerExchangeEnabled()) {
            int i;
            if (added != null) {
                for (i = 0; i < added.length; ++i) {
                    PeerItem pi = added[i];
                    this.manager.peerDiscovered(this, pi);
                    pex_item.addConnectedPeer(pi);
                }
            }
            if (dropped != null) {
                for (i = 0; i < dropped.length; ++i) {
                    pex_item.dropConnectedPeer(dropped[i]);
                }
            }
        } else if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this, LOGID, "Peer Exchange disabled for this download, dropping received exchange message"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeMetaData(AZUTMetaData metadata) {
        try {
            int BLOCK_SIZE = 16384;
            int type = metadata.getMessageType();
            if (type == 0) {
                if (!this.manager.isPrivateTorrent()) {
                    UTMetaData reply;
                    int piece = metadata.getPiece();
                    int total_size = this.manager.getTorrentInfoDictSize();
                    byte[] data = total_size <= 0 ? null : this.manager.getAdapter().getTorrentInfoDict(this);
                    int offset = piece * 16384;
                    if (this.is_metadata_download || data == null || offset >= data.length) {
                        reply = new UTMetaData(piece, null, 0, this.other_peer_bt_lt_ext_version);
                    } else {
                        int to_send = Math.min(data.length - offset, 16384);
                        reply = new UTMetaData(piece, ByteBuffer.wrap(data, offset, to_send), total_size, this.other_peer_bt_lt_ext_version);
                    }
                    this.connection.getOutgoingMessageQueue().addMessage(reply, false);
                }
            } else if (type == 1) {
                int piece_number = metadata.getPiece();
                DirectByteBuffer data = metadata.getMetadata();
                int data_size = data.remaining((byte)9);
                int total_size = this.manager.getTorrentInfoDictSize();
                int piece_count = (total_size + 16384 - 1) / 16384;
                int last_piece_size = total_size % 16384;
                if (last_piece_size == 0) {
                    last_piece_size = 16384;
                }
                boolean good = false;
                if (piece_number < piece_count) {
                    DiskManagerReadRequest request2;
                    int expected_size;
                    int n = expected_size = piece_number == piece_count - 1 ? last_piece_size : 16384;
                    if (data_size == expected_size && this.hasBeenRequested(request2 = this.manager.createDiskManagerRequest(piece_number, 0, 16384))) {
                        good = true;
                        metadata.setMetadata(null);
                        this.removeRequest(request2);
                        long now = SystemTime.getCurrentTime();
                        this.resetRequestsTime(now);
                        this.manager.writeBlock(piece_number, 0, data, this, false);
                        if (this.last_good_data_time != -1L && now - this.last_good_data_time <= 60000L) {
                            this.setSnubbed(false);
                        }
                        this.last_good_data_time = now;
                        ++requests_completed;
                    }
                }
                if (!good) {
                    this.peer_stats.bytesDiscarded(data_size);
                    this.manager.discarded(this, data_size);
                    ++requests_discarded;
                    this.printRequestStats();
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent((Object)this, LOGID, 3, "metadata piece discarded as invalid."));
                    }
                }
            } else {
                int piece = metadata.getPiece();
                DiskManagerReadRequest request3 = this.manager.createDiskManagerRequest(piece, 0, 16384);
                if (this.hasBeenRequested(request3)) {
                    this.removeRequest(request3);
                    this.manager.requestCanceled(request3);
                }
            }
            Object var16_22 = null;
            metadata.destroy();
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            metadata.destroy();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decodeUploadOnly(UTUploadOnly message) {
        try {
            boolean ulo = message.isUploadOnly();
            this.relativeSeeding = ulo ? (byte)(this.relativeSeeding | 1) : (byte)(this.relativeSeeding & 0xFFFFFFFE);
            Object var4_3 = null;
            message.destroy();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            message.destroy();
            throw throwable;
        }
    }

    @Override
    public boolean sendRequestHint(int piece_number, int offset, int length, int life) {
        if (this.request_hint_supported) {
            AZRequestHint rh = new AZRequestHint(piece_number, offset, length, life, this.other_peer_az_request_hint_version);
            this.connection.getOutgoingMessageQueue().addMessage(rh, false);
            return true;
        }
        return false;
    }

    protected void decodeSuggestPiece(BTSuggestPiece hint) {
        int piece_number = hint.getPieceNumber();
        int offset = 0;
        int length = this.manager.getPieceLength(piece_number);
        hint.destroy();
        if (this.manager.validateHintRequest(this, piece_number, offset, length) && this.request_hint == null) {
            this.request_hint = new int[]{piece_number, offset, length};
        }
    }

    protected void decodeAZRequestHint(AZRequestHint hint) {
        int piece_number = hint.getPieceNumber();
        int offset = hint.getOffset();
        int length = hint.getLength();
        int life = hint.getLife();
        hint.destroy();
        if (life > 150000) {
            life = 150000;
        }
        if (this.manager.validateHintRequest(this, piece_number, offset, length) && this.request_hint == null) {
            this.request_hint = new int[]{piece_number, offset, length};
        }
    }

    @Override
    public int[] getRequestHint() {
        return this.request_hint;
    }

    @Override
    public void clearRequestHint() {
        this.request_hint = null;
    }

    @Override
    public PeerItem getPeerItemIdentity() {
        return this.peer_item_identity;
    }

    @Override
    public int[] getReservedPieceNumbers() {
        return this.reserved_pieces;
    }

    @Override
    public void addReservedPieceNumber(int piece_number) {
        int[] existing = this.reserved_pieces;
        if (existing == null) {
            this.reserved_pieces = new int[]{piece_number};
        } else {
            int[] updated = new int[existing.length + 1];
            System.arraycopy(existing, 0, updated, 0, existing.length);
            updated[existing.length] = piece_number;
            this.reserved_pieces = updated;
        }
    }

    @Override
    public void removeReservedPieceNumber(int piece_number) {
        int[] existing = this.reserved_pieces;
        if (existing != null) {
            if (existing.length == 1) {
                if (existing[0] == piece_number) {
                    this.reserved_pieces = null;
                }
            } else {
                int[] updated = new int[existing.length - 1];
                int pos = 0;
                boolean found = false;
                for (int i = 0; i < existing.length; ++i) {
                    int pn = existing[i];
                    if (found || pn != piece_number) {
                        if (pos == updated.length) {
                            return;
                        }
                        updated[pos++] = pn;
                        continue;
                    }
                    found = true;
                }
                this.reserved_pieces = updated;
            }
        }
    }

    @Override
    public int getIncomingRequestCount() {
        if (this.outgoing_piece_message_handler == null) {
            return 0;
        }
        return this.outgoing_piece_message_handler.getRequestCount();
    }

    @Override
    public int getOutgoingRequestCount() {
        return this.getNbRequests();
    }

    @Override
    public int getOutboundDataQueueSize() {
        return this.connection.getOutgoingMessageQueue().getTotalSize();
    }

    @Override
    public boolean isStalledPendingLoad() {
        if (this.outgoing_piece_message_handler == null) {
            return false;
        }
        return this.outgoing_piece_message_handler.isStalledPendingLoad();
    }

    @Override
    public int[] getIncomingRequestedPieceNumbers() {
        if (this.outgoing_piece_message_handler == null) {
            return new int[0];
        }
        return this.outgoing_piece_message_handler.getRequestedPieceNumbers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] getOutgoingRequestedPieceNumbers() {
        try {
            this.requested_mon.enter();
            int iLastNumber = -1;
            int[] pieceNumbers = new int[this.requested.size()];
            int pos = 0;
            for (int i = 0; i < this.requested.size(); ++i) {
                DiskManagerReadRequest request2 = null;
                try {
                    request2 = (DiskManagerReadRequest)this.requested.get(i);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                if (request2 == null || iLastNumber == request2.getPieceNumber()) continue;
                iLastNumber = request2.getPieceNumber();
                pieceNumbers[pos++] = iLastNumber;
            }
            int[] trimmed = new int[pos];
            System.arraycopy(pieceNumbers, 0, trimmed, 0, pos);
            int[] nArray = trimmed;
            Object var8_8 = null;
            this.requested_mon.exit();
            return nArray;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.requested_mon.exit();
            throw throwable;
        }
    }

    @Override
    public int getPercentDoneOfCurrentIncomingRequest() {
        return this.connection.getIncomingMessageQueue().getPercentDoneOfCurrentMessage();
    }

    @Override
    public int getPercentDoneOfCurrentOutgoingRequest() {
        return this.connection.getOutgoingMessageQueue().getPercentDoneOfCurrentMessage();
    }

    @Override
    public String getRelationText() {
        String text = "";
        if (this.manager instanceof LogRelation) {
            text = ((LogRelation)((Object)this.manager)).getRelationText() + "; ";
        }
        text = text + "Peer: " + this.toString();
        return text;
    }

    @Override
    public Object[] getQueryableInterfaces() {
        return new Object[]{this.manager};
    }

    @Override
    public int getLastPiece() {
        return this._lastPiece;
    }

    @Override
    public void setLastPiece(int pieceNumber) {
        this._lastPiece = pieceNumber;
    }

    @Override
    public boolean isLANLocal() {
        if (this.connection == null) {
            return AddressUtils.isLANLocalAddress(this.ip) == 1;
        }
        return this.connection.isLANLocal();
    }

    @Override
    public boolean isTCP() {
        if (this.connection == null) {
            return false;
        }
        ProtocolEndpoint[] protocols = this.connection.getEndpoint().getProtocols();
        return protocols[0].getType() != 2;
    }

    @Override
    public void setUploadRateLimitBytesPerSecond(int bytes) {
        if (bytes == -1) {
            if (!this.isUploadDisabled(PEPeerTransport.class)) {
                this.setUploadDisabled(PEPeerTransport.class, true);
                this.connection.setUploadLimit(0);
            }
        } else {
            if (this.is_upload_disabled && this.isUploadDisabled(PEPeerTransport.class)) {
                this.setUploadDisabled(PEPeerTransport.class, false);
            }
            this.connection.setUploadLimit(bytes);
        }
    }

    @Override
    public int getUploadRateLimitBytesPerSecond() {
        if (this.is_upload_disabled && this.isUploadDisabled(PEPeerTransport.class)) {
            return -1;
        }
        return this.connection.getUploadLimit();
    }

    @Override
    public void setDownloadRateLimitBytesPerSecond(int bytes) {
        if (bytes == -1) {
            if (!this.isDownloadDisabled(PEPeerTransport.class)) {
                this.setDownloadDisabled(PEPeerTransport.class, true);
                this.connection.setDownloadLimit(0);
            }
        } else {
            if (this.is_download_disabled && this.isDownloadDisabled(PEPeerTransport.class)) {
                this.setDownloadDisabled(PEPeerTransport.class, false);
            }
            this.connection.setDownloadLimit(bytes);
        }
    }

    @Override
    public int getDownloadRateLimitBytesPerSecond() {
        if (this.is_download_disabled && this.isDownloadDisabled(PEPeerTransport.class)) {
            return -1;
        }
        return this.connection.getDownloadLimit();
    }

    @Override
    public String getClientNameFromPeerID() {
        return this.client_peer_id;
    }

    @Override
    public String getClientNameFromExtensionHandshake() {
        if (!this.client_handshake.equals("") && !this.client_handshake_version.equals("")) {
            return this.client_handshake + " " + this.client_handshake_version;
        }
        return this.client_handshake;
    }

    private static MainlineDHTProvider getDHTProvider() {
        return AzureusCoreImpl.getSingleton().getGlobalManager().getMainlineDHTProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPriorityConnection(boolean is_priority) {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            if (this.priority_connection == is_priority) {
                return;
            }
            this.priority_connection = is_priority;
        }
        this.manager.getAdapter().priorityConnectionChanged(is_priority);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isPriorityConnection() {
        PEPeerTransportProtocol pEPeerTransportProtocol = this;
        synchronized (pEPeerTransportProtocol) {
            return this.priority_connection;
        }
    }

    protected static List<Integer> generateFastSet(byte[] hash, String ip, int num_pieces, int num_required) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        try {
            byte[] address;
            if (AENetworkClassifier.categoriseAddress(ip) == "Public" && (address = InetAddress.getByName(ip).getAddress()).length == 4) {
                byte[] bytes = new byte[24];
                System.arraycopy(address, 0, bytes, 0, 3);
                System.arraycopy(hash, 0, bytes, 4, 20);
                num_required = Math.min(num_required, num_pieces);
                while (res.size() < num_required) {
                    bytes = new SHA1Simple().calculateHash(bytes);
                    int pos = 0;
                    while (pos < 20 && res.size() < num_required) {
                        long index;
                        Integer i;
                        if (res.contains(i = new Integer((int)((index = (long)(bytes[pos++] << 24) & 0xFF000000L | (long)(bytes[pos++] << 16) & 0xFF0000L | (long)(bytes[pos++] << 8) & 0xFF00L | (long)bytes[pos++] & 0xFFL) % (long)num_pieces)))) continue;
                        res.add(i);
                    }
                }
            }
        }
        catch (Throwable e) {
            Debug.out("Fast set generation failed", e);
        }
        return res;
    }

    protected List<Integer> generateFastSet(int num) {
        return PEPeerTransportProtocol.generateFastSet(this.manager.getHash(), this.getIp(), this.nbPieces, num);
    }

    @Override
    public int getTaggableType() {
        return 4;
    }

    @Override
    public String getTaggableID() {
        return null;
    }

    @Override
    public TaggableResolver getTaggableResolver() {
        return null;
    }

    @Override
    public void generateEvidence(IndentWriter writer) {
        writer.println("ip=" + this.getIp() + ",in=" + this.isIncoming() + ",port=" + this.getPort() + ",cli=" + this.client + ",tcp=" + this.getTCPListenPort() + ",udp=" + this.getUDPListenPort() + ",oudp=" + this.getUDPNonDataListenPort() + ",prot=" + this.getProtocol() + ",p_state=" + this.getPeerState() + ",c_state=" + this.getConnectionState() + ",seed=" + this.isSeed() + ",partialSeed=" + this.isRelativeSeed() + ",pex=" + this.peer_exchange_supported + ",closing=" + this.closing);
        writer.println("    choked=" + this.effectively_choked_by_other_peer + "/" + this.really_choked_by_other_peer + ",choking=" + this.choking_other_peer + ",is_opt=" + this.is_optimistic_unchoke);
        writer.println("    interested=" + this.interested_in_other_peer + ",interesting=" + this.other_peer_interested_in_me + ",snubbed=" + this.snubbed);
        writer.println("    lp=" + this._lastPiece + ",up=" + this.uniquePiece + ",rp=" + this.reserved_pieces);
        writer.println("    last_sent=" + this.last_message_sent_time + "/" + this.last_data_message_sent_time + ",last_recv=" + this.last_message_received_time + "/" + this.last_data_message_received_time + "/" + this.last_good_data_time);
        writer.println("    conn_at=" + this.connection_established_time + ",cons_no_reqs=" + this.consecutive_no_request_count + ",discard=" + requests_discarded + "/" + requests_discarded_endgame + ",recov=" + requests_recovered + ",comp=" + requests_completed + ",curr=" + this.requested.size());
    }

    public static void main(String[] args) {
        byte[] hash = new byte[20];
        Arrays.fill(hash, (byte)-86);
        try {
            List<Integer> res = PEPeerTransportProtocol.generateFastSet(hash, "80.4.4.200", 9, 5);
            System.out.println(res);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    static {
        String prop = System.getProperty("show.discard.rate.stats");
        SHOW_DISCARD_RATE_STATS = prop != null && prop.equals("1");
        requests_discarded = 0;
        requests_discarded_endgame = 0;
        requests_recovered = 0;
        requests_completed = 0;
        recentlyDisconnected = new DisconnectedTransportQueue();
        rnd = RandomUtils.SECURE_RANDOM;
        rnd.setSeed(SystemTime.getHighPrecisionCounter());
        sessionSecret = new byte[20];
        rnd.nextBytes(sessionSecret);
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Lazy Bitfield", "Peer.Fast.Initial.Unchoke.Enabled", "Bias Upload Enable"}, new ParameterListener(){

            public final void parameterChanged(String ignore) {
                String prop = System.getProperty("azureus.lazy.bitfield");
                ENABLE_LAZY_BITFIELD = prop != null && prop.equals("1");
                ENABLE_LAZY_BITFIELD |= COConfigurationManager.getBooleanParameter("Use Lazy Bitfield");
                fast_unchoke_new_peers = COConfigurationManager.getBooleanParameter("Peer.Fast.Initial.Unchoke.Enabled");
                enable_upload_bias = COConfigurationManager.getBooleanParameter("Bias Upload Enable");
            }
        });
    }

    private static final class DisconnectedTransportQueue
    extends LinkedHashMap {
        private static final long MAX_CACHE_AGE = 120000L;

        public DisconnectedTransportQueue() {
            super(20, 0.75f);
        }

        private void performCleaning() {
            if (this.size() > 20) {
                Iterator it = this.values().iterator();
                long now = SystemTime.getMonotonousTime();
                while (it.hasNext() && this.size() > 20) {
                    QueueEntry eldest = (QueueEntry)it.next();
                    if (now - eldest.addTime <= 120000L) break;
                    it.remove();
                }
            }
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > 100;
        }

        public synchronized Object put(HashWrapper key, PEPeerTransportProtocol value) {
            this.performCleaning();
            return super.put(key, new QueueEntry(value));
        }

        public synchronized PEPeerTransportProtocol remove(HashWrapper key) {
            this.performCleaning();
            QueueEntry entry = (QueueEntry)super.remove(key);
            if (entry != null) {
                return entry.transport;
            }
            return null;
        }

        private static final class QueueEntry {
            final PEPeerTransportProtocol transport;
            final long addTime = SystemTime.getMonotonousTime();

            public QueueEntry(PEPeerTransportProtocol trans) {
                this.transport = trans;
            }
        }
    }

    protected static class MutableInteger {
        private int value;

        protected MutableInteger(int v) {
            this.value = v;
        }

        protected void setValue(int v) {
            this.value = v;
        }

        protected int getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.value;
        }

        public boolean equals(Object obj) {
            if (obj instanceof MutableInteger) {
                return this.value == ((MutableInteger)obj).value;
            }
            return false;
        }
    }
}

