/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32.access.impl;

import java.util.List;
import java.util.Map;
import org.gudy.azureus2.platform.win32.PlatformManagerImpl;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessException;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessCallback;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessExceptionImpl;
import org.gudy.azureus2.update.UpdaterUtils;

public class AEWin32AccessInterface {
    public static final int HKEY_CLASSES_ROOT = 1;
    public static final int HKEY_CURRENT_CONFIG = 2;
    public static final int HKEY_LOCAL_MACHINE = 3;
    public static final int HKEY_CURRENT_USER = 4;
    public static final int WM_QUERYENDSESSION = 17;
    public static final int WM_ENDSESSION = 22;
    public static final int WM_POWERBROADCAST = 536;
    public static final int PBT_APMQUERYSUSPEND = 0;
    public static final int PBT_APMSUSPEND = 4;
    public static final int PBT_APMRESUMESUSPEND = 7;
    public static final long BROADCAST_QUERY_DENY = 1112363332L;
    public static final int ES_SYSTEM_REQUIRED = 1;
    public static final int ES_DISPLAY_REQUIRED = 2;
    public static final int ES_USER_PRESENT = 4;
    public static final int ES_AWAYMODE_REQUIRED = 64;
    public static final int ES_CONTINUOUS = Integer.MIN_VALUE;
    private static boolean enabled;
    private static boolean enabled_set;
    private static AEWin32AccessCallback cb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isEnabled(boolean check_if_disabled) {
        if (!check_if_disabled) {
            return true;
        }
        if (enabled_set) {
            return enabled;
        }
        try {
            boolean bl = enabled = !UpdaterUtils.disableNativeCode(AEWin32AccessInterface.getVersion());
            if (!enabled) {
                System.err.println("Native code has been disabled");
            }
            Object var2_1 = null;
            enabled_set = true;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            enabled_set = true;
            throw throwable;
        }
        return enabled;
    }

    protected static void load(AEWin32AccessCallback _callback, boolean _fully_initialise) {
        cb = _callback;
        if (_fully_initialise) {
            try {
                AEWin32AccessInterface.initialise();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static long callback(int msg, int param1, long param2) {
        if (cb == null) {
            return -1L;
        }
        return cb.windowsMessage(msg, param1, param2);
    }

    protected static native void initialise() throws AEWin32AccessExceptionImpl;

    protected static native String getVersion();

    protected static native String readStringValue(int var0, String var1, String var2) throws AEWin32AccessExceptionImpl;

    protected static native void writeStringValue(int var0, String var1, String var2, String var3) throws AEWin32AccessExceptionImpl;

    protected static native int readWordValue(int var0, String var1, String var2) throws AEWin32AccessExceptionImpl;

    protected static native void writeWordValue(int var0, String var1, String var2, int var3) throws AEWin32AccessExceptionImpl;

    protected static native void deleteKey(int var0, String var1, boolean var2) throws AEWin32AccessExceptionImpl;

    protected static native void deleteValue(int var0, String var1, String var2) throws AEWin32AccessExceptionImpl;

    public static native void createProcess(String var0, boolean var1) throws AEWin32AccessException;

    public static native void moveToRecycleBin(String var0) throws AEWin32AccessException;

    public static native void copyPermission(String var0, String var1) throws AEWin32AccessException;

    public static native boolean testNativeAvailability(String var0) throws AEWin32AccessException;

    public static native void traceRoute(int var0, int var1, int var2, int var3, AEWin32AccessCallback var4) throws AEWin32AccessException;

    public static native int shellExecute(String var0, String var1, String var2, String var3, int var4) throws AEWin32AccessExceptionImpl;

    public static native int shellExecuteAndWait(String var0, String var1) throws AEWin32AccessExceptionImpl;

    public static native List getAvailableDrives() throws AEWin32AccessExceptionImpl;

    public static native Map getDriveInfo(char var0) throws AEWin32AccessExceptionImpl;

    public static native int setThreadExecutionState(int var0);

    static {
        try {
            System.loadLibrary(PlatformManagerImpl.DLL_NAME);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

