/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.varia.DenyAllFilter;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderFactory;
import org.gudy.azureus2.core3.torrentdownloader.impl.TorrentDownloaderManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.installer.InstallablePlugin;
import org.gudy.azureus2.plugins.installer.PluginInstallerListener;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.plugins.update.UpdateManager;
import org.gudy.azureus2.ui.common.UIConst;
import org.gudy.azureus2.ui.console.CommandReader;
import org.gudy.azureus2.ui.console.UserProfile;
import org.gudy.azureus2.ui.console.commands.AddFind;
import org.gudy.azureus2.ui.console.commands.Alias;
import org.gudy.azureus2.ui.console.commands.Archive;
import org.gudy.azureus2.ui.console.commands.Create;
import org.gudy.azureus2.ui.console.commands.Hack;
import org.gudy.azureus2.ui.console.commands.IConsoleCommand;
import org.gudy.azureus2.ui.console.commands.Log;
import org.gudy.azureus2.ui.console.commands.Move;
import org.gudy.azureus2.ui.console.commands.Pairing;
import org.gudy.azureus2.ui.console.commands.Plugin;
import org.gudy.azureus2.ui.console.commands.Priority;
import org.gudy.azureus2.ui.console.commands.RunState;
import org.gudy.azureus2.ui.console.commands.Set;
import org.gudy.azureus2.ui.console.commands.Share;
import org.gudy.azureus2.ui.console.commands.Show;
import org.gudy.azureus2.ui.console.commands.Subscriptions;
import org.gudy.azureus2.ui.console.commands.Tags;
import org.gudy.azureus2.ui.console.commands.TorrentArchive;
import org.gudy.azureus2.ui.console.commands.TorrentCheck;
import org.gudy.azureus2.ui.console.commands.TorrentForceStart;
import org.gudy.azureus2.ui.console.commands.TorrentHost;
import org.gudy.azureus2.ui.console.commands.TorrentLog;
import org.gudy.azureus2.ui.console.commands.TorrentPublish;
import org.gudy.azureus2.ui.console.commands.TorrentQueue;
import org.gudy.azureus2.ui.console.commands.TorrentRemove;
import org.gudy.azureus2.ui.console.commands.TorrentStart;
import org.gudy.azureus2.ui.console.commands.TorrentStop;
import org.gudy.azureus2.ui.console.commands.XML;
import org.gudy.azureus2.ui.console.util.TextWrap;
import org.gudy.azureus2.update.CorePatchChecker;
import org.gudy.azureus2.update.UpdaterUpdateChecker;

public class ConsoleInput
extends Thread {
    private static final String ALIASES_CONFIG_FILE = "console.aliases.properties";
    public final AzureusCore azureus_core;
    public final PrintStream out;
    public final List torrents = new ArrayList();
    public File[] adds = null;
    private final CommandReader br;
    private final boolean controlling;
    private boolean running;
    private final Vector oldcommand = new Vector();
    private static final List pluginCommands = new ArrayList();
    public final Properties aliases = new Properties();
    private final Map commands = new LinkedHashMap();
    private final List helpItems = new ArrayList();
    private final UserProfile userProfile;

    public static void registerPluginCommand(Class clazz) {
        if (!IConsoleCommand.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class must implement IConsoleCommand");
        }
        pluginCommands.add(clazz);
    }

    public static void unregisterPluginCommand(Class clazz) {
        pluginCommands.remove(clazz);
    }

    public ConsoleInput(String con, AzureusCore _azureus_core, Reader _in, PrintStream _out, Boolean _controlling) {
        this(con, _azureus_core, _in, _out, _controlling, UserProfile.DEFAULT_USER_PROFILE);
    }

    public ConsoleInput(String con, AzureusCore _azureus_core, Reader _in, PrintStream _out, Boolean _controlling, UserProfile profile) {
        super("Console Input: " + con);
        this.out = _out;
        this.azureus_core = _azureus_core;
        this.userProfile = profile;
        this.controlling = _controlling;
        this.br = new CommandReader(_in);
        System.out.println("ConsoleInput: initializing...");
        this.initialise();
        System.out.println("ConsoleInput: initialized OK");
        System.out.println("ConsoleInput: starting...");
        this.start();
        System.out.println("ConsoleInput: started OK");
    }

    public ConsoleInput(AzureusCore _azureus_core, PrintStream _out) {
        super("");
        this.out = _out;
        this.azureus_core = _azureus_core;
        this.userProfile = UserProfile.DEFAULT_USER_PROFILE;
        this.controlling = false;
        this.br = new CommandReader(new InputStreamReader(new ByteArrayInputStream(new byte[0])));
        if (org.apache.log4j.Logger.getRootLogger().getAppender("ConsoleAppender") == null) {
            ConsoleAppender app = new ConsoleAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"));
            app.setName("ConsoleAppender");
            app.addFilter((Filter)new DenyAllFilter());
            org.apache.log4j.Logger.getRootLogger().addAppender((Appender)app);
        }
        this.initialise();
    }

    protected void initialise() {
        this.registerAlertHandler();
        this.registerCommands();
        this.registerPluginCommands();
        if (this.azureus_core != null) {
            if (this.controlling) {
                this.azureus_core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

                    public void started(AzureusCore core) {
                        ConsoleInput.this.registerUpdateChecker();
                        try {
                            SubscriptionManagerFactory.getSingleton();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                this.loadAliases();
            }
            catch (IOException e) {
                this.out.println("Error while loading aliases: " + e.getMessage());
            }
        }
        this.oldcommand.add("sh");
        this.oldcommand.add("t");
    }

    public void downloadTorrent(String filename, String outputDir) {
        DownloadManager manager = this.azureus_core.getGlobalManager().addDownloadManager(filename, outputDir);
        manager.getDownloadState().setAttribute("user", this.getUserProfile().getUsername());
    }

    public void downloadRemoteTorrent(String url, final String outputDir) {
        TorrentDownloader downloader = TorrentDownloaderFactory.create(new TorrentDownloaderCallBackInterface(){

            public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
                if (state == 3) {
                    ConsoleInput.this.out.println("Torrent file download complete. Starting torrent");
                    TorrentDownloaderManager.getInstance().remove(inf);
                    ConsoleInput.this.downloadTorrent(inf.getFile().getAbsolutePath(), outputDir);
                } else {
                    if (state == 4) {
                        ConsoleInput.this.out.println("Torrent file download failed: " + inf.getError());
                    }
                    TorrentDownloaderManager.getInstance().TorrentDownloaderEvent(state, inf);
                }
            }
        }, url, null, null, true);
        TorrentDownloaderManager.getInstance().add(downloader);
    }

    public void downloadTorrent(String fileName) {
        this.downloadTorrent(fileName, this.getDefaultSaveDirectory());
    }

    public void downloadRemoteTorrent(String url) {
        this.downloadRemoteTorrent(url, this.getDefaultSaveDirectory());
    }

    private void registerPluginCommands() {
        for (Class clazz : pluginCommands) {
            try {
                IConsoleCommand command = (IConsoleCommand)clazz.newInstance();
                this.registerCommand(command);
            }
            catch (InstantiationException e) {
                this.out.println("Error while registering plugin command: " + clazz.getName() + ":" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.out.println("Error while registering plugin command: " + clazz.getName() + ":" + e.getMessage());
            }
        }
    }

    protected void registerAlertHandler() {
        Logger.addListener(new ILogAlertListener(){
            private java.util.Set history = Collections.synchronizedSet(new HashSet());

            public void alertRaised(LogAlert alert) {
                if (!alert.repeatable) {
                    if (this.history.contains(alert.text)) {
                        return;
                    }
                    this.history.add(alert.text);
                }
                ConsoleInput.this.out.println(alert.text);
                if (alert.err != null) {
                    alert.err.printStackTrace(ConsoleInput.this.out);
                }
            }
        });
    }

    protected void registerCommands() {
        this.registerCommand(new XML());
        this.registerCommand(new Hack());
        this.registerCommand(new AddFind());
        this.registerCommand(new Create());
        this.registerCommand(new TorrentCheck());
        this.registerCommand(new TorrentQueue());
        this.registerCommand(new TorrentRemove());
        this.registerCommand(new TorrentArchive());
        this.registerCommand(new TorrentStart());
        this.registerCommand(new TorrentStop());
        this.registerCommand(new TorrentHost());
        this.registerCommand(new TorrentPublish());
        this.registerCommand(new TorrentForceStart());
        this.registerCommand(new TorrentLog());
        this.registerCommand(new Log());
        this.registerCommand(new Move());
        this.registerCommand(new RunState());
        this.registerCommand(new Share());
        this.registerCommand(new Set());
        this.registerCommand(new Show());
        this.registerCommand(new CommandUI());
        this.registerCommand(new CommandLogout());
        this.registerCommand(new CommandQuit());
        this.registerCommand(new CommandHelp());
        this.registerCommand(new Alias());
        this.registerCommand(new Priority());
        this.registerCommand(new Plugin());
        this.registerCommand(new Pairing());
        this.registerCommand(new Archive());
        try {
            this.registerCommand(new Subscriptions());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.registerCommand(new Tags());
    }

    protected void registerCommand(IConsoleCommand command) {
        for (String cmdName : command.getCommandNames()) {
            this.commands.put(cmdName, command);
        }
        this.helpItems.add(command);
    }

    protected void unregisterCommand(IConsoleCommand command) {
        for (String cmdName : command.getCommandNames()) {
            if (!command.equals(this.commands.get(cmdName))) continue;
            this.commands.remove(cmdName);
        }
        this.helpItems.remove(command);
    }

    protected void unregisterCommand(String commandName) {
        IConsoleCommand cmd = (IConsoleCommand)this.commands.get(commandName);
        if (cmd == null) {
            return;
        }
        int numCommands = 0;
        for (Map.Entry entry : this.commands.entrySet()) {
            if (!cmd.equals(entry.getValue())) continue;
            ++numCommands;
        }
        if (numCommands == 1) {
            this.unregisterCommand(cmd);
        } else {
            this.commands.remove(commandName);
        }
    }

    public ConsoleInput(String con, AzureusCore _azureus_core, InputStream _in, PrintStream _out, Boolean _controlling) {
        this(con, _azureus_core, new InputStreamReader(_in), _out, _controlling);
    }

    private static void quit(boolean finish) {
        if (finish) {
            UIConst.shutdown();
        }
    }

    public void printwelcome() {
        this.out.println("Running " + Constants.APP_NAME + " " + "5.5.0.1_B19" + "...");
        this.out.println("Using configuration settings from:");
        this.out.println("  " + SystemProperties.getUserPath());
    }

    public void printconsolehelp() {
        this.printconsolehelp(this.out);
    }

    private void printconsolehelp(PrintStream os) {
        os.println("> -----");
        os.println("Available console commands (use help <command> for more details):");
        os.println();
        ArrayList<String> cmd_lines = new ArrayList<String>();
        Iterator itr = this.helpItems.iterator();
        while (itr.hasNext()) {
            StringBuffer line_so_far = new StringBuffer("[");
            IConsoleCommand cmd = (IConsoleCommand)itr.next();
            String short_name = cmd.getShortCommandName();
            if (short_name != null) {
                line_so_far.append(short_name);
            }
            line_so_far.append("] ");
            line_so_far.append(cmd.getCommandName());
            cmd_lines.add(line_so_far.toString());
        }
        TextWrap.printList(cmd_lines.iterator(), os, "   ");
        os.println("> -----");
    }

    public boolean invokeCommand(String command, List cargs) {
        if (command.startsWith("\\")) {
            command = command.substring(1);
        } else if (this.aliases.containsKey(command)) {
            List list = this.br.parseCommandLine(this.aliases.getProperty(command));
            String newCommand = list.remove(0).toString().toLowerCase();
            list.addAll(cargs);
            return this.invokeCommand(newCommand, list);
        }
        if (this.commands.containsKey(command)) {
            IConsoleCommand cmd = (IConsoleCommand)this.commands.get(command);
            try {
                if (cargs == null) {
                    cargs = new ArrayList<String>();
                }
                cmd.execute(command, this, cargs);
                return true;
            }
            catch (Exception e) {
                this.out.println("> Invoking Command '" + command + "' failed. Exception: " + Debug.getNestedExceptionMessage(e));
                return false;
            }
        }
        return false;
    }

    public void run() {
        this.running = true;
        while (this.running) {
            List comargs;
            try {
                String line = this.br.readLine();
                comargs = this.br.parseCommandLine(line);
            }
            catch (Exception e) {
                this.out.println("Stopping console input reader because of exception: " + e.getMessage());
                this.running = false;
                break;
            }
            if (comargs.isEmpty()) continue;
            String command = ((String)comargs.get(0)).toLowerCase();
            if (".".equals(command)) {
                if (this.oldcommand.size() > 0) {
                    comargs.clear();
                    comargs.addAll(this.oldcommand);
                    command = ((String)comargs.get(0)).toLowerCase();
                } else {
                    this.out.println("No old command. Remove commands are not repeated to prevent errors");
                }
            }
            this.oldcommand.clear();
            this.oldcommand.addAll(comargs);
            comargs.remove(0);
            try {
                if (this.invokeCommand(command, comargs)) continue;
                this.out.println("> Command '" + command + "' unknown (or . used without prior command)");
            }
            catch (Throwable e) {
                this.out.println("Exception occurred when executing command: '" + command + "'");
                e.printStackTrace(this.out);
            }
        }
    }

    private File getAliasesFile() {
        PluginInterface pi = this.azureus_core.getPluginManager().getDefaultPluginInterface();
        String azureusUserDir = pi.getUtilities().getAzureusUserDir();
        return new File(azureusUserDir, ALIASES_CONFIG_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAliases() throws IOException {
        File aliasesFile = this.getAliasesFile();
        this.out.println("Attempting to load aliases from: " + aliasesFile.getCanonicalPath());
        if (aliasesFile.exists()) {
            FileInputStream fr = new FileInputStream(aliasesFile);
            this.aliases.clear();
            try {
                this.aliases.load(fr);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                fr.close();
                throw throwable;
            }
            fr.close();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAliases() {
        File aliasesFile = this.getAliasesFile();
        try {
            this.out.println("Saving aliases to: " + aliasesFile.getCanonicalPath());
            FileOutputStream fo = new FileOutputStream(aliasesFile);
            try {
                this.aliases.store(fo, "This aliases file was automatically written by Azureus");
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                fo.close();
                throw throwable;
            }
            fo.close();
            {
            }
        }
        catch (IOException e) {
            this.out.println("> Error saving aliases to " + aliasesFile.getPath() + ":" + e.getMessage());
        }
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public String getDefaultSaveDirectory() {
        try {
            String saveDir = this.getUserProfile().getDefaultSaveDirectory();
            if (saveDir == null && ((saveDir = COConfigurationManager.getDirectoryParameter("Default save path")) == null || saveDir.length() == 0)) {
                saveDir = ".";
            }
            return saveDir;
        }
        catch (Exception e) {
            e.printStackTrace();
            return ".";
        }
    }

    protected void registerUpdateChecker() {
        boolean check_at_start = COConfigurationManager.getBooleanParameter("update.start", true);
        if (!check_at_start) {
            return;
        }
        PluginManager pm = this.azureus_core.getPluginManager();
        pm.getPluginInstaller().addListener(new PluginInstallerListener(){

            public boolean installRequest(String reason, InstallablePlugin plugin) throws PluginException {
                ConsoleInput.this.out.println("Plugin installation request for '" + plugin.getName() + "' - " + reason);
                String desc = plugin.getDescription();
                String[] bits = desc.split("\n");
                for (int i = 0; i < bits.length; ++i) {
                    ConsoleInput.this.out.println("\t" + bits[i]);
                }
                return true;
            }
        });
        PluginInterface pi = pm.getPluginInterfaceByClass(CorePatchChecker.class);
        if (pi != null) {
            pi.getPluginState().setDisabled(true);
        }
        if ((pi = pm.getPluginInterfaceByClass(UpdaterUpdateChecker.class)) != null) {
            pi.getPluginState().setDisabled(true);
        }
        UpdateManager update_manager = this.azureus_core.getPluginManager().getDefaultPluginInterface().getUpdateManager();
        final UpdateCheckInstance checker = update_manager.createUpdateCheckInstance();
        checker.addListener(new UpdateCheckInstanceListener(){

            public void cancelled(UpdateCheckInstance instance) {
            }

            public void complete(UpdateCheckInstance instance) {
                int num_updates = 0;
                Update[] updates = instance.getUpdates();
                for (int i = 0; i < updates.length; ++i) {
                    Update update = updates[i];
                    ++num_updates;
                    ConsoleInput.this.out.println("Update available for '" + update.getName() + "', new version = " + update.getNewVersion());
                    String[] descs = update.getDescription();
                    for (int j = 0; j < descs.length; ++j) {
                        ConsoleInput.this.out.println("\t" + descs[j]);
                    }
                    if (!update.isMandatory()) continue;
                    ConsoleInput.this.out.println("**** This is a mandatory update, other updates can not proceed until this is performed ****");
                }
                checker.cancel();
                if (num_updates > 0) {
                    ConsoleInput.this.out.println("Apply these updates with the 'plugin update' command");
                }
            }
        });
        checker.start();
    }

    public AzureusCore getCore() {
        return this.azureus_core;
    }

    public GlobalManager getGlobalManager() {
        return this.azureus_core.getGlobalManager();
    }

    private class CommandHelp
    extends IConsoleCommand {
        public CommandHelp() {
            super("help", "?");
        }

        public String getCommandDescriptions() {
            return "help [torrents]\t\t\t?\tShow this help. 'torrents' shows info about the show torrents display.";
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            if (args.isEmpty()) {
                ConsoleInput.this.printconsolehelp(ci.out);
            } else {
                String subcommand = (String)args.get(0);
                IConsoleCommand cmd = (IConsoleCommand)ConsoleInput.this.commands.get(subcommand);
                if (cmd != null) {
                    ArrayList<String> newargs = new ArrayList<String>(args);
                    newargs.remove(0);
                    cmd.printHelp(ci.out, newargs);
                } else if (subcommand.equalsIgnoreCase("torrents") || subcommand.equalsIgnoreCase("t")) {
                    ci.out.println("> -----");
                    ci.out.println("# [state] PercentDone Name (Filesize) ETA\r\n\tDownSpeed / UpSpeed\tDownloaded/Uploaded\tConnectedSeeds(total) / ConnectedPeers(total)");
                    ci.out.println();
                    ci.out.println("States:");
                    ci.out.println(" > Downloading");
                    ci.out.println(" * Seeding");
                    ci.out.println(" ! Stopped");
                    ci.out.println(" . Waiting (for allocation/checking)");
                    ci.out.println(" : Ready");
                    ci.out.println(" - Queued");
                    ci.out.println(" A Allocating");
                    ci.out.println(" C Checking");
                    ci.out.println(" E Error");
                    ci.out.println(" I Initializing");
                    ci.out.println(" ? Unknown");
                    ci.out.println("> -----");
                } else {
                    ConsoleInput.this.printconsolehelp(ci.out);
                }
            }
        }
    }

    private static class CommandLogout
    extends IConsoleCommand {
        public CommandLogout() {
            super("logout");
        }

        public String getCommandDescriptions() {
            return "logout\t\t\t\t\tLog out of the CLI";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void execute(String commandName, ConsoleInput ci, List args) {
            try {
                block5: {
                    try {
                        if (ci.controlling) break block5;
                        if (ci.out != System.out) {
                            ci.out.println("Logged out");
                            ci.out.close();
                        }
                        ci.br.close();
                    }
                    catch (IOException ignored) {
                        Object var6_5 = null;
                        ci.running = false;
                        return;
                    }
                }
                Object var6_4 = null;
                ci.running = false;
                return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                ci.running = false;
                throw throwable;
            }
        }
    }

    private static class CommandQuit
    extends IConsoleCommand {
        public CommandQuit() {
            super("quit");
        }

        public String getCommandDescriptions() {
            return "quit\t\t\t\t\tShutdown Azureus";
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            if (ci.controlling) {
                ci.running = false;
                ci.out.print("Exiting.....");
                ConsoleInput.quit(true);
                ci.out.println("OK");
            } else if (args.isEmpty() || !args.get(0).toString().equalsIgnoreCase("IAMSURE")) {
                ci.out.println("> The 'quit' command exits azureus. Since this is a non-controlling shell thats probably not what you wanted. Use 'logout' to quit it or 'quit iamsure' to really exit azureus.");
            } else {
                ci.out.print("Exiting.....");
                ConsoleInput.quit(true);
                ci.out.println("OK");
            }
        }
    }

    private static class CommandUI
    extends IConsoleCommand {
        public CommandUI() {
            super("ui", "u");
        }

        public String getCommandDescriptions() {
            return "ui <interface>\t\t\tu\tStart additional user interface.";
        }

        public void execute(String commandName, ConsoleInput ci, List args) {
            if (!args.isEmpty()) {
                UIConst.startUI(args.get(0).toString(), null);
            } else {
                ci.out.println("> Missing subcommand for 'ui'\r\n> ui syntax: ui <interface>");
            }
        }
    }
}

