/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytracker;

import com.aelitis.azureus.core.AzureusCoreFactory;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class CategoryItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    protected static GlobalManager gm;

    public CategoryItem() {
        super("category", -1, 400, "MyTracker");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        TRHostTorrent tr_torrent = (TRHostTorrent)cell.getDataSource();
        if (tr_torrent == null) {
            cell.setText("");
        } else {
            TOTorrent torrent = tr_torrent.getTorrent();
            if (gm == null) {
                if (AzureusCoreFactory.isCoreRunning()) {
                    return;
                }
                gm = AzureusCoreFactory.getSingleton().getGlobalManager();
            }
            DownloadManager dm = gm.getDownloadManager(torrent);
            String cat_str = null;
            if (dm != null) {
                Category cat = dm.getDownloadState().getCategory();
                if (cat != null) {
                    cat_str = cat.getName();
                }
            } else {
                cat_str = TorrentUtils.getPluginStringProperty(torrent, "azcoreplugins.category");
            }
            cell.setText(cat_str == null ? "" : cat_str);
        }
    }
}

