/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import java.net.InetAddress;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class NetworkAdminNATDeviceImpl
implements NetworkAdminNATDevice {
    private UPnPPluginService service;
    private InetAddress external_address;
    private long address_time;

    protected NetworkAdminNATDeviceImpl(UPnPPluginService _service) {
        this.service = _service;
    }

    public String getName() {
        return this.service.getName();
    }

    public InetAddress getAddress() {
        try {
            return InetAddress.getByName(this.service.getAddress());
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public int getPort() {
        return this.service.getPort();
    }

    public InetAddress getExternalAddress() {
        long now = SystemTime.getCurrentTime();
        if (this.external_address != null && now > this.address_time && now - this.address_time < 60000L) {
            return this.external_address;
        }
        try {
            this.external_address = InetAddress.getByName(this.service.getExternalAddress());
            this.address_time = now;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return this.external_address;
    }

    protected boolean sameAs(NetworkAdminNATDeviceImpl other) {
        if (!this.getAddress().equals(other.getAddress()) || this.getPort() != other.getPort()) {
            return false;
        }
        InetAddress e1 = this.getExternalAddress();
        InetAddress e2 = other.getExternalAddress();
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.equals(e2);
    }

    public String getString() {
        String res = this.getName();
        res = res + ": address=" + this.service.getAddress() + ":" + this.service.getPort();
        InetAddress ext = this.getExternalAddress();
        res = ext == null ? res + ", no public address available" : res + ", public address=" + ext.getHostAddress();
        return res;
    }
}

